/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.context.typed;

import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.exceptions.SpecException;
import ar.com.dgarcia.javaspec.impl.context.typed.TypedContextMethodInvocation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class TypedContextValidator {
    private Map<String, Method> getters;
    private Map<String, Method> letters;
    private Class<? extends TestContext> validable;

    public void validate() throws SpecException {
        this.parseGettersAndLetters();
        this.findUnbalancedPairs();
        this.findMismatchedTypePair();
    }

    private void findMismatchedTypePair() {
        Set<String> allVariables = this.letters.keySet();
        for (String variable : allVariables) {
            Type getType;
            Type letType = this.getLetTypeFor(variable);
            if (!this.isAMismatch(letType, getType = this.getGetTypeFor(variable))) continue;
            throw new SpecException("Variable [" + variable + "] has mismatching type definitions in get [" + getType.getTypeName() + "] and let [" + letType.getTypeName() + "] operations");
        }
    }

    private Type getLetTypeFor(String variable) {
        Method letMethod = this.letters.get(variable);
        Type supplierType = letMethod.getGenericParameterTypes()[0];
        if (!(supplierType instanceof ParameterizedType)) {
            throw new SpecException("Argument of let operation [" + variable + "] is not a parameterized Supplier? " + supplierType);
        }
        ParameterizedType parameterizedSupplier = (ParameterizedType)supplierType;
        Type[] supplierArgs = parameterizedSupplier.getActualTypeArguments();
        Type letType = supplierArgs[0];
        return letType;
    }

    private Type getGetTypeFor(String variable) {
        Method getterMethod = this.getters.get(variable);
        Type getType = getterMethod.getGenericReturnType();
        return getType;
    }

    private boolean isAMismatch(Type letType, Type getType) {
        if (!(letType instanceof Class) || !(getType instanceof Class)) {
            return false;
        }
        boolean letIsUnassignableToGet = !((Class)getType).isAssignableFrom((Class)letType);
        return letIsUnassignableToGet;
    }

    private void findUnbalancedPairs() {
        Set<String> definedLetters = this.letters.keySet();
        for (String letVariable : definedLetters) {
            if (this.getters.containsKey(letVariable)) continue;
            throw new SpecException("Variable [" + letVariable + "] doesn't have a matching getter method in [" + this.validable.getSimpleName() + "]");
        }
        Set<String> definedGetters = this.getters.keySet();
        for (String getVariable : definedGetters) {
            if (this.letters.containsKey(getVariable)) continue;
            throw new SpecException("Variable [" + getVariable + "] doesn't have a matching setter method in [" + this.validable.getSimpleName() + "]");
        }
    }

    private void parseGettersAndLetters() {
        LinkedList pendingTypes = new LinkedList();
        pendingTypes.push(this.validable);
        while (!pendingTypes.isEmpty()) {
            Method[] typeMethods;
            Class currentType = (Class)pendingTypes.pop();
            if (currentType.equals(Object.class) || currentType.equals(TestContext.class)) continue;
            for (Method typeMethod : typeMethods = currentType.getDeclaredMethods()) {
                String variableName = TypedContextMethodInvocation.extractVariableNameFrom(typeMethod);
                if (this.seemsLikeLetter(typeMethod)) {
                    if (this.letters.containsKey(variableName)) {
                        throw new SpecException("Let operation for variable [" + variableName + "] is duplicated");
                    }
                    this.letters.put(variableName, typeMethod);
                    continue;
                }
                if (this.seemsLikeGetter(typeMethod)) {
                    if (this.getters.containsKey(variableName)) {
                        throw new SpecException("Get operation for variable [" + variableName + "] is duplicated");
                    }
                    this.getters.put(variableName, typeMethod);
                    continue;
                }
                throw new SpecException("Method [" + typeMethod.getName() + "] declared in [" + currentType.getSimpleName() + "] does not conform to get or let operation signatures [no arg | void, Supplier]");
            }
            Class<?>[] superInterfaces = currentType.getInterfaces();
            pendingTypes.addAll(Arrays.asList(superInterfaces));
        }
    }

    private boolean seemsLikeGetter(Method typeMethod) {
        boolean doesNotReturnsVoid = !this.returnsVoid(typeMethod);
        boolean hasNoArgs = typeMethod.getParameterCount() == 0;
        return doesNotReturnsVoid && hasNoArgs;
    }

    private boolean seemsLikeLetter(Method typeMethod) {
        boolean returnsVoid = this.returnsVoid(typeMethod);
        Class<?>[] argTypes = typeMethod.getParameterTypes();
        boolean hasOnSupplierArg = argTypes.length == 1 && argTypes[0].equals(Supplier.class);
        return returnsVoid && hasOnSupplierArg;
    }

    private boolean returnsVoid(Method typeMethod) {
        return typeMethod.getReturnType().equals(Void.TYPE);
    }

    public static TypedContextValidator create(Class<? extends TestContext> validableInterface) {
        TypedContextValidator validator = new TypedContextValidator();
        validator.validable = validableInterface;
        validator.getters = new HashMap<String, Method>();
        validator.letters = new HashMap<String, Method>();
        return validator;
    }
}

