/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.model.impl;

import ar.com.dgarcia.javaspec.impl.context.MappedContext;
import ar.com.dgarcia.javaspec.impl.model.DisabledStatus;
import ar.com.dgarcia.javaspec.impl.model.SpecElement;
import ar.com.dgarcia.javaspec.impl.model.SpecGroup;
import ar.com.dgarcia.javaspec.impl.model.SpecTest;
import ar.com.dgarcia.javaspec.impl.model.TestContextDefinition;
import ar.com.dgarcia.javaspec.impl.model.impl.NullContainerGroup;
import ar.com.dgarcia.javaspec.impl.model.impl.SpecElementSupport;
import ar.com.dgarcia.javaspec.impl.model.impl.TestSpecDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GroupSpecDefinition
extends SpecElementSupport
implements SpecGroup {
    private DisabledStatus disabledState;
    private List<SpecElement> elements;
    private List<Runnable> beforeBlocks;
    private List<Runnable> afterBlocks;
    private TestContextDefinition testContext;

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public List<SpecGroup> getSubGroups() {
        List<SpecGroup> subGroups = this.elements.stream().filter(element -> element instanceof SpecGroup).map(element -> (SpecGroup)element).collect(Collectors.toList());
        return subGroups;
    }

    @Override
    public List<SpecTest> getDeclaredTests() {
        List<SpecTest> declaredTest = this.elements.stream().filter(element -> element instanceof SpecTest).map(element -> (SpecTest)element).collect(Collectors.toList());
        return declaredTest;
    }

    @Override
    public boolean isMarkedAsDisabled() {
        return this.disabledState.isDisabledConsidering(this.getContainerGroup());
    }

    @Override
    public void markAsDisabled() {
        this.disabledState = DisabledStatus.DISABLED;
    }

    @Override
    public void addSubGroup(GroupSpecDefinition addedGroup) {
        this.addContainedElement(addedGroup);
    }

    @Override
    public void addTest(TestSpecDefinition addedSpec) {
        this.addContainedElement(addedSpec);
    }

    @Override
    public void addBeforeBlock(Runnable aCodeBlock) {
        this.beforeBlocks.add(aCodeBlock);
    }

    @Override
    public void addAfterBlock(Runnable aCodeBlock) {
        this.afterBlocks.add(aCodeBlock);
    }

    @Override
    public List<SpecElement> getSpecElements() {
        return this.elements;
    }

    @Override
    public boolean hasNoTests() {
        if (this.getDeclaredTests().size() > 0) {
            return false;
        }
        List<SpecGroup> subGroups = this.getSubGroups();
        for (SpecGroup subGroup : subGroups) {
            if (subGroup.hasNoTests()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TestContextDefinition getTestContext() {
        return this.testContext;
    }

    @Override
    public List<Runnable> getBeforeBlocks() {
        List<Runnable> containerBeforeBlocks = this.getContainerGroup().getBeforeBlocks();
        ArrayList<Runnable> inheritedBlocks = new ArrayList<Runnable>(containerBeforeBlocks.size() + this.beforeBlocks.size());
        inheritedBlocks.addAll(containerBeforeBlocks);
        inheritedBlocks.addAll(this.beforeBlocks);
        return inheritedBlocks;
    }

    @Override
    public List<Runnable> getAfterBlocks() {
        List<Runnable> containerAfterBlocks = this.getContainerGroup().getAfterBlocks();
        ArrayList<Runnable> inheritedBlocks = new ArrayList<Runnable>(containerAfterBlocks.size() + this.afterBlocks.size());
        inheritedBlocks.addAll(this.afterBlocks);
        inheritedBlocks.addAll(containerAfterBlocks);
        return inheritedBlocks;
    }

    private void addContainedElement(SpecElementSupport element) {
        this.elements.add(element);
        element.setContainerGroup(this);
    }

    @Override
    protected void setContainerGroup(SpecGroup containerGroup) {
        super.setContainerGroup(containerGroup);
        this.testContext.setParentDefinition(containerGroup.getTestContext());
    }

    public static GroupSpecDefinition create(String groupName) {
        GroupSpecDefinition groupSpec = new GroupSpecDefinition();
        groupSpec.setName(groupName);
        groupSpec.disabledState = DisabledStatus.ENABLED;
        groupSpec.elements = new ArrayList<SpecElement>();
        groupSpec.beforeBlocks = new ArrayList<Runnable>();
        groupSpec.afterBlocks = new ArrayList<Runnable>();
        groupSpec.testContext = MappedContext.create();
        groupSpec.setContainerGroup(NullContainerGroup.create());
        return groupSpec;
    }
}

