/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.model.impl;

import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.variable.Variable;
import ar.com.dgarcia.javaspec.impl.context.MappedContext;
import ar.com.dgarcia.javaspec.impl.model.TestContextDefinition;
import java.util.List;

public class SpecExecutionBlock
implements Runnable {
    private Variable<TestContext> sharedContext;
    private TestContextDefinition parentContext;
    private List<Runnable> beforeBlocks;
    private Runnable testCode;
    private List<Runnable> afterBlocks;

    @Override
    public void run() {
        this.runWithOwnSubContext(() -> this.executeTestCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithOwnSubContext(Runnable codeToRun) {
        MappedContext testRunContext = MappedContext.create();
        testRunContext.setParentDefinition(this.parentContext);
        TestContext previousContext = this.sharedContext.get();
        this.sharedContext.set(testRunContext);
        try {
            codeToRun.run();
        }
        finally {
            this.sharedContext.set(previousContext);
        }
    }

    private void executeTestCode() {
        this.executeBlocks(this.beforeBlocks);
        try {
            this.testCode.run();
        }
        finally {
            this.executeBlocks(this.afterBlocks);
        }
    }

    private void executeBlocks(List<Runnable> runnableBlocks) {
        for (Runnable runnable : runnableBlocks) {
            runnable.run();
        }
    }

    public static SpecExecutionBlock create(List<Runnable> befores, Runnable testCode, List<Runnable> afters, TestContextDefinition parentContext, Variable<TestContext> sharedContext) {
        SpecExecutionBlock executionBlock = new SpecExecutionBlock();
        executionBlock.testCode = testCode;
        executionBlock.afterBlocks = afters;
        executionBlock.beforeBlocks = befores;
        executionBlock.sharedContext = sharedContext;
        executionBlock.parentContext = parentContext;
        return executionBlock;
    }
}

