/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.context;

import ar.com.dgarcia.javaspec.api.contexts.ClassBasedTestContext;
import ar.com.dgarcia.javaspec.api.exceptions.SpecException;
import ar.com.dgarcia.javaspec.impl.context.NullContextDefinition;
import ar.com.dgarcia.javaspec.impl.model.TestContextDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MappedContext
implements TestContextDefinition,
ClassBasedTestContext<Object> {
    public static final String DESCRIBED_CLASS_VARIABLE_NAME = "describedClass";
    public static final String SUBJECT_VARIABLE_NAME = "subject";
    public static final String SETUP_CODE_VARIABLE_NAME = "setupCode";
    public static final String EXERCISE_CODE_VARIABLE_NAME = "exerciseCode";
    public static final String ASSERTION_CODE_VARIABLE_NAME = "assertionCode";
    private TestContextDefinition parentDefinition;
    private Map<String, Supplier<Object>> variableDefinitions;
    private Map<String, Object> variableValues;

    @Override
    public void let(String variableName, Supplier<?> valueDefinition) throws SpecException {
        if (this.containsValueFor(variableName)) {
            throw new SpecException("Variable [" + variableName + "] cannot be re-defined once assigned. Current value: [" + this.get(variableName) + "]");
        }
        this.storeDefinitionFor(variableName, valueDefinition);
    }

    @Override
    public <T> T get(String variableName) {
        if (this.containsValueFor(variableName)) {
            return this.getValueFor(variableName);
        }
        Optional<Supplier<Object>> variableDefinition = this.getDefinitionFor(variableName);
        if (!variableDefinition.isPresent()) {
            throw new SpecException("Variable [" + variableName + "] must be defined before accessing it in current context[" + this.getVariableDefinitions() + "]");
        }
        return (T)this.createNewValueFrom(variableDefinition.get(), variableName);
    }

    @Override
    public boolean hasDefinitionFor(String variableName) {
        return this.getDefinitionFor(variableName).isPresent();
    }

    @Override
    public Runnable setupCode() {
        return (Runnable)this.get(SETUP_CODE_VARIABLE_NAME);
    }

    @Override
    public void setupCode(Supplier<Runnable> definition) {
        this.let(SETUP_CODE_VARIABLE_NAME, definition);
    }

    @Override
    public Runnable exerciseCode() {
        return (Runnable)this.get(EXERCISE_CODE_VARIABLE_NAME);
    }

    @Override
    public void exerciseCode(Supplier<Runnable> definition) {
        this.let(EXERCISE_CODE_VARIABLE_NAME, definition);
    }

    @Override
    public Runnable assertionCode() {
        return (Runnable)this.get(ASSERTION_CODE_VARIABLE_NAME);
    }

    @Override
    public void assertionCode(Supplier<Runnable> definition) {
        this.let(ASSERTION_CODE_VARIABLE_NAME, definition);
    }

    private <T> T createNewValueFrom(Supplier<T> variableDefinition, String variableName) {
        try {
            T variableValue = variableDefinition.get();
            this.storeValueFor(variableName, variableValue);
            return variableValue;
        }
        catch (StackOverflowError e) {
            throw new SpecException("Got a Stackoverflow when evaluating variable [" + variableName + "]. Do we have a cyclic dependency on its definition?", e);
        }
    }

    private void storeDefinitionFor(String variableName, Supplier<?> valueDefinition) {
        this.getVariableDefinitions().put(variableName, valueDefinition);
    }

    private <T> T getValueFor(String variableName) {
        if (this.variableValues == null) {
            return null;
        }
        return (T)this.getVariableValues().get(variableName);
    }

    private void storeValueFor(String variableName, Object variableValue) {
        this.getVariableValues().put(variableName, variableValue);
    }

    @Override
    public Optional<Supplier<Object>> getDefinitionFor(String variableName) {
        boolean weDontHaveADefinition;
        boolean bl = weDontHaveADefinition = this.variableDefinitions == null || !this.variableDefinitions.containsKey(variableName);
        if (weDontHaveADefinition) {
            return this.getParentDefinition().getDefinitionFor(variableName);
        }
        return Optional.ofNullable(this.getVariableDefinitions().get(variableName));
    }

    private boolean containsValueFor(String variableName) {
        if (this.variableValues == null) {
            return false;
        }
        return this.getVariableValues().containsKey(variableName);
    }

    public static MappedContext create() {
        MappedContext context = new MappedContext();
        context.parentDefinition = NullContextDefinition.create();
        return context;
    }

    @Override
    public void setParentDefinition(TestContextDefinition parentDefinition) {
        this.parentDefinition = parentDefinition;
    }

    @Override
    public TestContextDefinition getParentDefinition() {
        return this.parentDefinition;
    }

    private Map<String, Supplier<Object>> getVariableDefinitions() {
        if (this.variableDefinitions == null) {
            this.variableDefinitions = new HashMap<String, Supplier<Object>>();
        }
        return this.variableDefinitions;
    }

    private Map<String, Object> getVariableValues() {
        if (this.variableValues == null) {
            this.variableValues = new HashMap<String, Object>();
        }
        return this.variableValues;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.variableDefinitions;
    }

    @Override
    public void describedClass(Supplier<Class<Object>> definition) {
        this.let(DESCRIBED_CLASS_VARIABLE_NAME, definition);
    }

    @Override
    public void subject(Supplier<Object> definition) {
        this.let(SUBJECT_VARIABLE_NAME, definition);
    }

    @Override
    public Class<Object> describedClass() throws SpecException {
        if (this.lacksVariableDefinitionFor(DESCRIBED_CLASS_VARIABLE_NAME)) {
            throw new SpecException("Described class is not defined in this context[" + this.getVariableDefinitions() + "].\nUse describe(class,lambda) to define it before accessing it");
        }
        return (Class)this.get(DESCRIBED_CLASS_VARIABLE_NAME);
    }

    private boolean lacksVariableDefinitionFor(String variableName) {
        return !this.getDefinitionFor(variableName).isPresent();
    }

    @Override
    public Object subject() {
        if (this.lacksVariableDefinitionFor(SUBJECT_VARIABLE_NAME)) {
            this.tryToDefineADefaultSubject();
        }
        return this.get(SUBJECT_VARIABLE_NAME);
    }

    private void tryToDefineADefaultSubject() {
        if (this.lacksVariableDefinitionFor(DESCRIBED_CLASS_VARIABLE_NAME)) {
            throw new SpecException("Subject is not defined in this context[" + this.getVariableDefinitions() + "].\nUse describe(class,lambda) to define a class whose subject is going to be tested");
        }
        Class<Object> testedClass = this.describedClass();
        this.subject(() -> this.instantiateSubjectFrom(testedClass));
    }

    private Object instantiateSubjectFrom(Class<Object> testedClass) {
        try {
            return testedClass.newInstance();
        }
        catch (Exception e) {
            throw new SpecException("Unknown error trying to instantiate subject", e);
        }
    }
}

