/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.context.typed;

import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.exceptions.SpecException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class TypedContextMethodInvocation {
    public static final String LET_PREFIX = "let";
    public static final String GET_PREFIX = "get";
    private Method method;
    private Object[] args;

    public static TypedContextMethodInvocation create(Method method, Object[] args) {
        TypedContextMethodInvocation invocation = new TypedContextMethodInvocation();
        invocation.method = method;
        invocation.args = args;
        return invocation;
    }

    public boolean canBeHandledByTestContext(TestContext testContext) {
        Class<?> receiverType = this.method.getDeclaringClass();
        return receiverType.isInstance(testContext);
    }

    public Object invokeOn(TestContext context) {
        try {
            return this.method.invoke((Object)context, this.args);
        }
        catch (SpecException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SpecException) {
                throw (SpecException)cause;
            }
            throw new SpecException("Invocation on proxied context failed: " + cause.getMessage(), cause);
        }
        catch (Exception e) {
            throw new SpecException("Unexpected error on proxied context invocation: " + e.getMessage(), e);
        }
    }

    public Supplier<Object> getVariableDefinitionArgument() {
        Supplier variableDefinition;
        if (this.args == null || this.args.length != 1) {
            return null;
        }
        Object firstArgument = this.args[0];
        try {
            variableDefinition = (Supplier)firstArgument;
        }
        catch (ClassCastException e) {
            throw new SpecException("Invocation should have only a supplier argument", e);
        }
        return variableDefinition;
    }

    public String getVariableName() {
        return TypedContextMethodInvocation.extractVariableNameFrom(this.method);
    }

    public static String extractVariableNameFrom(Method method) {
        String variableName = method.getName();
        if (variableName.startsWith(LET_PREFIX) && variableName.length() > LET_PREFIX.length()) {
            variableName = variableName.substring(LET_PREFIX.length());
        } else if (variableName.startsWith(GET_PREFIX) && variableName.length() > GET_PREFIX.length()) {
            variableName = variableName.substring(GET_PREFIX.length());
        }
        char firstLetter = variableName.charAt(0);
        if (Character.isUpperCase(firstLetter)) {
            variableName = Character.toLowerCase(firstLetter) + variableName.substring(1);
        }
        return variableName;
    }
}

