/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.junit;

import ar.com.dgarcia.javaspec.api.JavaSpec;
import ar.com.dgarcia.javaspec.impl.junit.JunitTestCode;
import ar.com.dgarcia.javaspec.impl.junit.JunitTestTree;
import ar.com.dgarcia.javaspec.impl.model.SpecElement;
import ar.com.dgarcia.javaspec.impl.model.SpecGroup;
import ar.com.dgarcia.javaspec.impl.model.SpecTest;
import ar.com.dgarcia.javaspec.impl.model.SpecTree;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.runner.Description;

public class JunitTestTreeAdapter {
    public static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private SpecTree specTree;
    private JunitTestTree junitTree;

    public static JunitTestTreeAdapter create(SpecTree specTree, Class<? extends JavaSpec> clase) {
        JunitTestTreeAdapter adapter = new JunitTestTreeAdapter();
        adapter.specTree = specTree;
        adapter.adaptToJunit(clase);
        return adapter;
    }

    private void adaptToJunit(Class<? extends JavaSpec> clase) {
        Description rootDescription = Description.createSuiteDescription(clase);
        this.junitTree = JunitTestTree.create(rootDescription);
        SpecGroup rootGroup = this.specTree.getRootGroup();
        this.recursiveAdaptToJunit(rootGroup, rootDescription);
    }

    private void recursiveAdaptToJunit(SpecGroup currentGroup, Description currentDescription) {
        List<SpecElement> specElements = currentGroup.getSpecElements();
        for (SpecElement specElement : specElements) {
            String specName = specElement.getName();
            String specId = specName + specElement.hashCode();
            Description elementDescription = Description.createSuiteDescription((String)specName, (Serializable)((Object)specId), (Annotation[])NO_ANNOTATIONS);
            currentDescription.addChild(elementDescription);
            if (specElement instanceof SpecTest) {
                JunitTestCode junitTest = this.adaptToJunitTest((SpecTest)specElement, elementDescription);
                this.junitTree.addTest(junitTest);
            }
            if (!(specElement instanceof SpecGroup)) continue;
            SpecGroup specGroup = (SpecGroup)specElement;
            this.recursiveAdaptToJunit(specGroup, elementDescription);
        }
    }

    private JunitTestCode adaptToJunitTest(SpecTest specTest, Description elementDescription) {
        Runnable specTestCode = specTest.getSpecExecutionCode();
        JunitTestCode junitTest = JunitTestCode.create(specTestCode, elementDescription);
        if (specTest.isMarkedAsPending()) {
            junitTest.ignoreTest();
        }
        return junitTest;
    }

    public JunitTestTree getJunitTree() {
        return this.junitTree;
    }

    public SpecTree getSpecTree() {
        return this.specTree;
    }
}

