/*
 * Decompiled with CFR 0.152.
 */
package ar.com.dgarcia.javaspec.impl.parser;

import ar.com.dgarcia.javaspec.api.contexts.TestContext;
import ar.com.dgarcia.javaspec.api.variable.Variable;
import ar.com.dgarcia.javaspec.impl.model.SpecGroup;
import ar.com.dgarcia.javaspec.impl.model.impl.GroupSpecDefinition;
import java.util.LinkedList;

public class SpecStack {
    private LinkedList<SpecGroup> nestedGroups;
    private Variable<TestContext> currentContext;

    public static SpecStack create(SpecGroup rootGroup, Variable<TestContext> sharedContext) {
        SpecStack stack = new SpecStack();
        stack.nestedGroups = new LinkedList();
        stack.currentContext = sharedContext;
        stack.push(rootGroup);
        return stack;
    }

    private void push(SpecGroup group) {
        this.nestedGroups.push(group);
        this.updateContext();
    }

    public void executeAsCurrent(GroupSpecDefinition newHead, Runnable code) {
        this.push(newHead);
        try {
            code.run();
        }
        finally {
            this.pop();
        }
    }

    private void updateContext() {
        this.currentContext.set(this.getCurrentHead().getTestContext());
    }

    private void pop() {
        this.nestedGroups.pop();
        this.updateContext();
    }

    public SpecGroup getCurrentHead() {
        return this.nestedGroups.peek();
    }
}

