/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TripleCursor<T> {
    private final List<T> list;
    private Optional<T> optionalPrevious = Optional.empty();
    private Optional<T> optionalCurrent = Optional.empty();
    private Optional<T> optionalNext = Optional.empty();
    private int currentIndex;

    public TripleCursor(List<T> list) {
        this.list = Collections.unmodifiableList(list);
        this.init();
    }

    public TripleCursor init() {
        if (this.list.size() == 0) {
            return this;
        }
        this.optionalCurrent = Optional.of(this.list.get(this.currentIndex));
        if (this.list.size() > 1) {
            this.optionalNext = Optional.of(this.list.get(this.currentIndex + 1));
        }
        return this;
    }

    public boolean haveCurrent() {
        return this.optionalCurrent.isPresent();
    }

    public void next() {
        ++this.currentIndex;
        this.optionalPrevious = this.optionalCurrent;
        this.optionalCurrent = this.optionalNext;
        this.optionalNext = this.list.size() > this.currentIndex + 1 ? Optional.of(this.list.get(this.currentIndex + 1)) : Optional.empty();
    }

    public Optional<T> getOptionalPrevious() {
        return this.optionalPrevious;
    }

    public void setOptionalPrevious(Optional<T> optionalPrevious) {
        this.optionalPrevious = optionalPrevious;
    }

    public Optional<T> getOptionalCurrent() {
        return this.optionalCurrent;
    }

    public void setOptionalCurrent(Optional<T> optionalCurrent) {
        this.optionalCurrent = optionalCurrent;
    }

    public Optional<T> getOptionalNext() {
        return this.optionalNext;
    }

    public void setOptionalNext(Optional<T> optionalNext) {
        this.optionalNext = optionalNext;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public List<T> getList() {
        return this.list;
    }
}

