/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DataTypeRegistration {
    private Optional<String> optionalNamespaceName = Optional.empty();
    private Optional<String> optionalKeyword = Optional.empty();
    private Optional<Function<String, Object>> optionalFunction = Optional.empty();
    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Trying to avoid null pointer errors, so value should exist.")
    private List<String> synonymsList = new ArrayList<String>();

    public static DataTypeRegistrationBuilder builder() {
        return new DataTypeRegistrationBuilder();
    }

    public Optional<String> getOptionalNamespaceName() {
        return this.optionalNamespaceName;
    }

    public Optional<String> getOptionalKeyword() {
        return this.optionalKeyword;
    }

    public Optional<Function<String, Object>> getOptionalFunction() {
        return this.optionalFunction;
    }

    public List<String> getSynonymsList() {
        return this.synonymsList;
    }

    public void setOptionalNamespaceName(Optional<String> optionalNamespaceName) {
        this.optionalNamespaceName = optionalNamespaceName;
    }

    public void setOptionalKeyword(Optional<String> optionalKeyword) {
        this.optionalKeyword = optionalKeyword;
    }

    public void setOptionalFunction(Optional<Function<String, Object>> optionalFunction) {
        this.optionalFunction = optionalFunction;
    }

    public void setSynonymsList(List<String> synonymsList) {
        this.synonymsList = synonymsList;
    }

    public DataTypeRegistration(Optional<String> optionalNamespaceName, Optional<String> optionalKeyword, Optional<Function<String, Object>> optionalFunction, List<String> synonymsList) {
        this.optionalNamespaceName = optionalNamespaceName;
        this.optionalKeyword = optionalKeyword;
        this.optionalFunction = optionalFunction;
        this.synonymsList = synonymsList;
    }

    public DataTypeRegistration() {
    }

    public static class DataTypeRegistrationBuilder {
        private Optional<String> optionalNamespaceName;
        private Optional<String> optionalKeyword;
        private Optional<Function<String, Object>> optionalFunction;
        private List<String> synonymsList;

        public DataTypeRegistrationBuilder namespaceName(String namespaceName) {
            this.optionalNamespaceName = Optional.ofNullable(namespaceName);
            return this;
        }

        public DataTypeRegistrationBuilder keyword(String keyword) {
            this.optionalKeyword = Optional.ofNullable(keyword);
            return this;
        }

        public DataTypeRegistrationBuilder function(Function<String, Object> function) {
            this.optionalFunction = Optional.ofNullable(function);
            return this;
        }

        public DataTypeRegistrationBuilder synonyms(String ... synonyms) {
            this.synonymsList = Collections.unmodifiableList(Arrays.asList(synonyms));
            return this;
        }

        DataTypeRegistrationBuilder() {
        }

        public DataTypeRegistrationBuilder optionalNamespaceName(Optional<String> optionalNamespaceName) {
            this.optionalNamespaceName = optionalNamespaceName;
            return this;
        }

        public DataTypeRegistrationBuilder optionalKeyword(Optional<String> optionalKeyword) {
            this.optionalKeyword = optionalKeyword;
            return this;
        }

        public DataTypeRegistrationBuilder optionalFunction(Optional<Function<String, Object>> optionalFunction) {
            this.optionalFunction = optionalFunction;
            return this;
        }

        public DataTypeRegistrationBuilder synonymsList(List<String> synonymsList) {
            this.synonymsList = synonymsList;
            return this;
        }

        public DataTypeRegistration build() {
            return new DataTypeRegistration(this.optionalNamespaceName, this.optionalKeyword, this.optionalFunction, this.synonymsList);
        }

        public String toString() {
            return "DataTypeRegistration.DataTypeRegistrationBuilder(optionalNamespaceName=" + this.optionalNamespaceName + ", optionalKeyword=" + this.optionalKeyword + ", optionalFunction=" + this.optionalFunction + ", synonymsList=" + this.synonymsList + ")";
        }
    }
}

