/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import info.setmy.textfunctions.register.Namespace;
import info.setmy.textfunctions.register.Synonym;
import info.setmy.textfunctions.register.TypeFunctions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class KeywordFunctionMapper {
    private final Map<String, Function<String, Object>> keywordFunctions = new ConcurrentHashMap<String, Function<String, Object>>();
    private final Namespace namespace;
    private final List<Synonym> synonyms = new ArrayList<Synonym>();
    private final Set<String> allKeywords = new HashSet<String>();

    public static KeywordFunctionMapper newInstance(Namespace namespace) {
        KeywordFunctionMapper keywordFunctionMapper = new KeywordFunctionMapper(namespace);
        keywordFunctionMapper.put("character", string -> Character.valueOf(string.toCharArray()[0]));
        keywordFunctionMapper.put("boolean", string -> Boolean.parseBoolean(string));
        keywordFunctionMapper.put("short", string -> Short.parseShort(string));
        keywordFunctionMapper.put("int", string -> Integer.parseInt(string));
        keywordFunctionMapper.put("long", string -> Long.parseLong(string));
        keywordFunctionMapper.put("float", string -> Float.valueOf(Float.parseFloat(string)));
        keywordFunctionMapper.put("double", string -> Double.parseDouble(string));
        keywordFunctionMapper.put("bigDecimal", string -> new BigDecimal((String)string));
        keywordFunctionMapper.put("string", string -> string);
        keywordFunctionMapper.put("time", TypeFunctions.TIME_TRANSFORM_FUNCTION);
        keywordFunctionMapper.put("date", TypeFunctions.DATE_TRANSFORM_FUNCTION);
        keywordFunctionMapper.put("dateTime", TypeFunctions.DATE_TIME_TRANSFORM_FUNCTION);
        keywordFunctionMapper.put("list", TypeFunctions.LIST_TRANSFORM_FUNCTION);
        keywordFunctionMapper.put("set", TypeFunctions.SET_TRANSFORM_FUNCTION);
        keywordFunctionMapper.register("character", "char", "Char");
        keywordFunctionMapper.register("boolean", "bool", "Boolean", "Bool");
        keywordFunctionMapper.register("int", "Int", "Integer", "integer");
        return keywordFunctionMapper;
    }

    public KeywordFunctionMapper(Namespace namespace) {
        this.namespace = namespace;
    }

    public void put(String key, Function<String, Object> func) {
        this.keywordFunctions.put(key, func);
    }

    public Optional<Function<String, Object>> getFunction(String key) {
        return Optional.ofNullable(this.get(key));
    }

    public Function<String, Object> get(String key) {
        Function<String, Object> result = this.keywordFunctions.get(this.getKeywordBySynonym(key).orElse(key));
        return result;
    }

    public boolean register(String keyword, String ... synonyms) {
        return this.synonyms.add(new Synonym(keyword, Arrays.asList(synonyms)));
    }

    public boolean register(String keyword, List<String> synonyms) {
        return this.synonyms.add(new Synonym(keyword, synonyms));
    }

    public <T> Optional<T> convert(String keyword, String value) {
        return this.getFunction(keyword).map(stringObjectFunction -> stringObjectFunction.apply(value));
    }

    public Set<String> getAllKeywordPlaceholders() {
        return this.getAllKeywords().stream().map(s -> "{" + s + "}").collect(Collectors.toSet());
    }

    public Set<String> getAllKeywords() {
        if (!this.allKeywords.isEmpty()) {
            return Collections.unmodifiableSet(this.allKeywords);
        }
        Set<String> keywords = this.getSynonymKeywords();
        Set moreKeywords = this.keywordFunctions.entrySet().stream().map(stringFunctionEntry -> (String)stringFunctionEntry.getKey()).collect(Collectors.toSet());
        this.allKeywords.addAll(keywords);
        this.allKeywords.addAll(moreKeywords);
        return Collections.unmodifiableSet(this.allKeywords);
    }

    public Optional<String> getKeywordBySynonym(String synonymString) {
        return this.synonyms.stream().filter(synonym -> synonym.containsKey(synonymString)).findFirst().map(synonym -> (String)synonym.getKey());
    }

    public Set<String> getSynonymKeywords() {
        Set<String> keywords = this.synonyms.stream().map(synonym -> (String)synonym.getKey()).collect(Collectors.toSet());
        this.synonyms.forEach(synonym -> keywords.addAll((Collection)synonym.getValue()));
        return keywords;
    }
}

