/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import info.setmy.textfunctions.functions.Return;
import info.setmy.textfunctions.register.DataTypeRegistration;
import info.setmy.textfunctions.register.FunctionDeclaration;
import info.setmy.textfunctions.register.KeywordFunctionMapper;
import info.setmy.textfunctions.register.TemplateFunctionMapper;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class Namespace {
    private final String name;
    private final KeywordFunctionMapper keywordFunctionMapper = KeywordFunctionMapper.newInstance(this);
    private final TemplateFunctionMapper templateFunctionMapper = TemplateFunctionMapper.newInstance(this);

    public Namespace(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void register(DataTypeRegistration dataTypeRegistration) {
        String keyword = dataTypeRegistration.getOptionalKeyword().orElse(null);
        Function function = dataTypeRegistration.getOptionalFunction().orElse(null);
        List<String> synonyms = dataTypeRegistration.getSynonymsList();
        this.keywordFunctionMapper.put(keyword, function);
        if (!dataTypeRegistration.getSynonymsList().isEmpty()) {
            this.keywordFunctionMapper.register(keyword, synonyms);
        }
    }

    public void register(FunctionDeclaration functionDeclaration) {
        this.templateFunctionMapper.register(functionDeclaration.getOptionalFunctionTemplate().orElse(null), functionDeclaration.getOptionalTextFunction().orElse(null));
    }

    public Return call(String functionCallString) {
        return this.templateFunctionMapper.call(functionCallString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace namespace = (Namespace)o;
        return Objects.equals(this.name, namespace.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public KeywordFunctionMapper getKeywordFunctionMapper() {
        return this.keywordFunctionMapper;
    }
}

