/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import info.setmy.textfunctions.LambdaReturn;
import info.setmy.textfunctions.functions.Return;
import info.setmy.textfunctions.register.DataTypeRegistration;
import info.setmy.textfunctions.register.FunctionDeclaration;
import info.setmy.textfunctions.register.Namespace;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class Namespaces {
    public static final String GLOBAL = "global";
    private final Map<String, Namespace> namespaces = new ConcurrentHashMap<String, Namespace>();
    private final Namespace global = new Namespace("global");

    public Namespaces() {
        this.namespaces.put(GLOBAL, this.global);
    }

    public void declare(DataTypeRegistration dataTypeRegistration) {
        this.onDemandCreateAndGet(dataTypeRegistration.getOptionalNamespaceName().orElse(null)).ifPresent(namespace -> namespace.register(dataTypeRegistration));
    }

    public void declare(FunctionDeclaration functionDeclaration) {
        this.onDemandCreateAndGet(functionDeclaration.getOptionalNamespaceName().orElse(null)).ifPresent(namespace -> namespace.register(functionDeclaration));
    }

    public Return call(String functionText) {
        LambdaReturn<Return> lambdaReturn = new LambdaReturn<Return>(new Return());
        this.onDemandCreateAndGet(null).ifPresent(namespace -> lambdaReturn.setValue(namespace.call(functionText)));
        return lambdaReturn.getValue().get();
    }

    public Return call(String namespaceName, String functionText) {
        LambdaReturn<Return> lambdaReturn = new LambdaReturn<Return>(new Return());
        this.onDemandCreateAndGet(namespaceName).ifPresent(namespace -> lambdaReturn.setValue(namespace.call(functionText)));
        return lambdaReturn.getValue().get();
    }

    private Optional<Namespace> onDemandCreateAndGet(String name) {
        Optional<Namespace> optionalNamespace = this.get(name);
        if (optionalNamespace.isPresent()) {
            return optionalNamespace;
        }
        this.namespaces.put(name, new Namespace(name));
        return this.get(name);
    }

    private Optional<Namespace> get(String name) {
        if (Objects.isNull(name)) {
            return Optional.of(this.global);
        }
        return Optional.ofNullable(this.namespaces.get(name));
    }
}

