/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import info.setmy.textfunctions.FunctionNotFoundException;
import info.setmy.textfunctions.LambdaReturn;
import info.setmy.textfunctions.functions.Context;
import info.setmy.textfunctions.functions.Parameter;
import info.setmy.textfunctions.functions.Parameters;
import info.setmy.textfunctions.functions.Return;
import info.setmy.textfunctions.functions.TextFunction;
import info.setmy.textfunctions.register.Namespace;
import info.setmy.textfunctions.tokens.Template;
import info.setmy.textfunctions.tokens.TextToken;
import info.setmy.textfunctions.tokens.TokenType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemplateFunctionMapper {
    private static final Logger log = LogManager.getLogger(TemplateFunctionMapper.class);
    private final Map<Template, TextFunction> templateFunctions = new ConcurrentHashMap<Template, TextFunction>();
    private final Namespace namespace;

    public static TemplateFunctionMapper newInstance(Namespace namespace) {
        TemplateFunctionMapper templateFunctionMapper = new TemplateFunctionMapper(namespace);
        return templateFunctionMapper;
    }

    public TemplateFunctionMapper(Namespace namespace) {
        this.namespace = namespace;
    }

    public Return call(String text) {
        LambdaReturn<Return> optionalReturn = new LambdaReturn<Return>(new Return());
        List<Map.Entry> foundFunctions = this.templateFunctions.entrySet().stream().filter(templateTemplateFunctionEntry -> ((Template)templateTemplateFunctionEntry.getKey()).match(text)).collect(Collectors.toList());
        if (foundFunctions.isEmpty()) {
            throw new FunctionNotFoundException("No matching function for: " + text);
        }
        foundFunctions.forEach(templateTemplateFunctionEntry -> {
            log.info("Found placeholder for: {} {}", (Object)text, (Object)((Template)templateTemplateFunctionEntry.getKey()).getTemplateString());
            List<TextToken> templateTokens = ((Template)templateTemplateFunctionEntry.getKey()).parse(text);
            LambdaReturn<Integer> optionalCounter = new LambdaReturn<Integer>(0);
            Parameters parameters = new Parameters();
            templateTokens.stream().filter(textToken -> textToken.is(TokenType.PLACEHOLDER)).forEach(textToken -> {
                parameters.add(new Parameter("parameter-" + optionalCounter.getValue().orElse(0), textToken.getValue()));
                optionalCounter.setValue(optionalCounter.getValue().orElse(0) + 1);
            });
            Return returnValue = (Return)((TextFunction)templateTemplateFunctionEntry.getValue()).apply(new Context(this.namespace, parameters));
            optionalReturn.setValue(returnValue);
        });
        return optionalReturn.getValue().get();
    }

    public void register(String templateString, TextFunction function) {
        this.templateFunctions.put(this.toTemplate(templateString), function);
    }

    private Template toTemplate(String templateString) {
        return new Template(this.namespace, templateString).tokenize();
    }

    public Optional<Template> getTemplate(String templateString) {
        return this.templateFunctions.keySet().stream().filter(template -> template.isTemplate(templateString)).findFirst();
    }
}

