/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.register;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;

public final class TypeFunctions {
    public static final Function<String, Object> TIME_TRANSFORM_FUNCTION = string -> {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH.mm.ss");
        return LocalTime.parse(string, formatter);
    };
    public static final Function<String, Object> DATE_TRANSFORM_FUNCTION = string -> {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        return LocalDate.parse(string, formatter);
    };
    public static final Function<String, Object> DATE_TIME_TRANSFORM_FUNCTION = string -> {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH.mm.ss");
        return LocalDateTime.parse(string, formatter);
    };
    public static final Function<String, Object> LIST_TRANSFORM_FUNCTION = string -> {
        String[] elements = string.split(",");
        return Arrays.asList(elements);
    };
    public static final Function<String, Object> SET_TRANSFORM_FUNCTION = string -> {
        String[] elements = string.split(",");
        return new HashSet<String>(Arrays.asList(elements));
    };

    private TypeFunctions() {
    }
}

