/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.tokens;

import info.setmy.textfunctions.TripleCursor;
import info.setmy.textfunctions.register.Namespace;
import info.setmy.textfunctions.tokens.TemplateToken;
import info.setmy.textfunctions.tokens.TextToken;
import info.setmy.textfunctions.tokens.TokenBuilder;
import info.setmy.textfunctions.tokens.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Template {
    public static final char PLACEHOLDER_BEGIN_CHAR = '{';
    public static final char PLACEHOLDER_END_CHAR = '}';
    private final List<TemplateToken> templateTokenList = new ArrayList<TemplateToken>();
    private TokenBuilder tokenBuilder;
    private final Namespace namespace;
    private final String templateString;
    private final char[] characters;

    public Template(Namespace namespace, String templateString) {
        this.namespace = namespace;
        this.templateString = templateString;
        this.characters = templateString.toCharArray();
    }

    public Template tokenize() {
        for (int i = 0; i < this.characters.length; ++i) {
            this.handleCharacter(this.characters[i]);
        }
        this.addCurrentTokenBuilder();
        return this;
    }

    private void handleCharacter(char character) {
        switch (character) {
            case '{': {
                this.handleBeginChar(character);
                break;
            }
            case '}': {
                this.handleEndChar(character);
                break;
            }
            default: {
                this.handleTextChar(character);
            }
        }
    }

    private void handleTextChar(char character) {
        if (this.tokenBuilder == null) {
            this.tokenBuilder = new TokenBuilder(TokenType.TEXT);
        }
        this.tokenBuilder.add(character);
    }

    private void handleBeginChar(char character) {
        this.addCurrentTokenBuilder();
        this.tokenBuilder = new TokenBuilder(TokenType.PLACEHOLDER).add(character);
    }

    private void handleEndChar(char character) {
        this.tokenBuilder.add(character);
        this.addCurrentTokenBuilder();
        this.tokenBuilder = null;
    }

    private void addCurrentTokenBuilder() {
        if (Objects.nonNull(this.tokenBuilder)) {
            this.add(new TemplateToken(this.tokenBuilder.getTokenType(), this.tokenBuilder.toString()));
        }
    }

    public boolean add(TemplateToken templateToken) {
        return this.templateTokenList.add(templateToken);
    }

    public boolean isTemplate(String templateString) {
        return this.templateString.equals(templateString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Template) {
            Template template = (Template)o;
            return Objects.equals(this.templateString, template.templateString);
        }
        return false;
    }

    public String getTemplateString() {
        return this.templateString;
    }

    public int hashCode() {
        return Objects.hash(this.templateTokenList);
    }

    public List<TextToken> parse(String text) {
        ArrayList<TextToken> result = new ArrayList<TextToken>();
        TripleCursor<TemplateToken> tripleCursor = new TripleCursor<TemplateToken>(this.templateTokenList);
        Data data = new Data(tripleCursor, result, text);
        while (tripleCursor.haveCurrent()) {
            this.handle(data);
            tripleCursor.next();
        }
        return result;
    }

    private void handle(Data data) {
        switch (data.tripleCursor.getOptionalCurrent().get().getTokenType()) {
            case TEXT: {
                this.handleUserText(data);
                break;
            }
            case PLACEHOLDER: {
                this.handlePlaceHolder(data);
                break;
            }
            default: {
                this.handleDefault(data);
            }
        }
    }

    private void handleUserText(Data data) {
        TripleCursor<TemplateToken> tripleCursor = data.tripleCursor;
        TemplateToken current = tripleCursor.getOptionalCurrent().get();
        data.result.add(new TextToken(current.getTokenType(), current.getValue()));
        data.begin += current.getValue().length();
    }

    private void handlePlaceHolder(Data data) {
        TripleCursor<TemplateToken> tripleCursor = data.tripleCursor;
        TemplateToken current = tripleCursor.getOptionalCurrent().get();
        int nextIndex = this.nextIndex(data);
        if (nextIndex >= 0) {
            String placeholderValue = data.text.substring(data.begin, nextIndex);
            String typeName = current.getValueInnerText();
            Object newPlaceholderValue = this.namespace.getKeywordFunctionMapper().convert(typeName, placeholderValue).orElse(null);
            data.result.add(new TextToken(current.getTokenType(), newPlaceholderValue));
        }
        data.begin = nextIndex;
    }

    private void handleDefault(Data data) {
    }

    private int nextIndex(Data data) {
        TripleCursor<TemplateToken> tripleCursor = data.tripleCursor;
        int result = tripleCursor.getOptionalNext().isPresent() ? data.text.indexOf(tripleCursor.getOptionalNext().get().getValue()) : data.text.length();
        return result;
    }

    public boolean match(String text) {
        boolean result = false;
        int expectedStringBegin = 0;
        for (TemplateToken templateToken : this.templateTokenList) {
            if (templateToken.getTokenType() == TokenType.TEXT) {
                result = false;
                int stringBegin = text.indexOf(templateToken.getValue());
                if (stringBegin < expectedStringBegin) {
                    return result;
                }
                result = true;
                expectedStringBegin = stringBegin + templateToken.getValue().length();
                continue;
            }
            ++expectedStringBegin;
        }
        return result;
    }

    public Template(Namespace namespace, String templateString, char[] characters) {
        this.namespace = namespace;
        this.templateString = templateString;
        this.characters = characters;
    }

    private static class Data {
        public final TripleCursor<TemplateToken> tripleCursor;
        public final List<TextToken> result;
        public final String text;
        public int begin;

        Data(TripleCursor<TemplateToken> tripleCursor, List<TextToken> result, String text) {
            this.tripleCursor = tripleCursor;
            this.result = result;
            this.text = text;
        }
    }
}

