/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.tokens;

import info.setmy.textfunctions.tokens.TokenType;
import java.util.Objects;

public class TemplateToken {
    private final TokenType tokenType;
    private final String value;

    public String getValueInnerText() {
        return this.value.substring(1, this.value.length() - 1);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenType, this.value});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateToken templateToken = (TemplateToken)o;
        return this.tokenType == templateToken.tokenType && Objects.equals(this.value, templateToken.value);
    }

    public static TemplateTokenBuilder builder() {
        return new TemplateTokenBuilder();
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public String getValue() {
        return this.value;
    }

    public TemplateToken(TokenType tokenType, String value) {
        this.tokenType = tokenType;
        this.value = value;
    }

    public static class TemplateTokenBuilder {
        private TokenType tokenType;
        private String value;

        TemplateTokenBuilder() {
        }

        public TemplateTokenBuilder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public TemplateTokenBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TemplateToken build() {
            return new TemplateToken(this.tokenType, this.value);
        }

        public String toString() {
            return "TemplateToken.TemplateTokenBuilder(tokenType=" + (Object)((Object)this.tokenType) + ", value=" + this.value + ")";
        }
    }
}

