/*
 * Decompiled with CFR 0.152.
 */
package info.setmy.textfunctions.tokens;

import info.setmy.textfunctions.tokens.TokenType;

public class TextToken {
    private final TokenType tokenType;
    private final Object value;

    public boolean is(TokenType tokenType) {
        return this.tokenType == tokenType;
    }

    public static TextTokenBuilder builder() {
        return new TextTokenBuilder();
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public Object getValue() {
        return this.value;
    }

    public TextToken(TokenType tokenType, Object value) {
        this.tokenType = tokenType;
        this.value = value;
    }

    public static class TextTokenBuilder {
        private TokenType tokenType;
        private Object value;

        TextTokenBuilder() {
        }

        public TextTokenBuilder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public TextTokenBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public TextToken build() {
            return new TextToken(this.tokenType, this.value);
        }

        public String toString() {
            return "TextToken.TextTokenBuilder(tokenType=" + (Object)((Object)this.tokenType) + ", value=" + this.value + ")";
        }
    }
}

