/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class MitmproxyServer
extends WebSocketServer {
    private Function<InterceptedMessage, InterceptedMessage> interceptor;

    public MitmproxyServer(InetSocketAddress address, Function<InterceptedMessage, InterceptedMessage> interceptor) {
        super(address);
        this.interceptor = interceptor;
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        System.out.println("new connection to websocket server" + conn.getRemoteSocketAddress());
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        System.out.println("closed " + conn.getRemoteSocketAddress() + " with exit code " + code + " additional info: " + reason);
    }

    public void onMessage(WebSocket conn, String message) {
        System.out.println("received message from " + conn.getRemoteSocketAddress() + ": " + message);
    }

    public void onMessage(WebSocket conn, ByteBuffer message) {
        InterceptedMessage intercepted = null;
        InterceptedMessage modifiedMessage = null;
        try {
            intercepted = new InterceptedMessage(message);
        }
        catch (IOException e) {
            System.out.println("Could not parse message");
            e.printStackTrace();
        }
        modifiedMessage = this.interceptor.apply(intercepted);
        if (modifiedMessage == null) {
            modifiedMessage = intercepted;
        }
        try {
            conn.send(modifiedMessage.serializedResponseToMitmproxy());
        }
        catch (JsonProcessingException e) {
            System.out.println("Could not encode response to mitmproxy");
            e.printStackTrace();
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        System.err.println("an error occured on connection " + conn.getRemoteSocketAddress() + ":" + ex);
    }

    public void onStart() {
        System.out.println("websocket server started successfully");
    }
}

