/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.util.Formatter;
import java.util.FormatterClosedException;
import java.util.IllegalFormatException;
import java.util.Locale;
import lombok.NonNull;

public final class HexUtil {
    private static final String NEW_LINE;
    private static final char[] HEX_CODES;

    public static String toHexString(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (byte value : bytes) {
            result.append(HEX_CODES[value >> 4 & 0xF]);
            result.append(HEX_CODES[value & 0xF]);
        }
        return result.toString();
    }

    public static byte[] toByteArray(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked @NonNull but is null");
        }
        int length = string.length();
        if (length % 2 != 0) {
            String msg = String.format(Locale.ENGLISH, "hexBinary needs to be even-length: %s", string);
            throw new IllegalArgumentException(msg);
        }
        byte[] result = new byte[length / 2];
        for (int index = 0; index < length; index += 2) {
            int hight = HexUtil.hexToBin(string.charAt(index));
            int low = HexUtil.hexToBin(string.charAt(index + 1));
            if (hight == -1 || low == -1) {
                String msg = String.format(Locale.ENGLISH, "contains illegal character for hexBinary: %s", string);
                throw new IllegalArgumentException(msg);
            }
            result[index / 2] = (byte)(hight * 16 + low);
        }
        return result;
    }

    public static String byteToHex(int value) {
        return String.format(Locale.ENGLISH, "%02x", value);
    }

    public static char byteToChar(int value) {
        return value <= 31 || value >= 127 ? (char)'.' : (char)value;
    }

    public static String prettyHexDump(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        Bytes buffer = Bytes.wrap(bytes);
        return HexUtil.prettyHexDump(buffer);
    }

    public static String prettyHexDump(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return HexUtil.prettyHexDump(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    public static String prettyHexDump(@NonNull Bytes buffer, int offset, int length) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        if (offset < 0 || length < 0 || offset + length > buffer.capacity()) {
            String msg = String.format(Locale.ENGLISH, "expected: 0 <= offset(%d) <= offset+length(%d) <= buffer.capacity(%d)", offset, length, buffer.capacity());
            throw new IndexOutOfBoundsException(msg);
        }
        if (length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder().append("         +-------------------------------------------------+").append(NEW_LINE).append("         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |").append(NEW_LINE).append("+--------+-------------------------------------------------+----------------+");
        int elementsInRow = 16;
        int rows = (int)Math.ceil((double)length / 16.0);
        for (int row = 0; row < rows; ++row) {
            StringBuilder hexDump = new StringBuilder("                                                 ");
            StringBuilder asciiDump = new StringBuilder("                ");
            int rowStartIndex = row * 16 + offset;
            int limit = Math.min(buffer.writerIndex() - rowStartIndex, 16);
            for (int index = 0; index < limit; ++index) {
                short value = buffer.getUnsignedByte(rowStartIndex + index);
                int hexIndex = 1 + 3 * index;
                hexDump.setCharAt(hexIndex, HEX_CODES[value >> 4 & 0xF]);
                hexDump.setCharAt(hexIndex + 1, HEX_CODES[value & 0xF]);
                asciiDump.setCharAt(index, HexUtil.byteToChar(value));
            }
            result.append(NEW_LINE).append('|').append(String.format(Locale.ENGLISH, "%07x0", row)).append('|').append((CharSequence)hexDump).append('|').append((CharSequence)asciiDump).append('|');
        }
        return result.append(NEW_LINE).append("+--------+-------------------------------------------------+----------------+").toString();
    }

    private static int hexToBin(char character) {
        if (Character.isDigit(character)) {
            return character - 48;
        }
        char letter = Character.toUpperCase(character);
        return 'A' <= letter && letter <= 'F' ? letter - 65 + 10 : -1;
    }

    private HexUtil() {
        throw new UnsupportedOperationException();
    }

    static {
        String newLine;
        try (Formatter formatter = new Formatter();){
            newLine = formatter.format("%n", new Object[0]).toString();
        }
        catch (FormatterClosedException | IllegalFormatException ex) {
            newLine = "\n";
        }
        NEW_LINE = newLine;
        HEX_CODES = "0123456789ABCDEF".toCharArray();
    }
}

