/*
 * Decompiled with CFR 0.152.
 */
package io.availe.builders;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import io.availe.builders.DataClassBuilderKt;
import io.availe.builders.KotlinPoetUtilsKt;
import io.availe.builders.TypeNameBuilderKt;
import io.availe.models.DtoVariant;
import io.availe.models.ForeignProperty;
import io.availe.models.Model;
import io.availe.models.Property;
import io.availe.models.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001aj\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001e\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000f\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a4\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u00a8\u0006\u0017"}, d2={"propertyShouldSkipWrapping", "", "property", "Lio/availe/models/Property;", "existingValueClasses", "", "", "resolveTypeNameForProperty", "Lcom/squareup/kotlinpoet/TypeName;", "dtoVariant", "Lio/availe/models/DtoVariant;", "model", "Lio/availe/models/Model;", "valueClassNames", "", "Lkotlin/Pair;", "modelsByName", "isContainerSerializable", "buildSimpleTypeName", "typeInfo", "Lio/availe/models/TypeInfo;", "buildRecursiveDtoTypeName", "isCurrentContainerSerializable", "codegen-runtime"})
@SourceDebugExtension(value={"SMAP\nTypeResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeResolution.kt\nio/availe/builders/TypeResolutionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1563#2:107\n1634#2,3:108\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 TypeResolution.kt\nio/availe/builders/TypeResolutionKt\n*L\n72#1:107\n72#1:108,3\n99#1:111\n99#1:112,3\n*E\n"})
public final class TypeResolutionKt {
    public static final boolean propertyShouldSkipWrapping(@NotNull Property property, @NotNull Set<String> existingValueClasses) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(existingValueClasses, (String)"existingValueClasses");
        return property.getTypeInfo().isEnum() || property.getTypeInfo().isValueClass() || property.getTypeInfo().isDataClass() || existingValueClasses.contains(property.getTypeInfo().getQualifiedName());
    }

    @NotNull
    public static final TypeName resolveTypeNameForProperty(@NotNull Property property, @NotNull DtoVariant dtoVariant, @NotNull Model model, @NotNull Map<Pair<String, String>, String> valueClassNames, @NotNull Set<String> existingValueClasses, @NotNull Map<String, Model> modelsByName, boolean isContainerSerializable) {
        TypeName baseType;
        ClassName patchableClassName;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)dtoVariant, (String)"dtoVariant");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(valueClassNames, (String)"valueClassNames");
        Intrinsics.checkNotNullParameter(existingValueClasses, (String)"existingValueClasses");
        Intrinsics.checkNotNullParameter(modelsByName, (String)"modelsByName");
        if (DataClassBuilderKt.isSerializable(model, dtoVariant)) {
            var8_7 = new String[]{"SerializablePatchable"};
            ClassName className = new ClassName("io.availe.models", var8_7);
            v1 = className;
        } else {
            var8_7 = new String[]{"Patchable"};
            v1 = patchableClassName = new ClassName("io.availe.models", var8_7);
        }
        if (property.getTypeInfo().getCustomSerializerFqName() != null) {
            TypeName typeName;
            baseType = TypeResolutionKt.buildSimpleTypeName(property.getTypeInfo());
            String string = property.getTypeInfo().getCustomSerializerFqName();
            Intrinsics.checkNotNull((Object)string);
            String serializerFqName = StringsKt.removeSuffix((String)string, (CharSequence)"::class");
            ClassName serializerClassName = KotlinPoetUtilsKt.asClassName(serializerFqName);
            Object[] objectArray = new Object[]{serializerClassName};
            AnnotationSpec serializableAnnotation = AnnotationSpec.Companion.builder(KotlinPoetUtilsKt.asClassName("kotlinx.serialization.Serializable")).addMember("with = %T::class", objectArray).build();
            TypeName annotatedType = TypeName.copy$default((TypeName)baseType, (boolean)false, (List)CollectionsKt.plus((Collection)baseType.getAnnotations(), (Object)serializableAnnotation), (int)1, null);
            if (dtoVariant == DtoVariant.PATCH) {
                TypeName[] typeNameArray = new TypeName[]{annotatedType};
                typeName = (TypeName)ParameterizedTypeName.Companion.get(patchableClassName, typeNameArray);
            } else {
                typeName = annotatedType;
            }
            return typeName;
        }
        if (property instanceof ForeignProperty) {
            v4 = TypeResolutionKt.buildRecursiveDtoTypeName(((ForeignProperty)property).getTypeInfo(), dtoVariant, modelsByName, isContainerSerializable);
        } else {
            boolean useWrapping = Intrinsics.areEqual((Object)property.getNominalTyping(), (Object)"ENABLED");
            boolean skipWrapping = TypeResolutionKt.propertyShouldSkipWrapping(property, existingValueClasses);
            if (useWrapping && !skipWrapping) {
                String string = valueClassNames.get(TuplesKt.to((Object)model.getName(), (Object)property.getName()));
                if (string != null) {
                    String vcName = string;
                    boolean bl = false;
                    String[] stringArray = new String[]{vcName};
                    v4 = (TypeName)new ClassName(model.getPackageName(), stringArray);
                } else {
                    v4 = TypeNameBuilderKt.buildTypeNameWithContextual(property.getTypeInfo(), isContainerSerializable);
                }
            } else {
                v4 = baseType = TypeNameBuilderKt.buildTypeNameWithContextual(property.getTypeInfo(), isContainerSerializable);
            }
        }
        if (dtoVariant == DtoVariant.PATCH) {
            TypeName[] typeNameArray = new TypeName[]{baseType};
            return (TypeName)ParameterizedTypeName.Companion.get(patchableClassName, typeNameArray);
        }
        return baseType;
    }

    /*
     * WARNING - void declaration
     */
    private static final TypeName buildSimpleTypeName(TypeInfo typeInfo) {
        void $this$mapTo$iv$iv;
        ClassName rawType = KotlinPoetUtilsKt.asClassName(typeInfo.getQualifiedName());
        if (typeInfo.getArguments().isEmpty()) {
            return TypeName.copy$default((TypeName)((TypeName)rawType), (boolean)typeInfo.isNullable(), null, (int)2, null);
        }
        Iterable $this$map$iv = typeInfo.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeInfo typeInfo2 = (TypeInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TypeResolutionKt.buildSimpleTypeName((TypeInfo)it));
        }
        List typeArguments = (List)destination$iv$iv;
        return TypeName.copy$default((TypeName)((TypeName)ParameterizedTypeName.Companion.get(rawType, typeArguments)), (boolean)typeInfo.isNullable(), null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TypeName buildRecursiveDtoTypeName(@NotNull TypeInfo typeInfo, @NotNull DtoVariant dtoVariant, @NotNull Map<String, Model> modelsByName, boolean isCurrentContainerSerializable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        Intrinsics.checkNotNullParameter((Object)dtoVariant, (String)"dtoVariant");
        Intrinsics.checkNotNullParameter(modelsByName, (String)"modelsByName");
        String simpleName = StringsKt.substringAfterLast$default((String)typeInfo.getQualifiedName(), (char)'.', null, (int)2, null);
        String lookupKey = StringsKt.endsWith$default((String)simpleName, (String)"Schema", (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)simpleName, (CharSequence)"Schema") : simpleName;
        Model targetModel = modelsByName.get(lookupKey);
        if (typeInfo.getArguments().isEmpty()) {
            ClassName className;
            if (targetModel == null) {
                return TypeNameBuilderKt.buildTypeNameWithContextual(typeInfo, isCurrentContainerSerializable);
            }
            if (targetModel.isVersionOf() != null) {
                var8_7 = new String[]{targetModel.isVersionOf() + "Schema", targetModel.getName(), dtoVariant.getSuffix()};
                ClassName className2 = new ClassName(targetModel.getPackageName(), var8_7);
                className = className2;
            } else {
                var8_7 = new String[]{targetModel.getName() + "Schema", dtoVariant.getSuffix()};
                ClassName className3 = new ClassName(targetModel.getPackageName(), var8_7);
                className = className3;
            }
            ClassName finalDtoName = className;
            return TypeName.copy$default((TypeName)((TypeName)finalDtoName), (boolean)typeInfo.isNullable(), null, (int)2, null);
        }
        ClassName rawType = KotlinPoetUtilsKt.asClassName(typeInfo.getQualifiedName());
        Iterable $this$map$iv = typeInfo.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arg;
            TypeInfo typeInfo2 = (TypeInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Model model = modelsByName.get(arg.getQualifiedName());
            boolean isNestedContainerSerializable = model != null ? DataClassBuilderKt.isSerializable(model, dtoVariant) : isCurrentContainerSerializable;
            collection.add(TypeResolutionKt.buildRecursiveDtoTypeName((TypeInfo)arg, dtoVariant, modelsByName, isNestedContainerSerializable));
        }
        List transformedArgs = (List)destination$iv$iv;
        return TypeName.copy$default((TypeName)((TypeName)ParameterizedTypeName.Companion.get(rawType, transformedArgs)), (boolean)typeInfo.isNullable(), null, (int)2, null);
    }
}

