/*
 * Decompiled with CFR 0.152.
 */
package io.availe.utils;

import io.availe.models.DtoVariant;
import io.availe.models.ForeignProperty;
import io.availe.models.Model;
import io.availe.utils.HelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a(\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "validateModelReplications", "", "allModels", "", "Lio/availe/models/Model;", "createEmptyVariantError", "", "model", "dtoVariant", "Lio/availe/models/DtoVariant;", "createDependencyError", "parentModel", "violatingProperty", "Lio/availe/models/ForeignProperty;", "targetModel", "codegen-runtime"})
@SourceDebugExtension(value={"SMAP\nValidateModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateModels.kt\nio/availe/utils/ValidateModelsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1208#2,2:73\n1236#2,4:75\n1869#2:79\n808#2,11:80\n1869#2,2:91\n1870#2:93\n*S KotlinDebug\n*F\n+ 1 ValidateModels.kt\nio/availe/utils/ValidateModelsKt\n*L\n11#1:73,2\n11#1:75,4\n13#1:79\n21#1:80,11\n22#1:91,2\n13#1:93\n*E\n"})
public final class ValidateModelsKt {
    private static final Logger logger = LoggerFactory.getLogger((String)"io.availe.utils.ValidateModels");

    /*
     * WARNING - void declaration
     */
    public static final void validateModelReplications(@NotNull List<Model> allModels) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(allModels, (String)"allModels");
        Iterable $this$associateBy$iv = allModels;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Model model = (Model)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map modelsByName = destination$iv$iv;
        List validationErrors = new ArrayList();
        Iterable $this$forEach$iv = allModels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Object element$iv$iv;
            Model model = (Model)element$iv;
            boolean bl = false;
            if (model.getDtoVariants().contains(DtoVariant.CREATE) && HelpersKt.fieldsFor(model, DtoVariant.CREATE).isEmpty()) {
                validationErrors.add(ValidateModelsKt.createEmptyVariantError(model, DtoVariant.CREATE));
            }
            if (model.getDtoVariants().contains(DtoVariant.PATCH) && HelpersKt.fieldsFor(model, DtoVariant.PATCH).isEmpty()) {
                validationErrors.add(ValidateModelsKt.createEmptyVariantError(model, DtoVariant.PATCH));
            }
            element$iv$iv = model.getProperties();
            boolean $i$f$filterIsInstance = false;
            void bl2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof ForeignProperty)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Model targetModel;
                ForeignProperty foreignProperty = (ForeignProperty)element$iv2;
                boolean bl3 = false;
                String targetModelName = foreignProperty.getForeignModelName();
                if ((Model)modelsByName.get(targetModelName) == null) {
                    throw new IllegalStateException(("Unknown referenced model '" + targetModelName + "' in " + model.getName()).toString());
                }
                if (foreignProperty.getDtoVariants().contains(DtoVariant.CREATE) && !targetModel.getDtoVariants().contains(DtoVariant.CREATE)) {
                    validationErrors.add(ValidateModelsKt.createDependencyError(model, foreignProperty, targetModel, DtoVariant.CREATE));
                }
                if (!foreignProperty.getDtoVariants().contains(DtoVariant.PATCH) || targetModel.getDtoVariants().contains(DtoVariant.PATCH)) continue;
                validationErrors.add(ValidateModelsKt.createDependencyError(model, foreignProperty, targetModel, DtoVariant.PATCH));
            }
        }
        if (!((Collection)validationErrors).isEmpty()) {
            String finalReport = "Model validation failed with " + validationErrors.size() + " error(s):\n\n" + CollectionsKt.joinToString$default((Iterable)validationErrors, (CharSequence)"\n\n--------------------------------------------------\n\n", null, null, (int)0, null, null, (int)62, null);
            logger.error(finalReport);
            throw new IllegalStateException(finalReport.toString());
        }
    }

    private static final String createEmptyVariantError(Model model, DtoVariant dtoVariant) {
        return StringsKt.trimIndent((String)("\n    Model '" + model.getName() + "' has invalid configuration.\n    It is declared to support the " + dtoVariant.name() + " variant, but it contains no properties for this variant. This would result in an empty '" + model.getName() + dtoVariant.getSuffix() + "' class.\n    "));
    }

    private static final String createDependencyError(Model parentModel, ForeignProperty violatingProperty, Model targetModel, DtoVariant dtoVariant) {
        String parentVariantClassName = parentModel.getName() + dtoVariant.getSuffix();
        String nestedVariantClassName = targetModel.getName() + dtoVariant.getSuffix();
        return StringsKt.trimIndent((String)("\n    Cannot generate '" + parentVariantClassName + "': required nested model '" + nestedVariantClassName + "' cannot be generated.\n    Details:\n        Parent Model      : " + parentModel.getName() + " (variants: " + parentModel.getDtoVariants() + ")\n        Variant Requested : " + dtoVariant.name() + "\n        Nested Property   : " + violatingProperty.getName() + " (type: " + targetModel.getName() + ")\n    \n    Why:\n        The parent model '" + parentModel.getName() + "' is configured to generate a '" + dtoVariant.name() + "' variant.\n        This variant includes the property '" + violatingProperty.getName() + "', which refers to the model '" + targetModel.getName() + "'.\n        However, '" + targetModel.getName() + "' (variants: " + targetModel.getDtoVariants() + ") does not support the '" + dtoVariant.name() + "' variant.\n    \n    To fix this, either add '" + dtoVariant.name() + "' to the variants of '" + targetModel.getName() + "', or adjust the variants of the '" + violatingProperty.getName() + "' property.\n    "));
    }
}

