/*
 * Decompiled with CFR 0.152.
 */
package bloombox.client;

import bloombox.client.Bloombox$APIEnvironment$WhenMappings;
import bloombox.client.Bloombox$Services$WhenMappings;
import bloombox.client.Bloombox$WhenMappings;
import bloombox.client.interfaces.ServiceClient;
import bloombox.client.internals.mtls.ClientCredentials;
import bloombox.client.services.menu.MenuClient;
import bloombox.client.services.shop.ShopClient;
import bloombox.client.services.telemetry.TelemetryClient;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 !2\u00020\u0001:\u0007\u001e\u001f !\"#$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u0019*\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lbloombox/client/Bloombox;", "", "settings", "Lbloombox/client/Bloombox$Settings;", "target", "Lbloombox/client/Bloombox$ClientTarget;", "(Lbloombox/client/Bloombox$Settings;Lbloombox/client/Bloombox$ClientTarget;)V", "services", "Lbloombox/client/Bloombox$Services;", "getSettings$java_client", "()Lbloombox/client/Bloombox$Settings;", "close", "", "soft", "", "block", "timeout", "Ljava/time/Duration;", "menu", "Lbloombox/client/services/menu/MenuClient;", "shop", "Lbloombox/client/services/shop/ShopClient;", "telemetry", "Lbloombox/client/services/telemetry/TelemetryClient;", "host", "", "region", "Lbloombox/client/Bloombox$APIRegion;", "environment", "Lbloombox/client/Bloombox$APIEnvironment;", "APIEnvironment", "APIRegion", "ClientTarget", "Companion", "Endpoints", "Services", "Settings", "java-client"})
public final class Bloombox {
    private final Services services;
    @NotNull
    private final Settings settings;
    @NotNull
    public static final String VERSION = "1.0";
    @NotNull
    public static final String VARIANT = "full";
    public static final long defaultCloseTimeoutDuration = 10L;
    public static final long defaultRequestTimeoutDuration = 30L;
    public static final Companion Companion = new Companion(null);

    private final String host(@NotNull ClientTarget $receiver, APIRegion region, APIEnvironment environment) {
        String string;
        switch (Bloombox$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                string = "127.0.0.1";
                break;
            }
            case 2: {
                string = "api.bloombox.cloud";
                break;
            }
            case 3: {
                string = "" + environment.getCode() + '.' + region.getCode() + ".private.bloombox.cloud";
                break;
            }
            case 4: {
                string = "sandbox.usw1.bloombox.services";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    static /* bridge */ /* synthetic */ String host$default(Bloombox bloombox, ClientTarget clientTarget, APIRegion aPIRegion, APIEnvironment aPIEnvironment, int n, Object object) {
        if ((n & 1) != 0) {
            aPIRegion = APIRegion.USW1;
        }
        if ((n & 2) != 0) {
            aPIEnvironment = APIEnvironment.PRODUCTION;
        }
        return bloombox.host(clientTarget, aPIRegion, aPIEnvironment);
    }

    public final void close(boolean soft, boolean block, @Nullable Duration timeout) {
        Duration duration = timeout;
        if (duration == null) {
            duration = this.settings.getCloseTimeout$java_client();
        }
        Duration closeTimeout = duration;
        for (Object element$iv : (Object[])this.services.allServices$java_client()) {
            ServiceClient it;
            ServiceClient serviceClient = it = (ServiceClient)element$iv;
            if (serviceClient == null) continue;
            serviceClient.close(soft, block, (Pair<Long, ? extends TimeUnit>)new Pair((Object)closeTimeout.toMillis(), (Object)TimeUnit.MILLISECONDS));
        }
    }

    public static /* bridge */ /* synthetic */ void close$default(Bloombox bloombox, boolean bl, boolean bl2, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            duration = null;
        }
        bloombox.close(bl, bl2, duration);
    }

    @NotNull
    public final ShopClient shop() {
        return this.services.shopClient$java_client();
    }

    @NotNull
    public final TelemetryClient telemetry() {
        return this.services.telemetryClient$java_client();
    }

    @NotNull
    public final MenuClient menu() {
        return this.services.menuClient$java_client();
    }

    @NotNull
    public final Settings getSettings$java_client() {
        return this.settings;
    }

    public Bloombox(@NotNull Settings settings, @NotNull ClientTarget target) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)((Object)target), (String)"target");
        this.settings = settings;
        this.services = new Services(this.host(target, this.settings.getRegion$java_client(), this.settings.getEnvironment$java_client()), this.settings.getApiKey$java_client(), target);
    }

    public /* synthetic */ Bloombox(Settings settings, ClientTarget clientTarget, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            clientTarget = ClientTarget.PRODUCTION;
        }
        this(settings, clientTarget);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lbloombox/client/Bloombox$APIRegion;", "", "(Ljava/lang/String;I)V", "code", "", "getCode", "()Ljava/lang/String;", "USW1", "USC1", "java-client"})
    public static final class APIRegion
    extends Enum<APIRegion> {
        public static final /* enum */ APIRegion USW1;
        public static final /* enum */ APIRegion USC1;
        private static final /* synthetic */ APIRegion[] $VALUES;

        static {
            APIRegion[] aPIRegionArray = new APIRegion[2];
            APIRegion[] aPIRegionArray2 = aPIRegionArray;
            aPIRegionArray[0] = USW1 = new APIRegion();
            aPIRegionArray[1] = USC1 = new APIRegion();
            $VALUES = aPIRegionArray;
        }

        @NotNull
        public final String getCode() {
            String string;
            String string2 = string = this.name();
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return string3;
        }

        public static APIRegion[] values() {
            return (APIRegion[])$VALUES.clone();
        }

        public static APIRegion valueOf(String string) {
            return Enum.valueOf(APIRegion.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lbloombox/client/Bloombox$APIEnvironment;", "", "(Ljava/lang/String;I)V", "code", "", "getCode", "()Ljava/lang/String;", "PRODUCTION", "STAGING", "SANDBOX", "java-client"})
    public static final class APIEnvironment
    extends Enum<APIEnvironment> {
        public static final /* enum */ APIEnvironment PRODUCTION;
        public static final /* enum */ APIEnvironment STAGING;
        public static final /* enum */ APIEnvironment SANDBOX;
        private static final /* synthetic */ APIEnvironment[] $VALUES;

        static {
            APIEnvironment[] aPIEnvironmentArray = new APIEnvironment[3];
            APIEnvironment[] aPIEnvironmentArray2 = aPIEnvironmentArray;
            aPIEnvironmentArray[0] = PRODUCTION = new APIEnvironment();
            aPIEnvironmentArray[1] = STAGING = new APIEnvironment();
            aPIEnvironmentArray[2] = SANDBOX = new APIEnvironment();
            $VALUES = aPIEnvironmentArray;
        }

        @NotNull
        public final String getCode() {
            String string;
            switch (Bloombox$APIEnvironment$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    string = "prod";
                    break;
                }
                default: {
                    String string2;
                    String string3 = string2 = this.name();
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                }
            }
            return string;
        }

        public static APIEnvironment[] values() {
            return (APIEnvironment[])$VALUES.clone();
        }

        public static APIEnvironment valueOf(String string) {
            return Enum.valueOf(APIEnvironment.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lbloombox/client/Bloombox$ClientTarget;", "", "(Ljava/lang/String;I)V", "LOCAL", "SANDBOX", "INTERNAL", "PRODUCTION", "java-client"})
    public static final class ClientTarget
    extends Enum<ClientTarget> {
        public static final /* enum */ ClientTarget LOCAL;
        public static final /* enum */ ClientTarget SANDBOX;
        public static final /* enum */ ClientTarget INTERNAL;
        public static final /* enum */ ClientTarget PRODUCTION;
        private static final /* synthetic */ ClientTarget[] $VALUES;

        static {
            ClientTarget[] clientTargetArray = new ClientTarget[4];
            ClientTarget[] clientTargetArray2 = clientTargetArray;
            clientTargetArray[0] = LOCAL = new ClientTarget();
            clientTargetArray[1] = SANDBOX = new ClientTarget();
            clientTargetArray[2] = INTERNAL = new ClientTarget();
            clientTargetArray[3] = PRODUCTION = new ClientTarget();
            $VALUES = clientTargetArray;
        }

        public static ClientTarget[] values() {
            return (ClientTarget[])$VALUES.clone();
        }

        public static ClientTarget valueOf(String string) {
            return Enum.valueOf(ClientTarget.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 C2\u00020\u0001:\u0001CBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010'\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b(J\u000e\u0010)\u001a\u00020\u0010H\u00c0\u0003\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u0004\u0018\u00010\u0013H\u00c0\u0003\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b2J\u000e\u00103\u001a\u00020\bH\u00c0\u0003\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u00020\nH\u00c0\u0003\u00a2\u0006\u0002\b6J\u000e\u00107\u001a\u00020\fH\u00c0\u0003\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u000eH\u00c0\u0003\u00a2\u0006\u0002\b:J\u000e\u0010;\u001a\u00020\u0010H\u00c0\u0003\u00a2\u0006\u0002\b<J\u007f\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00c6\u0001J\u0013\u0010>\u001a\u00020\n2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010@\u001a\u00020AH\u00d6\u0001J\t\u0010B\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0011\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001a\u00a8\u0006D"}, d2={"Lbloombox/client/Bloombox$Settings;", "", "apiKey", "", "partner", "location", "device", "region", "Lbloombox/client/Bloombox$APIRegion;", "enableLogging", "", "environment", "Lbloombox/client/Bloombox$APIEnvironment;", "executor", "Ljava/util/concurrent/Executor;", "requestTimeout", "Ljava/time/Duration;", "closeTimeout", "clientCredentials", "Lbloombox/client/internals/mtls/ClientCredentials;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lbloombox/client/Bloombox$APIRegion;ZLbloombox/client/Bloombox$APIEnvironment;Ljava/util/concurrent/Executor;Ljava/time/Duration;Ljava/time/Duration;Lbloombox/client/internals/mtls/ClientCredentials;)V", "getApiKey$java_client", "()Ljava/lang/String;", "getClientCredentials$java_client", "()Lbloombox/client/internals/mtls/ClientCredentials;", "getCloseTimeout$java_client", "()Ljava/time/Duration;", "getDevice$java_client", "getEnableLogging$java_client", "()Z", "getEnvironment$java_client", "()Lbloombox/client/Bloombox$APIEnvironment;", "getExecutor$java_client", "()Ljava/util/concurrent/Executor;", "getLocation$java_client", "getPartner$java_client", "getRegion$java_client", "()Lbloombox/client/Bloombox$APIRegion;", "getRequestTimeout$java_client", "component1", "component1$java_client", "component10", "component10$java_client", "component11", "component11$java_client", "component2", "component2$java_client", "component3", "component3$java_client", "component4", "component4$java_client", "component5", "component5$java_client", "component6", "component6$java_client", "component7", "component7$java_client", "component8", "component8$java_client", "component9", "component9$java_client", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "java-client"})
    public static final class Settings {
        @NotNull
        private final String apiKey;
        @Nullable
        private final String partner;
        @Nullable
        private final String location;
        @Nullable
        private final String device;
        @NotNull
        private final APIRegion region;
        private final boolean enableLogging;
        @NotNull
        private final APIEnvironment environment;
        @NotNull
        private final Executor executor;
        @NotNull
        private final Duration requestTimeout;
        @NotNull
        private final Duration closeTimeout;
        @Nullable
        private final ClientCredentials clientCredentials;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getApiKey$java_client() {
            return this.apiKey;
        }

        @Nullable
        public final String getPartner$java_client() {
            return this.partner;
        }

        @Nullable
        public final String getLocation$java_client() {
            return this.location;
        }

        @Nullable
        public final String getDevice$java_client() {
            return this.device;
        }

        @NotNull
        public final APIRegion getRegion$java_client() {
            return this.region;
        }

        public final boolean getEnableLogging$java_client() {
            return this.enableLogging;
        }

        @NotNull
        public final APIEnvironment getEnvironment$java_client() {
            return this.environment;
        }

        @NotNull
        public final Executor getExecutor$java_client() {
            return this.executor;
        }

        @NotNull
        public final Duration getRequestTimeout$java_client() {
            return this.requestTimeout;
        }

        @NotNull
        public final Duration getCloseTimeout$java_client() {
            return this.closeTimeout;
        }

        @Nullable
        public final ClientCredentials getClientCredentials$java_client() {
            return this.clientCredentials;
        }

        public Settings(@NotNull String apiKey, @Nullable String partner, @Nullable String location, @Nullable String device, @NotNull APIRegion region, boolean enableLogging, @NotNull APIEnvironment environment, @NotNull Executor executor, @NotNull Duration requestTimeout, @NotNull Duration closeTimeout, @Nullable ClientCredentials clientCredentials) {
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
            Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)requestTimeout, (String)"requestTimeout");
            Intrinsics.checkParameterIsNotNull((Object)closeTimeout, (String)"closeTimeout");
            this.apiKey = apiKey;
            this.partner = partner;
            this.location = location;
            this.device = device;
            this.region = region;
            this.enableLogging = enableLogging;
            this.environment = environment;
            this.executor = executor;
            this.requestTimeout = requestTimeout;
            this.closeTimeout = closeTimeout;
            this.clientCredentials = clientCredentials;
        }

        public /* synthetic */ Settings(String string, String string2, String string3, String string4, APIRegion aPIRegion, boolean bl, APIEnvironment aPIEnvironment, Executor executor, Duration duration, Duration duration2, ClientCredentials clientCredentials, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                aPIRegion = APIRegion.USW1;
            }
            if ((n & 0x20) != 0) {
                bl = false;
            }
            if ((n & 0x40) != 0) {
                aPIEnvironment = APIEnvironment.PRODUCTION;
            }
            if ((n & 0x80) != 0) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
                executor = executorService;
            }
            if ((n & 0x100) != 0) {
                Duration duration3 = Duration.ofSeconds(30L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofSeconds(defaultRequestTimeoutDuration)");
                duration = duration3;
            }
            if ((n & 0x200) != 0) {
                Duration duration4 = Duration.ofSeconds(10L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofSeconds(defaultCloseTimeoutDuration)");
                duration2 = duration4;
            }
            if ((n & 0x400) != 0) {
                clientCredentials = null;
            }
            this(string, string2, string3, string4, aPIRegion, bl, aPIEnvironment, executor, duration, duration2, clientCredentials);
        }

        @NotNull
        public final String component1$java_client() {
            return this.apiKey;
        }

        @Nullable
        public final String component2$java_client() {
            return this.partner;
        }

        @Nullable
        public final String component3$java_client() {
            return this.location;
        }

        @Nullable
        public final String component4$java_client() {
            return this.device;
        }

        @NotNull
        public final APIRegion component5$java_client() {
            return this.region;
        }

        public final boolean component6$java_client() {
            return this.enableLogging;
        }

        @NotNull
        public final APIEnvironment component7$java_client() {
            return this.environment;
        }

        @NotNull
        public final Executor component8$java_client() {
            return this.executor;
        }

        @NotNull
        public final Duration component9$java_client() {
            return this.requestTimeout;
        }

        @NotNull
        public final Duration component10$java_client() {
            return this.closeTimeout;
        }

        @Nullable
        public final ClientCredentials component11$java_client() {
            return this.clientCredentials;
        }

        @NotNull
        public final Settings copy(@NotNull String apiKey, @Nullable String partner, @Nullable String location, @Nullable String device, @NotNull APIRegion region, boolean enableLogging, @NotNull APIEnvironment environment, @NotNull Executor executor, @NotNull Duration requestTimeout, @NotNull Duration closeTimeout, @Nullable ClientCredentials clientCredentials) {
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)region), (String)"region");
            Intrinsics.checkParameterIsNotNull((Object)((Object)environment), (String)"environment");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)requestTimeout, (String)"requestTimeout");
            Intrinsics.checkParameterIsNotNull((Object)closeTimeout, (String)"closeTimeout");
            return new Settings(apiKey, partner, location, device, region, enableLogging, environment, executor, requestTimeout, closeTimeout, clientCredentials);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Settings copy$default(Settings settings, String string, String string2, String string3, String string4, APIRegion aPIRegion, boolean bl, APIEnvironment aPIEnvironment, Executor executor, Duration duration, Duration duration2, ClientCredentials clientCredentials, int n, Object object) {
            if ((n & 1) != 0) {
                string = settings.apiKey;
            }
            if ((n & 2) != 0) {
                string2 = settings.partner;
            }
            if ((n & 4) != 0) {
                string3 = settings.location;
            }
            if ((n & 8) != 0) {
                string4 = settings.device;
            }
            if ((n & 0x10) != 0) {
                aPIRegion = settings.region;
            }
            if ((n & 0x20) != 0) {
                bl = settings.enableLogging;
            }
            if ((n & 0x40) != 0) {
                aPIEnvironment = settings.environment;
            }
            if ((n & 0x80) != 0) {
                executor = settings.executor;
            }
            if ((n & 0x100) != 0) {
                duration = settings.requestTimeout;
            }
            if ((n & 0x200) != 0) {
                duration2 = settings.closeTimeout;
            }
            if ((n & 0x400) != 0) {
                clientCredentials = settings.clientCredentials;
            }
            return settings.copy(string, string2, string3, string4, aPIRegion, bl, aPIEnvironment, executor, duration, duration2, clientCredentials);
        }

        public String toString() {
            return "Settings(apiKey=" + this.apiKey + ", partner=" + this.partner + ", location=" + this.location + ", device=" + this.device + ", region=" + (Object)((Object)this.region) + ", enableLogging=" + this.enableLogging + ", environment=" + (Object)((Object)this.environment) + ", executor=" + this.executor + ", requestTimeout=" + this.requestTimeout + ", closeTimeout=" + this.closeTimeout + ", clientCredentials=" + this.clientCredentials + ")";
        }

        public int hashCode() {
            String string = this.apiKey;
            String string2 = this.partner;
            String string3 = this.location;
            String string4 = this.device;
            APIRegion aPIRegion = this.region;
            int n = (((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (aPIRegion != null ? ((Object)((Object)aPIRegion)).hashCode() : 0)) * 31;
            int n2 = this.enableLogging ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            APIEnvironment aPIEnvironment = this.environment;
            Executor executor = this.executor;
            Duration duration = this.requestTimeout;
            Duration duration2 = this.closeTimeout;
            ClientCredentials clientCredentials = this.clientCredentials;
            return (((((n + n2) * 31 + (aPIEnvironment != null ? ((Object)((Object)aPIEnvironment)).hashCode() : 0)) * 31 + (executor != null ? executor.hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0)) * 31 + (clientCredentials != null ? ((Object)clientCredentials).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (!Intrinsics.areEqual((Object)this.apiKey, (Object)settings.apiKey) || !Intrinsics.areEqual((Object)this.partner, (Object)settings.partner) || !Intrinsics.areEqual((Object)this.location, (Object)settings.location) || !Intrinsics.areEqual((Object)this.device, (Object)settings.device) || !Intrinsics.areEqual((Object)((Object)this.region), (Object)((Object)settings.region)) || !(this.enableLogging == settings.enableLogging) || !Intrinsics.areEqual((Object)((Object)this.environment), (Object)((Object)settings.environment)) || !Intrinsics.areEqual((Object)this.executor, (Object)settings.executor) || !Intrinsics.areEqual((Object)this.requestTimeout, (Object)settings.requestTimeout) || !Intrinsics.areEqual((Object)this.closeTimeout, (Object)settings.closeTimeout) || !Intrinsics.areEqual((Object)this.clientCredentials, (Object)settings.clientCredentials)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lbloombox/client/Bloombox$Settings$Companion;", "", "()V", "defaults", "Lbloombox/client/Bloombox$Settings;", "apiKey", "", "partner", "location", "withLogging", "java-client"})
        public static final class Companion {
            @NotNull
            public final Settings defaults(@NotNull String apiKey, @NotNull String partner, @NotNull String location) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                Intrinsics.checkParameterIsNotNull((Object)partner, (String)"partner");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                return new Settings(apiKey, partner, location, null, null, false, null, null, null, null, null, 2040, null);
            }

            @NotNull
            public final Settings withLogging(@NotNull String apiKey, @NotNull String partner, @NotNull String location) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                Intrinsics.checkParameterIsNotNull((Object)partner, (String)"partner");
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                return new Settings(apiKey, partner, location, null, null, true, null, null, null, null, null, 2008, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbloombox/client/Bloombox$Endpoints;", "", "()V", "grpcPort", "", "internal", "", "localMenuPort", "localShopPort", "localTelemetryPort", "production", "sandbox", "java-client"})
    public static final class Endpoints {
        @NotNull
        public static final String production = "api.bloombox.cloud";
        @NotNull
        public static final String internal = "private.bloombox.cloud";
        @NotNull
        public static final String sandbox = "sandbox.usw1.bloombox.services";
        public static final int grpcPort = 443;
        public static final int localTelemetryPort = 1090;
        public static final int localShopPort = 1091;
        public static final int localMenuPort = 1094;
        public static final Endpoints INSTANCE;

        private Endpoints() {
        }

        static {
            Endpoints endpoints;
            INSTANCE = endpoints = new Endpoints();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lbloombox/client/Bloombox$Services;", "", "domain", "", "apiKey", "ct", "Lbloombox/client/Bloombox$ClientTarget;", "(Lbloombox/client/Bloombox;Ljava/lang/String;Ljava/lang/String;Lbloombox/client/Bloombox$ClientTarget;)V", "serviceMap", "Ljava/util/HashMap;", "Lbloombox/client/interfaces/ServiceClient;", "Lkotlin/collections/HashMap;", "allServices", "", "allServices$java_client", "()[Lbloombox/client/interfaces/ServiceClient;", "menuClient", "Lbloombox/client/services/menu/MenuClient;", "menuClient$java_client", "shopClient", "Lbloombox/client/services/shop/ShopClient;", "shopClient$java_client", "telemetryClient", "Lbloombox/client/services/telemetry/TelemetryClient;", "telemetryClient$java_client", "java-client"})
    private final class Services {
        private HashMap<String, ServiceClient> serviceMap;
        private final String domain;
        private final String apiKey;
        private final ClientTarget ct;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ShopClient shopClient$java_client() {
            ShopClient shopClient;
            if (this.serviceMap.get("shop") == null) {
                void var1_1;
                ShopClient shopClient2;
                if (Intrinsics.areEqual((Object)((Object)this.ct), (Object)((Object)ClientTarget.LOCAL))) {
                    shopClient2 = new ShopClient(this.domain, 1091, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), 240, null);
                } else {
                    String string;
                    switch (Bloombox$Services$WhenMappings.$EnumSwitchMapping$0[this.ct.ordinal()]) {
                        case 1: 
                        case 2: {
                            string = "shop.rpc." + this.domain;
                            break;
                        }
                        default: {
                            string = "shop." + this.domain;
                        }
                    }
                    shopClient2 = new ShopClient(string, 443, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), 240, null);
                }
                ShopClient shopClient3 = shopClient2;
                Map map = this.serviceMap;
                String string = "shop";
                ShopClient shopClient4 = shopClient3;
                map.put(string, shopClient4);
                shopClient = var1_1;
            } else {
                ServiceClient serviceClient = this.serviceMap.get("shop");
                if (!(serviceClient instanceof ShopClient)) {
                    serviceClient = null;
                }
                shopClient = (ShopClient)serviceClient;
            }
            if (shopClient == null) {
                throw (Throwable)new IllegalStateException("Failed to initialize shop client.");
            }
            return shopClient;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TelemetryClient telemetryClient$java_client() {
            TelemetryClient telemetryClient;
            if (this.serviceMap.get("telemetry") == null) {
                void var1_1;
                TelemetryClient telemetryClient2;
                if (Intrinsics.areEqual((Object)((Object)this.ct), (Object)((Object)ClientTarget.LOCAL))) {
                    telemetryClient2 = new TelemetryClient(this.domain, 1090, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), Bloombox.this.getSettings$java_client().getDevice$java_client(), 240, null);
                } else {
                    String string;
                    switch (Bloombox$Services$WhenMappings.$EnumSwitchMapping$1[this.ct.ordinal()]) {
                        case 1: 
                        case 2: {
                            string = "telemetry.rpc." + this.domain;
                            break;
                        }
                        default: {
                            string = "telemetry." + this.domain;
                        }
                    }
                    telemetryClient2 = new TelemetryClient(string, 443, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), Bloombox.this.getSettings$java_client().getDevice$java_client(), 240, null);
                }
                TelemetryClient telemetryClient3 = telemetryClient2;
                Map map = this.serviceMap;
                String string = "telemetry";
                TelemetryClient telemetryClient4 = telemetryClient3;
                map.put(string, telemetryClient4);
                telemetryClient = var1_1;
            } else {
                ServiceClient serviceClient = this.serviceMap.get("telemetry");
                if (!(serviceClient instanceof TelemetryClient)) {
                    serviceClient = null;
                }
                telemetryClient = (TelemetryClient)serviceClient;
            }
            if (telemetryClient == null) {
                throw (Throwable)new IllegalStateException("Failed to initialize telemetry client.");
            }
            return telemetryClient;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MenuClient menuClient$java_client() {
            MenuClient menuClient;
            if (this.serviceMap.get("menu") == null) {
                void var1_1;
                MenuClient menuClient2;
                if (Intrinsics.areEqual((Object)((Object)this.ct), (Object)((Object)ClientTarget.LOCAL))) {
                    menuClient2 = new MenuClient(this.domain, 1094, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), 240, null);
                } else {
                    String string;
                    switch (Bloombox$Services$WhenMappings.$EnumSwitchMapping$2[this.ct.ordinal()]) {
                        case 1: 
                        case 2: {
                            string = "menu.rpc." + this.domain;
                            break;
                        }
                        default: {
                            string = "menu." + this.domain;
                        }
                    }
                    menuClient2 = new MenuClient(string, 443, this.apiKey, Bloombox.this.getSettings$java_client().getRequestTimeout$java_client(), null, null, null, null, Bloombox.this.getSettings$java_client().getExecutor$java_client(), Bloombox.this.getSettings$java_client().getPartner$java_client(), Bloombox.this.getSettings$java_client().getLocation$java_client(), 240, null);
                }
                MenuClient menuClient3 = menuClient2;
                Map map = this.serviceMap;
                String string = "menu";
                MenuClient menuClient4 = menuClient3;
                map.put(string, menuClient4);
                menuClient = var1_1;
            } else {
                ServiceClient serviceClient = this.serviceMap.get("menu");
                if (!(serviceClient instanceof MenuClient)) {
                    serviceClient = null;
                }
                menuClient = (MenuClient)serviceClient;
            }
            if (menuClient == null) {
                throw (Throwable)new IllegalStateException("Failed to initialize menu client.");
            }
            return menuClient;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ServiceClient[] allServices$java_client() {
            void var2_2;
            int size$iv = this.serviceMap.size();
            ServiceClient[] result$iv = new ServiceClient[size$iv];
            int n = 0;
            int n2 = result$iv.length;
            while (n < n2) {
                void it;
                ServiceClient serviceClient;
                void i$iv;
                void var5_5 = i$iv;
                void var9_7 = i$iv++;
                ServiceClient[] serviceClientArray = result$iv;
                Collection<ServiceClient> collection = this.serviceMap.values();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"serviceMap.values");
                serviceClientArray[var9_7] = serviceClient = (ServiceClient)CollectionsKt.elementAt((Iterable)collection, (int)it);
            }
            return var2_2;
        }

        public Services(@NotNull String domain, @NotNull String apiKey, ClientTarget ct) {
            Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Intrinsics.checkParameterIsNotNull((Object)((Object)ct), (String)"ct");
            this.domain = domain;
            this.apiKey = apiKey;
            this.ct = ct;
            this.serviceMap = new HashMap();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lbloombox/client/Bloombox$Companion;", "", "()V", "VARIANT", "", "VERSION", "defaultCloseTimeoutDuration", "", "defaultRequestTimeoutDuration", "java-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

