/*
 * Decompiled with CFR 0.152.
 */
package bloombox.client.internals.rpc;

import bloombox.client.ClientException;
import bloombox.client.internals.mtls.ClientCredentials;
import bloombox.client.internals.rpc.RPCClient$WhenMappings;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.ForwardingClientCall;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.ClientAuth;
import java.io.InputStream;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@kotlin.Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 $2\u00020\u0001:\u0003#$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lbloombox/client/internals/rpc/RPCClient;", "", "apiKey", "", "(Ljava/lang/String;)V", "channel", "Lio/grpc/ManagedChannel;", "getChannel", "()Lio/grpc/ManagedChannel;", "interceptor", "Lbloombox/client/internals/rpc/RPCClient$APIKeyInterceptor;", "channelBuilder", "Lio/grpc/netty/NettyChannelBuilder;", "host", "port", "", "transportMode", "Lbloombox/client/internals/rpc/RPCClient$TransportMode;", "clientAuth", "Lio/netty/handler/ssl/ClientAuth;", "clientCredentials", "Lbloombox/client/internals/mtls/ClientCredentials;", "clientAuthorityRoots", "Ljava/io/InputStream;", "executor", "Ljava/util/concurrent/Executor;", "close", "", "soft", "", "block", "timeout", "Lkotlin/Pair;", "", "Ljava/util/concurrent/TimeUnit;", "APIKeyInterceptor", "Companion", "TransportMode", "java-client"})
public abstract class RPCClient {
    private final APIKeyInterceptor interceptor;
    private static final String defaultAuthorityRoots = "/authority-roots.pem";
    private static final long sessionCacheSize = 100L;
    private static final long sessionCacheTimeout = 3600L;
    private static final boolean keepalive = true;
    private static final long keepaliveTime = 60L;
    private static final long keepaliveTimeout = 90L;
    private static final long idleConnectionTimeout = 120L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract ManagedChannel getChannel();

    public final void close(boolean soft, boolean block, @NotNull Pair<Long, ? extends TimeUnit> timeout) {
        Intrinsics.checkParameterIsNotNull(timeout, (String)"timeout");
        if (!this.getChannel().isShutdown()) {
            if (soft) {
                this.getChannel().shutdown();
            } else {
                this.getChannel().shutdownNow();
            }
            if (block) {
                this.getChannel().awaitTermination(((Number)timeout.getFirst()).longValue(), (TimeUnit)((Object)timeout.getSecond()));
            }
        }
    }

    @NotNull
    public final NettyChannelBuilder channelBuilder(@NotNull String host, int port, @NotNull TransportMode transportMode, @NotNull ClientAuth clientAuth, @Nullable ClientCredentials clientCredentials, @Nullable InputStream clientAuthorityRoots, @NotNull Executor executor) {
        NettyChannelBuilder nettyChannelBuilder;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)((Object)transportMode), (String)"transportMode");
        Intrinsics.checkParameterIsNotNull((Object)clientAuth, (String)"clientAuth");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        NettyChannelBuilder builder = (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).executor(executor)).idleTimeout(120L, TimeUnit.SECONDS);
        builder.intercept(new ClientInterceptor[]{this.interceptor});
        builder.keepAliveTime(60L, TimeUnit.SECONDS).keepAliveTimeout(90L, TimeUnit.SECONDS);
        CompressorRegistry compressionRegistry = CompressorRegistry.newEmptyInstance();
        DecompressorRegistry decompressorRegistry = DecompressorRegistry.emptyInstance().with((Decompressor)new Codec.Gzip(), true).with((Decompressor)Codec.Identity.NONE, false);
        compressionRegistry.register((Compressor)new Codec.Gzip());
        compressionRegistry.register((Compressor)Codec.Identity.NONE);
        builder.compressorRegistry(compressionRegistry);
        builder.decompressorRegistry(decompressorRegistry);
        switch (RPCClient$WhenMappings.$EnumSwitchMapping$0[transportMode.ordinal()]) {
            case 1: {
                NettyChannelBuilder nettyChannelBuilder2;
                if (Intrinsics.areEqual((Object)clientAuth, (Object)ClientAuth.NONE)) {
                    NettyChannelBuilder nettyChannelBuilder3 = builder.negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().trustManager(RPCClient.Companion.authorityRoots(clientAuthorityRoots)).build());
                    nettyChannelBuilder2 = nettyChannelBuilder3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)nettyChannelBuilder3, (String)"builder\n                \u2026                .build())");
                } else {
                    if (clientCredentials == null) {
                        throw (Throwable)new IllegalArgumentException("Configuration error: Client auth is active, but no credentials were provided.");
                    }
                    NettyChannelBuilder nettyChannelBuilder4 = builder.negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().trustManager(RPCClient.Companion.authorityRoots(clientAuthorityRoots)).clientAuth(clientAuth).keyManager(clientCredentials.getCertificate$java_client(), clientCredentials.getPrivateKey$java_client(), clientCredentials.getKeyPassword$java_client()).sessionCacheSize(100L).sessionTimeout(3600L).build());
                    nettyChannelBuilder2 = nettyChannelBuilder4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)nettyChannelBuilder4, (String)"builder\n                \u2026                .build())");
                }
                return nettyChannelBuilder2;
            }
            case 2: {
                nettyChannelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).executor(executor)).sslContext(GrpcSslContexts.forClient().trustManager(RPCClient.Companion.authorityRoots(clientAuthorityRoots)).build());
                Intrinsics.checkExpressionValueIsNotNull((Object)nettyChannelBuilder, (String)"NettyChannelBuilder\n    \u2026                .build())");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return nettyChannelBuilder;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ NettyChannelBuilder channelBuilder$default(RPCClient rPCClient, String string, int n, TransportMode transportMode, ClientAuth clientAuth, ClientCredentials clientCredentials, InputStream inputStream, Executor executor, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: channelBuilder");
        }
        if ((n2 & 0x10) != 0) {
            clientCredentials = null;
        }
        return rPCClient.channelBuilder(string, n, transportMode, clientAuth, clientCredentials, inputStream, executor);
    }

    public RPCClient(@NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this.interceptor = new APIKeyInterceptor(apiKey);
    }

    @JvmStatic
    private static final void handleError(Throwable err, Function1<? super ClientException, Unit> cbk) {
        RPCClient.Companion.handleError(err, (Function1<? super ClientException, Unit>)cbk);
    }

    @JvmStatic
    @NotNull
    public static final <T> ListenableFuture<T> executeAndDispatchCallback(@NotNull ListenableFuture<T> op, @Nullable Function1<? super T, Unit> callback, @Nullable Function1<? super ClientException, Unit> err, @NotNull Duration timeout) {
        return Companion.executeAndDispatchCallback(op, callback, err, timeout);
    }

    @kotlin.Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lbloombox/client/internals/rpc/RPCClient$TransportMode;", "", "(Ljava/lang/String;I)V", "SECURE", "CLEARTEXT", "java-client"})
    public static final class TransportMode
    extends Enum<TransportMode> {
        public static final /* enum */ TransportMode SECURE;
        public static final /* enum */ TransportMode CLEARTEXT;
        private static final /* synthetic */ TransportMode[] $VALUES;

        static {
            TransportMode[] transportModeArray = new TransportMode[2];
            TransportMode[] transportModeArray2 = transportModeArray;
            transportModeArray[0] = SECURE = new TransportMode();
            transportModeArray[1] = CLEARTEXT = new TransportMode();
            $VALUES = transportModeArray;
        }

        public static TransportMode[] values() {
            return (TransportMode[])$VALUES.clone();
        }

        public static TransportMode valueOf(String string) {
            return Enum.valueOf(TransportMode.class, string);
        }
    }

    @kotlin.Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lbloombox/client/internals/rpc/RPCClient$APIKeyInterceptor;", "Lio/grpc/ClientInterceptor;", "apikey", "", "(Ljava/lang/String;)V", "interceptCall", "Lio/grpc/ClientCall;", "ReqT", "RespT", "method", "Lio/grpc/MethodDescriptor;", "callOptions", "Lio/grpc/CallOptions;", "next", "Lio/grpc/Channel;", "Companion", "java-client"})
    protected static final class APIKeyInterceptor
    implements ClientInterceptor {
        private final String apikey;
        @NotNull
        private static final Metadata.Key<String> apiKeyHeader;
        public static final Companion Companion;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(@Nullable MethodDescriptor<ReqT, RespT> method, @Nullable CallOptions callOptions, @NotNull Channel next) {
            void call;
            Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            ClientCall clientCall = next.newCall(method, callOptions);
            Intrinsics.checkExpressionValueIsNotNull((Object)clientCall, (String)"next.newCall(method, callOptions)");
            objectRef.element = clientCall;
            call.element = (ClientCall)new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(this, (Ref.ObjectRef)call, (ClientCall)call.element){
                final /* synthetic */ APIKeyInterceptor this$0;
                final /* synthetic */ Ref.ObjectRef $call;

                public void start(@NotNull ClientCall.Listener<RespT> responseListener, @NotNull Metadata headers) {
                    Intrinsics.checkParameterIsNotNull(responseListener, (String)"responseListener");
                    Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
                    if (APIKeyInterceptor.access$getApikey$p(this.this$0) != null && APIKeyInterceptor.access$getApikey$p(this.this$0).length() > 2) {
                        headers.put(APIKeyInterceptor.Companion.getApiKeyHeader(), (Object)APIKeyInterceptor.access$getApikey$p(this.this$0));
                    }
                    super.start(responseListener, headers);
                }
                {
                    this.this$0 = $outer;
                    this.$call = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            return (ClientCall)call.element;
        }

        public APIKeyInterceptor(@Nullable String apikey) {
            this.apikey = apikey;
        }

        static {
            Companion = new Companion(null);
            Metadata.Key key = Metadata.Key.of((String)"x-api-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"io.grpc.Metadata.Key.of(\u2026.ASCII_STRING_MARSHALLER)");
            apiKeyHeader = key;
        }

        @Nullable
        public static final /* synthetic */ String access$getApikey$p(APIKeyInterceptor $this) {
            return $this.apikey;
        }

        @kotlin.Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lbloombox/client/internals/rpc/RPCClient$APIKeyInterceptor$Companion;", "", "()V", "apiKeyHeader", "Lio/grpc/Metadata$Key;", "", "getApiKeyHeader", "()Lio/grpc/Metadata$Key;", "java-client"})
        public static final class Companion {
            @NotNull
            public final Metadata.Key<String> getApiKeyHeader() {
                return apiKeyHeader;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlin.Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002JX\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00112\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0016\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J*\u0010\u001b\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lbloombox/client/internals/rpc/RPCClient$Companion;", "", "()V", "defaultAuthorityRoots", "", "idleConnectionTimeout", "", "keepalive", "", "keepaliveTime", "keepaliveTimeout", "sessionCacheSize", "sessionCacheTimeout", "authorityRoots", "Ljava/io/InputStream;", "custom", "executeAndDispatchCallback", "Lcom/google/common/util/concurrent/ListenableFuture;", "T", "op", "callback", "Lkotlin/Function1;", "", "err", "Lbloombox/client/ClientException;", "timeout", "Ljava/time/Duration;", "handleError", "", "cbk", "java-client"})
    public static final class Companion {
        private final InputStream authorityRoots(InputStream custom) {
            InputStream inputStream = custom;
            if (inputStream == null) {
                InputStream inputStream2 = RPCClient.class.getResourceAsStream(RPCClient.defaultAuthorityRoots);
                inputStream = inputStream2;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"RPCClient::class.java.ge\u2026am(defaultAuthorityRoots)");
            }
            return inputStream;
        }

        @JvmStatic
        private final void handleError(Throwable err, Function1<? super ClientException, Unit> cbk) {
            if (err instanceof ClientException) {
                Function1<? super ClientException, Unit> function1 = cbk;
                if (function1 != null) {
                    Unit cfr_ignored_0 = (Unit)function1.invoke((Object)err);
                }
            } else {
                if (err != null) {
                    throw err;
                }
                throw (Throwable)new IllegalStateException("Invalid null failure result.");
            }
        }

        @JvmStatic
        @NotNull
        public final <T> ListenableFuture<T> executeAndDispatchCallback(@NotNull ListenableFuture<T> op, @Nullable Function1<? super T, Unit> callback, @Nullable Function1<? super ClientException, Unit> err, @NotNull Duration timeout) {
            Intrinsics.checkParameterIsNotNull(op, (String)"op");
            Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
            try {
                Object response = op.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                if (response != null && callback != null) {
                    callback.invoke(response);
                }
            }
            catch (ClientException e) {
                this.handleError(e, err);
            }
            catch (StatusRuntimeException e) {
                this.handleError(e, err);
            }
            return op;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

