/*
 * Decompiled with CFR 0.152.
 */
package bloombox.client.services.telemetry;

import bloombox.client.interfaces.ServiceClient;
import bloombox.client.internals.mtls.ClientCredentials;
import bloombox.client.internals.rpc.RPCClient;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.bloombox.schema.identity.UserKey;
import io.bloombox.schema.services.telemetry.v1beta3.CommercialTelemetryGrpc;
import io.bloombox.schema.services.telemetry.v1beta3.Event;
import io.bloombox.schema.services.telemetry.v1beta3.EventTelemetryGrpc;
import io.bloombox.schema.services.telemetry.v1beta3.IdentityTelemetryGrpc;
import io.bloombox.schema.services.telemetry.v1beta3.TelemetryPing;
import io.bloombox.schema.telemetry.AnalyticsContext;
import io.bloombox.schema.telemetry.AnalyticsEvent;
import io.bloombox.schema.telemetry.AnalyticsScope;
import io.bloombox.schema.telemetry.context.AnalyticsCollection;
import io.bloombox.schema.telemetry.context.BrowserContext;
import io.bloombox.schema.telemetry.context.DeviceContext;
import io.bloombox.schema.telemetry.context.LibraryContext;
import io.bloombox.schema.telemetry.context.OperatingSystemContext;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.netty.handler.ssl.ClientAuth;
import io.opencannabis.schema.base.ProductKey;
import io.opencannabis.schema.menu.section.Section;
import io.opencannabis.schema.struct.VersionSpec;
import io.opencannabis.schema.temporal.Instant;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 L2\u00020\u00012\u00020\u0002:\u0002LMB\u007f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0017JO\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00042\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010=\u001a\u0004\u0018\u00010>2\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A\u0018\u00010@2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010C\u00a2\u0006\u0002\u0010DJ&\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00042\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A\u0018\u00010@J2\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00042\u0016\b\u0002\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020A\u0018\u00010@2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010CJ&\u0010E\u001a\u00020:2\u001e\b\u0002\u0010F\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010>\u0012\u0004\u0012\u00020:\u0018\u00010Gj\u0004\u0018\u0001`HJ\u001c\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020\u00042\n\b\u0002\u0010B\u001a\u0004\u0018\u00010CH\u0002J0\u0010K\u001a\u00020J*\u00020C2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0019R\u0016\u0010,\u001a\n (*\u0004\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0019R\u0016\u00101\u001a\n (*\u0004\u0018\u00010202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006N"}, d2={"Lbloombox/client/services/telemetry/TelemetryClient;", "Lbloombox/client/internals/rpc/RPCClient;", "Lbloombox/client/interfaces/ServiceClient;", "host", "", "port", "", "apiKey", "timeout", "Ljava/time/Duration;", "transportMode", "Lbloombox/client/internals/rpc/RPCClient$TransportMode;", "clientAuth", "Lio/netty/handler/ssl/ClientAuth;", "clientCredentials", "Lbloombox/client/internals/mtls/ClientCredentials;", "clientAuthorityRoots", "Ljava/io/InputStream;", "executor", "Ljava/util/concurrent/Executor;", "defaultPartner", "defaultLocation", "deviceUUID", "(Ljava/lang/String;ILjava/lang/String;Ljava/time/Duration;Lbloombox/client/internals/rpc/RPCClient$TransportMode;Lio/netty/handler/ssl/ClientAuth;Lbloombox/client/internals/mtls/ClientCredentials;Ljava/io/InputStream;Ljava/util/concurrent/Executor;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "b64", "Lorg/apache/commons/codec/binary/Base64;", "channel", "Lio/grpc/ManagedChannel;", "getChannel", "()Lio/grpc/ManagedChannel;", "getClientAuth", "()Lio/netty/handler/ssl/ClientAuth;", "getClientAuthorityRoots", "()Ljava/io/InputStream;", "getClientCredentials", "()Lbloombox/client/internals/mtls/ClientCredentials;", "commercialService", "Lio/bloombox/schema/services/telemetry/v1beta3/CommercialTelemetryGrpc$CommercialTelemetryFutureStub;", "kotlin.jvm.PlatformType", "getDefaultLocation$java_client", "getDefaultPartner$java_client", "getDeviceUUID$java_client", "eventService", "Lio/bloombox/schema/services/telemetry/v1beta3/EventTelemetryGrpc$EventTelemetryFutureStub;", "getExecutor", "()Ljava/util/concurrent/Executor;", "getHost", "identityService", "Lio/bloombox/schema/services/telemetry/v1beta3/IdentityTelemetryGrpc$IdentityTelemetryFutureStub;", "getPort", "()I", "getTimeout", "()Ljava/time/Duration;", "getTransportMode", "()Lbloombox/client/internals/rpc/RPCClient$TransportMode;", "event", "", "collection", "uuid", "occurred", "", "payload", "", "Lcom/google/protobuf/Value;", "context", "Lbloombox/client/services/telemetry/TelemetryClient$EventContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/util/Map;Lbloombox/client/services/telemetry/TelemetryClient$EventContext;)V", "ping", "callback", "Lkotlin/Function1;", "Lbloombox/client/services/telemetry/PingCallback;", "resolveContext", "Lio/bloombox/schema/telemetry/AnalyticsContext$Context$Builder;", "serialize", "Companion", "EventContext", "java-client"})
public final class TelemetryClient
extends RPCClient
implements ServiceClient {
    @NotNull
    private final ManagedChannel channel;
    private final Base64 b64;
    private final EventTelemetryGrpc.EventTelemetryFutureStub eventService;
    private final CommercialTelemetryGrpc.CommercialTelemetryFutureStub commercialService;
    private final IdentityTelemetryGrpc.IdentityTelemetryFutureStub identityService;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String apiKey;
    @NotNull
    private final Duration timeout;
    @NotNull
    private final RPCClient.TransportMode transportMode;
    @NotNull
    private final ClientAuth clientAuth;
    @Nullable
    private final ClientCredentials clientCredentials;
    @Nullable
    private final InputStream clientAuthorityRoots;
    @NotNull
    private final Executor executor;
    @Nullable
    private final String defaultPartner;
    @Nullable
    private final String defaultLocation;
    @Nullable
    private final String deviceUUID;
    private static final String internalPrefix = "_bloom_";
    private static final String fingerprint;
    private static final AnalyticsContext.Context baseContext;
    public static final Companion Companion;

    @Override
    @NotNull
    public ManagedChannel getChannel() {
        return this.channel;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AnalyticsContext.Context.Builder serialize(@NotNull EventContext $receiver, String defaultPartner, String defaultLocation, String deviceUUID) {
        CharSequence charSequence;
        String device;
        String string;
        String location;
        String string2;
        String partner;
        AnalyticsContext.Context.Builder builder = AnalyticsContext.Context.newBuilder();
        AnalyticsScope.Scope.Builder scope = AnalyticsScope.Scope.newBuilder();
        String string3 = defaultPartner;
        if (string3 == null) {
            string3 = partner = $receiver.getPartner();
        }
        if ((string2 = defaultLocation) == null) {
            string2 = location = $receiver.getLocation();
        }
        if ((string = deviceUUID) == null) {
            string = device = $receiver.getDeviceUUID();
        }
        if (partner != null) {
            if (location != null) {
                if (device != null) {
                    AnalyticsScope.Scope.Builder builder2 = scope;
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"scope");
                    builder2.setPartner("partner/" + partner + "/location/" + location + "/device/" + device);
                } else {
                    AnalyticsScope.Scope.Builder builder3 = scope;
                    Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"scope");
                    builder3.setPartner("partner/" + partner + "/location/" + location);
                }
            } else {
                AnalyticsScope.Scope.Builder builder4 = scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder4, (String)"scope");
                builder4.setPartner(partner);
            }
        }
        if ($receiver.getSection() != null) {
            Object object = $receiver.getItem();
            if (object != null && (object = ((ProductKey)object).getId()) != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)object))) {
                AnalyticsScope.Scope.Builder builder5 = scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"scope");
                builder5.setCommercial("section/" + $receiver.getSection().name() + "/item/" + $receiver.getItem().getId());
            } else {
                AnalyticsScope.Scope.Builder builder6 = scope;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder6, (String)"scope");
                builder6.setCommercial($receiver.getSection().name());
            }
        }
        String string4 = $receiver.getOrderKey();
        if (string4 != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string4))) {
            AnalyticsScope.Scope.Builder builder7 = scope;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder7, (String)"scope");
            builder7.setOrder($receiver.getOrderKey());
        }
        builder.setScope(scope);
        String string5 = $receiver.getUserKey();
        if (string5 != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string5))) {
            builder.setUserKey(UserKey.newBuilder().setUid($receiver.getUserKey()));
        }
        String string6 = $receiver.getFingerprint();
        if (string6 != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string6))) {
            AnalyticsContext.Context.Builder builder8 = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder8, (String)"builder");
            builder8.setFingerprint($receiver.getFingerprint());
        }
        String string7 = $receiver.getGroup();
        if (string7 != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)string7))) {
            AnalyticsContext.Context.Builder builder9 = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder9, (String)"builder");
            builder9.setGroup($receiver.getGroup());
        }
        AnalyticsContext.Context.Builder builder10 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder10, (String)"builder");
        return builder10;
    }

    static /* bridge */ /* synthetic */ AnalyticsContext.Context.Builder serialize$default(TelemetryClient telemetryClient, EventContext eventContext, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return telemetryClient.serialize(eventContext, string, string2, string3);
    }

    private final AnalyticsContext.Context.Builder resolveContext(String collection, EventContext context) {
        AnalyticsContext.Context.Builder merged;
        block13: {
            block12: {
                CharSequence charSequence;
                block11: {
                    block10: {
                        AnalyticsContext.Context.Builder builder;
                        if (context != null) {
                            AnalyticsContext.Context.Builder builder2 = this.serialize(context, this.defaultPartner, this.defaultLocation, this.deviceUUID).mergeFrom(TelemetryClient.Companion.getBaseContext());
                            builder = builder2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"context.serialize(defaul\u2026D).mergeFrom(baseContext)");
                        } else {
                            AnalyticsContext.Context.Builder builder3 = TelemetryClient.Companion.getBaseContext().toBuilder();
                            builder = builder3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"baseContext.toBuilder()");
                        }
                        merged = builder;
                        if (!merged.hasCollection()) {
                            AnalyticsCollection.Collection.Builder builder4 = AnalyticsCollection.Collection.newBuilder().setInternal(StringsKt.startsWith$default((String)collection, (String)internalPrefix, (boolean)false, (int)2, null)).setType(AnalyticsCollection.EventType.GENERIC);
                            charSequence = collection;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                            Charset charset2 = charset;
                            Base64 base64 = this.b64;
                            AnalyticsCollection.Collection.Builder builder5 = builder4;
                            AnalyticsContext.Context.Builder builder6 = merged;
                            CharSequence charSequence2 = charSequence;
                            if (charSequence2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            byte[] byArray = ((String)charSequence2).getBytes(charset2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                            byte[] byArray2 = byArray;
                            builder6.setCollection(builder5.setName(base64.encodeAsString(byArray2)));
                        }
                        if (merged.getFingerprint() == null) break block10;
                        String string = merged.getFingerprint();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"merged.fingerprint");
                        charSequence = string;
                        if (charSequence.length() == 0) break block10;
                        String string2 = merged.getFingerprint();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"merged.fingerprint");
                        if (!StringsKt.isBlank((CharSequence)string2)) break block11;
                    }
                    merged.setFingerprint(TelemetryClient.Companion.getFingerprint());
                }
                if (merged.getGroup() == null) break block12;
                String string = merged.getGroup();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"merged.group");
                charSequence = string;
                if (charSequence.length() == 0) break block12;
                String string3 = merged.getGroup();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"merged.group");
                if (!StringsKt.isBlank((CharSequence)string3)) break block13;
            }
            merged.setGroup(TelemetryClient.Companion.getFingerprint());
        }
        return merged;
    }

    static /* bridge */ /* synthetic */ AnalyticsContext.Context.Builder resolveContext$default(TelemetryClient telemetryClient, String string, EventContext eventContext, int n, Object object) {
        if ((n & 2) != 0) {
            eventContext = null;
        }
        return telemetryClient.resolveContext(string, eventContext);
    }

    public final void ping(@Nullable Function1<? super Long, Unit> callback) {
        block2: {
            long start = System.currentTimeMillis();
            try {
                this.eventService.ping(TelemetryPing.Request.getDefaultInstance()).get(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
                long end = System.currentTimeMillis();
                Function1<? super Long, Unit> function1 = callback;
                if (function1 == null) break block2;
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)(end - start));
            }
            catch (StatusRuntimeException e) {
                Function1<? super Long, Unit> function1 = callback;
                if (function1 == null) break block2;
                Unit cfr_ignored_1 = (Unit)function1.invoke(null);
            }
        }
    }

    public static /* bridge */ /* synthetic */ void ping$default(TelemetryClient telemetryClient, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        telemetryClient.ping((Function1<? super Long, Unit>)function1);
    }

    public final void event(@NotNull String collection, @Nullable Map<String, Value> payload) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        this.event(collection, null, null, payload, null);
    }

    public static /* bridge */ /* synthetic */ void event$default(TelemetryClient telemetryClient, String string, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        telemetryClient.event(string, map);
    }

    public final void event(@NotNull String collection, @Nullable Map<String, Value> payload, @Nullable EventContext context) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        this.event(collection, null, null, payload, context);
    }

    public static /* bridge */ /* synthetic */ void event$default(TelemetryClient telemetryClient, String string, Map map, EventContext eventContext, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            eventContext = null;
        }
        telemetryClient.event(string, map, eventContext);
    }

    public final void event(@NotNull String collection, @Nullable String uuid, @Nullable Long occurred, @Nullable Map<String, Value> payload, @Nullable EventContext context) {
        String string;
        AnalyticsContext.Context.Builder merged;
        block6: {
            String string2;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
                merged = this.resolveContext(collection, context);
                string = uuid;
                if (string == null) break block5;
                String string3 = string2 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                string = string4;
                if (string4 != null) break block6;
            }
            String string5 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"UUID.randomUUID().toString()");
            String string6 = string2 = string5;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toUpperCase();
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
        }
        String eventUUID = string;
        Long l = occurred;
        Instant.Builder instant = Instant.newBuilder().setTimestamp(l != null ? l : System.currentTimeMillis());
        AnalyticsEvent.Event ev = AnalyticsEvent.Event.newBuilder().setOccurred(instant).setPayload(Struct.newBuilder().putAllFields(payload)).build();
        Event.Request req = Event.Request.newBuilder().setUuid(eventUUID).setEvent(ev).setContext(merged).build();
        this.eventService.event(req).get(this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    public static /* bridge */ /* synthetic */ void event$default(TelemetryClient telemetryClient, String string, String string2, Long l, Map map, EventContext eventContext, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            eventContext = null;
        }
        telemetryClient.event(string, string2, l, map, eventContext);
    }

    @Override
    @NotNull
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    @NotNull
    public Duration getTimeout() {
        return this.timeout;
    }

    @Override
    @NotNull
    public RPCClient.TransportMode getTransportMode() {
        return this.transportMode;
    }

    @Override
    @NotNull
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    @Override
    @Nullable
    public ClientCredentials getClientCredentials() {
        return this.clientCredentials;
    }

    @Override
    @Nullable
    public InputStream getClientAuthorityRoots() {
        return this.clientAuthorityRoots;
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return this.executor;
    }

    @Nullable
    public final String getDefaultPartner$java_client() {
        return this.defaultPartner;
    }

    @Nullable
    public final String getDefaultLocation$java_client() {
        return this.defaultLocation;
    }

    @Nullable
    public final String getDeviceUUID$java_client() {
        return this.deviceUUID;
    }

    public TelemetryClient(@NotNull String host, int port, @NotNull String apiKey, @NotNull Duration timeout, @NotNull RPCClient.TransportMode transportMode, @NotNull ClientAuth clientAuth, @Nullable ClientCredentials clientCredentials, @Nullable InputStream clientAuthorityRoots, @NotNull Executor executor, @Nullable String defaultPartner, @Nullable String defaultLocation, @Nullable String deviceUUID) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull((Object)((Object)transportMode), (String)"transportMode");
        Intrinsics.checkParameterIsNotNull((Object)clientAuth, (String)"clientAuth");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        super(apiKey);
        this.host = host;
        this.port = port;
        this.apiKey = apiKey;
        this.timeout = timeout;
        this.transportMode = transportMode;
        this.clientAuth = clientAuth;
        this.clientCredentials = clientCredentials;
        this.clientAuthorityRoots = clientAuthorityRoots;
        this.executor = executor;
        this.defaultPartner = defaultPartner;
        this.defaultLocation = defaultLocation;
        this.deviceUUID = deviceUUID;
        InputStream inputStream = this.getClientAuthorityRoots();
        ClientCredentials clientCredentials2 = this.getClientCredentials();
        RPCClient.TransportMode transportMode2 = this.getTransportMode();
        ClientAuth clientAuth2 = this.getClientAuth();
        Executor executor2 = this.getExecutor();
        ManagedChannel managedChannel = this.channelBuilder(this.getHost(), this.getPort(), transportMode2, clientAuth2, clientCredentials2, inputStream, executor2).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)managedChannel, (String)"channelBuilder(\n        \u2026ntAuthorityRoots).build()");
        this.channel = managedChannel;
        this.b64 = new Base64();
        this.eventService = EventTelemetryGrpc.newFutureStub((Channel)this.getChannel());
        this.commercialService = CommercialTelemetryGrpc.newFutureStub((Channel)this.getChannel());
        this.identityService = IdentityTelemetryGrpc.newFutureStub((Channel)this.getChannel());
    }

    public /* synthetic */ TelemetryClient(String string, int n, String string2, Duration duration, RPCClient.TransportMode transportMode, ClientAuth clientAuth, ClientCredentials clientCredentials, InputStream inputStream, Executor executor, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            transportMode = RPCClient.TransportMode.SECURE;
        }
        if ((n2 & 0x20) != 0) {
            clientAuth = ClientAuth.NONE;
        }
        if ((n2 & 0x40) != 0) {
            clientCredentials = null;
        }
        if ((n2 & 0x80) != 0) {
            inputStream = null;
        }
        if ((n2 & 0x100) != 0) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
            executor = executorService;
        }
        if ((n2 & 0x200) != 0) {
            string3 = null;
        }
        if ((n2 & 0x400) != 0) {
            string4 = null;
        }
        if ((n2 & 0x800) != 0) {
            string5 = null;
        }
        this(string, n, string2, duration, transportMode, clientAuth, clientCredentials, inputStream, executor, string3, string4, string5);
    }

    static {
        String string;
        Companion = new Companion(null);
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        fingerprint = string4;
        AnalyticsContext.Context context = AnalyticsContext.Context.newBuilder().setLibrary(LibraryContext.DeviceLibrary.newBuilder().setClient(LibraryContext.APIClient.JAVA).setVariant("full").setVersion(VersionSpec.newBuilder().setName("1.0"))).setNative(DeviceContext.NativeDeviceContext.newBuilder().setRole(DeviceContext.DeviceRole.SERVER).setOs(OperatingSystemContext.DeviceOS.newBuilder().setType(OperatingSystemContext.OSType.LINUX))).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"AnalyticsContext.Context\u2026NUX)))\n          .build()");
        baseContext = context;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0089\u0001\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u008d\u0001\u0010.\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016\u00a8\u00065"}, d2={"Lbloombox/client/services/telemetry/TelemetryClient$EventContext;", "", "partner", "", "location", "deviceUUID", "userKey", "orderKey", "section", "Lio/opencannabis/schema/menu/section/Section;", "item", "Lio/opencannabis/schema/base/ProductKey;", "fingerprint", "group", "nativeContext", "Lio/bloombox/schema/telemetry/context/DeviceContext$NativeDeviceContext;", "browserContext", "Lio/bloombox/schema/telemetry/context/BrowserContext$BrowserDeviceContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/opencannabis/schema/menu/section/Section;Lio/opencannabis/schema/base/ProductKey;Ljava/lang/String;Ljava/lang/String;Lio/bloombox/schema/telemetry/context/DeviceContext$NativeDeviceContext;Lio/bloombox/schema/telemetry/context/BrowserContext$BrowserDeviceContext;)V", "getBrowserContext", "()Lio/bloombox/schema/telemetry/context/BrowserContext$BrowserDeviceContext;", "getDeviceUUID", "()Ljava/lang/String;", "getFingerprint", "getGroup", "getItem", "()Lio/opencannabis/schema/base/ProductKey;", "getLocation", "getNativeContext", "()Lio/bloombox/schema/telemetry/context/DeviceContext$NativeDeviceContext;", "getOrderKey", "getPartner", "getSection", "()Lio/opencannabis/schema/menu/section/Section;", "getUserKey", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "java-client"})
    public static final class EventContext {
        @Nullable
        private final String partner;
        @Nullable
        private final String location;
        @Nullable
        private final String deviceUUID;
        @Nullable
        private final String userKey;
        @Nullable
        private final String orderKey;
        @Nullable
        private final Section section;
        @Nullable
        private final ProductKey item;
        @Nullable
        private final String fingerprint;
        @Nullable
        private final String group;
        @Nullable
        private final DeviceContext.NativeDeviceContext nativeContext;
        @Nullable
        private final BrowserContext.BrowserDeviceContext browserContext;

        @Nullable
        public final String getPartner() {
            return this.partner;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        @Nullable
        public final String getDeviceUUID() {
            return this.deviceUUID;
        }

        @Nullable
        public final String getUserKey() {
            return this.userKey;
        }

        @Nullable
        public final String getOrderKey() {
            return this.orderKey;
        }

        @Nullable
        public final Section getSection() {
            return this.section;
        }

        @Nullable
        public final ProductKey getItem() {
            return this.item;
        }

        @Nullable
        public final String getFingerprint() {
            return this.fingerprint;
        }

        @Nullable
        public final String getGroup() {
            return this.group;
        }

        @Nullable
        public final DeviceContext.NativeDeviceContext getNativeContext() {
            return this.nativeContext;
        }

        @Nullable
        public final BrowserContext.BrowserDeviceContext getBrowserContext() {
            return this.browserContext;
        }

        public EventContext(@Nullable String partner, @Nullable String location, @Nullable String deviceUUID, @Nullable String userKey, @Nullable String orderKey, @Nullable Section section, @Nullable ProductKey item, @Nullable String fingerprint, @Nullable String group, @Nullable DeviceContext.NativeDeviceContext nativeContext, @Nullable BrowserContext.BrowserDeviceContext browserContext) {
            this.partner = partner;
            this.location = location;
            this.deviceUUID = deviceUUID;
            this.userKey = userKey;
            this.orderKey = orderKey;
            this.section = section;
            this.item = item;
            this.fingerprint = fingerprint;
            this.group = group;
            this.nativeContext = nativeContext;
            this.browserContext = browserContext;
        }

        public /* synthetic */ EventContext(String string, String string2, String string3, String string4, String string5, Section section, ProductKey productKey, String string6, String string7, DeviceContext.NativeDeviceContext nativeDeviceContext, BrowserContext.BrowserDeviceContext browserDeviceContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            if ((n & 0x20) != 0) {
                section = null;
            }
            if ((n & 0x40) != 0) {
                productKey = null;
            }
            if ((n & 0x80) != 0) {
                string6 = null;
            }
            if ((n & 0x100) != 0) {
                string7 = null;
            }
            if ((n & 0x200) != 0) {
                nativeDeviceContext = null;
            }
            if ((n & 0x400) != 0) {
                browserDeviceContext = null;
            }
            this(string, string2, string3, string4, string5, section, productKey, string6, string7, nativeDeviceContext, browserDeviceContext);
        }

        public EventContext() {
            this(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
        }

        @Nullable
        public final String component1() {
            return this.partner;
        }

        @Nullable
        public final String component2() {
            return this.location;
        }

        @Nullable
        public final String component3() {
            return this.deviceUUID;
        }

        @Nullable
        public final String component4() {
            return this.userKey;
        }

        @Nullable
        public final String component5() {
            return this.orderKey;
        }

        @Nullable
        public final Section component6() {
            return this.section;
        }

        @Nullable
        public final ProductKey component7() {
            return this.item;
        }

        @Nullable
        public final String component8() {
            return this.fingerprint;
        }

        @Nullable
        public final String component9() {
            return this.group;
        }

        @Nullable
        public final DeviceContext.NativeDeviceContext component10() {
            return this.nativeContext;
        }

        @Nullable
        public final BrowserContext.BrowserDeviceContext component11() {
            return this.browserContext;
        }

        @NotNull
        public final EventContext copy(@Nullable String partner, @Nullable String location, @Nullable String deviceUUID, @Nullable String userKey, @Nullable String orderKey, @Nullable Section section, @Nullable ProductKey item, @Nullable String fingerprint, @Nullable String group, @Nullable DeviceContext.NativeDeviceContext nativeContext, @Nullable BrowserContext.BrowserDeviceContext browserContext) {
            return new EventContext(partner, location, deviceUUID, userKey, orderKey, section, item, fingerprint, group, nativeContext, browserContext);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ EventContext copy$default(EventContext eventContext, String string, String string2, String string3, String string4, String string5, Section section, ProductKey productKey, String string6, String string7, DeviceContext.NativeDeviceContext nativeDeviceContext, BrowserContext.BrowserDeviceContext browserDeviceContext, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventContext.partner;
            }
            if ((n & 2) != 0) {
                string2 = eventContext.location;
            }
            if ((n & 4) != 0) {
                string3 = eventContext.deviceUUID;
            }
            if ((n & 8) != 0) {
                string4 = eventContext.userKey;
            }
            if ((n & 0x10) != 0) {
                string5 = eventContext.orderKey;
            }
            if ((n & 0x20) != 0) {
                section = eventContext.section;
            }
            if ((n & 0x40) != 0) {
                productKey = eventContext.item;
            }
            if ((n & 0x80) != 0) {
                string6 = eventContext.fingerprint;
            }
            if ((n & 0x100) != 0) {
                string7 = eventContext.group;
            }
            if ((n & 0x200) != 0) {
                nativeDeviceContext = eventContext.nativeContext;
            }
            if ((n & 0x400) != 0) {
                browserDeviceContext = eventContext.browserContext;
            }
            return eventContext.copy(string, string2, string3, string4, string5, section, productKey, string6, string7, nativeDeviceContext, browserDeviceContext);
        }

        public String toString() {
            return "EventContext(partner=" + this.partner + ", location=" + this.location + ", deviceUUID=" + this.deviceUUID + ", userKey=" + this.userKey + ", orderKey=" + this.orderKey + ", section=" + (Object)((Object)this.section) + ", item=" + this.item + ", fingerprint=" + this.fingerprint + ", group=" + this.group + ", nativeContext=" + this.nativeContext + ", browserContext=" + this.browserContext + ")";
        }

        public int hashCode() {
            String string = this.partner;
            String string2 = this.location;
            String string3 = this.deviceUUID;
            String string4 = this.userKey;
            String string5 = this.orderKey;
            Section section = this.section;
            ProductKey productKey = this.item;
            String string6 = this.fingerprint;
            String string7 = this.group;
            DeviceContext.NativeDeviceContext nativeDeviceContext = this.nativeContext;
            BrowserContext.BrowserDeviceContext browserDeviceContext = this.browserContext;
            return ((((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (section != null ? ((Object)((Object)section)).hashCode() : 0)) * 31 + (productKey != null ? ((Object)productKey).hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (nativeDeviceContext != null ? ((Object)nativeDeviceContext).hashCode() : 0)) * 31 + (browserDeviceContext != null ? ((Object)browserDeviceContext).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EventContext)) break block3;
                    EventContext eventContext = (EventContext)object;
                    if (!Intrinsics.areEqual((Object)this.partner, (Object)eventContext.partner) || !Intrinsics.areEqual((Object)this.location, (Object)eventContext.location) || !Intrinsics.areEqual((Object)this.deviceUUID, (Object)eventContext.deviceUUID) || !Intrinsics.areEqual((Object)this.userKey, (Object)eventContext.userKey) || !Intrinsics.areEqual((Object)this.orderKey, (Object)eventContext.orderKey) || !Intrinsics.areEqual((Object)((Object)this.section), (Object)((Object)eventContext.section)) || !Intrinsics.areEqual((Object)this.item, (Object)eventContext.item) || !Intrinsics.areEqual((Object)this.fingerprint, (Object)eventContext.fingerprint) || !Intrinsics.areEqual((Object)this.group, (Object)eventContext.group) || !Intrinsics.areEqual((Object)this.nativeContext, (Object)eventContext.nativeContext) || !Intrinsics.areEqual((Object)this.browserContext, (Object)eventContext.browserContext)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbloombox/client/services/telemetry/TelemetryClient$Companion;", "", "()V", "baseContext", "Lio/bloombox/schema/telemetry/AnalyticsContext$Context;", "getBaseContext", "()Lio/bloombox/schema/telemetry/AnalyticsContext$Context;", "fingerprint", "", "getFingerprint", "()Ljava/lang/String;", "internalPrefix", "java-client"})
    public static final class Companion {
        private final String getFingerprint() {
            return fingerprint;
        }

        private final AnalyticsContext.Context getBaseContext() {
            return baseContext;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

