/*
 * Decompiled with CFR 0.152.
 */
package io.opencannabis.schema.crypto.primitives.integrity;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Internal;
import com.google.protobuf.ProtocolMessageEnum;
import io.opencannabis.schema.crypto.primitives.integrity.Integrity;

public enum HashAlgorithm implements ProtocolMessageEnum
{
    SHA1(0),
    MD5(1),
    SHA256(2),
    SHA384(3),
    SHA512(4),
    MURMUR(6),
    UNRECOGNIZED(-1);

    public static final int SHA1_VALUE = 0;
    public static final int MD5_VALUE = 1;
    public static final int SHA256_VALUE = 2;
    public static final int SHA384_VALUE = 3;
    public static final int SHA512_VALUE = 4;
    public static final int MURMUR_VALUE = 6;
    private static final Internal.EnumLiteMap<HashAlgorithm> internalValueMap;
    private static final HashAlgorithm[] VALUES;
    private final int value;

    public final int getNumber() {
        if (this == UNRECOGNIZED) {
            throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
        }
        return this.value;
    }

    @Deprecated
    public static HashAlgorithm valueOf(int value) {
        return HashAlgorithm.forNumber(value);
    }

    public static HashAlgorithm forNumber(int value) {
        switch (value) {
            case 0: {
                return SHA1;
            }
            case 1: {
                return MD5;
            }
            case 2: {
                return SHA256;
            }
            case 3: {
                return SHA384;
            }
            case 4: {
                return SHA512;
            }
            case 6: {
                return MURMUR;
            }
        }
        return null;
    }

    public static Internal.EnumLiteMap<HashAlgorithm> internalGetValueMap() {
        return internalValueMap;
    }

    public final Descriptors.EnumValueDescriptor getValueDescriptor() {
        return (Descriptors.EnumValueDescriptor)HashAlgorithm.getDescriptor().getValues().get(this.ordinal());
    }

    public final Descriptors.EnumDescriptor getDescriptorForType() {
        return HashAlgorithm.getDescriptor();
    }

    public static final Descriptors.EnumDescriptor getDescriptor() {
        return (Descriptors.EnumDescriptor)Integrity.getDescriptor().getEnumTypes().get(0);
    }

    public static HashAlgorithm valueOf(Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != HashAlgorithm.getDescriptor()) {
            throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
    }

    private HashAlgorithm(int value) {
        this.value = value;
    }

    static {
        internalValueMap = new Internal.EnumLiteMap<HashAlgorithm>(){

            public HashAlgorithm findValueByNumber(int number) {
                return HashAlgorithm.forNumber(number);
            }
        };
        VALUES = HashAlgorithm.values();
    }
}

