/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/commerce/OrderAnalytics.proto

package io.bloombox.schema.analytics.order;

public final class OrderAnalytics {
  private OrderAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies actions that may be taken on an order.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.order.OrderAction}
   */
  public enum OrderAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The user added to their cart.
     * </pre>
     *
     * <code>ADD_TO_CART = 0;</code>
     */
    ADD_TO_CART(0),
    /**
     * <pre>
     * The user removed something from their cart.
     * </pre>
     *
     * <code>REMOVE_FROM_CART = 1;</code>
     */
    REMOVE_FROM_CART(1),
    /**
     * <pre>
     * The user restored a previous cart.
     * </pre>
     *
     * <code>RESTORE_CART = 2;</code>
     */
    RESTORE_CART(2),
    /**
     * <pre>
     * The user verified themselves as a member, to place an order.
     * </pre>
     *
     * <code>VERIFY_MEMBER = 3;</code>
     */
    VERIFY_MEMBER(3),
    /**
     * <pre>
     * The user submitted an order.
     * </pre>
     *
     * <code>ORDER_SUBMIT = 4;</code>
     */
    ORDER_SUBMIT(4),
    /**
     * <pre>
     * The user queries status for an order.
     * </pre>
     *
     * <code>ORDER_STATUS = 5;</code>
     */
    ORDER_STATUS(5),
    /**
     * <pre>
     * The user cancelled an order.
     * </pre>
     *
     * <code>ORDER_CANCEL = 6;</code>
     */
    ORDER_CANCEL(6),
    /**
     * <pre>
     * An order was accepted by a back-office user.
     * </pre>
     *
     * <code>ORDER_ACCEPTED = 7;</code>
     */
    ORDER_ACCEPTED(7),
    /**
     * <pre>
     * An order was rejected by a back-office user.
     * </pre>
     *
     * <code>ORDER_REJECTED = 8;</code>
     */
    ORDER_REJECTED(8),
    /**
     * <pre>
     * An order was set to in-progress by a back-office user.
     * </pre>
     *
     * <code>ORDER_IN_PROGERSS = 9;</code>
     */
    ORDER_IN_PROGERSS(9),
    /**
     * <pre>
     * An order left for delivery.
     * </pre>
     *
     * <code>ORDER_OUT_FOR_DELIVERY = 10;</code>
     */
    ORDER_OUT_FOR_DELIVERY(10),
    /**
     * <pre>
     * An order was fulfilled and may now be considered complete.
     * </pre>
     *
     * <code>ORDER_FULFILLED = 11;</code>
     */
    ORDER_FULFILLED(11),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The user added to their cart.
     * </pre>
     *
     * <code>ADD_TO_CART = 0;</code>
     */
    public static final int ADD_TO_CART_VALUE = 0;
    /**
     * <pre>
     * The user removed something from their cart.
     * </pre>
     *
     * <code>REMOVE_FROM_CART = 1;</code>
     */
    public static final int REMOVE_FROM_CART_VALUE = 1;
    /**
     * <pre>
     * The user restored a previous cart.
     * </pre>
     *
     * <code>RESTORE_CART = 2;</code>
     */
    public static final int RESTORE_CART_VALUE = 2;
    /**
     * <pre>
     * The user verified themselves as a member, to place an order.
     * </pre>
     *
     * <code>VERIFY_MEMBER = 3;</code>
     */
    public static final int VERIFY_MEMBER_VALUE = 3;
    /**
     * <pre>
     * The user submitted an order.
     * </pre>
     *
     * <code>ORDER_SUBMIT = 4;</code>
     */
    public static final int ORDER_SUBMIT_VALUE = 4;
    /**
     * <pre>
     * The user queries status for an order.
     * </pre>
     *
     * <code>ORDER_STATUS = 5;</code>
     */
    public static final int ORDER_STATUS_VALUE = 5;
    /**
     * <pre>
     * The user cancelled an order.
     * </pre>
     *
     * <code>ORDER_CANCEL = 6;</code>
     */
    public static final int ORDER_CANCEL_VALUE = 6;
    /**
     * <pre>
     * An order was accepted by a back-office user.
     * </pre>
     *
     * <code>ORDER_ACCEPTED = 7;</code>
     */
    public static final int ORDER_ACCEPTED_VALUE = 7;
    /**
     * <pre>
     * An order was rejected by a back-office user.
     * </pre>
     *
     * <code>ORDER_REJECTED = 8;</code>
     */
    public static final int ORDER_REJECTED_VALUE = 8;
    /**
     * <pre>
     * An order was set to in-progress by a back-office user.
     * </pre>
     *
     * <code>ORDER_IN_PROGERSS = 9;</code>
     */
    public static final int ORDER_IN_PROGERSS_VALUE = 9;
    /**
     * <pre>
     * An order left for delivery.
     * </pre>
     *
     * <code>ORDER_OUT_FOR_DELIVERY = 10;</code>
     */
    public static final int ORDER_OUT_FOR_DELIVERY_VALUE = 10;
    /**
     * <pre>
     * An order was fulfilled and may now be considered complete.
     * </pre>
     *
     * <code>ORDER_FULFILLED = 11;</code>
     */
    public static final int ORDER_FULFILLED_VALUE = 11;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OrderAction valueOf(int value) {
      return forNumber(value);
    }

    public static OrderAction forNumber(int value) {
      switch (value) {
        case 0: return ADD_TO_CART;
        case 1: return REMOVE_FROM_CART;
        case 2: return RESTORE_CART;
        case 3: return VERIFY_MEMBER;
        case 4: return ORDER_SUBMIT;
        case 5: return ORDER_STATUS;
        case 6: return ORDER_CANCEL;
        case 7: return ORDER_ACCEPTED;
        case 8: return ORDER_REJECTED;
        case 9: return ORDER_IN_PROGERSS;
        case 10: return ORDER_OUT_FOR_DELIVERY;
        case 11: return ORDER_FULFILLED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OrderAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        OrderAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OrderAction>() {
            public OrderAction findValueByNumber(int number) {
              return OrderAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.order.OrderAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final OrderAction[] VALUES = values();

    public static OrderAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OrderAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.order.OrderAction)
  }

  public interface ActionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.order.Action)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    boolean hasOrderKey();
    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    io.opencannabis.schema.commerce.CommercialOrder.OrderKey getOrderKey();
    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder getOrderKeyOrBuilder();

    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
     */
    int getVerbValue();
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
     */
    io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction getVerb();

    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    boolean hasCustomer();
    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer();
    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder();

    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies an order action event, wherein a user or backoffice admin has affirmatively taken some action upon or
   * regarding a commercial order to be submitted or previously submitted by an end user.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.order.Action}
   */
  public  static final class Action extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.order.Action)
      ActionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Action.newBuilder() to construct.
    private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Action() {
      verb_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Action(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder subBuilder = null;
              if (orderKey_ != null) {
                subBuilder = orderKey_.toBuilder();
              }
              orderKey_ = input.readMessage(io.opencannabis.schema.commerce.CommercialOrder.OrderKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(orderKey_);
                orderKey_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              verb_ = rawValue;
              break;
            }
            case 26: {
              io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder subBuilder = null;
              if (customer_ != null) {
                subBuilder = customer_.toBuilder();
              }
              customer_ = input.readMessage(io.opencannabis.schema.commerce.OrderCustomer.Customer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(customer_);
                customer_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.order.OrderAnalytics.internal_static_bloombox_schema_analytics_order_Action_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.order.OrderAnalytics.internal_static_bloombox_schema_analytics_order_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.order.OrderAnalytics.Action.class, io.bloombox.schema.analytics.order.OrderAnalytics.Action.Builder.class);
    }

    public static final int ORDER_KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.commerce.CommercialOrder.OrderKey orderKey_;
    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    public boolean hasOrderKey() {
      return orderKey_ != null;
    }
    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    public io.opencannabis.schema.commerce.CommercialOrder.OrderKey getOrderKey() {
      return orderKey_ == null ? io.opencannabis.schema.commerce.CommercialOrder.OrderKey.getDefaultInstance() : orderKey_;
    }
    /**
     * <pre>
     * Order being referenced for action, if any.
     * </pre>
     *
     * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
     */
    public io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder getOrderKeyOrBuilder() {
      return getOrderKey();
    }

    public static final int VERB_FIELD_NUMBER = 2;
    private int verb_;
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
     */
    public int getVerbValue() {
      return verb_;
    }
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
     */
    public io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction getVerb() {
      io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction result = io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.valueOf(verb_);
      return result == null ? io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.UNRECOGNIZED : result;
    }

    public static final int CUSTOMER_FIELD_NUMBER = 3;
    private io.opencannabis.schema.commerce.OrderCustomer.Customer customer_;
    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    public boolean hasCustomer() {
      return customer_ != null;
    }
    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    public io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer() {
      return customer_ == null ? io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
    }
    /**
     * <pre>
     * Customer that took this action.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 3;</code>
     */
    public io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder() {
      return getCustomer();
    }

    public static final int OCCURRED_FIELD_NUMBER = 4;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (orderKey_ != null) {
        output.writeMessage(1, getOrderKey());
      }
      if (verb_ != io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.ADD_TO_CART.getNumber()) {
        output.writeEnum(2, verb_);
      }
      if (customer_ != null) {
        output.writeMessage(3, getCustomer());
      }
      if (occurred_ != null) {
        output.writeMessage(4, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (orderKey_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getOrderKey());
      }
      if (verb_ != io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.ADD_TO_CART.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, verb_);
      }
      if (customer_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getCustomer());
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.order.OrderAnalytics.Action)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.order.OrderAnalytics.Action other = (io.bloombox.schema.analytics.order.OrderAnalytics.Action) obj;

      boolean result = true;
      result = result && (hasOrderKey() == other.hasOrderKey());
      if (hasOrderKey()) {
        result = result && getOrderKey()
            .equals(other.getOrderKey());
      }
      result = result && verb_ == other.verb_;
      result = result && (hasCustomer() == other.hasCustomer());
      if (hasCustomer()) {
        result = result && getCustomer()
            .equals(other.getCustomer());
      }
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOrderKey()) {
        hash = (37 * hash) + ORDER_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getOrderKey().hashCode();
      }
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + verb_;
      if (hasCustomer()) {
        hash = (37 * hash) + CUSTOMER_FIELD_NUMBER;
        hash = (53 * hash) + getCustomer().hashCode();
      }
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.order.OrderAnalytics.Action prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an order action event, wherein a user or backoffice admin has affirmatively taken some action upon or
     * regarding a commercial order to be submitted or previously submitted by an end user.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.order.Action}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.order.Action)
        io.bloombox.schema.analytics.order.OrderAnalytics.ActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.order.OrderAnalytics.internal_static_bloombox_schema_analytics_order_Action_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.order.OrderAnalytics.internal_static_bloombox_schema_analytics_order_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.order.OrderAnalytics.Action.class, io.bloombox.schema.analytics.order.OrderAnalytics.Action.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.order.OrderAnalytics.Action.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (orderKeyBuilder_ == null) {
          orderKey_ = null;
        } else {
          orderKey_ = null;
          orderKeyBuilder_ = null;
        }
        verb_ = 0;

        if (customerBuilder_ == null) {
          customer_ = null;
        } else {
          customer_ = null;
          customerBuilder_ = null;
        }
        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.order.OrderAnalytics.internal_static_bloombox_schema_analytics_order_Action_descriptor;
      }

      public io.bloombox.schema.analytics.order.OrderAnalytics.Action getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.order.OrderAnalytics.Action.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.order.OrderAnalytics.Action build() {
        io.bloombox.schema.analytics.order.OrderAnalytics.Action result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.order.OrderAnalytics.Action buildPartial() {
        io.bloombox.schema.analytics.order.OrderAnalytics.Action result = new io.bloombox.schema.analytics.order.OrderAnalytics.Action(this);
        if (orderKeyBuilder_ == null) {
          result.orderKey_ = orderKey_;
        } else {
          result.orderKey_ = orderKeyBuilder_.build();
        }
        result.verb_ = verb_;
        if (customerBuilder_ == null) {
          result.customer_ = customer_;
        } else {
          result.customer_ = customerBuilder_.build();
        }
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.order.OrderAnalytics.Action) {
          return mergeFrom((io.bloombox.schema.analytics.order.OrderAnalytics.Action)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.order.OrderAnalytics.Action other) {
        if (other == io.bloombox.schema.analytics.order.OrderAnalytics.Action.getDefaultInstance()) return this;
        if (other.hasOrderKey()) {
          mergeOrderKey(other.getOrderKey());
        }
        if (other.verb_ != 0) {
          setVerbValue(other.getVerbValue());
        }
        if (other.hasCustomer()) {
          mergeCustomer(other.getCustomer());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.order.OrderAnalytics.Action parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.order.OrderAnalytics.Action) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.commerce.CommercialOrder.OrderKey orderKey_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.CommercialOrder.OrderKey, io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder> orderKeyBuilder_;
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public boolean hasOrderKey() {
        return orderKeyBuilder_ != null || orderKey_ != null;
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.OrderKey getOrderKey() {
        if (orderKeyBuilder_ == null) {
          return orderKey_ == null ? io.opencannabis.schema.commerce.CommercialOrder.OrderKey.getDefaultInstance() : orderKey_;
        } else {
          return orderKeyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public Builder setOrderKey(io.opencannabis.schema.commerce.CommercialOrder.OrderKey value) {
        if (orderKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          orderKey_ = value;
          onChanged();
        } else {
          orderKeyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public Builder setOrderKey(
          io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder builderForValue) {
        if (orderKeyBuilder_ == null) {
          orderKey_ = builderForValue.build();
          onChanged();
        } else {
          orderKeyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public Builder mergeOrderKey(io.opencannabis.schema.commerce.CommercialOrder.OrderKey value) {
        if (orderKeyBuilder_ == null) {
          if (orderKey_ != null) {
            orderKey_ =
              io.opencannabis.schema.commerce.CommercialOrder.OrderKey.newBuilder(orderKey_).mergeFrom(value).buildPartial();
          } else {
            orderKey_ = value;
          }
          onChanged();
        } else {
          orderKeyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public Builder clearOrderKey() {
        if (orderKeyBuilder_ == null) {
          orderKey_ = null;
          onChanged();
        } else {
          orderKey_ = null;
          orderKeyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder getOrderKeyBuilder() {
        
        onChanged();
        return getOrderKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder getOrderKeyOrBuilder() {
        if (orderKeyBuilder_ != null) {
          return orderKeyBuilder_.getMessageOrBuilder();
        } else {
          return orderKey_ == null ?
              io.opencannabis.schema.commerce.CommercialOrder.OrderKey.getDefaultInstance() : orderKey_;
        }
      }
      /**
       * <pre>
       * Order being referenced for action, if any.
       * </pre>
       *
       * <code>.opencannabis.commerce.OrderKey order_key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.CommercialOrder.OrderKey, io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder> 
          getOrderKeyFieldBuilder() {
        if (orderKeyBuilder_ == null) {
          orderKeyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.commerce.CommercialOrder.OrderKey, io.opencannabis.schema.commerce.CommercialOrder.OrderKey.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderKeyOrBuilder>(
                  getOrderKey(),
                  getParentForChildren(),
                  isClean());
          orderKey_ = null;
        }
        return orderKeyBuilder_;
      }

      private int verb_ = 0;
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
       */
      public int getVerbValue() {
        return verb_;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
       */
      public Builder setVerbValue(int value) {
        verb_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
       */
      public io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction getVerb() {
        io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction result = io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.valueOf(verb_);
        return result == null ? io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
       */
      public Builder setVerb(io.bloombox.schema.analytics.order.OrderAnalytics.OrderAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        verb_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.order.OrderAction verb = 2;</code>
       */
      public Builder clearVerb() {
        
        verb_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.commerce.OrderCustomer.Customer customer_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder> customerBuilder_;
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public boolean hasCustomer() {
        return customerBuilder_ != null || customer_ != null;
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer() {
        if (customerBuilder_ == null) {
          return customer_ == null ? io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
        } else {
          return customerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public Builder setCustomer(io.opencannabis.schema.commerce.OrderCustomer.Customer value) {
        if (customerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customer_ = value;
          onChanged();
        } else {
          customerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public Builder setCustomer(
          io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder builderForValue) {
        if (customerBuilder_ == null) {
          customer_ = builderForValue.build();
          onChanged();
        } else {
          customerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public Builder mergeCustomer(io.opencannabis.schema.commerce.OrderCustomer.Customer value) {
        if (customerBuilder_ == null) {
          if (customer_ != null) {
            customer_ =
              io.opencannabis.schema.commerce.OrderCustomer.Customer.newBuilder(customer_).mergeFrom(value).buildPartial();
          } else {
            customer_ = value;
          }
          onChanged();
        } else {
          customerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public Builder clearCustomer() {
        if (customerBuilder_ == null) {
          customer_ = null;
          onChanged();
        } else {
          customer_ = null;
          customerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder getCustomerBuilder() {
        
        onChanged();
        return getCustomerFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder() {
        if (customerBuilder_ != null) {
          return customerBuilder_.getMessageOrBuilder();
        } else {
          return customer_ == null ?
              io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
        }
      }
      /**
       * <pre>
       * Customer that took this action.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder> 
          getCustomerFieldBuilder() {
        if (customerBuilder_ == null) {
          customerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder>(
                  getCustomer(),
                  getParentForChildren(),
                  isClean());
          customer_ = null;
        }
        return customerBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.order.Action)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.order.Action)
    private static final io.bloombox.schema.analytics.order.OrderAnalytics.Action DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.order.OrderAnalytics.Action();
    }

    public static io.bloombox.schema.analytics.order.OrderAnalytics.Action getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Action>
        PARSER = new com.google.protobuf.AbstractParser<Action>() {
      public Action parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Action(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Action> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Action> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.order.OrderAnalytics.Action getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_order_Action_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_order_Action_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\'analytics/commerce/OrderAnalytics.prot" +
      "o\022\037bloombox.schema.analytics.order\032\024comm" +
      "erce/Order.proto\032\026temporal/Instant.proto" +
      "\032\027commerce/Customer.proto\"\335\001\n\006Action\0222\n\t" +
      "order_key\030\001 \001(\0132\037.opencannabis.commerce." +
      "OrderKey\022:\n\004verb\030\002 \001(\0162,.bloombox.schema" +
      ".analytics.order.OrderAction\0221\n\010customer" +
      "\030\003 \001(\0132\037.opencannabis.commerce.Customer\022" +
      "0\n\010occurred\030\004 \001(\0132\036.opencannabis.tempora" +
      "l.Instant*\377\001\n\013OrderAction\022\017\n\013ADD_TO_CART" +
      "\020\000\022\024\n\020REMOVE_FROM_CART\020\001\022\020\n\014RESTORE_CART" +
      "\020\002\022\021\n\rVERIFY_MEMBER\020\003\022\020\n\014ORDER_SUBMIT\020\004\022" +
      "\020\n\014ORDER_STATUS\020\005\022\020\n\014ORDER_CANCEL\020\006\022\022\n\016O" +
      "RDER_ACCEPTED\020\007\022\022\n\016ORDER_REJECTED\020\010\022\025\n\021O" +
      "RDER_IN_PROGERSS\020\t\022\032\n\026ORDER_OUT_FOR_DELI" +
      "VERY\020\n\022\023\n\017ORDER_FULFILLED\020\013B>\n\"io.bloomb" +
      "ox.schema.analytics.orderB\016OrderAnalytic" +
      "sH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.commerce.CommercialOrder.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
          io.opencannabis.schema.commerce.OrderCustomer.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_order_Action_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_order_Action_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_order_Action_descriptor,
        new java.lang.String[] { "OrderKey", "Verb", "Customer", "Occurred", });
    io.opencannabis.schema.commerce.CommercialOrder.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
    io.opencannabis.schema.commerce.OrderCustomer.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
