/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/commerce/ProductAnalytics.proto

package io.bloombox.schema.analytics.product;

public final class ProductAnalytics {
  private ProductAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies the types of actions that a user may take on a product.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.product.ProductAction}
   */
  public enum ProductAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The user viewed a product. Product views are implemented under the hood as 'VIEW' actions.
     * </pre>
     *
     * <code>VIEW = 0;</code>
     */
    VIEW(0),
    /**
     * <pre>
     * The user shared a product on social media, or via email or SMS to a friend.
     * </pre>
     *
     * <code>SHARE = 1;</code>
     */
    SHARE(1),
    /**
     * <pre>
     * The user favorited a product.
     * </pre>
     *
     * <code>FAVORITE = 2;</code>
     */
    FAVORITE(2),
    /**
     * <pre>
     * The user compared two or more products.
     * </pre>
     *
     * <code>COMPARE = 3;</code>
     */
    COMPARE(3),
    /**
     * <pre>
     * The user added this product to their cart.
     * </pre>
     *
     * <code>CART = 4;</code>
     */
    CART(4),
    /**
     * <pre>
     * The user purchased a product.
     * </pre>
     *
     * <code>PURCHASE = 5;</code>
     */
    PURCHASE(5),
    /**
     * <pre>
     * The user subscribed to updates for a product.
     * </pre>
     *
     * <code>SUBSCRIBE = 6;</code>
     */
    SUBSCRIBE(6),
    /**
     * <pre>
     * The user magnified media for a product.
     * </pre>
     *
     * <code>ZOOM = 7;</code>
     */
    ZOOM(7),
    /**
     * <pre>
     * The user examined reports or lab test results for a product.
     * </pre>
     *
     * <code>REPORTS = 8;</code>
     */
    REPORTS(8),
    /**
     * <pre>
     * The user made use of the "similar products" UI while viewing this product.
     * </pre>
     *
     * <code>SIMILAR = 9;</code>
     */
    SIMILAR(9),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The user viewed a product. Product views are implemented under the hood as 'VIEW' actions.
     * </pre>
     *
     * <code>VIEW = 0;</code>
     */
    public static final int VIEW_VALUE = 0;
    /**
     * <pre>
     * The user shared a product on social media, or via email or SMS to a friend.
     * </pre>
     *
     * <code>SHARE = 1;</code>
     */
    public static final int SHARE_VALUE = 1;
    /**
     * <pre>
     * The user favorited a product.
     * </pre>
     *
     * <code>FAVORITE = 2;</code>
     */
    public static final int FAVORITE_VALUE = 2;
    /**
     * <pre>
     * The user compared two or more products.
     * </pre>
     *
     * <code>COMPARE = 3;</code>
     */
    public static final int COMPARE_VALUE = 3;
    /**
     * <pre>
     * The user added this product to their cart.
     * </pre>
     *
     * <code>CART = 4;</code>
     */
    public static final int CART_VALUE = 4;
    /**
     * <pre>
     * The user purchased a product.
     * </pre>
     *
     * <code>PURCHASE = 5;</code>
     */
    public static final int PURCHASE_VALUE = 5;
    /**
     * <pre>
     * The user subscribed to updates for a product.
     * </pre>
     *
     * <code>SUBSCRIBE = 6;</code>
     */
    public static final int SUBSCRIBE_VALUE = 6;
    /**
     * <pre>
     * The user magnified media for a product.
     * </pre>
     *
     * <code>ZOOM = 7;</code>
     */
    public static final int ZOOM_VALUE = 7;
    /**
     * <pre>
     * The user examined reports or lab test results for a product.
     * </pre>
     *
     * <code>REPORTS = 8;</code>
     */
    public static final int REPORTS_VALUE = 8;
    /**
     * <pre>
     * The user made use of the "similar products" UI while viewing this product.
     * </pre>
     *
     * <code>SIMILAR = 9;</code>
     */
    public static final int SIMILAR_VALUE = 9;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProductAction valueOf(int value) {
      return forNumber(value);
    }

    public static ProductAction forNumber(int value) {
      switch (value) {
        case 0: return VIEW;
        case 1: return SHARE;
        case 2: return FAVORITE;
        case 3: return COMPARE;
        case 4: return CART;
        case 5: return PURCHASE;
        case 6: return SUBSCRIBE;
        case 7: return ZOOM;
        case 8: return REPORTS;
        case 9: return SIMILAR;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProductAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ProductAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ProductAction>() {
            public ProductAction findValueByNumber(int number) {
              return ProductAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProductAction[] VALUES = values();

    public static ProductAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProductAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.product.ProductAction)
  }

  public interface ImpressionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.product.Impression)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * If the master view was filtered in any way, this flag is set.
     * </pre>
     *
     * <code>bool filtered = 2;</code>
     */
    boolean getFiltered();

    /**
     * <pre>
     * If the master view was sorted in any way, this flag is set.
     * </pre>
     *
     * <code>bool sorted = 3;</code>
     */
    boolean getSorted();

    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies that a product was presented, alongside one or more other products in a master-style view, as a candidate
   * for detail information to an end user.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.product.Impression}
   */
  public  static final class Impression extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.product.Impression)
      ImpressionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Impression.newBuilder() to construct.
    private Impression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Impression() {
      filtered_ = false;
      sorted_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Impression(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              filtered_ = input.readBool();
              break;
            }
            case 24: {

              sorted_ = input.readBool();
              break;
            }
            case 34: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Impression_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Impression_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.product.ProductAnalytics.Impression.class, io.bloombox.schema.analytics.product.ProductAnalytics.Impression.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int FILTERED_FIELD_NUMBER = 2;
    private boolean filtered_;
    /**
     * <pre>
     * If the master view was filtered in any way, this flag is set.
     * </pre>
     *
     * <code>bool filtered = 2;</code>
     */
    public boolean getFiltered() {
      return filtered_;
    }

    public static final int SORTED_FIELD_NUMBER = 3;
    private boolean sorted_;
    /**
     * <pre>
     * If the master view was sorted in any way, this flag is set.
     * </pre>
     *
     * <code>bool sorted = 3;</code>
     */
    public boolean getSorted() {
      return sorted_;
    }

    public static final int OCCURRED_FIELD_NUMBER = 4;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Timestamp for when this impression occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (filtered_ != false) {
        output.writeBool(2, filtered_);
      }
      if (sorted_ != false) {
        output.writeBool(3, sorted_);
      }
      if (occurred_ != null) {
        output.writeMessage(4, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (filtered_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, filtered_);
      }
      if (sorted_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, sorted_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.product.ProductAnalytics.Impression)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.product.ProductAnalytics.Impression other = (io.bloombox.schema.analytics.product.ProductAnalytics.Impression) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && (getFiltered()
          == other.getFiltered());
      result = result && (getSorted()
          == other.getSorted());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + FILTERED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFiltered());
      hash = (37 * hash) + SORTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSorted());
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.product.ProductAnalytics.Impression prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies that a product was presented, alongside one or more other products in a master-style view, as a candidate
     * for detail information to an end user.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.product.Impression}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.product.Impression)
        io.bloombox.schema.analytics.product.ProductAnalytics.ImpressionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Impression_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Impression_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.product.ProductAnalytics.Impression.class, io.bloombox.schema.analytics.product.ProductAnalytics.Impression.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.product.ProductAnalytics.Impression.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        filtered_ = false;

        sorted_ = false;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Impression_descriptor;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Impression getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.Impression.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Impression build() {
        io.bloombox.schema.analytics.product.ProductAnalytics.Impression result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Impression buildPartial() {
        io.bloombox.schema.analytics.product.ProductAnalytics.Impression result = new io.bloombox.schema.analytics.product.ProductAnalytics.Impression(this);
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.filtered_ = filtered_;
        result.sorted_ = sorted_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.product.ProductAnalytics.Impression) {
          return mergeFrom((io.bloombox.schema.analytics.product.ProductAnalytics.Impression)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.product.ProductAnalytics.Impression other) {
        if (other == io.bloombox.schema.analytics.product.ProductAnalytics.Impression.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.getFiltered() != false) {
          setFiltered(other.getFiltered());
        }
        if (other.getSorted() != false) {
          setSorted(other.getSorted());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.product.ProductAnalytics.Impression parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.product.ProductAnalytics.Impression) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private boolean filtered_ ;
      /**
       * <pre>
       * If the master view was filtered in any way, this flag is set.
       * </pre>
       *
       * <code>bool filtered = 2;</code>
       */
      public boolean getFiltered() {
        return filtered_;
      }
      /**
       * <pre>
       * If the master view was filtered in any way, this flag is set.
       * </pre>
       *
       * <code>bool filtered = 2;</code>
       */
      public Builder setFiltered(boolean value) {
        
        filtered_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * If the master view was filtered in any way, this flag is set.
       * </pre>
       *
       * <code>bool filtered = 2;</code>
       */
      public Builder clearFiltered() {
        
        filtered_ = false;
        onChanged();
        return this;
      }

      private boolean sorted_ ;
      /**
       * <pre>
       * If the master view was sorted in any way, this flag is set.
       * </pre>
       *
       * <code>bool sorted = 3;</code>
       */
      public boolean getSorted() {
        return sorted_;
      }
      /**
       * <pre>
       * If the master view was sorted in any way, this flag is set.
       * </pre>
       *
       * <code>bool sorted = 3;</code>
       */
      public Builder setSorted(boolean value) {
        
        sorted_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * If the master view was sorted in any way, this flag is set.
       * </pre>
       *
       * <code>bool sorted = 3;</code>
       */
      public Builder clearSorted() {
        
        sorted_ = false;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Timestamp for when this impression occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.product.Impression)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.product.Impression)
    private static final io.bloombox.schema.analytics.product.ProductAnalytics.Impression DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.product.ProductAnalytics.Impression();
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.Impression getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Impression>
        PARSER = new com.google.protobuf.AbstractParser<Impression>() {
      public Impression parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Impression(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Impression> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Impression> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.product.ProductAnalytics.Impression getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.product.View)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    boolean getInteractive();

    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies that an end-user viewed detail information about a product.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.product.View}
   */
  public  static final class View extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.product.View)
      ViewOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use View.newBuilder() to construct.
    private View(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private View() {
      interactive_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private View(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              interactive_ = input.readBool();
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_View_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_View_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.product.ProductAnalytics.View.class, io.bloombox.schema.analytics.product.ProductAnalytics.View.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Key for the product that was viewed.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int INTERACTIVE_FIELD_NUMBER = 2;
    private boolean interactive_;
    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    public boolean getInteractive() {
      return interactive_;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Timestamp for when this view occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (interactive_ != false) {
        output.writeBool(2, interactive_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (interactive_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, interactive_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.product.ProductAnalytics.View)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.product.ProductAnalytics.View other = (io.bloombox.schema.analytics.product.ProductAnalytics.View) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && (getInteractive()
          == other.getInteractive());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + INTERACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInteractive());
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.product.ProductAnalytics.View prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies that an end-user viewed detail information about a product.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.product.View}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.product.View)
        io.bloombox.schema.analytics.product.ProductAnalytics.ViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_View_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_View_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.product.ProductAnalytics.View.class, io.bloombox.schema.analytics.product.ProductAnalytics.View.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.product.ProductAnalytics.View.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        interactive_ = false;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_View_descriptor;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.View getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.View.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.View build() {
        io.bloombox.schema.analytics.product.ProductAnalytics.View result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.View buildPartial() {
        io.bloombox.schema.analytics.product.ProductAnalytics.View result = new io.bloombox.schema.analytics.product.ProductAnalytics.View(this);
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.interactive_ = interactive_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.product.ProductAnalytics.View) {
          return mergeFrom((io.bloombox.schema.analytics.product.ProductAnalytics.View)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.product.ProductAnalytics.View other) {
        if (other == io.bloombox.schema.analytics.product.ProductAnalytics.View.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.getInteractive() != false) {
          setInteractive(other.getInteractive());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.product.ProductAnalytics.View parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.product.ProductAnalytics.View) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Key for the product that was viewed.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private boolean interactive_ ;
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public boolean getInteractive() {
        return interactive_;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder setInteractive(boolean value) {
        
        interactive_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder clearInteractive() {
        
        interactive_ = false;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Timestamp for when this view occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.product.View)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.product.View)
    private static final io.bloombox.schema.analytics.product.ProductAnalytics.View DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.product.ProductAnalytics.View();
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.View getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<View>
        PARSER = new com.google.protobuf.AbstractParser<View>() {
      public View parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new View(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<View> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<View> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.product.ProductAnalytics.View getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ActionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.product.Action)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * The action that was taken on the product.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
     */
    int getVerbValue();
    /**
     * <pre>
     * The action that was taken on the product.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
     */
    io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction getVerb();

    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * An action that was taken affirmatively by a user on a particular product.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.product.Action}
   */
  public  static final class Action extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.product.Action)
      ActionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Action.newBuilder() to construct.
    private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Action() {
      verb_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Action(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              verb_ = rawValue;
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Action_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.product.ProductAnalytics.Action.class, io.bloombox.schema.analytics.product.ProductAnalytics.Action.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Key for the product that action was taken on.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int VERB_FIELD_NUMBER = 2;
    private int verb_;
    /**
     * <pre>
     * The action that was taken on the product.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
     */
    public int getVerbValue() {
      return verb_;
    }
    /**
     * <pre>
     * The action that was taken on the product.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
     */
    public io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction getVerb() {
      io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction result = io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.valueOf(verb_);
      return result == null ? io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.UNRECOGNIZED : result;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Timestamp for when this action occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (verb_ != io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.VIEW.getNumber()) {
        output.writeEnum(2, verb_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (verb_ != io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.VIEW.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, verb_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.product.ProductAnalytics.Action)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.product.ProductAnalytics.Action other = (io.bloombox.schema.analytics.product.ProductAnalytics.Action) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && verb_ == other.verb_;
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + verb_;
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.product.ProductAnalytics.Action prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * An action that was taken affirmatively by a user on a particular product.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.product.Action}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.product.Action)
        io.bloombox.schema.analytics.product.ProductAnalytics.ActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Action_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.product.ProductAnalytics.Action.class, io.bloombox.schema.analytics.product.ProductAnalytics.Action.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.product.ProductAnalytics.Action.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        verb_ = 0;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.internal_static_bloombox_schema_analytics_product_Action_descriptor;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Action getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.product.ProductAnalytics.Action.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Action build() {
        io.bloombox.schema.analytics.product.ProductAnalytics.Action result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.product.ProductAnalytics.Action buildPartial() {
        io.bloombox.schema.analytics.product.ProductAnalytics.Action result = new io.bloombox.schema.analytics.product.ProductAnalytics.Action(this);
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.verb_ = verb_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.product.ProductAnalytics.Action) {
          return mergeFrom((io.bloombox.schema.analytics.product.ProductAnalytics.Action)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.product.ProductAnalytics.Action other) {
        if (other == io.bloombox.schema.analytics.product.ProductAnalytics.Action.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.verb_ != 0) {
          setVerbValue(other.getVerbValue());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.product.ProductAnalytics.Action parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.product.ProductAnalytics.Action) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Key for the product that action was taken on.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private int verb_ = 0;
      /**
       * <pre>
       * The action that was taken on the product.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
       */
      public int getVerbValue() {
        return verb_;
      }
      /**
       * <pre>
       * The action that was taken on the product.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
       */
      public Builder setVerbValue(int value) {
        verb_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The action that was taken on the product.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
       */
      public io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction getVerb() {
        io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction result = io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.valueOf(verb_);
        return result == null ? io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * The action that was taken on the product.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
       */
      public Builder setVerb(io.bloombox.schema.analytics.product.ProductAnalytics.ProductAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        verb_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The action that was taken on the product.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.product.ProductAction verb = 2;</code>
       */
      public Builder clearVerb() {
        
        verb_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Timestamp for when this action occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.product.Action)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.product.Action)
    private static final io.bloombox.schema.analytics.product.ProductAnalytics.Action DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.product.ProductAnalytics.Action();
    }

    public static io.bloombox.schema.analytics.product.ProductAnalytics.Action getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Action>
        PARSER = new com.google.protobuf.AbstractParser<Action>() {
      public Action parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Action(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Action> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Action> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.product.ProductAnalytics.Action getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_product_Impression_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_product_Impression_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_product_View_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_product_View_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_product_Action_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_product_Action_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n)analytics/commerce/ProductAnalytics.pr" +
      "oto\022!bloombox.schema.analytics.product\032\025" +
      "base/ProductKey.proto\032\026temporal/Instant." +
      "proto\"\214\001\n\nImpression\022*\n\003key\030\001 \001(\0132\035.open" +
      "cannabis.base.ProductKey\022\020\n\010filtered\030\002 \001" +
      "(\010\022\016\n\006sorted\030\003 \001(\010\0220\n\010occurred\030\004 \001(\0132\036.o" +
      "pencannabis.temporal.Instant\"y\n\004View\022*\n\003" +
      "key\030\001 \001(\0132\035.opencannabis.base.ProductKey" +
      "\022\023\n\013interactive\030\002 \001(\010\0220\n\010occurred\030\003 \001(\0132" +
      "\036.opencannabis.temporal.Instant\"\246\001\n\006Acti" +
      "on\022*\n\003key\030\001 \001(\0132\035.opencannabis.base.Prod" +
      "uctKey\022>\n\004verb\030\002 \001(\01620.bloombox.schema.a" +
      "nalytics.product.ProductAction\0220\n\010occurr" +
      "ed\030\003 \001(\0132\036.opencannabis.temporal.Instant" +
      "*\212\001\n\rProductAction\022\010\n\004VIEW\020\000\022\t\n\005SHARE\020\001\022" +
      "\014\n\010FAVORITE\020\002\022\013\n\007COMPARE\020\003\022\010\n\004CART\020\004\022\014\n\010" +
      "PURCHASE\020\005\022\r\n\tSUBSCRIBE\020\006\022\010\n\004ZOOM\020\007\022\013\n\007R" +
      "EPORTS\020\010\022\013\n\007SIMILAR\020\tBB\n$io.bloombox.sch" +
      "ema.analytics.productB\020ProductAnalyticsH" +
      "\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_product_Impression_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_product_Impression_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_product_Impression_descriptor,
        new java.lang.String[] { "Key", "Filtered", "Sorted", "Occurred", });
    internal_static_bloombox_schema_analytics_product_View_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_product_View_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_product_View_descriptor,
        new java.lang.String[] { "Key", "Interactive", "Occurred", });
    internal_static_bloombox_schema_analytics_product_Action_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_product_Action_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_product_Action_descriptor,
        new java.lang.String[] { "Key", "Verb", "Occurred", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
