/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/commerce/SectionAnalytics.proto

package io.bloombox.schema.analytics.section;

public final class SectionAnalytics {
  private SectionAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies actions that may be taken within a menu section.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.section.SectionAction}
   */
  public enum SectionAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The section was viewed. Section views are implemented under-the-hood as actions of type VIEW.
     * </pre>
     *
     * <code>VIEW = 0;</code>
     */
    VIEW(0),
    /**
     * <pre>
     * The section was sorted on some product property, presumably reordering the visible products.
     * </pre>
     *
     * <code>SORT = 1;</code>
     */
    SORT(1),
    /**
     * <pre>
     * The section was filtered on some product property, presumably mutating the set of visible products.
     * </pre>
     *
     * <code>FILTER = 2;</code>
     */
    FILTER(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The section was viewed. Section views are implemented under-the-hood as actions of type VIEW.
     * </pre>
     *
     * <code>VIEW = 0;</code>
     */
    public static final int VIEW_VALUE = 0;
    /**
     * <pre>
     * The section was sorted on some product property, presumably reordering the visible products.
     * </pre>
     *
     * <code>SORT = 1;</code>
     */
    public static final int SORT_VALUE = 1;
    /**
     * <pre>
     * The section was filtered on some product property, presumably mutating the set of visible products.
     * </pre>
     *
     * <code>FILTER = 2;</code>
     */
    public static final int FILTER_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SectionAction valueOf(int value) {
      return forNumber(value);
    }

    public static SectionAction forNumber(int value) {
      switch (value) {
        case 0: return VIEW;
        case 1: return SORT;
        case 2: return FILTER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SectionAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SectionAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SectionAction>() {
            public SectionAction findValueByNumber(int number) {
              return SectionAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final SectionAction[] VALUES = values();

    public static SectionAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SectionAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.section.SectionAction)
  }

  public interface ImpressionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.section.Impression)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    boolean hasSpec();
    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpec getSpec();
    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder();

    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a section impression event, wherein a user has been presented a particular menu section.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.section.Impression}
   */
  public  static final class Impression extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.section.Impression)
      ImpressionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Impression.newBuilder() to construct.
    private Impression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Impression() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Impression(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.menu.section.SectionSpec.Builder subBuilder = null;
              if (spec_ != null) {
                subBuilder = spec_.toBuilder();
              }
              spec_ = input.readMessage(io.opencannabis.schema.menu.section.SectionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(spec_);
                spec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Impression_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Impression_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.section.SectionAnalytics.Impression.class, io.bloombox.schema.analytics.section.SectionAnalytics.Impression.Builder.class);
    }

    public static final int SPEC_FIELD_NUMBER = 1;
    private io.opencannabis.schema.menu.section.SectionSpec spec_;
    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public boolean hasSpec() {
      return spec_ != null;
    }
    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
      return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
    }
    /**
     * <pre>
     * Section that was presented.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
      return getSpec();
    }

    public static final int OCCURRED_FIELD_NUMBER = 2;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (spec_ != null) {
        output.writeMessage(1, getSpec());
      }
      if (occurred_ != null) {
        output.writeMessage(2, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (spec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getSpec());
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.section.SectionAnalytics.Impression)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.section.SectionAnalytics.Impression other = (io.bloombox.schema.analytics.section.SectionAnalytics.Impression) obj;

      boolean result = true;
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec()
            .equals(other.getSpec());
      }
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.section.SectionAnalytics.Impression prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a section impression event, wherein a user has been presented a particular menu section.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.section.Impression}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.section.Impression)
        io.bloombox.schema.analytics.section.SectionAnalytics.ImpressionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Impression_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Impression_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.section.SectionAnalytics.Impression.class, io.bloombox.schema.analytics.section.SectionAnalytics.Impression.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.section.SectionAnalytics.Impression.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          spec_ = null;
          specBuilder_ = null;
        }
        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Impression_descriptor;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Impression getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.Impression.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Impression build() {
        io.bloombox.schema.analytics.section.SectionAnalytics.Impression result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Impression buildPartial() {
        io.bloombox.schema.analytics.section.SectionAnalytics.Impression result = new io.bloombox.schema.analytics.section.SectionAnalytics.Impression(this);
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.section.SectionAnalytics.Impression) {
          return mergeFrom((io.bloombox.schema.analytics.section.SectionAnalytics.Impression)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.section.SectionAnalytics.Impression other) {
        if (other == io.bloombox.schema.analytics.section.SectionAnalytics.Impression.getDefaultInstance()) return this;
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.section.SectionAnalytics.Impression parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.section.SectionAnalytics.Impression) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.menu.section.SectionSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> specBuilder_;
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public boolean hasSpec() {
        return specBuilder_ != null || spec_ != null;
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(
          io.opencannabis.schema.menu.section.SectionSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder mergeSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (spec_ != null) {
            spec_ =
              io.opencannabis.schema.menu.section.SectionSpec.newBuilder(spec_).mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          spec_ = null;
          specBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec.Builder getSpecBuilder() {
        
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null ?
              io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        }
      }
      /**
       * <pre>
       * Section that was presented.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> 
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder>(
                  getSpec(),
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.section.Impression)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.section.Impression)
    private static final io.bloombox.schema.analytics.section.SectionAnalytics.Impression DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.section.SectionAnalytics.Impression();
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.Impression getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Impression>
        PARSER = new com.google.protobuf.AbstractParser<Impression>() {
      public Impression parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Impression(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Impression> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Impression> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.section.SectionAnalytics.Impression getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.section.View)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    boolean hasSpec();
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpec getSpec();
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder();

    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    boolean getInteractive();

    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a section view event, wherein a user has navigated to a particular menu section.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.section.View}
   */
  public  static final class View extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.section.View)
      ViewOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use View.newBuilder() to construct.
    private View(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private View() {
      interactive_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private View(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.menu.section.SectionSpec.Builder subBuilder = null;
              if (spec_ != null) {
                subBuilder = spec_.toBuilder();
              }
              spec_ = input.readMessage(io.opencannabis.schema.menu.section.SectionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(spec_);
                spec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              interactive_ = input.readBool();
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_View_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_View_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.section.SectionAnalytics.View.class, io.bloombox.schema.analytics.section.SectionAnalytics.View.Builder.class);
    }

    public static final int SPEC_FIELD_NUMBER = 1;
    private io.opencannabis.schema.menu.section.SectionSpec spec_;
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public boolean hasSpec() {
      return spec_ != null;
    }
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
      return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
    }
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
      return getSpec();
    }

    public static final int INTERACTIVE_FIELD_NUMBER = 2;
    private boolean interactive_;
    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    public boolean getInteractive() {
      return interactive_;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (spec_ != null) {
        output.writeMessage(1, getSpec());
      }
      if (interactive_ != false) {
        output.writeBool(2, interactive_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (spec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getSpec());
      }
      if (interactive_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, interactive_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.section.SectionAnalytics.View)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.section.SectionAnalytics.View other = (io.bloombox.schema.analytics.section.SectionAnalytics.View) obj;

      boolean result = true;
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec()
            .equals(other.getSpec());
      }
      result = result && (getInteractive()
          == other.getInteractive());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (37 * hash) + INTERACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInteractive());
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.section.SectionAnalytics.View prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a section view event, wherein a user has navigated to a particular menu section.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.section.View}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.section.View)
        io.bloombox.schema.analytics.section.SectionAnalytics.ViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_View_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_View_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.section.SectionAnalytics.View.class, io.bloombox.schema.analytics.section.SectionAnalytics.View.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.section.SectionAnalytics.View.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          spec_ = null;
          specBuilder_ = null;
        }
        interactive_ = false;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_View_descriptor;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.View getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.View.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.View build() {
        io.bloombox.schema.analytics.section.SectionAnalytics.View result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.View buildPartial() {
        io.bloombox.schema.analytics.section.SectionAnalytics.View result = new io.bloombox.schema.analytics.section.SectionAnalytics.View(this);
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.interactive_ = interactive_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.section.SectionAnalytics.View) {
          return mergeFrom((io.bloombox.schema.analytics.section.SectionAnalytics.View)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.section.SectionAnalytics.View other) {
        if (other == io.bloombox.schema.analytics.section.SectionAnalytics.View.getDefaultInstance()) return this;
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.getInteractive() != false) {
          setInteractive(other.getInteractive());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.section.SectionAnalytics.View parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.section.SectionAnalytics.View) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.menu.section.SectionSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> specBuilder_;
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public boolean hasSpec() {
        return specBuilder_ != null || spec_ != null;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(
          io.opencannabis.schema.menu.section.SectionSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder mergeSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (spec_ != null) {
            spec_ =
              io.opencannabis.schema.menu.section.SectionSpec.newBuilder(spec_).mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          spec_ = null;
          specBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec.Builder getSpecBuilder() {
        
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null ?
              io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        }
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> 
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder>(
                  getSpec(),
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private boolean interactive_ ;
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public boolean getInteractive() {
        return interactive_;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder setInteractive(boolean value) {
        
        interactive_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder clearInteractive() {
        
        interactive_ = false;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.section.View)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.section.View)
    private static final io.bloombox.schema.analytics.section.SectionAnalytics.View DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.section.SectionAnalytics.View();
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.View getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<View>
        PARSER = new com.google.protobuf.AbstractParser<View>() {
      public View parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new View(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<View> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<View> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.section.SectionAnalytics.View getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ActionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.section.Action)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    boolean hasSpec();
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpec getSpec();
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder();

    /**
     * <pre>
     * Action that was taken within the section.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
     */
    int getVerbValue();
    /**
     * <pre>
     * Action that was taken within the section.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
     */
    io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction getVerb();

    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a section action event, wherein a user has affirmatively elected to take some action while within a master
   * view of a particular menu section.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.section.Action}
   */
  public  static final class Action extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.section.Action)
      ActionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Action.newBuilder() to construct.
    private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Action() {
      verb_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Action(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.menu.section.SectionSpec.Builder subBuilder = null;
              if (spec_ != null) {
                subBuilder = spec_.toBuilder();
              }
              spec_ = input.readMessage(io.opencannabis.schema.menu.section.SectionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(spec_);
                spec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              verb_ = rawValue;
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Action_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.section.SectionAnalytics.Action.class, io.bloombox.schema.analytics.section.SectionAnalytics.Action.Builder.class);
    }

    public static final int SPEC_FIELD_NUMBER = 1;
    private io.opencannabis.schema.menu.section.SectionSpec spec_;
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public boolean hasSpec() {
      return spec_ != null;
    }
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
      return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
    }
    /**
     * <pre>
     * Section that was viewed.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
     */
    public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
      return getSpec();
    }

    public static final int VERB_FIELD_NUMBER = 2;
    private int verb_;
    /**
     * <pre>
     * Action that was taken within the section.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
     */
    public int getVerbValue() {
      return verb_;
    }
    /**
     * <pre>
     * Action that was taken within the section.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
     */
    public io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction getVerb() {
      io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction result = io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.valueOf(verb_);
      return result == null ? io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.UNRECOGNIZED : result;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (spec_ != null) {
        output.writeMessage(1, getSpec());
      }
      if (verb_ != io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.VIEW.getNumber()) {
        output.writeEnum(2, verb_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (spec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getSpec());
      }
      if (verb_ != io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.VIEW.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, verb_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.section.SectionAnalytics.Action)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.section.SectionAnalytics.Action other = (io.bloombox.schema.analytics.section.SectionAnalytics.Action) obj;

      boolean result = true;
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec()
            .equals(other.getSpec());
      }
      result = result && verb_ == other.verb_;
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + verb_;
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.section.SectionAnalytics.Action prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a section action event, wherein a user has affirmatively elected to take some action while within a master
     * view of a particular menu section.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.section.Action}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.section.Action)
        io.bloombox.schema.analytics.section.SectionAnalytics.ActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Action_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.section.SectionAnalytics.Action.class, io.bloombox.schema.analytics.section.SectionAnalytics.Action.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.section.SectionAnalytics.Action.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          spec_ = null;
          specBuilder_ = null;
        }
        verb_ = 0;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.internal_static_bloombox_schema_analytics_section_Action_descriptor;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Action getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.section.SectionAnalytics.Action.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Action build() {
        io.bloombox.schema.analytics.section.SectionAnalytics.Action result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.section.SectionAnalytics.Action buildPartial() {
        io.bloombox.schema.analytics.section.SectionAnalytics.Action result = new io.bloombox.schema.analytics.section.SectionAnalytics.Action(this);
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.verb_ = verb_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.section.SectionAnalytics.Action) {
          return mergeFrom((io.bloombox.schema.analytics.section.SectionAnalytics.Action)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.section.SectionAnalytics.Action other) {
        if (other == io.bloombox.schema.analytics.section.SectionAnalytics.Action.getDefaultInstance()) return this;
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.verb_ != 0) {
          setVerbValue(other.getVerbValue());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.section.SectionAnalytics.Action parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.section.SectionAnalytics.Action) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.menu.section.SectionSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> specBuilder_;
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public boolean hasSpec() {
        return specBuilder_ != null || spec_ != null;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null ? io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder setSpec(
          io.opencannabis.schema.menu.section.SectionSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder mergeSpec(io.opencannabis.schema.menu.section.SectionSpec value) {
        if (specBuilder_ == null) {
          if (spec_ != null) {
            spec_ =
              io.opencannabis.schema.menu.section.SectionSpec.newBuilder(spec_).mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          spec_ = null;
          specBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpec.Builder getSpecBuilder() {
        
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      public io.opencannabis.schema.menu.section.SectionSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null ?
              io.opencannabis.schema.menu.section.SectionSpec.getDefaultInstance() : spec_;
        }
      }
      /**
       * <pre>
       * Section that was viewed.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.SectionSpec spec = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder> 
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.menu.section.SectionSpec, io.opencannabis.schema.menu.section.SectionSpec.Builder, io.opencannabis.schema.menu.section.SectionSpecOrBuilder>(
                  getSpec(),
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private int verb_ = 0;
      /**
       * <pre>
       * Action that was taken within the section.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
       */
      public int getVerbValue() {
        return verb_;
      }
      /**
       * <pre>
       * Action that was taken within the section.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
       */
      public Builder setVerbValue(int value) {
        verb_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken within the section.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
       */
      public io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction getVerb() {
        io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction result = io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.valueOf(verb_);
        return result == null ? io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Action that was taken within the section.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
       */
      public Builder setVerb(io.bloombox.schema.analytics.section.SectionAnalytics.SectionAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        verb_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken within the section.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.section.SectionAction verb = 2;</code>
       */
      public Builder clearVerb() {
        
        verb_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.section.Action)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.section.Action)
    private static final io.bloombox.schema.analytics.section.SectionAnalytics.Action DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.section.SectionAnalytics.Action();
    }

    public static io.bloombox.schema.analytics.section.SectionAnalytics.Action getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Action>
        PARSER = new com.google.protobuf.AbstractParser<Action>() {
      public Action parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Action(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Action> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Action> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.section.SectionAnalytics.Action getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_section_Impression_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_section_Impression_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_section_View_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_section_View_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_section_Action_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_section_Action_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n)analytics/commerce/SectionAnalytics.pr" +
      "oto\022!bloombox.schema.analytics.section\032\026" +
      "temporal/Instant.proto\032\033products/menu/Se" +
      "ction.proto\"}\n\nImpression\022=\n\004spec\030\001 \001(\0132" +
      "/.opencannabis.products.menu.section.Sec" +
      "tionSpec\0220\n\010occurred\030\002 \001(\0132\036.opencannabi" +
      "s.temporal.Instant\"\214\001\n\004View\022=\n\004spec\030\001 \001(" +
      "\0132/.opencannabis.products.menu.section.S" +
      "ectionSpec\022\023\n\013interactive\030\002 \001(\010\0220\n\010occur" +
      "red\030\003 \001(\0132\036.opencannabis.temporal.Instan" +
      "t\"\271\001\n\006Action\022=\n\004spec\030\001 \001(\0132/.opencannabi" +
      "s.products.menu.section.SectionSpec\022>\n\004v" +
      "erb\030\002 \001(\01620.bloombox.schema.analytics.se" +
      "ction.SectionAction\0220\n\010occurred\030\003 \001(\0132\036." +
      "opencannabis.temporal.Instant*/\n\rSection" +
      "Action\022\010\n\004VIEW\020\000\022\010\n\004SORT\020\001\022\n\n\006FILTER\020\002BB" +
      "\n$io.bloombox.schema.analytics.sectionB\020" +
      "SectionAnalyticsH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
          io.opencannabis.schema.menu.section.SectionOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_section_Impression_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_section_Impression_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_section_Impression_descriptor,
        new java.lang.String[] { "Spec", "Occurred", });
    internal_static_bloombox_schema_analytics_section_View_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_section_View_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_section_View_descriptor,
        new java.lang.String[] { "Spec", "Interactive", "Occurred", });
    internal_static_bloombox_schema_analytics_section_Action_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_section_Action_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_section_Action_descriptor,
        new java.lang.String[] { "Spec", "Verb", "Occurred", });
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
    io.opencannabis.schema.menu.section.SectionOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
