/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/commerce/ShopAnalytics.proto

package io.bloombox.schema.analytics.shop;

public final class ShopAnalytics {
  private ShopAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies actions that may be taken w.r.t. a physical or digital storefront. Stays in sync with `UserAction`.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.shop.ShopAction}
   */
  public enum ShopAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The storefront was viewed, or entered physically by a patron.
     * </pre>
     *
     * <code>ENGAGE = 0;</code>
     */
    ENGAGE(0),
    /**
     * <pre>
     * The storefront or digital property facilitated the user's enrollment with Bloombox.
     * </pre>
     *
     * <code>ENROLL = 10;</code>
     */
    ENROLL(10),
    /**
     * <pre>
     * The user activated a dormant or previously-created shadow account for themselves at this digital storefront or
     * physical storefront location.
     * </pre>
     *
     * <code>ACTIVATE = 11;</code>
     */
    ACTIVATE(11),
    /**
     * <pre>
     * The storefront or digital property facilitated the enrollment of an existing Bloombox user with the storefront's
     * membership systems, either operated by Bloombox or another party.
     * </pre>
     *
     * <code>JOIN = 12;</code>
     */
    JOIN(12),
    /**
     * <pre>
     * A physical storefront verified a user's cannabis recommendation, age eligibility, or in general, their eligibility
     * to make purchases including legal cannabis.
     * </pre>
     *
     * <code>VERIFY = 13;</code>
     */
    VERIFY(13),
    /**
     * <pre>
     * A physical storefront checked a user in, or a digital storefront logged a user in.
     * </pre>
     *
     * <code>CHECKIN = 14;</code>
     */
    CHECKIN(14),
    /**
     * <pre>
     * The user's preferences were adjusted in some manner, either online, after logging in as themselves; or by partner
     * staff through back-office systems.
     * </pre>
     *
     * <code>PREFERENCES = 15;</code>
     */
    PREFERENCES(15),
    /**
     * <pre>
     * The user made a purchase, either digitally, or at a brick-and-mortar location, facilitated by partner staff.
     * </pre>
     *
     * <code>PURCHASE = 16;</code>
     */
    PURCHASE(16),
    /**
     * <pre>
     * The user submitted an order, digitally, via the online shop; or via other communication mediums (phone/email) and
     * entered and facilitated by dispensary staff, via back-office systems.
     * </pre>
     *
     * <code>ORDER = 17;</code>
     */
    ORDER(17),
    /**
     * <pre>
     * The user opted in to receive marketing content of some kind, or authorized communications from a partner, whether
     * physically or digitally. This is distinguished from the corresponding `UserAction`, which is global, and therefore
     * carries a different ID.
     * </pre>
     *
     * <code>OPT_IN = 20;</code>
     */
    OPT_IN(20),
    /**
     * <pre>
     * The user opted out from receiving marketing content from a partner, whether physically or digitally. This is
     * distinguished from the corresponding `UserAction`, which is global, and therefore carries a different ID.
     * </pre>
     *
     * <code>OPT_OUT = 21;</code>
     */
    OPT_OUT(21),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The storefront was viewed, or entered physically by a patron.
     * </pre>
     *
     * <code>ENGAGE = 0;</code>
     */
    public static final int ENGAGE_VALUE = 0;
    /**
     * <pre>
     * The storefront or digital property facilitated the user's enrollment with Bloombox.
     * </pre>
     *
     * <code>ENROLL = 10;</code>
     */
    public static final int ENROLL_VALUE = 10;
    /**
     * <pre>
     * The user activated a dormant or previously-created shadow account for themselves at this digital storefront or
     * physical storefront location.
     * </pre>
     *
     * <code>ACTIVATE = 11;</code>
     */
    public static final int ACTIVATE_VALUE = 11;
    /**
     * <pre>
     * The storefront or digital property facilitated the enrollment of an existing Bloombox user with the storefront's
     * membership systems, either operated by Bloombox or another party.
     * </pre>
     *
     * <code>JOIN = 12;</code>
     */
    public static final int JOIN_VALUE = 12;
    /**
     * <pre>
     * A physical storefront verified a user's cannabis recommendation, age eligibility, or in general, their eligibility
     * to make purchases including legal cannabis.
     * </pre>
     *
     * <code>VERIFY = 13;</code>
     */
    public static final int VERIFY_VALUE = 13;
    /**
     * <pre>
     * A physical storefront checked a user in, or a digital storefront logged a user in.
     * </pre>
     *
     * <code>CHECKIN = 14;</code>
     */
    public static final int CHECKIN_VALUE = 14;
    /**
     * <pre>
     * The user's preferences were adjusted in some manner, either online, after logging in as themselves; or by partner
     * staff through back-office systems.
     * </pre>
     *
     * <code>PREFERENCES = 15;</code>
     */
    public static final int PREFERENCES_VALUE = 15;
    /**
     * <pre>
     * The user made a purchase, either digitally, or at a brick-and-mortar location, facilitated by partner staff.
     * </pre>
     *
     * <code>PURCHASE = 16;</code>
     */
    public static final int PURCHASE_VALUE = 16;
    /**
     * <pre>
     * The user submitted an order, digitally, via the online shop; or via other communication mediums (phone/email) and
     * entered and facilitated by dispensary staff, via back-office systems.
     * </pre>
     *
     * <code>ORDER = 17;</code>
     */
    public static final int ORDER_VALUE = 17;
    /**
     * <pre>
     * The user opted in to receive marketing content of some kind, or authorized communications from a partner, whether
     * physically or digitally. This is distinguished from the corresponding `UserAction`, which is global, and therefore
     * carries a different ID.
     * </pre>
     *
     * <code>OPT_IN = 20;</code>
     */
    public static final int OPT_IN_VALUE = 20;
    /**
     * <pre>
     * The user opted out from receiving marketing content from a partner, whether physically or digitally. This is
     * distinguished from the corresponding `UserAction`, which is global, and therefore carries a different ID.
     * </pre>
     *
     * <code>OPT_OUT = 21;</code>
     */
    public static final int OPT_OUT_VALUE = 21;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ShopAction valueOf(int value) {
      return forNumber(value);
    }

    public static ShopAction forNumber(int value) {
      switch (value) {
        case 0: return ENGAGE;
        case 10: return ENROLL;
        case 11: return ACTIVATE;
        case 12: return JOIN;
        case 13: return VERIFY;
        case 14: return CHECKIN;
        case 15: return PREFERENCES;
        case 16: return PURCHASE;
        case 17: return ORDER;
        case 20: return OPT_IN;
        case 21: return OPT_OUT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ShopAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ShopAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ShopAction>() {
            public ShopAction findValueByNumber(int number) {
              return ShopAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final ShopAction[] VALUES = values();

    public static ShopAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ShopAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.shop.ShopAction)
  }

  public interface ImpressionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.shop.Impression)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    boolean getPhysical();

    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a shop impression event, wherein a user, known or unknown, has witnessed a shop's existence or brand, and
   * was offered the decision to engage.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.shop.Impression}
   */
  public  static final class Impression extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.shop.Impression)
      ImpressionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Impression.newBuilder() to construct.
    private Impression(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Impression() {
      physical_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Impression(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              physical_ = input.readBool();
              break;
            }
            case 18: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Impression_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Impression_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.class, io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.Builder.class);
    }

    public static final int PHYSICAL_FIELD_NUMBER = 1;
    private boolean physical_;
    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    public boolean getPhysical() {
      return physical_;
    }

    public static final int OCCURRED_FIELD_NUMBER = 2;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this impression event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 2;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (physical_ != false) {
        output.writeBool(1, physical_);
      }
      if (occurred_ != null) {
        output.writeMessage(2, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (physical_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, physical_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.Impression)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.shop.ShopAnalytics.Impression other = (io.bloombox.schema.analytics.shop.ShopAnalytics.Impression) obj;

      boolean result = true;
      result = result && (getPhysical()
          == other.getPhysical());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PHYSICAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPhysical());
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.shop.ShopAnalytics.Impression prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a shop impression event, wherein a user, known or unknown, has witnessed a shop's existence or brand, and
     * was offered the decision to engage.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.shop.Impression}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.shop.Impression)
        io.bloombox.schema.analytics.shop.ShopAnalytics.ImpressionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Impression_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Impression_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.class, io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        physical_ = false;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Impression_descriptor;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Impression getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Impression build() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Impression result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Impression buildPartial() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Impression result = new io.bloombox.schema.analytics.shop.ShopAnalytics.Impression(this);
        result.physical_ = physical_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.Impression) {
          return mergeFrom((io.bloombox.schema.analytics.shop.ShopAnalytics.Impression)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.shop.ShopAnalytics.Impression other) {
        if (other == io.bloombox.schema.analytics.shop.ShopAnalytics.Impression.getDefaultInstance()) return this;
        if (other.getPhysical() != false) {
          setPhysical(other.getPhysical());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Impression parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.shop.ShopAnalytics.Impression) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean physical_ ;
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public boolean getPhysical() {
        return physical_;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder setPhysical(boolean value) {
        
        physical_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder clearPhysical() {
        
        physical_ = false;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this impression event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.shop.Impression)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.shop.Impression)
    private static final io.bloombox.schema.analytics.shop.ShopAnalytics.Impression DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.shop.ShopAnalytics.Impression();
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Impression getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Impression>
        PARSER = new com.google.protobuf.AbstractParser<Impression>() {
      public Impression parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Impression(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Impression> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Impression> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.shop.ShopAnalytics.Impression getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ViewOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.shop.View)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    boolean getPhysical();

    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view action of some kind.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    boolean getInteractive();

    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a shop view event, wherein a user has navigated to a page on a digital web store, entered a physical
   * brick-and-mortar location, or otherwise chosen to engage in a non-commercial way.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.shop.View}
   */
  public  static final class View extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.shop.View)
      ViewOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use View.newBuilder() to construct.
    private View(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private View() {
      physical_ = false;
      interactive_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private View(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              physical_ = input.readBool();
              break;
            }
            case 16: {

              interactive_ = input.readBool();
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_View_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_View_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.shop.ShopAnalytics.View.class, io.bloombox.schema.analytics.shop.ShopAnalytics.View.Builder.class);
    }

    public static final int PHYSICAL_FIELD_NUMBER = 1;
    private boolean physical_;
    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    public boolean getPhysical() {
      return physical_;
    }

    public static final int INTERACTIVE_FIELD_NUMBER = 2;
    private boolean interactive_;
    /**
     * <pre>
     * Whether this was a user-initiated view, or a default view action of some kind.
     * </pre>
     *
     * <code>bool interactive = 2;</code>
     */
    public boolean getInteractive() {
      return interactive_;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (physical_ != false) {
        output.writeBool(1, physical_);
      }
      if (interactive_ != false) {
        output.writeBool(2, interactive_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (physical_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, physical_);
      }
      if (interactive_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, interactive_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.View)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.shop.ShopAnalytics.View other = (io.bloombox.schema.analytics.shop.ShopAnalytics.View) obj;

      boolean result = true;
      result = result && (getPhysical()
          == other.getPhysical());
      result = result && (getInteractive()
          == other.getInteractive());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PHYSICAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPhysical());
      hash = (37 * hash) + INTERACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getInteractive());
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.shop.ShopAnalytics.View prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a shop view event, wherein a user has navigated to a page on a digital web store, entered a physical
     * brick-and-mortar location, or otherwise chosen to engage in a non-commercial way.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.shop.View}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.shop.View)
        io.bloombox.schema.analytics.shop.ShopAnalytics.ViewOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_View_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_View_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.shop.ShopAnalytics.View.class, io.bloombox.schema.analytics.shop.ShopAnalytics.View.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.shop.ShopAnalytics.View.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        physical_ = false;

        interactive_ = false;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_View_descriptor;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.View getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.View.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.View build() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.View result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.View buildPartial() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.View result = new io.bloombox.schema.analytics.shop.ShopAnalytics.View(this);
        result.physical_ = physical_;
        result.interactive_ = interactive_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.View) {
          return mergeFrom((io.bloombox.schema.analytics.shop.ShopAnalytics.View)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.shop.ShopAnalytics.View other) {
        if (other == io.bloombox.schema.analytics.shop.ShopAnalytics.View.getDefaultInstance()) return this;
        if (other.getPhysical() != false) {
          setPhysical(other.getPhysical());
        }
        if (other.getInteractive() != false) {
          setInteractive(other.getInteractive());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.shop.ShopAnalytics.View parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.shop.ShopAnalytics.View) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean physical_ ;
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public boolean getPhysical() {
        return physical_;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder setPhysical(boolean value) {
        
        physical_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder clearPhysical() {
        
        physical_ = false;
        onChanged();
        return this;
      }

      private boolean interactive_ ;
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view action of some kind.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public boolean getInteractive() {
        return interactive_;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view action of some kind.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder setInteractive(boolean value) {
        
        interactive_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was a user-initiated view, or a default view action of some kind.
       * </pre>
       *
       * <code>bool interactive = 2;</code>
       */
      public Builder clearInteractive() {
        
        interactive_ = false;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.shop.View)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.shop.View)
    private static final io.bloombox.schema.analytics.shop.ShopAnalytics.View DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.shop.ShopAnalytics.View();
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.View getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<View>
        PARSER = new com.google.protobuf.AbstractParser<View>() {
      public View parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new View(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<View> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<View> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.shop.ShopAnalytics.View getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ActionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.shop.Action)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    boolean getPhysical();

    /**
     * <pre>
     * Action that was taken at or within the digital or physical shop.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
     */
    int getVerbValue();
    /**
     * <pre>
     * Action that was taken at or within the digital or physical shop.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
     */
    io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction getVerb();

    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a shop action event, wherein a user has affirmatively elected to take some action while engaged in an
   * interactive session with a digital or physical commercial storefront.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.shop.Action}
   */
  public  static final class Action extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.shop.Action)
      ActionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Action.newBuilder() to construct.
    private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Action() {
      physical_ = false;
      verb_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Action(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              physical_ = input.readBool();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              verb_ = rawValue;
              break;
            }
            case 34: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Action_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.shop.ShopAnalytics.Action.class, io.bloombox.schema.analytics.shop.ShopAnalytics.Action.Builder.class);
    }

    public static final int PHYSICAL_FIELD_NUMBER = 1;
    private boolean physical_;
    /**
     * <pre>
     * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
     * </pre>
     *
     * <code>bool physical = 1;</code>
     */
    public boolean getPhysical() {
      return physical_;
    }

    public static final int VERB_FIELD_NUMBER = 2;
    private int verb_;
    /**
     * <pre>
     * Action that was taken at or within the digital or physical shop.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
     */
    public int getVerbValue() {
      return verb_;
    }
    /**
     * <pre>
     * Action that was taken at or within the digital or physical shop.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
     */
    public io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction getVerb() {
      io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction result = io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.valueOf(verb_);
      return result == null ? io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.UNRECOGNIZED : result;
    }

    public static final int OCCURRED_FIELD_NUMBER = 4;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this action event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (physical_ != false) {
        output.writeBool(1, physical_);
      }
      if (verb_ != io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.ENGAGE.getNumber()) {
        output.writeEnum(2, verb_);
      }
      if (occurred_ != null) {
        output.writeMessage(4, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (physical_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, physical_);
      }
      if (verb_ != io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.ENGAGE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, verb_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.Action)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.shop.ShopAnalytics.Action other = (io.bloombox.schema.analytics.shop.ShopAnalytics.Action) obj;

      boolean result = true;
      result = result && (getPhysical()
          == other.getPhysical());
      result = result && verb_ == other.verb_;
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PHYSICAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getPhysical());
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + verb_;
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.shop.ShopAnalytics.Action prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a shop action event, wherein a user has affirmatively elected to take some action while engaged in an
     * interactive session with a digital or physical commercial storefront.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.shop.Action}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.shop.Action)
        io.bloombox.schema.analytics.shop.ShopAnalytics.ActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Action_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.shop.ShopAnalytics.Action.class, io.bloombox.schema.analytics.shop.ShopAnalytics.Action.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.shop.ShopAnalytics.Action.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        physical_ = false;

        verb_ = 0;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.internal_static_bloombox_schema_analytics_shop_Action_descriptor;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Action getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.shop.ShopAnalytics.Action.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Action build() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Action result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.shop.ShopAnalytics.Action buildPartial() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Action result = new io.bloombox.schema.analytics.shop.ShopAnalytics.Action(this);
        result.physical_ = physical_;
        result.verb_ = verb_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.shop.ShopAnalytics.Action) {
          return mergeFrom((io.bloombox.schema.analytics.shop.ShopAnalytics.Action)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.shop.ShopAnalytics.Action other) {
        if (other == io.bloombox.schema.analytics.shop.ShopAnalytics.Action.getDefaultInstance()) return this;
        if (other.getPhysical() != false) {
          setPhysical(other.getPhysical());
        }
        if (other.verb_ != 0) {
          setVerbValue(other.getVerbValue());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.shop.ShopAnalytics.Action parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.shop.ShopAnalytics.Action) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean physical_ ;
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public boolean getPhysical() {
        return physical_;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder setPhysical(boolean value) {
        
        physical_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this was an event that occurred at a physical store location, or not. Defaults to no.
       * </pre>
       *
       * <code>bool physical = 1;</code>
       */
      public Builder clearPhysical() {
        
        physical_ = false;
        onChanged();
        return this;
      }

      private int verb_ = 0;
      /**
       * <pre>
       * Action that was taken at or within the digital or physical shop.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
       */
      public int getVerbValue() {
        return verb_;
      }
      /**
       * <pre>
       * Action that was taken at or within the digital or physical shop.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
       */
      public Builder setVerbValue(int value) {
        verb_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken at or within the digital or physical shop.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
       */
      public io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction getVerb() {
        io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction result = io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.valueOf(verb_);
        return result == null ? io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Action that was taken at or within the digital or physical shop.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
       */
      public Builder setVerb(io.bloombox.schema.analytics.shop.ShopAnalytics.ShopAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        verb_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken at or within the digital or physical shop.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.shop.ShopAction verb = 2;</code>
       */
      public Builder clearVerb() {
        
        verb_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this action event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.shop.Action)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.shop.Action)
    private static final io.bloombox.schema.analytics.shop.ShopAnalytics.Action DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.shop.ShopAnalytics.Action();
    }

    public static io.bloombox.schema.analytics.shop.ShopAnalytics.Action getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Action>
        PARSER = new com.google.protobuf.AbstractParser<Action>() {
      public Action parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Action(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Action> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Action> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.shop.ShopAnalytics.Action getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_shop_Impression_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_shop_Impression_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_shop_View_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_shop_View_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_shop_Action_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_shop_Action_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n&analytics/commerce/ShopAnalytics.proto" +
      "\022\036bloombox.schema.analytics.shop\032\026tempor" +
      "al/Instant.proto\"P\n\nImpression\022\020\n\010physic" +
      "al\030\001 \001(\010\0220\n\010occurred\030\002 \001(\0132\036.opencannabi" +
      "s.temporal.Instant\"_\n\004View\022\020\n\010physical\030\001" +
      " \001(\010\022\023\n\013interactive\030\002 \001(\010\0220\n\010occurred\030\003 " +
      "\001(\0132\036.opencannabis.temporal.Instant\"\206\001\n\006" +
      "Action\022\020\n\010physical\030\001 \001(\010\0228\n\004verb\030\002 \001(\0162*" +
      ".bloombox.schema.analytics.shop.ShopActi" +
      "on\0220\n\010occurred\030\004 \001(\0132\036.opencannabis.temp" +
      "oral.Instant*\230\001\n\nShopAction\022\n\n\006ENGAGE\020\000\022" +
      "\n\n\006ENROLL\020\n\022\014\n\010ACTIVATE\020\013\022\010\n\004JOIN\020\014\022\n\n\006V" +
      "ERIFY\020\r\022\013\n\007CHECKIN\020\016\022\017\n\013PREFERENCES\020\017\022\014\n" +
      "\010PURCHASE\020\020\022\t\n\005ORDER\020\021\022\n\n\006OPT_IN\020\024\022\013\n\007OP" +
      "T_OUT\020\025B<\n!io.bloombox.schema.analytics." +
      "shopB\rShopAnalyticsH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_shop_Impression_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_shop_Impression_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_shop_Impression_descriptor,
        new java.lang.String[] { "Physical", "Occurred", });
    internal_static_bloombox_schema_analytics_shop_View_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_shop_View_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_shop_View_descriptor,
        new java.lang.String[] { "Physical", "Interactive", "Occurred", });
    internal_static_bloombox_schema_analytics_shop_Action_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_shop_Action_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_shop_Action_descriptor,
        new java.lang.String[] { "Physical", "Verb", "Occurred", });
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
