/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/identity/UserAnalytics.proto

package io.bloombox.schema.analytics.user;

public final class UserAnalytics {
  private UserAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies actions that may be taken by a user. See also: `ShopAction`.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.identity.UserAction}
   */
  public enum UserAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The user engaged in some manner, either anonymously, or with an identified user key.
     * </pre>
     *
     * <code>ENGAGE = 0;</code>
     */
    ENGAGE(0),
    /**
     * <pre>
     * The user signed up for a fresh, completely-new Bloombox account.
     * </pre>
     *
     * <code>ENROLL = 10;</code>
     */
    ENROLL(10),
    /**
     * <pre>
     * The user activated a dormant or previously-created shadow account for themselves.
     * </pre>
     *
     * <code>ACTIVATE = 11;</code>
     */
    ACTIVATE(11),
    /**
     * <pre>
     * The user joined a particular partner location or organization.
     * </pre>
     *
     * <code>JOIN = 12;</code>
     */
    JOIN(12),
    /**
     * <pre>
     * The user verified an assertion of their identity or eligibility to purchase cannabis.
     * </pre>
     *
     * <code>VERIFY = 13;</code>
     */
    VERIFY(13),
    /**
     * <pre>
     * The user checked in at a physical or digital location.
     * </pre>
     *
     * <code>CHECKIN = 14;</code>
     */
    CHECKIN(14),
    /**
     * <pre>
     * The user adjusted their own preferences, w.r.t. a specific location, or globally.
     * </pre>
     *
     * <code>PREFERENCES = 15;</code>
     */
    PREFERENCES(15),
    /**
     * <pre>
     * The user made a purchase.
     * </pre>
     *
     * <code>PURCHASE = 16;</code>
     */
    PURCHASE(16),
    /**
     * <pre>
     * The user submitted an order for pickup or delivery.
     * </pre>
     *
     * <code>ORDER = 17;</code>
     */
    ORDER(17),
    /**
     * <pre>
     * The user opted-in globally to communications related to Bloombox, their account, and so on, whether physically or
     * digitally.
     * </pre>
     *
     * <code>OPT_IN = 18;</code>
     */
    OPT_IN(18),
    /**
     * <pre>
     * The user opted-out globally from communications related to Bloombox, their account, and so on, whether physically
     * or digitally.
     * </pre>
     *
     * <code>OPT_OUT = 19;</code>
     */
    OPT_OUT(19),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The user engaged in some manner, either anonymously, or with an identified user key.
     * </pre>
     *
     * <code>ENGAGE = 0;</code>
     */
    public static final int ENGAGE_VALUE = 0;
    /**
     * <pre>
     * The user signed up for a fresh, completely-new Bloombox account.
     * </pre>
     *
     * <code>ENROLL = 10;</code>
     */
    public static final int ENROLL_VALUE = 10;
    /**
     * <pre>
     * The user activated a dormant or previously-created shadow account for themselves.
     * </pre>
     *
     * <code>ACTIVATE = 11;</code>
     */
    public static final int ACTIVATE_VALUE = 11;
    /**
     * <pre>
     * The user joined a particular partner location or organization.
     * </pre>
     *
     * <code>JOIN = 12;</code>
     */
    public static final int JOIN_VALUE = 12;
    /**
     * <pre>
     * The user verified an assertion of their identity or eligibility to purchase cannabis.
     * </pre>
     *
     * <code>VERIFY = 13;</code>
     */
    public static final int VERIFY_VALUE = 13;
    /**
     * <pre>
     * The user checked in at a physical or digital location.
     * </pre>
     *
     * <code>CHECKIN = 14;</code>
     */
    public static final int CHECKIN_VALUE = 14;
    /**
     * <pre>
     * The user adjusted their own preferences, w.r.t. a specific location, or globally.
     * </pre>
     *
     * <code>PREFERENCES = 15;</code>
     */
    public static final int PREFERENCES_VALUE = 15;
    /**
     * <pre>
     * The user made a purchase.
     * </pre>
     *
     * <code>PURCHASE = 16;</code>
     */
    public static final int PURCHASE_VALUE = 16;
    /**
     * <pre>
     * The user submitted an order for pickup or delivery.
     * </pre>
     *
     * <code>ORDER = 17;</code>
     */
    public static final int ORDER_VALUE = 17;
    /**
     * <pre>
     * The user opted-in globally to communications related to Bloombox, their account, and so on, whether physically or
     * digitally.
     * </pre>
     *
     * <code>OPT_IN = 18;</code>
     */
    public static final int OPT_IN_VALUE = 18;
    /**
     * <pre>
     * The user opted-out globally from communications related to Bloombox, their account, and so on, whether physically
     * or digitally.
     * </pre>
     *
     * <code>OPT_OUT = 19;</code>
     */
    public static final int OPT_OUT_VALUE = 19;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UserAction valueOf(int value) {
      return forNumber(value);
    }

    public static UserAction forNumber(int value) {
      switch (value) {
        case 0: return ENGAGE;
        case 10: return ENROLL;
        case 11: return ACTIVATE;
        case 12: return JOIN;
        case 13: return VERIFY;
        case 14: return CHECKIN;
        case 15: return PREFERENCES;
        case 16: return PURCHASE;
        case 17: return ORDER;
        case 18: return OPT_IN;
        case 19: return OPT_OUT;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UserAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        UserAction> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<UserAction>() {
            public UserAction findValueByNumber(int number) {
              return UserAction.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.user.UserAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final UserAction[] VALUES = values();

    public static UserAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UserAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.identity.UserAction)
  }

  public interface ActionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.identity.Action)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * User identity being referenced.
     * </pre>
     *
     * <code>string identity = 1;</code>
     */
    java.lang.String getIdentity();
    /**
     * <pre>
     * User identity being referenced.
     * </pre>
     *
     * <code>string identity = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdentityBytes();

    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
     */
    int getVerbValue();
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
     */
    io.bloombox.schema.analytics.user.UserAnalytics.UserAction getVerb();

    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Specifies a user action event, wherein a user has taken some affirmative action related to themselves, their identity
   * with regards to a particular system, or their account or preferences.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.identity.Action}
   */
  public  static final class Action extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.identity.Action)
      ActionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Action.newBuilder() to construct.
    private Action(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Action() {
      identity_ = "";
      verb_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Action(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              identity_ = s;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              verb_ = rawValue;
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.analytics.user.UserAnalytics.internal_static_bloombox_schema_analytics_identity_Action_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.analytics.user.UserAnalytics.internal_static_bloombox_schema_analytics_identity_Action_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.analytics.user.UserAnalytics.Action.class, io.bloombox.schema.analytics.user.UserAnalytics.Action.Builder.class);
    }

    public static final int IDENTITY_FIELD_NUMBER = 1;
    private volatile java.lang.Object identity_;
    /**
     * <pre>
     * User identity being referenced.
     * </pre>
     *
     * <code>string identity = 1;</code>
     */
    public java.lang.String getIdentity() {
      java.lang.Object ref = identity_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        identity_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User identity being referenced.
     * </pre>
     *
     * <code>string identity = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdentityBytes() {
      java.lang.Object ref = identity_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        identity_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERB_FIELD_NUMBER = 2;
    private int verb_;
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
     */
    public int getVerbValue() {
      return verb_;
    }
    /**
     * <pre>
     * Action that was taken upon or regarding the order.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
     */
    public io.bloombox.schema.analytics.user.UserAnalytics.UserAction getVerb() {
      io.bloombox.schema.analytics.user.UserAnalytics.UserAction result = io.bloombox.schema.analytics.user.UserAnalytics.UserAction.valueOf(verb_);
      return result == null ? io.bloombox.schema.analytics.user.UserAnalytics.UserAction.UNRECOGNIZED : result;
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Specifies when this view event occurred.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdentityBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, identity_);
      }
      if (verb_ != io.bloombox.schema.analytics.user.UserAnalytics.UserAction.ENGAGE.getNumber()) {
        output.writeEnum(2, verb_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdentityBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, identity_);
      }
      if (verb_ != io.bloombox.schema.analytics.user.UserAnalytics.UserAction.ENGAGE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, verb_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.analytics.user.UserAnalytics.Action)) {
        return super.equals(obj);
      }
      io.bloombox.schema.analytics.user.UserAnalytics.Action other = (io.bloombox.schema.analytics.user.UserAnalytics.Action) obj;

      boolean result = true;
      result = result && getIdentity()
          .equals(other.getIdentity());
      result = result && verb_ == other.verb_;
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IDENTITY_FIELD_NUMBER;
      hash = (53 * hash) + getIdentity().hashCode();
      hash = (37 * hash) + VERB_FIELD_NUMBER;
      hash = (53 * hash) + verb_;
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.analytics.user.UserAnalytics.Action parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.analytics.user.UserAnalytics.Action prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a user action event, wherein a user has taken some affirmative action related to themselves, their identity
     * with regards to a particular system, or their account or preferences.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.identity.Action}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.identity.Action)
        io.bloombox.schema.analytics.user.UserAnalytics.ActionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.analytics.user.UserAnalytics.internal_static_bloombox_schema_analytics_identity_Action_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.analytics.user.UserAnalytics.internal_static_bloombox_schema_analytics_identity_Action_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.analytics.user.UserAnalytics.Action.class, io.bloombox.schema.analytics.user.UserAnalytics.Action.Builder.class);
      }

      // Construct using io.bloombox.schema.analytics.user.UserAnalytics.Action.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        identity_ = "";

        verb_ = 0;

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.analytics.user.UserAnalytics.internal_static_bloombox_schema_analytics_identity_Action_descriptor;
      }

      public io.bloombox.schema.analytics.user.UserAnalytics.Action getDefaultInstanceForType() {
        return io.bloombox.schema.analytics.user.UserAnalytics.Action.getDefaultInstance();
      }

      public io.bloombox.schema.analytics.user.UserAnalytics.Action build() {
        io.bloombox.schema.analytics.user.UserAnalytics.Action result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.analytics.user.UserAnalytics.Action buildPartial() {
        io.bloombox.schema.analytics.user.UserAnalytics.Action result = new io.bloombox.schema.analytics.user.UserAnalytics.Action(this);
        result.identity_ = identity_;
        result.verb_ = verb_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.analytics.user.UserAnalytics.Action) {
          return mergeFrom((io.bloombox.schema.analytics.user.UserAnalytics.Action)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.analytics.user.UserAnalytics.Action other) {
        if (other == io.bloombox.schema.analytics.user.UserAnalytics.Action.getDefaultInstance()) return this;
        if (!other.getIdentity().isEmpty()) {
          identity_ = other.identity_;
          onChanged();
        }
        if (other.verb_ != 0) {
          setVerbValue(other.getVerbValue());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.analytics.user.UserAnalytics.Action parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.analytics.user.UserAnalytics.Action) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object identity_ = "";
      /**
       * <pre>
       * User identity being referenced.
       * </pre>
       *
       * <code>string identity = 1;</code>
       */
      public java.lang.String getIdentity() {
        java.lang.Object ref = identity_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          identity_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User identity being referenced.
       * </pre>
       *
       * <code>string identity = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdentityBytes() {
        java.lang.Object ref = identity_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          identity_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User identity being referenced.
       * </pre>
       *
       * <code>string identity = 1;</code>
       */
      public Builder setIdentity(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        identity_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User identity being referenced.
       * </pre>
       *
       * <code>string identity = 1;</code>
       */
      public Builder clearIdentity() {
        
        identity_ = getDefaultInstance().getIdentity();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User identity being referenced.
       * </pre>
       *
       * <code>string identity = 1;</code>
       */
      public Builder setIdentityBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        identity_ = value;
        onChanged();
        return this;
      }

      private int verb_ = 0;
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
       */
      public int getVerbValue() {
        return verb_;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
       */
      public Builder setVerbValue(int value) {
        verb_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
       */
      public io.bloombox.schema.analytics.user.UserAnalytics.UserAction getVerb() {
        io.bloombox.schema.analytics.user.UserAnalytics.UserAction result = io.bloombox.schema.analytics.user.UserAnalytics.UserAction.valueOf(verb_);
        return result == null ? io.bloombox.schema.analytics.user.UserAnalytics.UserAction.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
       */
      public Builder setVerb(io.bloombox.schema.analytics.user.UserAnalytics.UserAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        verb_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Action that was taken upon or regarding the order.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.identity.UserAction verb = 2;</code>
       */
      public Builder clearVerb() {
        
        verb_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Specifies when this view event occurred.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.identity.Action)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.identity.Action)
    private static final io.bloombox.schema.analytics.user.UserAnalytics.Action DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.analytics.user.UserAnalytics.Action();
    }

    public static io.bloombox.schema.analytics.user.UserAnalytics.Action getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Action>
        PARSER = new com.google.protobuf.AbstractParser<Action>() {
      public Action parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Action(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Action> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Action> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.analytics.user.UserAnalytics.Action getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_identity_Action_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_identity_Action_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n&analytics/identity/UserAnalytics.proto" +
      "\022\"bloombox.schema.analytics.identity\032\026te" +
      "mporal/Instant.proto\"\212\001\n\006Action\022\020\n\010ident" +
      "ity\030\001 \001(\t\022<\n\004verb\030\002 \001(\0162..bloombox.schem" +
      "a.analytics.identity.UserAction\0220\n\010occur" +
      "red\030\003 \001(\0132\036.opencannabis.temporal.Instan" +
      "t*\230\001\n\nUserAction\022\n\n\006ENGAGE\020\000\022\n\n\006ENROLL\020\n" +
      "\022\014\n\010ACTIVATE\020\013\022\010\n\004JOIN\020\014\022\n\n\006VERIFY\020\r\022\013\n\007" +
      "CHECKIN\020\016\022\017\n\013PREFERENCES\020\017\022\014\n\010PURCHASE\020\020" +
      "\022\t\n\005ORDER\020\021\022\n\n\006OPT_IN\020\022\022\013\n\007OPT_OUT\020\023B<\n!" +
      "io.bloombox.schema.analytics.userB\rUserA" +
      "nalyticsH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_identity_Action_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_identity_Action_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_identity_Action_descriptor,
        new java.lang.String[] { "Identity", "Verb", "Occurred", });
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
