/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: commerce/pos/Purchase.proto

package io.bloombox.schema.commerce.pos;

public final class CommercialPurchase {
  private CommercialPurchase() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates statuses that a purchase transaction may take.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.commerce.pos.PurchaseStatus}
   */
  public enum PurchaseStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The purchase has been allocated and has not yet begun filling with data.
     * </pre>
     *
     * <code>DORMANT = 0;</code>
     */
    DORMANT(0),
    /**
     * <pre>
     * The purchase is actively being collaborated on.
     * </pre>
     *
     * <code>OPEN = 1;</code>
     */
    OPEN(1),
    /**
     * <pre>
     * The purchase was cancelled.
     * </pre>
     *
     * <code>VOIDED = 2;</code>
     */
    VOIDED(2),
    /**
     * <pre>
     * The purchase was completed and is now closed.
     * </pre>
     *
     * <code>CLOSED = 3;</code>
     */
    CLOSED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The purchase has been allocated and has not yet begun filling with data.
     * </pre>
     *
     * <code>DORMANT = 0;</code>
     */
    public static final int DORMANT_VALUE = 0;
    /**
     * <pre>
     * The purchase is actively being collaborated on.
     * </pre>
     *
     * <code>OPEN = 1;</code>
     */
    public static final int OPEN_VALUE = 1;
    /**
     * <pre>
     * The purchase was cancelled.
     * </pre>
     *
     * <code>VOIDED = 2;</code>
     */
    public static final int VOIDED_VALUE = 2;
    /**
     * <pre>
     * The purchase was completed and is now closed.
     * </pre>
     *
     * <code>CLOSED = 3;</code>
     */
    public static final int CLOSED_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PurchaseStatus valueOf(int value) {
      return forNumber(value);
    }

    public static PurchaseStatus forNumber(int value) {
      switch (value) {
        case 0: return DORMANT;
        case 1: return OPEN;
        case 2: return VOIDED;
        case 3: return CLOSED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PurchaseStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        PurchaseStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<PurchaseStatus>() {
            public PurchaseStatus findValueByNumber(int number) {
              return PurchaseStatus.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.getDescriptor().getEnumTypes().get(0);
    }

    private static final PurchaseStatus[] VALUES = values();

    public static PurchaseStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PurchaseStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.commerce.pos.PurchaseStatus)
  }

  public interface PurchaseEventOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.commerce.pos.PurchaseEvent)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Status the order moved to.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
     */
    int getStatusValue();
    /**
     * <pre>
     * Status the order moved to.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus();

    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    boolean hasInstant();
    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    io.opencannabis.schema.temporal.Instant getInstant();
    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getInstantOrBuilder();

    /**
     * <pre>
     * Message or reason given for this status change, if any.
     * </pre>
     *
     * <code>string message = 3;</code>
     */
    java.lang.String getMessage();
    /**
     * <pre>
     * Message or reason given for this status change, if any.
     * </pre>
     *
     * <code>string message = 3;</code>
     */
    com.google.protobuf.ByteString
        getMessageBytes();
  }
  /**
   * <pre>
   * Specifies an event that takes place against a Purchase.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.commerce.pos.PurchaseEvent}
   */
  public  static final class PurchaseEvent extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.commerce.pos.PurchaseEvent)
      PurchaseEventOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PurchaseEvent.newBuilder() to construct.
    private PurchaseEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PurchaseEvent() {
      status_ = 0;
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PurchaseEvent(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (instant_ != null) {
                subBuilder = instant_.toBuilder();
              }
              instant_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(instant_);
                instant_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              message_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_PurchaseEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.class, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder.class);
    }

    public static final int STATUS_FIELD_NUMBER = 1;
    private int status_;
    /**
     * <pre>
     * Status the order moved to.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Status the order moved to.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus() {
      io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus result = io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.valueOf(status_);
      return result == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.UNRECOGNIZED : result;
    }

    public static final int INSTANT_FIELD_NUMBER = 2;
    private io.opencannabis.schema.temporal.Instant instant_;
    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    public boolean hasInstant() {
      return instant_ != null;
    }
    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    public io.opencannabis.schema.temporal.Instant getInstant() {
      return instant_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : instant_;
    }
    /**
     * <pre>
     * Instant the order was moved to this status.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant instant = 2;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getInstantOrBuilder() {
      return getInstant();
    }

    public static final int MESSAGE_FIELD_NUMBER = 3;
    private volatile java.lang.Object message_;
    /**
     * <pre>
     * Message or reason given for this status change, if any.
     * </pre>
     *
     * <code>string message = 3;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Message or reason given for this status change, if any.
     * </pre>
     *
     * <code>string message = 3;</code>
     */
    public com.google.protobuf.ByteString
        getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (status_ != io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.DORMANT.getNumber()) {
        output.writeEnum(1, status_);
      }
      if (instant_ != null) {
        output.writeMessage(2, getInstant());
      }
      if (!getMessageBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, message_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (status_ != io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.DORMANT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, status_);
      }
      if (instant_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getInstant());
      }
      if (!getMessageBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, message_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent)) {
        return super.equals(obj);
      }
      io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent other = (io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent) obj;

      boolean result = true;
      result = result && status_ == other.status_;
      result = result && (hasInstant() == other.hasInstant());
      if (hasInstant()) {
        result = result && getInstant()
            .equals(other.getInstant());
      }
      result = result && getMessage()
          .equals(other.getMessage());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
      if (hasInstant()) {
        hash = (37 * hash) + INSTANT_FIELD_NUMBER;
        hash = (53 * hash) + getInstant().hashCode();
      }
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an event that takes place against a Purchase.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.commerce.pos.PurchaseEvent}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.commerce.pos.PurchaseEvent)
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_PurchaseEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.class, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder.class);
      }

      // Construct using io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        status_ = 0;

        if (instantBuilder_ == null) {
          instant_ = null;
        } else {
          instant_ = null;
          instantBuilder_ = null;
        }
        message_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getDefaultInstanceForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.getDefaultInstance();
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent build() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent buildPartial() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent result = new io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent(this);
        result.status_ = status_;
        if (instantBuilder_ == null) {
          result.instant_ = instant_;
        } else {
          result.instant_ = instantBuilder_.build();
        }
        result.message_ = message_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent) {
          return mergeFrom((io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent other) {
        if (other == io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.getDefaultInstance()) return this;
        if (other.status_ != 0) {
          setStatusValue(other.getStatusValue());
        }
        if (other.hasInstant()) {
          mergeInstant(other.getInstant());
        }
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int status_ = 0;
      /**
       * <pre>
       * Status the order moved to.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
       */
      public int getStatusValue() {
        return status_;
      }
      /**
       * <pre>
       * Status the order moved to.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
       */
      public Builder setStatusValue(int value) {
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status the order moved to.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus result = io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.valueOf(status_);
        return result == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Status the order moved to.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
       */
      public Builder setStatus(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status the order moved to.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 1;</code>
       */
      public Builder clearStatus() {
        
        status_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant instant_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> instantBuilder_;
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public boolean hasInstant() {
        return instantBuilder_ != null || instant_ != null;
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant getInstant() {
        if (instantBuilder_ == null) {
          return instant_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : instant_;
        } else {
          return instantBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public Builder setInstant(io.opencannabis.schema.temporal.Instant value) {
        if (instantBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          instant_ = value;
          onChanged();
        } else {
          instantBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public Builder setInstant(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (instantBuilder_ == null) {
          instant_ = builderForValue.build();
          onChanged();
        } else {
          instantBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public Builder mergeInstant(io.opencannabis.schema.temporal.Instant value) {
        if (instantBuilder_ == null) {
          if (instant_ != null) {
            instant_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(instant_).mergeFrom(value).buildPartial();
          } else {
            instant_ = value;
          }
          onChanged();
        } else {
          instantBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public Builder clearInstant() {
        if (instantBuilder_ == null) {
          instant_ = null;
          onChanged();
        } else {
          instant_ = null;
          instantBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getInstantBuilder() {
        
        onChanged();
        return getInstantFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getInstantOrBuilder() {
        if (instantBuilder_ != null) {
          return instantBuilder_.getMessageOrBuilder();
        } else {
          return instant_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : instant_;
        }
      }
      /**
       * <pre>
       * Instant the order was moved to this status.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant instant = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getInstantFieldBuilder() {
        if (instantBuilder_ == null) {
          instantBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getInstant(),
                  getParentForChildren(),
                  isClean());
          instant_ = null;
        }
        return instantBuilder_;
      }

      private java.lang.Object message_ = "";
      /**
       * <pre>
       * Message or reason given for this status change, if any.
       * </pre>
       *
       * <code>string message = 3;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Message or reason given for this status change, if any.
       * </pre>
       *
       * <code>string message = 3;</code>
       */
      public com.google.protobuf.ByteString
          getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Message or reason given for this status change, if any.
       * </pre>
       *
       * <code>string message = 3;</code>
       */
      public Builder setMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        message_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Message or reason given for this status change, if any.
       * </pre>
       *
       * <code>string message = 3;</code>
       */
      public Builder clearMessage() {
        
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Message or reason given for this status change, if any.
       * </pre>
       *
       * <code>string message = 3;</code>
       */
      public Builder setMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        message_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.commerce.pos.PurchaseEvent)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.commerce.pos.PurchaseEvent)
    private static final io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent();
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PurchaseEvent>
        PARSER = new com.google.protobuf.AbstractParser<PurchaseEvent>() {
      public PurchaseEvent parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PurchaseEvent(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<PurchaseEvent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PurchaseEvent> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ReceiptOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.commerce.pos.Receipt)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Calculated subtotal of all items, and their ordered quantities, summed of price.
     * </pre>
     *
     * <code>double subtotal = 1;</code>
     */
    double getSubtotal();

    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax> 
        getTaxList();
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.Tax getTax(int index);
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    int getTaxCount();
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    java.util.List<? extends io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder> 
        getTaxOrBuilderList();
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder getTaxOrBuilder(
        int index);

    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount> 
        getDiscountList();
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDiscount(int index);
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    int getDiscountCount();
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    java.util.List<? extends io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder> 
        getDiscountOrBuilderList();
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder getDiscountOrBuilder(
        int index);

    /**
     * <pre>
     * Calculated full total.
     * </pre>
     *
     * <code>double total = 4;</code>
     */
    double getTotal();
  }
  /**
   * <pre>
   * Receipt object describing each of a purchase's component taxes and charges.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.commerce.pos.Receipt}
   */
  public  static final class Receipt extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.commerce.pos.Receipt)
      ReceiptOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Receipt.newBuilder() to construct.
    private Receipt(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Receipt() {
      subtotal_ = 0D;
      tax_ = java.util.Collections.emptyList();
      discount_ = java.util.Collections.emptyList();
      total_ = 0D;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Receipt(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 9: {

              subtotal_ = input.readDouble();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                tax_ = new java.util.ArrayList<io.opencannabis.schema.accounting.AccountingTaxes.Tax>();
                mutable_bitField0_ |= 0x00000002;
              }
              tax_.add(
                  input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.Tax.parser(), extensionRegistry));
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                discount_ = new java.util.ArrayList<io.opencannabis.schema.accounting.CommercialDiscounts.Discount>();
                mutable_bitField0_ |= 0x00000004;
              }
              discount_.add(
                  input.readMessage(io.opencannabis.schema.accounting.CommercialDiscounts.Discount.parser(), extensionRegistry));
              break;
            }
            case 33: {

              total_ = input.readDouble();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          tax_ = java.util.Collections.unmodifiableList(tax_);
        }
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          discount_ = java.util.Collections.unmodifiableList(discount_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Receipt_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Receipt_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.class, io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder.class);
    }

    private int bitField0_;
    public static final int SUBTOTAL_FIELD_NUMBER = 1;
    private double subtotal_;
    /**
     * <pre>
     * Calculated subtotal of all items, and their ordered quantities, summed of price.
     * </pre>
     *
     * <code>double subtotal = 1;</code>
     */
    public double getSubtotal() {
      return subtotal_;
    }

    public static final int TAX_FIELD_NUMBER = 2;
    private java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax> tax_;
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    public java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax> getTaxList() {
      return tax_;
    }
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder> 
        getTaxOrBuilderList() {
      return tax_;
    }
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    public int getTaxCount() {
      return tax_.size();
    }
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.Tax getTax(int index) {
      return tax_.get(index);
    }
    /**
     * <pre>
     * Tax entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder getTaxOrBuilder(
        int index) {
      return tax_.get(index);
    }

    public static final int DISCOUNT_FIELD_NUMBER = 3;
    private java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount> discount_;
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount> getDiscountList() {
      return discount_;
    }
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder> 
        getDiscountOrBuilderList() {
      return discount_;
    }
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    public int getDiscountCount() {
      return discount_.size();
    }
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDiscount(int index) {
      return discount_.get(index);
    }
    /**
     * <pre>
     * Discount entries applied to this receipt.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder getDiscountOrBuilder(
        int index) {
      return discount_.get(index);
    }

    public static final int TOTAL_FIELD_NUMBER = 4;
    private double total_;
    /**
     * <pre>
     * Calculated full total.
     * </pre>
     *
     * <code>double total = 4;</code>
     */
    public double getTotal() {
      return total_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (subtotal_ != 0D) {
        output.writeDouble(1, subtotal_);
      }
      for (int i = 0; i < tax_.size(); i++) {
        output.writeMessage(2, tax_.get(i));
      }
      for (int i = 0; i < discount_.size(); i++) {
        output.writeMessage(3, discount_.get(i));
      }
      if (total_ != 0D) {
        output.writeDouble(4, total_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (subtotal_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(1, subtotal_);
      }
      for (int i = 0; i < tax_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, tax_.get(i));
      }
      for (int i = 0; i < discount_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, discount_.get(i));
      }
      if (total_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(4, total_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt)) {
        return super.equals(obj);
      }
      io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt other = (io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt) obj;

      boolean result = true;
      result = result && (
          java.lang.Double.doubleToLongBits(getSubtotal())
          == java.lang.Double.doubleToLongBits(
              other.getSubtotal()));
      result = result && getTaxList()
          .equals(other.getTaxList());
      result = result && getDiscountList()
          .equals(other.getDiscountList());
      result = result && (
          java.lang.Double.doubleToLongBits(getTotal())
          == java.lang.Double.doubleToLongBits(
              other.getTotal()));
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUBTOTAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getSubtotal()));
      if (getTaxCount() > 0) {
        hash = (37 * hash) + TAX_FIELD_NUMBER;
        hash = (53 * hash) + getTaxList().hashCode();
      }
      if (getDiscountCount() > 0) {
        hash = (37 * hash) + DISCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getDiscountList().hashCode();
      }
      hash = (37 * hash) + TOTAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          java.lang.Double.doubleToLongBits(getTotal()));
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Receipt object describing each of a purchase's component taxes and charges.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.commerce.pos.Receipt}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.commerce.pos.Receipt)
        io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Receipt_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Receipt_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.class, io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder.class);
      }

      // Construct using io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTaxFieldBuilder();
          getDiscountFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        subtotal_ = 0D;

        if (taxBuilder_ == null) {
          tax_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          taxBuilder_.clear();
        }
        if (discountBuilder_ == null) {
          discount_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          discountBuilder_.clear();
        }
        total_ = 0D;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Receipt_descriptor;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getDefaultInstanceForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.getDefaultInstance();
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt build() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt buildPartial() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt result = new io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.subtotal_ = subtotal_;
        if (taxBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            tax_ = java.util.Collections.unmodifiableList(tax_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.tax_ = tax_;
        } else {
          result.tax_ = taxBuilder_.build();
        }
        if (discountBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            discount_ = java.util.Collections.unmodifiableList(discount_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.discount_ = discount_;
        } else {
          result.discount_ = discountBuilder_.build();
        }
        result.total_ = total_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt) {
          return mergeFrom((io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt other) {
        if (other == io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.getDefaultInstance()) return this;
        if (other.getSubtotal() != 0D) {
          setSubtotal(other.getSubtotal());
        }
        if (taxBuilder_ == null) {
          if (!other.tax_.isEmpty()) {
            if (tax_.isEmpty()) {
              tax_ = other.tax_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureTaxIsMutable();
              tax_.addAll(other.tax_);
            }
            onChanged();
          }
        } else {
          if (!other.tax_.isEmpty()) {
            if (taxBuilder_.isEmpty()) {
              taxBuilder_.dispose();
              taxBuilder_ = null;
              tax_ = other.tax_;
              bitField0_ = (bitField0_ & ~0x00000002);
              taxBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTaxFieldBuilder() : null;
            } else {
              taxBuilder_.addAllMessages(other.tax_);
            }
          }
        }
        if (discountBuilder_ == null) {
          if (!other.discount_.isEmpty()) {
            if (discount_.isEmpty()) {
              discount_ = other.discount_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureDiscountIsMutable();
              discount_.addAll(other.discount_);
            }
            onChanged();
          }
        } else {
          if (!other.discount_.isEmpty()) {
            if (discountBuilder_.isEmpty()) {
              discountBuilder_.dispose();
              discountBuilder_ = null;
              discount_ = other.discount_;
              bitField0_ = (bitField0_ & ~0x00000004);
              discountBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getDiscountFieldBuilder() : null;
            } else {
              discountBuilder_.addAllMessages(other.discount_);
            }
          }
        }
        if (other.getTotal() != 0D) {
          setTotal(other.getTotal());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private double subtotal_ ;
      /**
       * <pre>
       * Calculated subtotal of all items, and their ordered quantities, summed of price.
       * </pre>
       *
       * <code>double subtotal = 1;</code>
       */
      public double getSubtotal() {
        return subtotal_;
      }
      /**
       * <pre>
       * Calculated subtotal of all items, and their ordered quantities, summed of price.
       * </pre>
       *
       * <code>double subtotal = 1;</code>
       */
      public Builder setSubtotal(double value) {
        
        subtotal_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Calculated subtotal of all items, and their ordered quantities, summed of price.
       * </pre>
       *
       * <code>double subtotal = 1;</code>
       */
      public Builder clearSubtotal() {
        
        subtotal_ = 0D;
        onChanged();
        return this;
      }

      private java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax> tax_ =
        java.util.Collections.emptyList();
      private void ensureTaxIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          tax_ = new java.util.ArrayList<io.opencannabis.schema.accounting.AccountingTaxes.Tax>(tax_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.Tax, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder> taxBuilder_;

      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax> getTaxList() {
        if (taxBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tax_);
        } else {
          return taxBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public int getTaxCount() {
        if (taxBuilder_ == null) {
          return tax_.size();
        } else {
          return taxBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.Tax getTax(int index) {
        if (taxBuilder_ == null) {
          return tax_.get(index);
        } else {
          return taxBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder setTax(
          int index, io.opencannabis.schema.accounting.AccountingTaxes.Tax value) {
        if (taxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTaxIsMutable();
          tax_.set(index, value);
          onChanged();
        } else {
          taxBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder setTax(
          int index, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder builderForValue) {
        if (taxBuilder_ == null) {
          ensureTaxIsMutable();
          tax_.set(index, builderForValue.build());
          onChanged();
        } else {
          taxBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder addTax(io.opencannabis.schema.accounting.AccountingTaxes.Tax value) {
        if (taxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTaxIsMutable();
          tax_.add(value);
          onChanged();
        } else {
          taxBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder addTax(
          int index, io.opencannabis.schema.accounting.AccountingTaxes.Tax value) {
        if (taxBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTaxIsMutable();
          tax_.add(index, value);
          onChanged();
        } else {
          taxBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder addTax(
          io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder builderForValue) {
        if (taxBuilder_ == null) {
          ensureTaxIsMutable();
          tax_.add(builderForValue.build());
          onChanged();
        } else {
          taxBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder addTax(
          int index, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder builderForValue) {
        if (taxBuilder_ == null) {
          ensureTaxIsMutable();
          tax_.add(index, builderForValue.build());
          onChanged();
        } else {
          taxBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder addAllTax(
          java.lang.Iterable<? extends io.opencannabis.schema.accounting.AccountingTaxes.Tax> values) {
        if (taxBuilder_ == null) {
          ensureTaxIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tax_);
          onChanged();
        } else {
          taxBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder clearTax() {
        if (taxBuilder_ == null) {
          tax_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          taxBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public Builder removeTax(int index) {
        if (taxBuilder_ == null) {
          ensureTaxIsMutable();
          tax_.remove(index);
          onChanged();
        } else {
          taxBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder getTaxBuilder(
          int index) {
        return getTaxFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder getTaxOrBuilder(
          int index) {
        if (taxBuilder_ == null) {
          return tax_.get(index);  } else {
          return taxBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder> 
           getTaxOrBuilderList() {
        if (taxBuilder_ != null) {
          return taxBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tax_);
        }
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder addTaxBuilder() {
        return getTaxFieldBuilder().addBuilder(
            io.opencannabis.schema.accounting.AccountingTaxes.Tax.getDefaultInstance());
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder addTaxBuilder(
          int index) {
        return getTaxFieldBuilder().addBuilder(
            index, io.opencannabis.schema.accounting.AccountingTaxes.Tax.getDefaultInstance());
      }
      /**
       * <pre>
       * Tax entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.taxes.Tax tax = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder> 
           getTaxBuilderList() {
        return getTaxFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.Tax, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder> 
          getTaxFieldBuilder() {
        if (taxBuilder_ == null) {
          taxBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.Tax, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder>(
                  tax_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          tax_ = null;
        }
        return taxBuilder_;
      }

      private java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount> discount_ =
        java.util.Collections.emptyList();
      private void ensureDiscountIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          discount_ = new java.util.ArrayList<io.opencannabis.schema.accounting.CommercialDiscounts.Discount>(discount_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.accounting.CommercialDiscounts.Discount, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder> discountBuilder_;

      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount> getDiscountList() {
        if (discountBuilder_ == null) {
          return java.util.Collections.unmodifiableList(discount_);
        } else {
          return discountBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public int getDiscountCount() {
        if (discountBuilder_ == null) {
          return discount_.size();
        } else {
          return discountBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDiscount(int index) {
        if (discountBuilder_ == null) {
          return discount_.get(index);
        } else {
          return discountBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder setDiscount(
          int index, io.opencannabis.schema.accounting.CommercialDiscounts.Discount value) {
        if (discountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDiscountIsMutable();
          discount_.set(index, value);
          onChanged();
        } else {
          discountBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder setDiscount(
          int index, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder builderForValue) {
        if (discountBuilder_ == null) {
          ensureDiscountIsMutable();
          discount_.set(index, builderForValue.build());
          onChanged();
        } else {
          discountBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder addDiscount(io.opencannabis.schema.accounting.CommercialDiscounts.Discount value) {
        if (discountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDiscountIsMutable();
          discount_.add(value);
          onChanged();
        } else {
          discountBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder addDiscount(
          int index, io.opencannabis.schema.accounting.CommercialDiscounts.Discount value) {
        if (discountBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDiscountIsMutable();
          discount_.add(index, value);
          onChanged();
        } else {
          discountBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder addDiscount(
          io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder builderForValue) {
        if (discountBuilder_ == null) {
          ensureDiscountIsMutable();
          discount_.add(builderForValue.build());
          onChanged();
        } else {
          discountBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder addDiscount(
          int index, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder builderForValue) {
        if (discountBuilder_ == null) {
          ensureDiscountIsMutable();
          discount_.add(index, builderForValue.build());
          onChanged();
        } else {
          discountBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder addAllDiscount(
          java.lang.Iterable<? extends io.opencannabis.schema.accounting.CommercialDiscounts.Discount> values) {
        if (discountBuilder_ == null) {
          ensureDiscountIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, discount_);
          onChanged();
        } else {
          discountBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder clearDiscount() {
        if (discountBuilder_ == null) {
          discount_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          discountBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public Builder removeDiscount(int index) {
        if (discountBuilder_ == null) {
          ensureDiscountIsMutable();
          discount_.remove(index);
          onChanged();
        } else {
          discountBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder getDiscountBuilder(
          int index) {
        return getDiscountFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder getDiscountOrBuilder(
          int index) {
        if (discountBuilder_ == null) {
          return discount_.get(index);  } else {
          return discountBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder> 
           getDiscountOrBuilderList() {
        if (discountBuilder_ != null) {
          return discountBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(discount_);
        }
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder addDiscountBuilder() {
        return getDiscountFieldBuilder().addBuilder(
            io.opencannabis.schema.accounting.CommercialDiscounts.Discount.getDefaultInstance());
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder addDiscountBuilder(
          int index) {
        return getDiscountFieldBuilder().addBuilder(
            index, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.getDefaultInstance());
      }
      /**
       * <pre>
       * Discount entries applied to this receipt.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Discount discount = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder> 
           getDiscountBuilderList() {
        return getDiscountFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.accounting.CommercialDiscounts.Discount, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder> 
          getDiscountFieldBuilder() {
        if (discountBuilder_ == null) {
          discountBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.accounting.CommercialDiscounts.Discount, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder>(
                  discount_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          discount_ = null;
        }
        return discountBuilder_;
      }

      private double total_ ;
      /**
       * <pre>
       * Calculated full total.
       * </pre>
       *
       * <code>double total = 4;</code>
       */
      public double getTotal() {
        return total_;
      }
      /**
       * <pre>
       * Calculated full total.
       * </pre>
       *
       * <code>double total = 4;</code>
       */
      public Builder setTotal(double value) {
        
        total_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Calculated full total.
       * </pre>
       *
       * <code>double total = 4;</code>
       */
      public Builder clearTotal() {
        
        total_ = 0D;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.commerce.pos.Receipt)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.commerce.pos.Receipt)
    private static final io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt();
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Receipt>
        PARSER = new com.google.protobuf.AbstractParser<Receipt>() {
      public Receipt parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Receipt(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Receipt> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Receipt> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PurchaseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.commerce.pos.Purchase)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID assigned to the purchase by the server.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID assigned to the purchase by the server.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Partner ID for the purchase.
     * </pre>
     *
     * <code>string partner_code = 2;</code>
     */
    java.lang.String getPartnerCode();
    /**
     * <pre>
     * Partner ID for the purchase.
     * </pre>
     *
     * <code>string partner_code = 2;</code>
     */
    com.google.protobuf.ByteString
        getPartnerCodeBytes();

    /**
     * <pre>
     * Location ID for the purchase.
     * </pre>
     *
     * <code>string location_code = 3;</code>
     */
    java.lang.String getLocationCode();
    /**
     * <pre>
     * Location ID for the purchase.
     * </pre>
     *
     * <code>string location_code = 3;</code>
     */
    com.google.protobuf.ByteString
        getLocationCodeBytes();

    /**
     * <pre>
     * Current status of this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
     */
    int getStatusValue();
    /**
     * <pre>
     * Current status of this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus();

    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    boolean hasCustomer();
    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer();
    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder();

    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    boolean hasRegister();
    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    io.bloombox.schema.partner.PartnerDeviceKey getRegister();
    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder getRegisterOrBuilder();

    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    java.util.List<io.opencannabis.schema.commerce.OrderItem.Item> 
        getItemList();
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    io.opencannabis.schema.commerce.OrderItem.Item getItem(int index);
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    int getItemCount();
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder> 
        getItemOrBuilderList();
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder getItemOrBuilder(
        int index);

    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    boolean hasReceipt();
    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getReceipt();
    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder getReceiptOrBuilder();

    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> 
        getActionLogList();
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getActionLog(int index);
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    int getActionLogCount();
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    java.util.List<? extends io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder> 
        getActionLogOrBuilderList();
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder getActionLogOrBuilder(
        int index);

    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    boolean hasCreatedAt();
    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    io.opencannabis.schema.temporal.Instant getCreatedAt();
    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder();
  }
  /**
   * <pre>
   * Represents a commercial purchase, made at a point-of-sale station at a brick-and-mortar
   * retail dispensary.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.commerce.pos.Purchase}
   */
  public  static final class Purchase extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.commerce.pos.Purchase)
      PurchaseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Purchase.newBuilder() to construct.
    private Purchase(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Purchase() {
      id_ = "";
      partnerCode_ = "";
      locationCode_ = "";
      status_ = 0;
      item_ = java.util.Collections.emptyList();
      actionLog_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Purchase(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              partnerCode_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              locationCode_ = s;
              break;
            }
            case 32: {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
            case 42: {
              io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder subBuilder = null;
              if (customer_ != null) {
                subBuilder = customer_.toBuilder();
              }
              customer_ = input.readMessage(io.opencannabis.schema.commerce.OrderCustomer.Customer.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(customer_);
                customer_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              io.bloombox.schema.partner.PartnerDeviceKey.Builder subBuilder = null;
              if (register_ != null) {
                subBuilder = register_.toBuilder();
              }
              register_ = input.readMessage(io.bloombox.schema.partner.PartnerDeviceKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(register_);
                register_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                item_ = new java.util.ArrayList<io.opencannabis.schema.commerce.OrderItem.Item>();
                mutable_bitField0_ |= 0x00000040;
              }
              item_.add(
                  input.readMessage(io.opencannabis.schema.commerce.OrderItem.Item.parser(), extensionRegistry));
              break;
            }
            case 66: {
              io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder subBuilder = null;
              if (receipt_ != null) {
                subBuilder = receipt_.toBuilder();
              }
              receipt_ = input.readMessage(io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(receipt_);
                receipt_ = subBuilder.buildPartial();
              }

              break;
            }
            case 74: {
              if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
                actionLog_ = new java.util.ArrayList<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent>();
                mutable_bitField0_ |= 0x00000100;
              }
              actionLog_.add(
                  input.readMessage(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.parser(), extensionRegistry));
              break;
            }
            case 82: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (createdAt_ != null) {
                subBuilder = createdAt_.toBuilder();
              }
              createdAt_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createdAt_);
                createdAt_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          item_ = java.util.Collections.unmodifiableList(item_);
        }
        if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
          actionLog_ = java.util.Collections.unmodifiableList(actionLog_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Purchase_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Purchase_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.class, io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID assigned to the purchase by the server.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID assigned to the purchase by the server.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTNER_CODE_FIELD_NUMBER = 2;
    private volatile java.lang.Object partnerCode_;
    /**
     * <pre>
     * Partner ID for the purchase.
     * </pre>
     *
     * <code>string partner_code = 2;</code>
     */
    public java.lang.String getPartnerCode() {
      java.lang.Object ref = partnerCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partnerCode_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partner ID for the purchase.
     * </pre>
     *
     * <code>string partner_code = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPartnerCodeBytes() {
      java.lang.Object ref = partnerCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partnerCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_CODE_FIELD_NUMBER = 3;
    private volatile java.lang.Object locationCode_;
    /**
     * <pre>
     * Location ID for the purchase.
     * </pre>
     *
     * <code>string location_code = 3;</code>
     */
    public java.lang.String getLocationCode() {
      java.lang.Object ref = locationCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationCode_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Location ID for the purchase.
     * </pre>
     *
     * <code>string location_code = 3;</code>
     */
    public com.google.protobuf.ByteString
        getLocationCodeBytes() {
      java.lang.Object ref = locationCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        locationCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 4;
    private int status_;
    /**
     * <pre>
     * Current status of this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Current status of this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus() {
      io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus result = io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.valueOf(status_);
      return result == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.UNRECOGNIZED : result;
    }

    public static final int CUSTOMER_FIELD_NUMBER = 5;
    private io.opencannabis.schema.commerce.OrderCustomer.Customer customer_;
    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    public boolean hasCustomer() {
      return customer_ != null;
    }
    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    public io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer() {
      return customer_ == null ? io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
    }
    /**
     * <pre>
     * Customer that submitted this purchase.
     * </pre>
     *
     * <code>.opencannabis.commerce.Customer customer = 5;</code>
     */
    public io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder() {
      return getCustomer();
    }

    public static final int REGISTER_FIELD_NUMBER = 6;
    private io.bloombox.schema.partner.PartnerDeviceKey register_;
    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    public boolean hasRegister() {
      return register_ != null;
    }
    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    public io.bloombox.schema.partner.PartnerDeviceKey getRegister() {
      return register_ == null ? io.bloombox.schema.partner.PartnerDeviceKey.getDefaultInstance() : register_;
    }
    /**
     * <pre>
     * Point-of-Sale device that submitted this purchase.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
     */
    public io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder getRegisterOrBuilder() {
      return getRegister();
    }

    public static final int ITEM_FIELD_NUMBER = 7;
    private java.util.List<io.opencannabis.schema.commerce.OrderItem.Item> item_;
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    public java.util.List<io.opencannabis.schema.commerce.OrderItem.Item> getItemList() {
      return item_;
    }
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder> 
        getItemOrBuilderList() {
      return item_;
    }
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    public int getItemCount() {
      return item_.size();
    }
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    public io.opencannabis.schema.commerce.OrderItem.Item getItem(int index) {
      return item_.get(index);
    }
    /**
     * <pre>
     * Items being ordered.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.Item item = 7;</code>
     */
    public io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder getItemOrBuilder(
        int index) {
      return item_.get(index);
    }

    public static final int RECEIPT_FIELD_NUMBER = 8;
    private io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt receipt_;
    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    public boolean hasReceipt() {
      return receipt_ != null;
    }
    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getReceipt() {
      return receipt_ == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.getDefaultInstance() : receipt_;
    }
    /**
     * <pre>
     * Calculated order values and components, like taxes, subtotal, and so on.
     * </pre>
     *
     * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder getReceiptOrBuilder() {
      return getReceipt();
    }

    public static final int ACTION_LOG_FIELD_NUMBER = 9;
    private java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> actionLog_;
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    public java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> getActionLogList() {
      return actionLog_;
    }
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    public java.util.List<? extends io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder> 
        getActionLogOrBuilderList() {
      return actionLog_;
    }
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    public int getActionLogCount() {
      return actionLog_.size();
    }
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getActionLog(int index) {
      return actionLog_.get(index);
    }
    /**
     * <pre>
     * Actions taken on this order.
     * </pre>
     *
     * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
     */
    public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder getActionLogOrBuilder(
        int index) {
      return actionLog_.get(index);
    }

    public static final int CREATED_AT_FIELD_NUMBER = 10;
    private io.opencannabis.schema.temporal.Instant createdAt_;
    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    public boolean hasCreatedAt() {
      return createdAt_ != null;
    }
    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    public io.opencannabis.schema.temporal.Instant getCreatedAt() {
      return createdAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
    }
    /**
     * <pre>
     * When this order was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 10;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder() {
      return getCreatedAt();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!getPartnerCodeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, partnerCode_);
      }
      if (!getLocationCodeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, locationCode_);
      }
      if (status_ != io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.DORMANT.getNumber()) {
        output.writeEnum(4, status_);
      }
      if (customer_ != null) {
        output.writeMessage(5, getCustomer());
      }
      if (register_ != null) {
        output.writeMessage(6, getRegister());
      }
      for (int i = 0; i < item_.size(); i++) {
        output.writeMessage(7, item_.get(i));
      }
      if (receipt_ != null) {
        output.writeMessage(8, getReceipt());
      }
      for (int i = 0; i < actionLog_.size(); i++) {
        output.writeMessage(9, actionLog_.get(i));
      }
      if (createdAt_ != null) {
        output.writeMessage(10, getCreatedAt());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!getPartnerCodeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, partnerCode_);
      }
      if (!getLocationCodeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, locationCode_);
      }
      if (status_ != io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.DORMANT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, status_);
      }
      if (customer_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getCustomer());
      }
      if (register_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getRegister());
      }
      for (int i = 0; i < item_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, item_.get(i));
      }
      if (receipt_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getReceipt());
      }
      for (int i = 0; i < actionLog_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, actionLog_.get(i));
      }
      if (createdAt_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getCreatedAt());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase)) {
        return super.equals(obj);
      }
      io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase other = (io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && getPartnerCode()
          .equals(other.getPartnerCode());
      result = result && getLocationCode()
          .equals(other.getLocationCode());
      result = result && status_ == other.status_;
      result = result && (hasCustomer() == other.hasCustomer());
      if (hasCustomer()) {
        result = result && getCustomer()
            .equals(other.getCustomer());
      }
      result = result && (hasRegister() == other.hasRegister());
      if (hasRegister()) {
        result = result && getRegister()
            .equals(other.getRegister());
      }
      result = result && getItemList()
          .equals(other.getItemList());
      result = result && (hasReceipt() == other.hasReceipt());
      if (hasReceipt()) {
        result = result && getReceipt()
            .equals(other.getReceipt());
      }
      result = result && getActionLogList()
          .equals(other.getActionLogList());
      result = result && (hasCreatedAt() == other.hasCreatedAt());
      if (hasCreatedAt()) {
        result = result && getCreatedAt()
            .equals(other.getCreatedAt());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + PARTNER_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getPartnerCode().hashCode();
      hash = (37 * hash) + LOCATION_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getLocationCode().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
      if (hasCustomer()) {
        hash = (37 * hash) + CUSTOMER_FIELD_NUMBER;
        hash = (53 * hash) + getCustomer().hashCode();
      }
      if (hasRegister()) {
        hash = (37 * hash) + REGISTER_FIELD_NUMBER;
        hash = (53 * hash) + getRegister().hashCode();
      }
      if (getItemCount() > 0) {
        hash = (37 * hash) + ITEM_FIELD_NUMBER;
        hash = (53 * hash) + getItemList().hashCode();
      }
      if (hasReceipt()) {
        hash = (37 * hash) + RECEIPT_FIELD_NUMBER;
        hash = (53 * hash) + getReceipt().hashCode();
      }
      if (getActionLogCount() > 0) {
        hash = (37 * hash) + ACTION_LOG_FIELD_NUMBER;
        hash = (53 * hash) + getActionLogList().hashCode();
      }
      if (hasCreatedAt()) {
        hash = (37 * hash) + CREATED_AT_FIELD_NUMBER;
        hash = (53 * hash) + getCreatedAt().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Represents a commercial purchase, made at a point-of-sale station at a brick-and-mortar
     * retail dispensary.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.commerce.pos.Purchase}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.commerce.pos.Purchase)
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Purchase_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Purchase_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.class, io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.Builder.class);
      }

      // Construct using io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getItemFieldBuilder();
          getActionLogFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        partnerCode_ = "";

        locationCode_ = "";

        status_ = 0;

        if (customerBuilder_ == null) {
          customer_ = null;
        } else {
          customer_ = null;
          customerBuilder_ = null;
        }
        if (registerBuilder_ == null) {
          register_ = null;
        } else {
          register_ = null;
          registerBuilder_ = null;
        }
        if (itemBuilder_ == null) {
          item_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          itemBuilder_.clear();
        }
        if (receiptBuilder_ == null) {
          receipt_ = null;
        } else {
          receipt_ = null;
          receiptBuilder_ = null;
        }
        if (actionLogBuilder_ == null) {
          actionLog_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          actionLogBuilder_.clear();
        }
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.internal_static_bloombox_schema_commerce_pos_Purchase_descriptor;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase getDefaultInstanceForType() {
        return io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.getDefaultInstance();
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase build() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase buildPartial() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase result = new io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        result.partnerCode_ = partnerCode_;
        result.locationCode_ = locationCode_;
        result.status_ = status_;
        if (customerBuilder_ == null) {
          result.customer_ = customer_;
        } else {
          result.customer_ = customerBuilder_.build();
        }
        if (registerBuilder_ == null) {
          result.register_ = register_;
        } else {
          result.register_ = registerBuilder_.build();
        }
        if (itemBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            item_ = java.util.Collections.unmodifiableList(item_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.item_ = item_;
        } else {
          result.item_ = itemBuilder_.build();
        }
        if (receiptBuilder_ == null) {
          result.receipt_ = receipt_;
        } else {
          result.receipt_ = receiptBuilder_.build();
        }
        if (actionLogBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100)) {
            actionLog_ = java.util.Collections.unmodifiableList(actionLog_);
            bitField0_ = (bitField0_ & ~0x00000100);
          }
          result.actionLog_ = actionLog_;
        } else {
          result.actionLog_ = actionLogBuilder_.build();
        }
        if (createdAtBuilder_ == null) {
          result.createdAt_ = createdAt_;
        } else {
          result.createdAt_ = createdAtBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase) {
          return mergeFrom((io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase other) {
        if (other == io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getPartnerCode().isEmpty()) {
          partnerCode_ = other.partnerCode_;
          onChanged();
        }
        if (!other.getLocationCode().isEmpty()) {
          locationCode_ = other.locationCode_;
          onChanged();
        }
        if (other.status_ != 0) {
          setStatusValue(other.getStatusValue());
        }
        if (other.hasCustomer()) {
          mergeCustomer(other.getCustomer());
        }
        if (other.hasRegister()) {
          mergeRegister(other.getRegister());
        }
        if (itemBuilder_ == null) {
          if (!other.item_.isEmpty()) {
            if (item_.isEmpty()) {
              item_ = other.item_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureItemIsMutable();
              item_.addAll(other.item_);
            }
            onChanged();
          }
        } else {
          if (!other.item_.isEmpty()) {
            if (itemBuilder_.isEmpty()) {
              itemBuilder_.dispose();
              itemBuilder_ = null;
              item_ = other.item_;
              bitField0_ = (bitField0_ & ~0x00000040);
              itemBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getItemFieldBuilder() : null;
            } else {
              itemBuilder_.addAllMessages(other.item_);
            }
          }
        }
        if (other.hasReceipt()) {
          mergeReceipt(other.getReceipt());
        }
        if (actionLogBuilder_ == null) {
          if (!other.actionLog_.isEmpty()) {
            if (actionLog_.isEmpty()) {
              actionLog_ = other.actionLog_;
              bitField0_ = (bitField0_ & ~0x00000100);
            } else {
              ensureActionLogIsMutable();
              actionLog_.addAll(other.actionLog_);
            }
            onChanged();
          }
        } else {
          if (!other.actionLog_.isEmpty()) {
            if (actionLogBuilder_.isEmpty()) {
              actionLogBuilder_.dispose();
              actionLogBuilder_ = null;
              actionLog_ = other.actionLog_;
              bitField0_ = (bitField0_ & ~0x00000100);
              actionLogBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getActionLogFieldBuilder() : null;
            } else {
              actionLogBuilder_.addAllMessages(other.actionLog_);
            }
          }
        }
        if (other.hasCreatedAt()) {
          mergeCreatedAt(other.getCreatedAt());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID assigned to the purchase by the server.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID assigned to the purchase by the server.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID assigned to the purchase by the server.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID assigned to the purchase by the server.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID assigned to the purchase by the server.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object partnerCode_ = "";
      /**
       * <pre>
       * Partner ID for the purchase.
       * </pre>
       *
       * <code>string partner_code = 2;</code>
       */
      public java.lang.String getPartnerCode() {
        java.lang.Object ref = partnerCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partnerCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partner ID for the purchase.
       * </pre>
       *
       * <code>string partner_code = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPartnerCodeBytes() {
        java.lang.Object ref = partnerCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partnerCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partner ID for the purchase.
       * </pre>
       *
       * <code>string partner_code = 2;</code>
       */
      public Builder setPartnerCode(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partnerCode_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID for the purchase.
       * </pre>
       *
       * <code>string partner_code = 2;</code>
       */
      public Builder clearPartnerCode() {
        
        partnerCode_ = getDefaultInstance().getPartnerCode();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID for the purchase.
       * </pre>
       *
       * <code>string partner_code = 2;</code>
       */
      public Builder setPartnerCodeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partnerCode_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object locationCode_ = "";
      /**
       * <pre>
       * Location ID for the purchase.
       * </pre>
       *
       * <code>string location_code = 3;</code>
       */
      public java.lang.String getLocationCode() {
        java.lang.Object ref = locationCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          locationCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Location ID for the purchase.
       * </pre>
       *
       * <code>string location_code = 3;</code>
       */
      public com.google.protobuf.ByteString
          getLocationCodeBytes() {
        java.lang.Object ref = locationCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          locationCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Location ID for the purchase.
       * </pre>
       *
       * <code>string location_code = 3;</code>
       */
      public Builder setLocationCode(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        locationCode_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID for the purchase.
       * </pre>
       *
       * <code>string location_code = 3;</code>
       */
      public Builder clearLocationCode() {
        
        locationCode_ = getDefaultInstance().getLocationCode();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID for the purchase.
       * </pre>
       *
       * <code>string location_code = 3;</code>
       */
      public Builder setLocationCodeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        locationCode_ = value;
        onChanged();
        return this;
      }

      private int status_ = 0;
      /**
       * <pre>
       * Current status of this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
       */
      public int getStatusValue() {
        return status_;
      }
      /**
       * <pre>
       * Current status of this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
       */
      public Builder setStatusValue(int value) {
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Current status of this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus getStatus() {
        io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus result = io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.valueOf(status_);
        return result == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Current status of this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
       */
      public Builder setStatus(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Current status of this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.PurchaseStatus status = 4;</code>
       */
      public Builder clearStatus() {
        
        status_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.commerce.OrderCustomer.Customer customer_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder> customerBuilder_;
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public boolean hasCustomer() {
        return customerBuilder_ != null || customer_ != null;
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.Customer getCustomer() {
        if (customerBuilder_ == null) {
          return customer_ == null ? io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
        } else {
          return customerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public Builder setCustomer(io.opencannabis.schema.commerce.OrderCustomer.Customer value) {
        if (customerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          customer_ = value;
          onChanged();
        } else {
          customerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public Builder setCustomer(
          io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder builderForValue) {
        if (customerBuilder_ == null) {
          customer_ = builderForValue.build();
          onChanged();
        } else {
          customerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public Builder mergeCustomer(io.opencannabis.schema.commerce.OrderCustomer.Customer value) {
        if (customerBuilder_ == null) {
          if (customer_ != null) {
            customer_ =
              io.opencannabis.schema.commerce.OrderCustomer.Customer.newBuilder(customer_).mergeFrom(value).buildPartial();
          } else {
            customer_ = value;
          }
          onChanged();
        } else {
          customerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public Builder clearCustomer() {
        if (customerBuilder_ == null) {
          customer_ = null;
          onChanged();
        } else {
          customer_ = null;
          customerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder getCustomerBuilder() {
        
        onChanged();
        return getCustomerFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      public io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder getCustomerOrBuilder() {
        if (customerBuilder_ != null) {
          return customerBuilder_.getMessageOrBuilder();
        } else {
          return customer_ == null ?
              io.opencannabis.schema.commerce.OrderCustomer.Customer.getDefaultInstance() : customer_;
        }
      }
      /**
       * <pre>
       * Customer that submitted this purchase.
       * </pre>
       *
       * <code>.opencannabis.commerce.Customer customer = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder> 
          getCustomerFieldBuilder() {
        if (customerBuilder_ == null) {
          customerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.commerce.OrderCustomer.Customer, io.opencannabis.schema.commerce.OrderCustomer.Customer.Builder, io.opencannabis.schema.commerce.OrderCustomer.CustomerOrBuilder>(
                  getCustomer(),
                  getParentForChildren(),
                  isClean());
          customer_ = null;
        }
        return customerBuilder_;
      }

      private io.bloombox.schema.partner.PartnerDeviceKey register_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerDeviceKey, io.bloombox.schema.partner.PartnerDeviceKey.Builder, io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder> registerBuilder_;
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public boolean hasRegister() {
        return registerBuilder_ != null || register_ != null;
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerDeviceKey getRegister() {
        if (registerBuilder_ == null) {
          return register_ == null ? io.bloombox.schema.partner.PartnerDeviceKey.getDefaultInstance() : register_;
        } else {
          return registerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public Builder setRegister(io.bloombox.schema.partner.PartnerDeviceKey value) {
        if (registerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          register_ = value;
          onChanged();
        } else {
          registerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public Builder setRegister(
          io.bloombox.schema.partner.PartnerDeviceKey.Builder builderForValue) {
        if (registerBuilder_ == null) {
          register_ = builderForValue.build();
          onChanged();
        } else {
          registerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public Builder mergeRegister(io.bloombox.schema.partner.PartnerDeviceKey value) {
        if (registerBuilder_ == null) {
          if (register_ != null) {
            register_ =
              io.bloombox.schema.partner.PartnerDeviceKey.newBuilder(register_).mergeFrom(value).buildPartial();
          } else {
            register_ = value;
          }
          onChanged();
        } else {
          registerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public Builder clearRegister() {
        if (registerBuilder_ == null) {
          register_ = null;
          onChanged();
        } else {
          register_ = null;
          registerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerDeviceKey.Builder getRegisterBuilder() {
        
        onChanged();
        return getRegisterFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder getRegisterOrBuilder() {
        if (registerBuilder_ != null) {
          return registerBuilder_.getMessageOrBuilder();
        } else {
          return register_ == null ?
              io.bloombox.schema.partner.PartnerDeviceKey.getDefaultInstance() : register_;
        }
      }
      /**
       * <pre>
       * Point-of-Sale device that submitted this purchase.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerDeviceKey register = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerDeviceKey, io.bloombox.schema.partner.PartnerDeviceKey.Builder, io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder> 
          getRegisterFieldBuilder() {
        if (registerBuilder_ == null) {
          registerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.PartnerDeviceKey, io.bloombox.schema.partner.PartnerDeviceKey.Builder, io.bloombox.schema.partner.PartnerDeviceKeyOrBuilder>(
                  getRegister(),
                  getParentForChildren(),
                  isClean());
          register_ = null;
        }
        return registerBuilder_;
      }

      private java.util.List<io.opencannabis.schema.commerce.OrderItem.Item> item_ =
        java.util.Collections.emptyList();
      private void ensureItemIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          item_ = new java.util.ArrayList<io.opencannabis.schema.commerce.OrderItem.Item>(item_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderItem.Item, io.opencannabis.schema.commerce.OrderItem.Item.Builder, io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder> itemBuilder_;

      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public java.util.List<io.opencannabis.schema.commerce.OrderItem.Item> getItemList() {
        if (itemBuilder_ == null) {
          return java.util.Collections.unmodifiableList(item_);
        } else {
          return itemBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public int getItemCount() {
        if (itemBuilder_ == null) {
          return item_.size();
        } else {
          return itemBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.Item getItem(int index) {
        if (itemBuilder_ == null) {
          return item_.get(index);
        } else {
          return itemBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder setItem(
          int index, io.opencannabis.schema.commerce.OrderItem.Item value) {
        if (itemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemIsMutable();
          item_.set(index, value);
          onChanged();
        } else {
          itemBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder setItem(
          int index, io.opencannabis.schema.commerce.OrderItem.Item.Builder builderForValue) {
        if (itemBuilder_ == null) {
          ensureItemIsMutable();
          item_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder addItem(io.opencannabis.schema.commerce.OrderItem.Item value) {
        if (itemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemIsMutable();
          item_.add(value);
          onChanged();
        } else {
          itemBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder addItem(
          int index, io.opencannabis.schema.commerce.OrderItem.Item value) {
        if (itemBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemIsMutable();
          item_.add(index, value);
          onChanged();
        } else {
          itemBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder addItem(
          io.opencannabis.schema.commerce.OrderItem.Item.Builder builderForValue) {
        if (itemBuilder_ == null) {
          ensureItemIsMutable();
          item_.add(builderForValue.build());
          onChanged();
        } else {
          itemBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder addItem(
          int index, io.opencannabis.schema.commerce.OrderItem.Item.Builder builderForValue) {
        if (itemBuilder_ == null) {
          ensureItemIsMutable();
          item_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder addAllItem(
          java.lang.Iterable<? extends io.opencannabis.schema.commerce.OrderItem.Item> values) {
        if (itemBuilder_ == null) {
          ensureItemIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, item_);
          onChanged();
        } else {
          itemBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder clearItem() {
        if (itemBuilder_ == null) {
          item_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          itemBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public Builder removeItem(int index) {
        if (itemBuilder_ == null) {
          ensureItemIsMutable();
          item_.remove(index);
          onChanged();
        } else {
          itemBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.Item.Builder getItemBuilder(
          int index) {
        return getItemFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder getItemOrBuilder(
          int index) {
        if (itemBuilder_ == null) {
          return item_.get(index);  } else {
          return itemBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder> 
           getItemOrBuilderList() {
        if (itemBuilder_ != null) {
          return itemBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(item_);
        }
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.Item.Builder addItemBuilder() {
        return getItemFieldBuilder().addBuilder(
            io.opencannabis.schema.commerce.OrderItem.Item.getDefaultInstance());
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.Item.Builder addItemBuilder(
          int index) {
        return getItemFieldBuilder().addBuilder(
            index, io.opencannabis.schema.commerce.OrderItem.Item.getDefaultInstance());
      }
      /**
       * <pre>
       * Items being ordered.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.Item item = 7;</code>
       */
      public java.util.List<io.opencannabis.schema.commerce.OrderItem.Item.Builder> 
           getItemBuilderList() {
        return getItemFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderItem.Item, io.opencannabis.schema.commerce.OrderItem.Item.Builder, io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder> 
          getItemFieldBuilder() {
        if (itemBuilder_ == null) {
          itemBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.commerce.OrderItem.Item, io.opencannabis.schema.commerce.OrderItem.Item.Builder, io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder>(
                  item_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          item_ = null;
        }
        return itemBuilder_;
      }

      private io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt receipt_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt, io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder> receiptBuilder_;
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public boolean hasReceipt() {
        return receiptBuilder_ != null || receipt_ != null;
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt getReceipt() {
        if (receiptBuilder_ == null) {
          return receipt_ == null ? io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.getDefaultInstance() : receipt_;
        } else {
          return receiptBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public Builder setReceipt(io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt value) {
        if (receiptBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          receipt_ = value;
          onChanged();
        } else {
          receiptBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public Builder setReceipt(
          io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder builderForValue) {
        if (receiptBuilder_ == null) {
          receipt_ = builderForValue.build();
          onChanged();
        } else {
          receiptBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public Builder mergeReceipt(io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt value) {
        if (receiptBuilder_ == null) {
          if (receipt_ != null) {
            receipt_ =
              io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.newBuilder(receipt_).mergeFrom(value).buildPartial();
          } else {
            receipt_ = value;
          }
          onChanged();
        } else {
          receiptBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public Builder clearReceipt() {
        if (receiptBuilder_ == null) {
          receipt_ = null;
          onChanged();
        } else {
          receipt_ = null;
          receiptBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder getReceiptBuilder() {
        
        onChanged();
        return getReceiptFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder getReceiptOrBuilder() {
        if (receiptBuilder_ != null) {
          return receiptBuilder_.getMessageOrBuilder();
        } else {
          return receipt_ == null ?
              io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.getDefaultInstance() : receipt_;
        }
      }
      /**
       * <pre>
       * Calculated order values and components, like taxes, subtotal, and so on.
       * </pre>
       *
       * <code>.bloombox.schema.commerce.pos.Receipt receipt = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt, io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder> 
          getReceiptFieldBuilder() {
        if (receiptBuilder_ == null) {
          receiptBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt, io.bloombox.schema.commerce.pos.CommercialPurchase.Receipt.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.ReceiptOrBuilder>(
                  getReceipt(),
                  getParentForChildren(),
                  isClean());
          receipt_ = null;
        }
        return receiptBuilder_;
      }

      private java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> actionLog_ =
        java.util.Collections.emptyList();
      private void ensureActionLogIsMutable() {
        if (!((bitField0_ & 0x00000100) == 0x00000100)) {
          actionLog_ = new java.util.ArrayList<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent>(actionLog_);
          bitField0_ |= 0x00000100;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder> actionLogBuilder_;

      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> getActionLogList() {
        if (actionLogBuilder_ == null) {
          return java.util.Collections.unmodifiableList(actionLog_);
        } else {
          return actionLogBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public int getActionLogCount() {
        if (actionLogBuilder_ == null) {
          return actionLog_.size();
        } else {
          return actionLogBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent getActionLog(int index) {
        if (actionLogBuilder_ == null) {
          return actionLog_.get(index);
        } else {
          return actionLogBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder setActionLog(
          int index, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent value) {
        if (actionLogBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionLogIsMutable();
          actionLog_.set(index, value);
          onChanged();
        } else {
          actionLogBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder setActionLog(
          int index, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder builderForValue) {
        if (actionLogBuilder_ == null) {
          ensureActionLogIsMutable();
          actionLog_.set(index, builderForValue.build());
          onChanged();
        } else {
          actionLogBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder addActionLog(io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent value) {
        if (actionLogBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionLogIsMutable();
          actionLog_.add(value);
          onChanged();
        } else {
          actionLogBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder addActionLog(
          int index, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent value) {
        if (actionLogBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActionLogIsMutable();
          actionLog_.add(index, value);
          onChanged();
        } else {
          actionLogBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder addActionLog(
          io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder builderForValue) {
        if (actionLogBuilder_ == null) {
          ensureActionLogIsMutable();
          actionLog_.add(builderForValue.build());
          onChanged();
        } else {
          actionLogBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder addActionLog(
          int index, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder builderForValue) {
        if (actionLogBuilder_ == null) {
          ensureActionLogIsMutable();
          actionLog_.add(index, builderForValue.build());
          onChanged();
        } else {
          actionLogBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder addAllActionLog(
          java.lang.Iterable<? extends io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent> values) {
        if (actionLogBuilder_ == null) {
          ensureActionLogIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, actionLog_);
          onChanged();
        } else {
          actionLogBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder clearActionLog() {
        if (actionLogBuilder_ == null) {
          actionLog_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
          onChanged();
        } else {
          actionLogBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public Builder removeActionLog(int index) {
        if (actionLogBuilder_ == null) {
          ensureActionLogIsMutable();
          actionLog_.remove(index);
          onChanged();
        } else {
          actionLogBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder getActionLogBuilder(
          int index) {
        return getActionLogFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder getActionLogOrBuilder(
          int index) {
        if (actionLogBuilder_ == null) {
          return actionLog_.get(index);  } else {
          return actionLogBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public java.util.List<? extends io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder> 
           getActionLogOrBuilderList() {
        if (actionLogBuilder_ != null) {
          return actionLogBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(actionLog_);
        }
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder addActionLogBuilder() {
        return getActionLogFieldBuilder().addBuilder(
            io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.getDefaultInstance());
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder addActionLogBuilder(
          int index) {
        return getActionLogFieldBuilder().addBuilder(
            index, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.getDefaultInstance());
      }
      /**
       * <pre>
       * Actions taken on this order.
       * </pre>
       *
       * <code>repeated .bloombox.schema.commerce.pos.PurchaseEvent action_log = 9;</code>
       */
      public java.util.List<io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder> 
           getActionLogBuilderList() {
        return getActionLogFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder> 
          getActionLogFieldBuilder() {
        if (actionLogBuilder_ == null) {
          actionLogBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEvent.Builder, io.bloombox.schema.commerce.pos.CommercialPurchase.PurchaseEventOrBuilder>(
                  actionLog_,
                  ((bitField0_ & 0x00000100) == 0x00000100),
                  getParentForChildren(),
                  isClean());
          actionLog_ = null;
        }
        return actionLogBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant createdAt_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> createdAtBuilder_;
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public boolean hasCreatedAt() {
        return createdAtBuilder_ != null || createdAt_ != null;
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public io.opencannabis.schema.temporal.Instant getCreatedAt() {
        if (createdAtBuilder_ == null) {
          return createdAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
        } else {
          return createdAtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public Builder setCreatedAt(io.opencannabis.schema.temporal.Instant value) {
        if (createdAtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createdAt_ = value;
          onChanged();
        } else {
          createdAtBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public Builder setCreatedAt(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (createdAtBuilder_ == null) {
          createdAt_ = builderForValue.build();
          onChanged();
        } else {
          createdAtBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public Builder mergeCreatedAt(io.opencannabis.schema.temporal.Instant value) {
        if (createdAtBuilder_ == null) {
          if (createdAt_ != null) {
            createdAt_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(createdAt_).mergeFrom(value).buildPartial();
          } else {
            createdAt_ = value;
          }
          onChanged();
        } else {
          createdAtBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public Builder clearCreatedAt() {
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
          onChanged();
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getCreatedAtBuilder() {
        
        onChanged();
        return getCreatedAtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder() {
        if (createdAtBuilder_ != null) {
          return createdAtBuilder_.getMessageOrBuilder();
        } else {
          return createdAt_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
        }
      }
      /**
       * <pre>
       * When this order was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getCreatedAtFieldBuilder() {
        if (createdAtBuilder_ == null) {
          createdAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getCreatedAt(),
                  getParentForChildren(),
                  isClean());
          createdAt_ = null;
        }
        return createdAtBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.commerce.pos.Purchase)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.commerce.pos.Purchase)
    private static final io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase();
    }

    public static io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Purchase>
        PARSER = new com.google.protobuf.AbstractParser<Purchase>() {
      public Purchase parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Purchase(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Purchase> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Purchase> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.commerce.pos.CommercialPurchase.Purchase getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_commerce_pos_PurchaseEvent_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_commerce_pos_Receipt_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_commerce_pos_Receipt_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_commerce_pos_Purchase_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_commerce_pos_Purchase_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\033commerce/pos/Purchase.proto\022\034bloombox." +
      "schema.commerce.pos\032\026accounting/Taxes.pr" +
      "oto\032\023commerce/Item.proto\032\027commerce/Custo" +
      "mer.proto\032\030commerce/Discounts.proto\032\026tem" +
      "poral/Instant.proto\032\033partner/PartnerDevi" +
      "ce.proto\"\217\001\n\rPurchaseEvent\022<\n\006status\030\001 \001" +
      "(\0162,.bloombox.schema.commerce.pos.Purcha" +
      "seStatus\022/\n\007instant\030\002 \001(\0132\036.opencannabis" +
      ".temporal.Instant\022\017\n\007message\030\003 \001(\t\"\203\001\n\007R" +
      "eceipt\022\020\n\010subtotal\030\001 \001(\001\022$\n\003tax\030\002 \003(\0132\027." +
      "opencannabis.taxes.Tax\0221\n\010discount\030\003 \003(\013" +
      "2\037.opencannabis.commerce.Discount\022\r\n\005tot" +
      "al\030\004 \001(\001\"\311\003\n\010Purchase\022\n\n\002id\030\001 \001(\t\022\024\n\014par" +
      "tner_code\030\002 \001(\t\022\025\n\rlocation_code\030\003 \001(\t\022<" +
      "\n\006status\030\004 \001(\0162,.bloombox.schema.commerc" +
      "e.pos.PurchaseStatus\0221\n\010customer\030\005 \001(\0132\037" +
      ".opencannabis.commerce.Customer\022;\n\010regis" +
      "ter\030\006 \001(\0132).bloombox.schema.partner.Part" +
      "nerDeviceKey\022)\n\004item\030\007 \003(\0132\033.opencannabi" +
      "s.commerce.Item\0226\n\007receipt\030\010 \001(\0132%.bloom" +
      "box.schema.commerce.pos.Receipt\022?\n\nactio" +
      "n_log\030\t \003(\0132+.bloombox.schema.commerce.p" +
      "os.PurchaseEvent\0222\n\ncreated_at\030\n \001(\0132\036.o" +
      "pencannabis.temporal.Instant*?\n\016Purchase" +
      "Status\022\013\n\007DORMANT\020\000\022\010\n\004OPEN\020\001\022\n\n\006VOIDED\020" +
      "\002\022\n\n\006CLOSED\020\003B?\n\037io.bloombox.schema.comm" +
      "erce.posB\022CommercialPurchaseH\001P\000\242\002\003BBSb\006" +
      "proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.accounting.AccountingTaxes.getDescriptor(),
          io.opencannabis.schema.commerce.OrderItem.getDescriptor(),
          io.opencannabis.schema.commerce.OrderCustomer.getDescriptor(),
          io.opencannabis.schema.accounting.CommercialDiscounts.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
          io.bloombox.schema.partner.PartnerDeviceOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_commerce_pos_PurchaseEvent_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_commerce_pos_PurchaseEvent_descriptor,
        new java.lang.String[] { "Status", "Instant", "Message", });
    internal_static_bloombox_schema_commerce_pos_Receipt_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_commerce_pos_Receipt_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_commerce_pos_Receipt_descriptor,
        new java.lang.String[] { "Subtotal", "Tax", "Discount", "Total", });
    internal_static_bloombox_schema_commerce_pos_Purchase_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_commerce_pos_Purchase_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_commerce_pos_Purchase_descriptor,
        new java.lang.String[] { "Id", "PartnerCode", "LocationCode", "Status", "Customer", "Register", "Item", "Receipt", "ActionLog", "CreatedAt", });
    io.opencannabis.schema.accounting.AccountingTaxes.getDescriptor();
    io.opencannabis.schema.commerce.OrderItem.getDescriptor();
    io.opencannabis.schema.commerce.OrderCustomer.getDescriptor();
    io.opencannabis.schema.accounting.CommercialDiscounts.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
    io.bloombox.schema.partner.PartnerDeviceOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
