/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Represents a consumer's membership at a particular dispensary.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.ConsumerMembership}
 */
public  final class ConsumerMembership extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.ConsumerMembership)
    ConsumerMembershipOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ConsumerMembership.newBuilder() to construct.
  private ConsumerMembership(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ConsumerMembership() {
    referralSource_ = 0;
    referralChannel_ = "";
    foreignId_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ConsumerMembership(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            referralSource_ = rawValue;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            referralChannel_ = s;
            break;
          }
          case 26: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (signedUpAt_ != null) {
              subBuilder = signedUpAt_.toBuilder();
            }
            signedUpAt_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(signedUpAt_);
              signedUpAt_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (seen_ != null) {
              subBuilder = seen_.toBuilder();
            }
            seen_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(seen_);
              seen_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            foreignId_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerMembership_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerMembership_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.ConsumerMembership.class, io.bloombox.schema.identity.ConsumerMembership.Builder.class);
  }

  public static final int REFERRAL_SOURCE_FIELD_NUMBER = 1;
  private int referralSource_;
  /**
   * <pre>
   * Referral source for this enrollment.
   * </pre>
   *
   * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
   */
  public int getReferralSourceValue() {
    return referralSource_;
  }
  /**
   * <pre>
   * Referral source for this enrollment.
   * </pre>
   *
   * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
   */
  public io.bloombox.schema.identity.EnrollmentSource getReferralSource() {
    io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(referralSource_);
    return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
  }

  public static final int REFERRAL_CHANNEL_FIELD_NUMBER = 2;
  private volatile java.lang.Object referralChannel_;
  /**
   * <pre>
   * Referral channel token - an artbirary, end-system provided value.
   * </pre>
   *
   * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
   */
  public java.lang.String getReferralChannel() {
    java.lang.Object ref = referralChannel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referralChannel_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Referral channel token - an artbirary, end-system provided value.
   * </pre>
   *
   * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
   */
  public com.google.protobuf.ByteString
      getReferralChannelBytes() {
    java.lang.Object ref = referralChannel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referralChannel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIGNED_UP_AT_FIELD_NUMBER = 3;
  private io.opencannabis.schema.temporal.Instant signedUpAt_;
  /**
   * <pre>
   * Timestamp for when this profile enrolled.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
   */
  public boolean hasSignedUpAt() {
    return signedUpAt_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this profile enrolled.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getSignedUpAt() {
    return signedUpAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signedUpAt_;
  }
  /**
   * <pre>
   * Timestamp for when this profile enrolled.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSignedUpAtOrBuilder() {
    return getSignedUpAt();
  }

  public static final int SEEN_FIELD_NUMBER = 4;
  private io.opencannabis.schema.temporal.Instant seen_;
  /**
   * <pre>
   * Timestamp for when this profile was last seen.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
   */
  public boolean hasSeen() {
    return seen_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this profile was last seen.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getSeen() {
    return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
  }
  /**
   * <pre>
   * Timestamp for when this profile was last seen.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
    return getSeen();
  }

  public static final int FOREIGN_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object foreignId_;
  /**
   * <pre>
   * Foreign ID for this membership, in the partner-colocated membership system.
   * </pre>
   *
   * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
   */
  public java.lang.String getForeignId() {
    java.lang.Object ref = foreignId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      foreignId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Foreign ID for this membership, in the partner-colocated membership system.
   * </pre>
   *
   * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
   */
  public com.google.protobuf.ByteString
      getForeignIdBytes() {
    java.lang.Object ref = foreignId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      foreignId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (referralSource_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
      output.writeEnum(1, referralSource_);
    }
    if (!getReferralChannelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, referralChannel_);
    }
    if (signedUpAt_ != null) {
      output.writeMessage(3, getSignedUpAt());
    }
    if (seen_ != null) {
      output.writeMessage(4, getSeen());
    }
    if (!getForeignIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, foreignId_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (referralSource_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, referralSource_);
    }
    if (!getReferralChannelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, referralChannel_);
    }
    if (signedUpAt_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getSignedUpAt());
    }
    if (seen_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getSeen());
    }
    if (!getForeignIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, foreignId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.ConsumerMembership)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.ConsumerMembership other = (io.bloombox.schema.identity.ConsumerMembership) obj;

    boolean result = true;
    result = result && referralSource_ == other.referralSource_;
    result = result && getReferralChannel()
        .equals(other.getReferralChannel());
    result = result && (hasSignedUpAt() == other.hasSignedUpAt());
    if (hasSignedUpAt()) {
      result = result && getSignedUpAt()
          .equals(other.getSignedUpAt());
    }
    result = result && (hasSeen() == other.hasSeen());
    if (hasSeen()) {
      result = result && getSeen()
          .equals(other.getSeen());
    }
    result = result && getForeignId()
        .equals(other.getForeignId());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REFERRAL_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + referralSource_;
    hash = (37 * hash) + REFERRAL_CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + getReferralChannel().hashCode();
    if (hasSignedUpAt()) {
      hash = (37 * hash) + SIGNED_UP_AT_FIELD_NUMBER;
      hash = (53 * hash) + getSignedUpAt().hashCode();
    }
    if (hasSeen()) {
      hash = (37 * hash) + SEEN_FIELD_NUMBER;
      hash = (53 * hash) + getSeen().hashCode();
    }
    hash = (37 * hash) + FOREIGN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getForeignId().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerMembership parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.ConsumerMembership prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a consumer's membership at a particular dispensary.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.ConsumerMembership}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.ConsumerMembership)
      io.bloombox.schema.identity.ConsumerMembershipOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerMembership_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerMembership_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.ConsumerMembership.class, io.bloombox.schema.identity.ConsumerMembership.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.ConsumerMembership.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      referralSource_ = 0;

      referralChannel_ = "";

      if (signedUpAtBuilder_ == null) {
        signedUpAt_ = null;
      } else {
        signedUpAt_ = null;
        signedUpAtBuilder_ = null;
      }
      if (seenBuilder_ == null) {
        seen_ = null;
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }
      foreignId_ = "";

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerMembership_descriptor;
    }

    public io.bloombox.schema.identity.ConsumerMembership getDefaultInstanceForType() {
      return io.bloombox.schema.identity.ConsumerMembership.getDefaultInstance();
    }

    public io.bloombox.schema.identity.ConsumerMembership build() {
      io.bloombox.schema.identity.ConsumerMembership result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.ConsumerMembership buildPartial() {
      io.bloombox.schema.identity.ConsumerMembership result = new io.bloombox.schema.identity.ConsumerMembership(this);
      result.referralSource_ = referralSource_;
      result.referralChannel_ = referralChannel_;
      if (signedUpAtBuilder_ == null) {
        result.signedUpAt_ = signedUpAt_;
      } else {
        result.signedUpAt_ = signedUpAtBuilder_.build();
      }
      if (seenBuilder_ == null) {
        result.seen_ = seen_;
      } else {
        result.seen_ = seenBuilder_.build();
      }
      result.foreignId_ = foreignId_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.ConsumerMembership) {
        return mergeFrom((io.bloombox.schema.identity.ConsumerMembership)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.ConsumerMembership other) {
      if (other == io.bloombox.schema.identity.ConsumerMembership.getDefaultInstance()) return this;
      if (other.referralSource_ != 0) {
        setReferralSourceValue(other.getReferralSourceValue());
      }
      if (!other.getReferralChannel().isEmpty()) {
        referralChannel_ = other.referralChannel_;
        onChanged();
      }
      if (other.hasSignedUpAt()) {
        mergeSignedUpAt(other.getSignedUpAt());
      }
      if (other.hasSeen()) {
        mergeSeen(other.getSeen());
      }
      if (!other.getForeignId().isEmpty()) {
        foreignId_ = other.foreignId_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.ConsumerMembership parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.ConsumerMembership) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int referralSource_ = 0;
    /**
     * <pre>
     * Referral source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
     */
    public int getReferralSourceValue() {
      return referralSource_;
    }
    /**
     * <pre>
     * Referral source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
     */
    public Builder setReferralSourceValue(int value) {
      referralSource_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Referral source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
     */
    public io.bloombox.schema.identity.EnrollmentSource getReferralSource() {
      io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(referralSource_);
      return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Referral source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
     */
    public Builder setReferralSource(io.bloombox.schema.identity.EnrollmentSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      referralSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Referral source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource referral_source = 1 [(.gen_bq_schema.description) = "Referral source for this enrollment."];</code>
     */
    public Builder clearReferralSource() {
      
      referralSource_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object referralChannel_ = "";
    /**
     * <pre>
     * Referral channel token - an artbirary, end-system provided value.
     * </pre>
     *
     * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
     */
    public java.lang.String getReferralChannel() {
      java.lang.Object ref = referralChannel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referralChannel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Referral channel token - an artbirary, end-system provided value.
     * </pre>
     *
     * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
     */
    public com.google.protobuf.ByteString
        getReferralChannelBytes() {
      java.lang.Object ref = referralChannel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referralChannel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Referral channel token - an artbirary, end-system provided value.
     * </pre>
     *
     * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
     */
    public Builder setReferralChannel(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referralChannel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Referral channel token - an artbirary, end-system provided value.
     * </pre>
     *
     * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
     */
    public Builder clearReferralChannel() {
      
      referralChannel_ = getDefaultInstance().getReferralChannel();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Referral channel token - an artbirary, end-system provided value.
     * </pre>
     *
     * <code>string referral_channel = 2 [(.gen_bq_schema.description) = "Referral channel token - an artbirary, end-system provided value."];</code>
     */
    public Builder setReferralChannelBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referralChannel_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant signedUpAt_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> signedUpAtBuilder_;
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public boolean hasSignedUpAt() {
      return signedUpAtBuilder_ != null || signedUpAt_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getSignedUpAt() {
      if (signedUpAtBuilder_ == null) {
        return signedUpAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signedUpAt_;
      } else {
        return signedUpAtBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public Builder setSignedUpAt(io.opencannabis.schema.temporal.Instant value) {
      if (signedUpAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signedUpAt_ = value;
        onChanged();
      } else {
        signedUpAtBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public Builder setSignedUpAt(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (signedUpAtBuilder_ == null) {
        signedUpAt_ = builderForValue.build();
        onChanged();
      } else {
        signedUpAtBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public Builder mergeSignedUpAt(io.opencannabis.schema.temporal.Instant value) {
      if (signedUpAtBuilder_ == null) {
        if (signedUpAt_ != null) {
          signedUpAt_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(signedUpAt_).mergeFrom(value).buildPartial();
        } else {
          signedUpAt_ = value;
        }
        onChanged();
      } else {
        signedUpAtBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public Builder clearSignedUpAt() {
      if (signedUpAtBuilder_ == null) {
        signedUpAt_ = null;
        onChanged();
      } else {
        signedUpAt_ = null;
        signedUpAtBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSignedUpAtBuilder() {
      
      onChanged();
      return getSignedUpAtFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSignedUpAtOrBuilder() {
      if (signedUpAtBuilder_ != null) {
        return signedUpAtBuilder_.getMessageOrBuilder();
      } else {
        return signedUpAt_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signedUpAt_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this profile enrolled.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signed_up_at = 3 [(.gen_bq_schema.description) = "Timestamp for when this profile enrolled."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSignedUpAtFieldBuilder() {
      if (signedUpAtBuilder_ == null) {
        signedUpAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSignedUpAt(),
                getParentForChildren(),
                isClean());
        signedUpAt_ = null;
      }
      return signedUpAtBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant seen_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> seenBuilder_;
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public boolean hasSeen() {
      return seenBuilder_ != null || seen_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getSeen() {
      if (seenBuilder_ == null) {
        return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      } else {
        return seenBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public Builder setSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        seen_ = value;
        onChanged();
      } else {
        seenBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public Builder setSeen(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (seenBuilder_ == null) {
        seen_ = builderForValue.build();
        onChanged();
      } else {
        seenBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public Builder mergeSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (seen_ != null) {
          seen_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(seen_).mergeFrom(value).buildPartial();
        } else {
          seen_ = value;
        }
        onChanged();
      } else {
        seenBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public Builder clearSeen() {
      if (seenBuilder_ == null) {
        seen_ = null;
        onChanged();
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSeenBuilder() {
      
      onChanged();
      return getSeenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
      if (seenBuilder_ != null) {
        return seenBuilder_.getMessageOrBuilder();
      } else {
        return seen_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this profile was last seen.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 4 [(.gen_bq_schema.description) = "Timestamp for when this profile was last seen."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSeenFieldBuilder() {
      if (seenBuilder_ == null) {
        seenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSeen(),
                getParentForChildren(),
                isClean());
        seen_ = null;
      }
      return seenBuilder_;
    }

    private java.lang.Object foreignId_ = "";
    /**
     * <pre>
     * Foreign ID for this membership, in the partner-colocated membership system.
     * </pre>
     *
     * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
     */
    public java.lang.String getForeignId() {
      java.lang.Object ref = foreignId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        foreignId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Foreign ID for this membership, in the partner-colocated membership system.
     * </pre>
     *
     * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
     */
    public com.google.protobuf.ByteString
        getForeignIdBytes() {
      java.lang.Object ref = foreignId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        foreignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Foreign ID for this membership, in the partner-colocated membership system.
     * </pre>
     *
     * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
     */
    public Builder setForeignId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      foreignId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Foreign ID for this membership, in the partner-colocated membership system.
     * </pre>
     *
     * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
     */
    public Builder clearForeignId() {
      
      foreignId_ = getDefaultInstance().getForeignId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Foreign ID for this membership, in the partner-colocated membership system.
     * </pre>
     *
     * <code>string foreign_id = 5 [(.gen_bq_schema.description) = "Foreign ID for this membership, in the partner-colocated membership system."];</code>
     */
    public Builder setForeignIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      foreignId_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.ConsumerMembership)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.ConsumerMembership)
  private static final io.bloombox.schema.identity.ConsumerMembership DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.ConsumerMembership();
  }

  public static io.bloombox.schema.identity.ConsumerMembership getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConsumerMembership>
      PARSER = new com.google.protobuf.AbstractParser<ConsumerMembership>() {
    public ConsumerMembership parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ConsumerMembership(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ConsumerMembership> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConsumerMembership> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.ConsumerMembership getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

