/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * User profile information for a cannabis consumer.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.ConsumerProfile}
 */
public  final class ConsumerProfile extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.ConsumerProfile)
    ConsumerProfileOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ConsumerProfile.newBuilder() to construct.
  private ConsumerProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ConsumerProfile() {
    active_ = false;
    favoriteDispensaries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    enrollmentSource_ = 0;
    enrollmentChannel_ = "";
    type_ = 0;
    referralSource_ = 0;
    referralDetail_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ConsumerProfile(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            active_ = input.readBool();
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              favoriteDispensaries_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            favoriteDispensaries_.add(s);
            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            enrollmentSource_ = rawValue;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            enrollmentChannel_ = s;
            break;
          }
          case 42: {
            io.bloombox.schema.identity.ConsumerPreferences.Builder subBuilder = null;
            if (preferences_ != null) {
              subBuilder = preferences_.toBuilder();
            }
            preferences_ = input.readMessage(io.bloombox.schema.identity.ConsumerPreferences.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(preferences_);
              preferences_ = subBuilder.buildPartial();
            }

            break;
          }
          case 48: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 56: {
            int rawValue = input.readEnum();

            referralSource_ = rawValue;
            break;
          }
          case 66: {
            java.lang.String s = input.readStringRequireUtf8();

            referralDetail_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        favoriteDispensaries_ = favoriteDispensaries_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerProfile_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.ConsumerProfile.class, io.bloombox.schema.identity.ConsumerProfile.Builder.class);
  }

  private int bitField0_;
  public static final int ACTIVE_FIELD_NUMBER = 1;
  private boolean active_;
  /**
   * <pre>
   * Profile active/inactive flag.
   * </pre>
   *
   * <code>bool active = 1 [(.gen_bq_schema.description) = "Profile active/inactive flag."];</code>
   */
  public boolean getActive() {
    return active_;
  }

  public static final int FAVORITE_DISPENSARIES_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList favoriteDispensaries_;
  /**
   * <pre>
   * Enumerates favorite dispensaries for a user.
   * </pre>
   *
   * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
   */
  public com.google.protobuf.ProtocolStringList
      getFavoriteDispensariesList() {
    return favoriteDispensaries_;
  }
  /**
   * <pre>
   * Enumerates favorite dispensaries for a user.
   * </pre>
   *
   * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
   */
  public int getFavoriteDispensariesCount() {
    return favoriteDispensaries_.size();
  }
  /**
   * <pre>
   * Enumerates favorite dispensaries for a user.
   * </pre>
   *
   * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
   */
  public java.lang.String getFavoriteDispensaries(int index) {
    return favoriteDispensaries_.get(index);
  }
  /**
   * <pre>
   * Enumerates favorite dispensaries for a user.
   * </pre>
   *
   * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
   */
  public com.google.protobuf.ByteString
      getFavoriteDispensariesBytes(int index) {
    return favoriteDispensaries_.getByteString(index);
  }

  public static final int ENROLLMENT_SOURCE_FIELD_NUMBER = 3;
  private int enrollmentSource_;
  /**
   * <pre>
   * Specifies enrollment source attribution information.
   * </pre>
   *
   * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
   */
  public int getEnrollmentSourceValue() {
    return enrollmentSource_;
  }
  /**
   * <pre>
   * Specifies enrollment source attribution information.
   * </pre>
   *
   * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
   */
  public io.bloombox.schema.identity.EnrollmentSource getEnrollmentSource() {
    io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(enrollmentSource_);
    return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
  }

  public static final int ENROLLMENT_CHANNEL_FIELD_NUMBER = 4;
  private volatile java.lang.Object enrollmentChannel_;
  /**
   * <pre>
   * Arbitrary string for the channel through which this user enrolled.
   * </pre>
   *
   * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
   */
  public java.lang.String getEnrollmentChannel() {
    java.lang.Object ref = enrollmentChannel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      enrollmentChannel_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Arbitrary string for the channel through which this user enrolled.
   * </pre>
   *
   * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
   */
  public com.google.protobuf.ByteString
      getEnrollmentChannelBytes() {
    java.lang.Object ref = enrollmentChannel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      enrollmentChannel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFERENCES_FIELD_NUMBER = 5;
  private io.bloombox.schema.identity.ConsumerPreferences preferences_;
  /**
   * <pre>
   * Preferences attached to a consumer account.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
   */
  public boolean hasPreferences() {
    return preferences_ != null;
  }
  /**
   * <pre>
   * Preferences attached to a consumer account.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
   */
  public io.bloombox.schema.identity.ConsumerPreferences getPreferences() {
    return preferences_ == null ? io.bloombox.schema.identity.ConsumerPreferences.getDefaultInstance() : preferences_;
  }
  /**
   * <pre>
   * Preferences attached to a consumer account.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
   */
  public io.bloombox.schema.identity.ConsumerPreferencesOrBuilder getPreferencesOrBuilder() {
    return getPreferences();
  }

  public static final int TYPE_FIELD_NUMBER = 6;
  private int type_;
  /**
   * <pre>
   * Specifies the primary consumer type for this account.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Specifies the primary consumer type for this account.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
   */
  public io.bloombox.schema.identity.ConsumerType getType() {
    io.bloombox.schema.identity.ConsumerType result = io.bloombox.schema.identity.ConsumerType.valueOf(type_);
    return result == null ? io.bloombox.schema.identity.ConsumerType.UNRECOGNIZED : result;
  }

  public static final int REFERRAL_SOURCE_FIELD_NUMBER = 7;
  private int referralSource_;
  /**
   * <pre>
   * Specifies referral source attribution information.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
   */
  public int getReferralSourceValue() {
    return referralSource_;
  }
  /**
   * <pre>
   * Specifies referral source attribution information.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
   */
  public io.bloombox.schema.identity.ReferralSource getReferralSource() {
    io.bloombox.schema.identity.ReferralSource result = io.bloombox.schema.identity.ReferralSource.valueOf(referralSource_);
    return result == null ? io.bloombox.schema.identity.ReferralSource.UNRECOGNIZED : result;
  }

  public static final int REFERRAL_DETAIL_FIELD_NUMBER = 8;
  private volatile java.lang.Object referralDetail_;
  /**
   * <pre>
   * Specifies the referrer's name.
   * </pre>
   *
   * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
   */
  public java.lang.String getReferralDetail() {
    java.lang.Object ref = referralDetail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      referralDetail_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Specifies the referrer's name.
   * </pre>
   *
   * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
   */
  public com.google.protobuf.ByteString
      getReferralDetailBytes() {
    java.lang.Object ref = referralDetail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      referralDetail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (active_ != false) {
      output.writeBool(1, active_);
    }
    for (int i = 0; i < favoriteDispensaries_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, favoriteDispensaries_.getRaw(i));
    }
    if (enrollmentSource_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, enrollmentSource_);
    }
    if (!getEnrollmentChannelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, enrollmentChannel_);
    }
    if (preferences_ != null) {
      output.writeMessage(5, getPreferences());
    }
    if (type_ != io.bloombox.schema.identity.ConsumerType.UNVALIDATED.getNumber()) {
      output.writeEnum(6, type_);
    }
    if (referralSource_ != io.bloombox.schema.identity.ReferralSource.UNKNOWN.getNumber()) {
      output.writeEnum(7, referralSource_);
    }
    if (!getReferralDetailBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, referralDetail_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (active_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, active_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < favoriteDispensaries_.size(); i++) {
        dataSize += computeStringSizeNoTag(favoriteDispensaries_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFavoriteDispensariesList().size();
    }
    if (enrollmentSource_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, enrollmentSource_);
    }
    if (!getEnrollmentChannelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, enrollmentChannel_);
    }
    if (preferences_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getPreferences());
    }
    if (type_ != io.bloombox.schema.identity.ConsumerType.UNVALIDATED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, type_);
    }
    if (referralSource_ != io.bloombox.schema.identity.ReferralSource.UNKNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, referralSource_);
    }
    if (!getReferralDetailBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, referralDetail_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.ConsumerProfile)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.ConsumerProfile other = (io.bloombox.schema.identity.ConsumerProfile) obj;

    boolean result = true;
    result = result && (getActive()
        == other.getActive());
    result = result && getFavoriteDispensariesList()
        .equals(other.getFavoriteDispensariesList());
    result = result && enrollmentSource_ == other.enrollmentSource_;
    result = result && getEnrollmentChannel()
        .equals(other.getEnrollmentChannel());
    result = result && (hasPreferences() == other.hasPreferences());
    if (hasPreferences()) {
      result = result && getPreferences()
          .equals(other.getPreferences());
    }
    result = result && type_ == other.type_;
    result = result && referralSource_ == other.referralSource_;
    result = result && getReferralDetail()
        .equals(other.getReferralDetail());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getActive());
    if (getFavoriteDispensariesCount() > 0) {
      hash = (37 * hash) + FAVORITE_DISPENSARIES_FIELD_NUMBER;
      hash = (53 * hash) + getFavoriteDispensariesList().hashCode();
    }
    hash = (37 * hash) + ENROLLMENT_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + enrollmentSource_;
    hash = (37 * hash) + ENROLLMENT_CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + getEnrollmentChannel().hashCode();
    if (hasPreferences()) {
      hash = (37 * hash) + PREFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + getPreferences().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + REFERRAL_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + referralSource_;
    hash = (37 * hash) + REFERRAL_DETAIL_FIELD_NUMBER;
    hash = (53 * hash) + getReferralDetail().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ConsumerProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.ConsumerProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * User profile information for a cannabis consumer.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.ConsumerProfile}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.ConsumerProfile)
      io.bloombox.schema.identity.ConsumerProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerProfile_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.ConsumerProfile.class, io.bloombox.schema.identity.ConsumerProfile.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.ConsumerProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      active_ = false;

      favoriteDispensaries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      enrollmentSource_ = 0;

      enrollmentChannel_ = "";

      if (preferencesBuilder_ == null) {
        preferences_ = null;
      } else {
        preferences_ = null;
        preferencesBuilder_ = null;
      }
      type_ = 0;

      referralSource_ = 0;

      referralDetail_ = "";

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_ConsumerProfile_descriptor;
    }

    public io.bloombox.schema.identity.ConsumerProfile getDefaultInstanceForType() {
      return io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance();
    }

    public io.bloombox.schema.identity.ConsumerProfile build() {
      io.bloombox.schema.identity.ConsumerProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.ConsumerProfile buildPartial() {
      io.bloombox.schema.identity.ConsumerProfile result = new io.bloombox.schema.identity.ConsumerProfile(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.active_ = active_;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        favoriteDispensaries_ = favoriteDispensaries_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.favoriteDispensaries_ = favoriteDispensaries_;
      result.enrollmentSource_ = enrollmentSource_;
      result.enrollmentChannel_ = enrollmentChannel_;
      if (preferencesBuilder_ == null) {
        result.preferences_ = preferences_;
      } else {
        result.preferences_ = preferencesBuilder_.build();
      }
      result.type_ = type_;
      result.referralSource_ = referralSource_;
      result.referralDetail_ = referralDetail_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.ConsumerProfile) {
        return mergeFrom((io.bloombox.schema.identity.ConsumerProfile)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.ConsumerProfile other) {
      if (other == io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance()) return this;
      if (other.getActive() != false) {
        setActive(other.getActive());
      }
      if (!other.favoriteDispensaries_.isEmpty()) {
        if (favoriteDispensaries_.isEmpty()) {
          favoriteDispensaries_ = other.favoriteDispensaries_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureFavoriteDispensariesIsMutable();
          favoriteDispensaries_.addAll(other.favoriteDispensaries_);
        }
        onChanged();
      }
      if (other.enrollmentSource_ != 0) {
        setEnrollmentSourceValue(other.getEnrollmentSourceValue());
      }
      if (!other.getEnrollmentChannel().isEmpty()) {
        enrollmentChannel_ = other.enrollmentChannel_;
        onChanged();
      }
      if (other.hasPreferences()) {
        mergePreferences(other.getPreferences());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.referralSource_ != 0) {
        setReferralSourceValue(other.getReferralSourceValue());
      }
      if (!other.getReferralDetail().isEmpty()) {
        referralDetail_ = other.referralDetail_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.ConsumerProfile parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.ConsumerProfile) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private boolean active_ ;
    /**
     * <pre>
     * Profile active/inactive flag.
     * </pre>
     *
     * <code>bool active = 1 [(.gen_bq_schema.description) = "Profile active/inactive flag."];</code>
     */
    public boolean getActive() {
      return active_;
    }
    /**
     * <pre>
     * Profile active/inactive flag.
     * </pre>
     *
     * <code>bool active = 1 [(.gen_bq_schema.description) = "Profile active/inactive flag."];</code>
     */
    public Builder setActive(boolean value) {
      
      active_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Profile active/inactive flag.
     * </pre>
     *
     * <code>bool active = 1 [(.gen_bq_schema.description) = "Profile active/inactive flag."];</code>
     */
    public Builder clearActive() {
      
      active_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList favoriteDispensaries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensureFavoriteDispensariesIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        favoriteDispensaries_ = new com.google.protobuf.LazyStringArrayList(favoriteDispensaries_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFavoriteDispensariesList() {
      return favoriteDispensaries_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public int getFavoriteDispensariesCount() {
      return favoriteDispensaries_.size();
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public java.lang.String getFavoriteDispensaries(int index) {
      return favoriteDispensaries_.get(index);
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public com.google.protobuf.ByteString
        getFavoriteDispensariesBytes(int index) {
      return favoriteDispensaries_.getByteString(index);
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public Builder setFavoriteDispensaries(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFavoriteDispensariesIsMutable();
      favoriteDispensaries_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public Builder addFavoriteDispensaries(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensureFavoriteDispensariesIsMutable();
      favoriteDispensaries_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public Builder addAllFavoriteDispensaries(
        java.lang.Iterable<java.lang.String> values) {
      ensureFavoriteDispensariesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, favoriteDispensaries_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public Builder clearFavoriteDispensaries() {
      favoriteDispensaries_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enumerates favorite dispensaries for a user.
     * </pre>
     *
     * <code>repeated string favorite_dispensaries = 2 [(.gen_bq_schema.description) = "Enumerates favorite dispensaries for a user."];</code>
     */
    public Builder addFavoriteDispensariesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensureFavoriteDispensariesIsMutable();
      favoriteDispensaries_.add(value);
      onChanged();
      return this;
    }

    private int enrollmentSource_ = 0;
    /**
     * <pre>
     * Specifies enrollment source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
     */
    public int getEnrollmentSourceValue() {
      return enrollmentSource_;
    }
    /**
     * <pre>
     * Specifies enrollment source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
     */
    public Builder setEnrollmentSourceValue(int value) {
      enrollmentSource_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies enrollment source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
     */
    public io.bloombox.schema.identity.EnrollmentSource getEnrollmentSource() {
      io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(enrollmentSource_);
      return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies enrollment source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
     */
    public Builder setEnrollmentSource(io.bloombox.schema.identity.EnrollmentSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      enrollmentSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies enrollment source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource enrollment_source = 3 [(.gen_bq_schema.description) = "Specifies enrollment source attribution information."];</code>
     */
    public Builder clearEnrollmentSource() {
      
      enrollmentSource_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object enrollmentChannel_ = "";
    /**
     * <pre>
     * Arbitrary string for the channel through which this user enrolled.
     * </pre>
     *
     * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
     */
    public java.lang.String getEnrollmentChannel() {
      java.lang.Object ref = enrollmentChannel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        enrollmentChannel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Arbitrary string for the channel through which this user enrolled.
     * </pre>
     *
     * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
     */
    public com.google.protobuf.ByteString
        getEnrollmentChannelBytes() {
      java.lang.Object ref = enrollmentChannel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        enrollmentChannel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Arbitrary string for the channel through which this user enrolled.
     * </pre>
     *
     * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
     */
    public Builder setEnrollmentChannel(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      enrollmentChannel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Arbitrary string for the channel through which this user enrolled.
     * </pre>
     *
     * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
     */
    public Builder clearEnrollmentChannel() {
      
      enrollmentChannel_ = getDefaultInstance().getEnrollmentChannel();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Arbitrary string for the channel through which this user enrolled.
     * </pre>
     *
     * <code>string enrollment_channel = 4 [(.gen_bq_schema.description) = "Arbitrary string for the channel through which this user enrolled."];</code>
     */
    public Builder setEnrollmentChannelBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      enrollmentChannel_ = value;
      onChanged();
      return this;
    }

    private io.bloombox.schema.identity.ConsumerPreferences preferences_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ConsumerPreferences, io.bloombox.schema.identity.ConsumerPreferences.Builder, io.bloombox.schema.identity.ConsumerPreferencesOrBuilder> preferencesBuilder_;
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public boolean hasPreferences() {
      return preferencesBuilder_ != null || preferences_ != null;
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public io.bloombox.schema.identity.ConsumerPreferences getPreferences() {
      if (preferencesBuilder_ == null) {
        return preferences_ == null ? io.bloombox.schema.identity.ConsumerPreferences.getDefaultInstance() : preferences_;
      } else {
        return preferencesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public Builder setPreferences(io.bloombox.schema.identity.ConsumerPreferences value) {
      if (preferencesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preferences_ = value;
        onChanged();
      } else {
        preferencesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public Builder setPreferences(
        io.bloombox.schema.identity.ConsumerPreferences.Builder builderForValue) {
      if (preferencesBuilder_ == null) {
        preferences_ = builderForValue.build();
        onChanged();
      } else {
        preferencesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public Builder mergePreferences(io.bloombox.schema.identity.ConsumerPreferences value) {
      if (preferencesBuilder_ == null) {
        if (preferences_ != null) {
          preferences_ =
            io.bloombox.schema.identity.ConsumerPreferences.newBuilder(preferences_).mergeFrom(value).buildPartial();
        } else {
          preferences_ = value;
        }
        onChanged();
      } else {
        preferencesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public Builder clearPreferences() {
      if (preferencesBuilder_ == null) {
        preferences_ = null;
        onChanged();
      } else {
        preferences_ = null;
        preferencesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public io.bloombox.schema.identity.ConsumerPreferences.Builder getPreferencesBuilder() {
      
      onChanged();
      return getPreferencesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    public io.bloombox.schema.identity.ConsumerPreferencesOrBuilder getPreferencesOrBuilder() {
      if (preferencesBuilder_ != null) {
        return preferencesBuilder_.getMessageOrBuilder();
      } else {
        return preferences_ == null ?
            io.bloombox.schema.identity.ConsumerPreferences.getDefaultInstance() : preferences_;
      }
    }
    /**
     * <pre>
     * Preferences attached to a consumer account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerPreferences preferences = 5 [(.gen_bq_schema.description) = "Preferences attached to a consumer account."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ConsumerPreferences, io.bloombox.schema.identity.ConsumerPreferences.Builder, io.bloombox.schema.identity.ConsumerPreferencesOrBuilder> 
        getPreferencesFieldBuilder() {
      if (preferencesBuilder_ == null) {
        preferencesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.ConsumerPreferences, io.bloombox.schema.identity.ConsumerPreferences.Builder, io.bloombox.schema.identity.ConsumerPreferencesOrBuilder>(
                getPreferences(),
                getParentForChildren(),
                isClean());
        preferences_ = null;
      }
      return preferencesBuilder_;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Specifies the primary consumer type for this account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specifies the primary consumer type for this account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the primary consumer type for this account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
     */
    public io.bloombox.schema.identity.ConsumerType getType() {
      io.bloombox.schema.identity.ConsumerType result = io.bloombox.schema.identity.ConsumerType.valueOf(type_);
      return result == null ? io.bloombox.schema.identity.ConsumerType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the primary consumer type for this account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
     */
    public Builder setType(io.bloombox.schema.identity.ConsumerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the primary consumer type for this account.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerType type = 6 [(.gen_bq_schema.description) = "Specifies the primary consumer type for this account."];</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private int referralSource_ = 0;
    /**
     * <pre>
     * Specifies referral source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
     */
    public int getReferralSourceValue() {
      return referralSource_;
    }
    /**
     * <pre>
     * Specifies referral source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
     */
    public Builder setReferralSourceValue(int value) {
      referralSource_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies referral source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
     */
    public io.bloombox.schema.identity.ReferralSource getReferralSource() {
      io.bloombox.schema.identity.ReferralSource result = io.bloombox.schema.identity.ReferralSource.valueOf(referralSource_);
      return result == null ? io.bloombox.schema.identity.ReferralSource.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies referral source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
     */
    public Builder setReferralSource(io.bloombox.schema.identity.ReferralSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      referralSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies referral source attribution information.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ReferralSource referral_source = 7 [(.gen_bq_schema.description) = "Specifies referral source attribution information."];</code>
     */
    public Builder clearReferralSource() {
      
      referralSource_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object referralDetail_ = "";
    /**
     * <pre>
     * Specifies the referrer's name.
     * </pre>
     *
     * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
     */
    public java.lang.String getReferralDetail() {
      java.lang.Object ref = referralDetail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referralDetail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Specifies the referrer's name.
     * </pre>
     *
     * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
     */
    public com.google.protobuf.ByteString
        getReferralDetailBytes() {
      java.lang.Object ref = referralDetail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referralDetail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Specifies the referrer's name.
     * </pre>
     *
     * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
     */
    public Builder setReferralDetail(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      referralDetail_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the referrer's name.
     * </pre>
     *
     * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
     */
    public Builder clearReferralDetail() {
      
      referralDetail_ = getDefaultInstance().getReferralDetail();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the referrer's name.
     * </pre>
     *
     * <code>string referral_detail = 8 [(.gen_bq_schema.description) = "Specifies the referrer&#92;'s name."];</code>
     */
    public Builder setReferralDetailBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      referralDetail_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.ConsumerProfile)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.ConsumerProfile)
  private static final io.bloombox.schema.identity.ConsumerProfile DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.ConsumerProfile();
  }

  public static io.bloombox.schema.identity.ConsumerProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConsumerProfile>
      PARSER = new com.google.protobuf.AbstractParser<ConsumerProfile>() {
    public ConsumerProfile parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ConsumerProfile(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ConsumerProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConsumerProfile> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.ConsumerProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

