/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Specifies the type of consumer profile in use for an account.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.identity.ConsumerType}
 */
public enum ConsumerType
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * The consumer type is not yet determined.
   * </pre>
   *
   * <code>UNVALIDATED = 0;</code>
   */
  UNVALIDATED(0),
  /**
   * <pre>
   * The consumer is a recreational user.
   * </pre>
   *
   * <code>RECREATIONAL = 1;</code>
   */
  RECREATIONAL(1),
  /**
   * <pre>
   * The consumer is a validated medical user. Considered a superset of 'RECREATIONAL'.
   * </pre>
   *
   * <code>MEDICAL = 2;</code>
   */
  MEDICAL(2),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * The consumer type is not yet determined.
   * </pre>
   *
   * <code>UNVALIDATED = 0;</code>
   */
  public static final int UNVALIDATED_VALUE = 0;
  /**
   * <pre>
   * The consumer is a recreational user.
   * </pre>
   *
   * <code>RECREATIONAL = 1;</code>
   */
  public static final int RECREATIONAL_VALUE = 1;
  /**
   * <pre>
   * The consumer is a validated medical user. Considered a superset of 'RECREATIONAL'.
   * </pre>
   *
   * <code>MEDICAL = 2;</code>
   */
  public static final int MEDICAL_VALUE = 2;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ConsumerType valueOf(int value) {
    return forNumber(value);
  }

  public static ConsumerType forNumber(int value) {
    switch (value) {
      case 0: return UNVALIDATED;
      case 1: return RECREATIONAL;
      case 2: return MEDICAL;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ConsumerType>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      ConsumerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ConsumerType>() {
          public ConsumerType findValueByNumber(int number) {
            return ConsumerType.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.getDescriptor().getEnumTypes().get(4);
  }

  private static final ConsumerType[] VALUES = values();

  public static ConsumerType valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ConsumerType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.identity.ConsumerType)
}

