/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/ID.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Specifies an object for expressing a user's government ID information.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.ID}
 */
public  final class ID extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.ID)
    IDOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ID.newBuilder() to construct.
  private ID(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ID() {
    type_ = 0;
    id_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ID(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 26: {
            io.opencannabis.schema.temporal.Date.Builder subBuilder = null;
            if (expireDate_ != null) {
              subBuilder = expireDate_.toBuilder();
            }
            expireDate_ = input.readMessage(io.opencannabis.schema.temporal.Date.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(expireDate_);
              expireDate_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.temporal.Date.Builder subBuilder = null;
            if (birthDate_ != null) {
              subBuilder = birthDate_.toBuilder();
            }
            birthDate_ = input.readMessage(io.opencannabis.schema.temporal.Date.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(birthDate_);
              birthDate_ = subBuilder.buildPartial();
            }

            break;
          }
          case 162: {
            io.bloombox.schema.identity.ids.USDL.Builder subBuilder = null;
            if (documentCase_ == 20) {
              subBuilder = ((io.bloombox.schema.identity.ids.USDL) document_).toBuilder();
            }
            document_ =
                input.readMessage(io.bloombox.schema.identity.ids.USDL.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.identity.ids.USDL) document_);
              document_ = subBuilder.buildPartial();
            }
            documentCase_ = 20;
            break;
          }
          case 170: {
            io.bloombox.schema.identity.ids.Passport.Builder subBuilder = null;
            if (documentCase_ == 21) {
              subBuilder = ((io.bloombox.schema.identity.ids.Passport) document_).toBuilder();
            }
            document_ =
                input.readMessage(io.bloombox.schema.identity.ids.Passport.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.identity.ids.Passport) document_);
              document_ = subBuilder.buildPartial();
            }
            documentCase_ = 21;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.IDOuterClass.internal_static_bloombox_schema_identity_ID_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.IDOuterClass.internal_static_bloombox_schema_identity_ID_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.ID.class, io.bloombox.schema.identity.ID.Builder.class);
  }

  private int documentCase_ = 0;
  private java.lang.Object document_;
  public enum DocumentCase
      implements com.google.protobuf.Internal.EnumLite {
    LICENSE(20),
    PASSPORT(21),
    DOCUMENT_NOT_SET(0);
    private final int value;
    private DocumentCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DocumentCase valueOf(int value) {
      return forNumber(value);
    }

    public static DocumentCase forNumber(int value) {
      switch (value) {
        case 20: return LICENSE;
        case 21: return PASSPORT;
        case 0: return DOCUMENT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public DocumentCase
  getDocumentCase() {
    return DocumentCase.forNumber(
        documentCase_);
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_;
  /**
   * <pre>
   * Type of ID we're specifying.
   * </pre>
   *
   * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Type of ID we're specifying.
   * </pre>
   *
   * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
   */
  public io.bloombox.schema.identity.IDType getType() {
    io.bloombox.schema.identity.IDType result = io.bloombox.schema.identity.IDType.valueOf(type_);
    return result == null ? io.bloombox.schema.identity.IDType.UNRECOGNIZED : result;
  }

  public static final int ID_FIELD_NUMBER = 2;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * ID number or string identifying this identity document.
   * </pre>
   *
   * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * ID number or string identifying this identity document.
   * </pre>
   *
   * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_DATE_FIELD_NUMBER = 3;
  private io.opencannabis.schema.temporal.Date expireDate_;
  /**
   * <pre>
   * Expiration date for this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
   */
  public boolean hasExpireDate() {
    return expireDate_ != null;
  }
  /**
   * <pre>
   * Expiration date for this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
   */
  public io.opencannabis.schema.temporal.Date getExpireDate() {
    return expireDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : expireDate_;
  }
  /**
   * <pre>
   * Expiration date for this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
   */
  public io.opencannabis.schema.temporal.DateOrBuilder getExpireDateOrBuilder() {
    return getExpireDate();
  }

  public static final int BIRTH_DATE_FIELD_NUMBER = 4;
  private io.opencannabis.schema.temporal.Date birthDate_;
  /**
   * <pre>
   * Birth date listed on this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
   */
  public boolean hasBirthDate() {
    return birthDate_ != null;
  }
  /**
   * <pre>
   * Birth date listed on this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
   */
  public io.opencannabis.schema.temporal.Date getBirthDate() {
    return birthDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : birthDate_;
  }
  /**
   * <pre>
   * Birth date listed on this document.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
   */
  public io.opencannabis.schema.temporal.DateOrBuilder getBirthDateOrBuilder() {
    return getBirthDate();
  }

  public static final int LICENSE_FIELD_NUMBER = 20;
  /**
   * <pre>
   * United States Driver's License.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
   */
  public boolean hasLicense() {
    return documentCase_ == 20;
  }
  /**
   * <pre>
   * United States Driver's License.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
   */
  public io.bloombox.schema.identity.ids.USDL getLicense() {
    if (documentCase_ == 20) {
       return (io.bloombox.schema.identity.ids.USDL) document_;
    }
    return io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
  }
  /**
   * <pre>
   * United States Driver's License.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
   */
  public io.bloombox.schema.identity.ids.USDLOrBuilder getLicenseOrBuilder() {
    if (documentCase_ == 20) {
       return (io.bloombox.schema.identity.ids.USDL) document_;
    }
    return io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
  }

  public static final int PASSPORT_FIELD_NUMBER = 21;
  /**
   * <pre>
   * National passport.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
   */
  public boolean hasPassport() {
    return documentCase_ == 21;
  }
  /**
   * <pre>
   * National passport.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
   */
  public io.bloombox.schema.identity.ids.Passport getPassport() {
    if (documentCase_ == 21) {
       return (io.bloombox.schema.identity.ids.Passport) document_;
    }
    return io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
  }
  /**
   * <pre>
   * National passport.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
   */
  public io.bloombox.schema.identity.ids.PassportOrBuilder getPassportOrBuilder() {
    if (documentCase_ == 21) {
       return (io.bloombox.schema.identity.ids.Passport) document_;
    }
    return io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (type_ != io.bloombox.schema.identity.IDType.USDL.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, id_);
    }
    if (expireDate_ != null) {
      output.writeMessage(3, getExpireDate());
    }
    if (birthDate_ != null) {
      output.writeMessage(4, getBirthDate());
    }
    if (documentCase_ == 20) {
      output.writeMessage(20, (io.bloombox.schema.identity.ids.USDL) document_);
    }
    if (documentCase_ == 21) {
      output.writeMessage(21, (io.bloombox.schema.identity.ids.Passport) document_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != io.bloombox.schema.identity.IDType.USDL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, type_);
    }
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, id_);
    }
    if (expireDate_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getExpireDate());
    }
    if (birthDate_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getBirthDate());
    }
    if (documentCase_ == 20) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(20, (io.bloombox.schema.identity.ids.USDL) document_);
    }
    if (documentCase_ == 21) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(21, (io.bloombox.schema.identity.ids.Passport) document_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.ID)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.ID other = (io.bloombox.schema.identity.ID) obj;

    boolean result = true;
    result = result && type_ == other.type_;
    result = result && getId()
        .equals(other.getId());
    result = result && (hasExpireDate() == other.hasExpireDate());
    if (hasExpireDate()) {
      result = result && getExpireDate()
          .equals(other.getExpireDate());
    }
    result = result && (hasBirthDate() == other.hasBirthDate());
    if (hasBirthDate()) {
      result = result && getBirthDate()
          .equals(other.getBirthDate());
    }
    result = result && getDocumentCase().equals(
        other.getDocumentCase());
    if (!result) return false;
    switch (documentCase_) {
      case 20:
        result = result && getLicense()
            .equals(other.getLicense());
        break;
      case 21:
        result = result && getPassport()
            .equals(other.getPassport());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (hasExpireDate()) {
      hash = (37 * hash) + EXPIRE_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getExpireDate().hashCode();
    }
    if (hasBirthDate()) {
      hash = (37 * hash) + BIRTH_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getBirthDate().hashCode();
    }
    switch (documentCase_) {
      case 20:
        hash = (37 * hash) + LICENSE_FIELD_NUMBER;
        hash = (53 * hash) + getLicense().hashCode();
        break;
      case 21:
        hash = (37 * hash) + PASSPORT_FIELD_NUMBER;
        hash = (53 * hash) + getPassport().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.ID parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ID parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ID parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ID parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ID parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ID parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.ID prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an object for expressing a user's government ID information.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.ID}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.ID)
      io.bloombox.schema.identity.IDOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.IDOuterClass.internal_static_bloombox_schema_identity_ID_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.IDOuterClass.internal_static_bloombox_schema_identity_ID_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.ID.class, io.bloombox.schema.identity.ID.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.ID.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      type_ = 0;

      id_ = "";

      if (expireDateBuilder_ == null) {
        expireDate_ = null;
      } else {
        expireDate_ = null;
        expireDateBuilder_ = null;
      }
      if (birthDateBuilder_ == null) {
        birthDate_ = null;
      } else {
        birthDate_ = null;
        birthDateBuilder_ = null;
      }
      documentCase_ = 0;
      document_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.IDOuterClass.internal_static_bloombox_schema_identity_ID_descriptor;
    }

    public io.bloombox.schema.identity.ID getDefaultInstanceForType() {
      return io.bloombox.schema.identity.ID.getDefaultInstance();
    }

    public io.bloombox.schema.identity.ID build() {
      io.bloombox.schema.identity.ID result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.ID buildPartial() {
      io.bloombox.schema.identity.ID result = new io.bloombox.schema.identity.ID(this);
      result.type_ = type_;
      result.id_ = id_;
      if (expireDateBuilder_ == null) {
        result.expireDate_ = expireDate_;
      } else {
        result.expireDate_ = expireDateBuilder_.build();
      }
      if (birthDateBuilder_ == null) {
        result.birthDate_ = birthDate_;
      } else {
        result.birthDate_ = birthDateBuilder_.build();
      }
      if (documentCase_ == 20) {
        if (licenseBuilder_ == null) {
          result.document_ = document_;
        } else {
          result.document_ = licenseBuilder_.build();
        }
      }
      if (documentCase_ == 21) {
        if (passportBuilder_ == null) {
          result.document_ = document_;
        } else {
          result.document_ = passportBuilder_.build();
        }
      }
      result.documentCase_ = documentCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.ID) {
        return mergeFrom((io.bloombox.schema.identity.ID)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.ID other) {
      if (other == io.bloombox.schema.identity.ID.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (other.hasExpireDate()) {
        mergeExpireDate(other.getExpireDate());
      }
      if (other.hasBirthDate()) {
        mergeBirthDate(other.getBirthDate());
      }
      switch (other.getDocumentCase()) {
        case LICENSE: {
          mergeLicense(other.getLicense());
          break;
        }
        case PASSPORT: {
          mergePassport(other.getPassport());
          break;
        }
        case DOCUMENT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.ID parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.ID) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int documentCase_ = 0;
    private java.lang.Object document_;
    public DocumentCase
        getDocumentCase() {
      return DocumentCase.forNumber(
          documentCase_);
    }

    public Builder clearDocument() {
      documentCase_ = 0;
      document_ = null;
      onChanged();
      return this;
    }


    private int type_ = 0;
    /**
     * <pre>
     * Type of ID we're specifying.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of ID we're specifying.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of ID we're specifying.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
     */
    public io.bloombox.schema.identity.IDType getType() {
      io.bloombox.schema.identity.IDType result = io.bloombox.schema.identity.IDType.valueOf(type_);
      return result == null ? io.bloombox.schema.identity.IDType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Type of ID we're specifying.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
     */
    public Builder setType(io.bloombox.schema.identity.IDType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of ID we're specifying.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IDType type = 1 [(.gen_bq_schema.description) = "Type of ID we&#92;'re specifying."];</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * ID number or string identifying this identity document.
     * </pre>
     *
     * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * ID number or string identifying this identity document.
     * </pre>
     *
     * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * ID number or string identifying this identity document.
     * </pre>
     *
     * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID number or string identifying this identity document.
     * </pre>
     *
     * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID number or string identifying this identity document.
     * </pre>
     *
     * <code>string id = 2 [(.gen_bq_schema.description) = "ID number or string identifying this identity document."];</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Date expireDate_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> expireDateBuilder_;
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public boolean hasExpireDate() {
      return expireDateBuilder_ != null || expireDate_ != null;
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public io.opencannabis.schema.temporal.Date getExpireDate() {
      if (expireDateBuilder_ == null) {
        return expireDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : expireDate_;
      } else {
        return expireDateBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public Builder setExpireDate(io.opencannabis.schema.temporal.Date value) {
      if (expireDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireDate_ = value;
        onChanged();
      } else {
        expireDateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public Builder setExpireDate(
        io.opencannabis.schema.temporal.Date.Builder builderForValue) {
      if (expireDateBuilder_ == null) {
        expireDate_ = builderForValue.build();
        onChanged();
      } else {
        expireDateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public Builder mergeExpireDate(io.opencannabis.schema.temporal.Date value) {
      if (expireDateBuilder_ == null) {
        if (expireDate_ != null) {
          expireDate_ =
            io.opencannabis.schema.temporal.Date.newBuilder(expireDate_).mergeFrom(value).buildPartial();
        } else {
          expireDate_ = value;
        }
        onChanged();
      } else {
        expireDateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public Builder clearExpireDate() {
      if (expireDateBuilder_ == null) {
        expireDate_ = null;
        onChanged();
      } else {
        expireDate_ = null;
        expireDateBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public io.opencannabis.schema.temporal.Date.Builder getExpireDateBuilder() {
      
      onChanged();
      return getExpireDateFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    public io.opencannabis.schema.temporal.DateOrBuilder getExpireDateOrBuilder() {
      if (expireDateBuilder_ != null) {
        return expireDateBuilder_.getMessageOrBuilder();
      } else {
        return expireDate_ == null ?
            io.opencannabis.schema.temporal.Date.getDefaultInstance() : expireDate_;
      }
    }
    /**
     * <pre>
     * Expiration date for this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expire_date = 3 [(.gen_bq_schema.description) = "Expiration date for this document."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> 
        getExpireDateFieldBuilder() {
      if (expireDateBuilder_ == null) {
        expireDateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder>(
                getExpireDate(),
                getParentForChildren(),
                isClean());
        expireDate_ = null;
      }
      return expireDateBuilder_;
    }

    private io.opencannabis.schema.temporal.Date birthDate_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> birthDateBuilder_;
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public boolean hasBirthDate() {
      return birthDateBuilder_ != null || birthDate_ != null;
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public io.opencannabis.schema.temporal.Date getBirthDate() {
      if (birthDateBuilder_ == null) {
        return birthDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : birthDate_;
      } else {
        return birthDateBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public Builder setBirthDate(io.opencannabis.schema.temporal.Date value) {
      if (birthDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        birthDate_ = value;
        onChanged();
      } else {
        birthDateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public Builder setBirthDate(
        io.opencannabis.schema.temporal.Date.Builder builderForValue) {
      if (birthDateBuilder_ == null) {
        birthDate_ = builderForValue.build();
        onChanged();
      } else {
        birthDateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public Builder mergeBirthDate(io.opencannabis.schema.temporal.Date value) {
      if (birthDateBuilder_ == null) {
        if (birthDate_ != null) {
          birthDate_ =
            io.opencannabis.schema.temporal.Date.newBuilder(birthDate_).mergeFrom(value).buildPartial();
        } else {
          birthDate_ = value;
        }
        onChanged();
      } else {
        birthDateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public Builder clearBirthDate() {
      if (birthDateBuilder_ == null) {
        birthDate_ = null;
        onChanged();
      } else {
        birthDate_ = null;
        birthDateBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public io.opencannabis.schema.temporal.Date.Builder getBirthDateBuilder() {
      
      onChanged();
      return getBirthDateFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    public io.opencannabis.schema.temporal.DateOrBuilder getBirthDateOrBuilder() {
      if (birthDateBuilder_ != null) {
        return birthDateBuilder_.getMessageOrBuilder();
      } else {
        return birthDate_ == null ?
            io.opencannabis.schema.temporal.Date.getDefaultInstance() : birthDate_;
      }
    }
    /**
     * <pre>
     * Birth date listed on this document.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date birth_date = 4 [(.gen_bq_schema.description) = "Birth date listed on this document."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> 
        getBirthDateFieldBuilder() {
      if (birthDateBuilder_ == null) {
        birthDateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder>(
                getBirthDate(),
                getParentForChildren(),
                isClean());
        birthDate_ = null;
      }
      return birthDateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ids.USDL, io.bloombox.schema.identity.ids.USDL.Builder, io.bloombox.schema.identity.ids.USDLOrBuilder> licenseBuilder_;
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public boolean hasLicense() {
      return documentCase_ == 20;
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public io.bloombox.schema.identity.ids.USDL getLicense() {
      if (licenseBuilder_ == null) {
        if (documentCase_ == 20) {
          return (io.bloombox.schema.identity.ids.USDL) document_;
        }
        return io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
      } else {
        if (documentCase_ == 20) {
          return licenseBuilder_.getMessage();
        }
        return io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public Builder setLicense(io.bloombox.schema.identity.ids.USDL value) {
      if (licenseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
        onChanged();
      } else {
        licenseBuilder_.setMessage(value);
      }
      documentCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public Builder setLicense(
        io.bloombox.schema.identity.ids.USDL.Builder builderForValue) {
      if (licenseBuilder_ == null) {
        document_ = builderForValue.build();
        onChanged();
      } else {
        licenseBuilder_.setMessage(builderForValue.build());
      }
      documentCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public Builder mergeLicense(io.bloombox.schema.identity.ids.USDL value) {
      if (licenseBuilder_ == null) {
        if (documentCase_ == 20 &&
            document_ != io.bloombox.schema.identity.ids.USDL.getDefaultInstance()) {
          document_ = io.bloombox.schema.identity.ids.USDL.newBuilder((io.bloombox.schema.identity.ids.USDL) document_)
              .mergeFrom(value).buildPartial();
        } else {
          document_ = value;
        }
        onChanged();
      } else {
        if (documentCase_ == 20) {
          licenseBuilder_.mergeFrom(value);
        }
        licenseBuilder_.setMessage(value);
      }
      documentCase_ = 20;
      return this;
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public Builder clearLicense() {
      if (licenseBuilder_ == null) {
        if (documentCase_ == 20) {
          documentCase_ = 0;
          document_ = null;
          onChanged();
        }
      } else {
        if (documentCase_ == 20) {
          documentCase_ = 0;
          document_ = null;
        }
        licenseBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public io.bloombox.schema.identity.ids.USDL.Builder getLicenseBuilder() {
      return getLicenseFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    public io.bloombox.schema.identity.ids.USDLOrBuilder getLicenseOrBuilder() {
      if ((documentCase_ == 20) && (licenseBuilder_ != null)) {
        return licenseBuilder_.getMessageOrBuilder();
      } else {
        if (documentCase_ == 20) {
          return (io.bloombox.schema.identity.ids.USDL) document_;
        }
        return io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * United States Driver's License.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.USDL license = 20 [(.gen_bq_schema.description) = "United States Driver&#92;'s License."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ids.USDL, io.bloombox.schema.identity.ids.USDL.Builder, io.bloombox.schema.identity.ids.USDLOrBuilder> 
        getLicenseFieldBuilder() {
      if (licenseBuilder_ == null) {
        if (!(documentCase_ == 20)) {
          document_ = io.bloombox.schema.identity.ids.USDL.getDefaultInstance();
        }
        licenseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.ids.USDL, io.bloombox.schema.identity.ids.USDL.Builder, io.bloombox.schema.identity.ids.USDLOrBuilder>(
                (io.bloombox.schema.identity.ids.USDL) document_,
                getParentForChildren(),
                isClean());
        document_ = null;
      }
      documentCase_ = 20;
      onChanged();;
      return licenseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ids.Passport, io.bloombox.schema.identity.ids.Passport.Builder, io.bloombox.schema.identity.ids.PassportOrBuilder> passportBuilder_;
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public boolean hasPassport() {
      return documentCase_ == 21;
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public io.bloombox.schema.identity.ids.Passport getPassport() {
      if (passportBuilder_ == null) {
        if (documentCase_ == 21) {
          return (io.bloombox.schema.identity.ids.Passport) document_;
        }
        return io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
      } else {
        if (documentCase_ == 21) {
          return passportBuilder_.getMessage();
        }
        return io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public Builder setPassport(io.bloombox.schema.identity.ids.Passport value) {
      if (passportBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        document_ = value;
        onChanged();
      } else {
        passportBuilder_.setMessage(value);
      }
      documentCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public Builder setPassport(
        io.bloombox.schema.identity.ids.Passport.Builder builderForValue) {
      if (passportBuilder_ == null) {
        document_ = builderForValue.build();
        onChanged();
      } else {
        passportBuilder_.setMessage(builderForValue.build());
      }
      documentCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public Builder mergePassport(io.bloombox.schema.identity.ids.Passport value) {
      if (passportBuilder_ == null) {
        if (documentCase_ == 21 &&
            document_ != io.bloombox.schema.identity.ids.Passport.getDefaultInstance()) {
          document_ = io.bloombox.schema.identity.ids.Passport.newBuilder((io.bloombox.schema.identity.ids.Passport) document_)
              .mergeFrom(value).buildPartial();
        } else {
          document_ = value;
        }
        onChanged();
      } else {
        if (documentCase_ == 21) {
          passportBuilder_.mergeFrom(value);
        }
        passportBuilder_.setMessage(value);
      }
      documentCase_ = 21;
      return this;
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public Builder clearPassport() {
      if (passportBuilder_ == null) {
        if (documentCase_ == 21) {
          documentCase_ = 0;
          document_ = null;
          onChanged();
        }
      } else {
        if (documentCase_ == 21) {
          documentCase_ = 0;
          document_ = null;
        }
        passportBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public io.bloombox.schema.identity.ids.Passport.Builder getPassportBuilder() {
      return getPassportFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    public io.bloombox.schema.identity.ids.PassportOrBuilder getPassportOrBuilder() {
      if ((documentCase_ == 21) && (passportBuilder_ != null)) {
        return passportBuilder_.getMessageOrBuilder();
      } else {
        if (documentCase_ == 21) {
          return (io.bloombox.schema.identity.ids.Passport) document_;
        }
        return io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * National passport.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.Passport passport = 21 [(.gen_bq_schema.description) = "National passport."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ids.Passport, io.bloombox.schema.identity.ids.Passport.Builder, io.bloombox.schema.identity.ids.PassportOrBuilder> 
        getPassportFieldBuilder() {
      if (passportBuilder_ == null) {
        if (!(documentCase_ == 21)) {
          document_ = io.bloombox.schema.identity.ids.Passport.getDefaultInstance();
        }
        passportBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.ids.Passport, io.bloombox.schema.identity.ids.Passport.Builder, io.bloombox.schema.identity.ids.PassportOrBuilder>(
                (io.bloombox.schema.identity.ids.Passport) document_,
                getParentForChildren(),
                isClean());
        document_ = null;
      }
      documentCase_ = 21;
      onChanged();;
      return passportBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.ID)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.ID)
  private static final io.bloombox.schema.identity.ID DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.ID();
  }

  public static io.bloombox.schema.identity.ID getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ID>
      PARSER = new com.google.protobuf.AbstractParser<ID>() {
    public ID parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ID(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ID> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ID> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.ID getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

