/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Enumerates providers through which users may authenticate.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.identity.IdentityProvider}
 */
public enum IdentityProvider
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Email/password-based authentication.
   * </pre>
   *
   * <code>EMAIL = 0;</code>
   */
  EMAIL(0),
  /**
   * <pre>
   * Authentication via Google OpenID/OAuth2.
   * </pre>
   *
   * <code>GOOGLE = 1;</code>
   */
  GOOGLE(1),
  /**
   * <pre>
   * OAuth2 Graph authentication via Facebook.
   * </pre>
   *
   * <code>FACEBOOK = 2;</code>
   */
  FACEBOOK(2),
  /**
   * <pre>
   * OAuth2 account authentication via Twitter.
   * </pre>
   *
   * <code>TWITTER = 3;</code>
   */
  TWITTER(3),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Email/password-based authentication.
   * </pre>
   *
   * <code>EMAIL = 0;</code>
   */
  public static final int EMAIL_VALUE = 0;
  /**
   * <pre>
   * Authentication via Google OpenID/OAuth2.
   * </pre>
   *
   * <code>GOOGLE = 1;</code>
   */
  public static final int GOOGLE_VALUE = 1;
  /**
   * <pre>
   * OAuth2 Graph authentication via Facebook.
   * </pre>
   *
   * <code>FACEBOOK = 2;</code>
   */
  public static final int FACEBOOK_VALUE = 2;
  /**
   * <pre>
   * OAuth2 account authentication via Twitter.
   * </pre>
   *
   * <code>TWITTER = 3;</code>
   */
  public static final int TWITTER_VALUE = 3;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static IdentityProvider valueOf(int value) {
    return forNumber(value);
  }

  public static IdentityProvider forNumber(int value) {
    switch (value) {
      case 0: return EMAIL;
      case 1: return GOOGLE;
      case 2: return FACEBOOK;
      case 3: return TWITTER;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<IdentityProvider>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      IdentityProvider> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IdentityProvider>() {
          public IdentityProvider findValueByNumber(int number) {
            return IdentityProvider.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.getDescriptor().getEnumTypes().get(1);
  }

  private static final IdentityProvider[] VALUES = values();

  public static IdentityProvider valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private IdentityProvider(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.identity.IdentityProvider)
}

