/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Consumer preferences related to menus and products.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.MenuPreferences}
 */
public  final class MenuPreferences extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.MenuPreferences)
    MenuPreferencesOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MenuPreferences.newBuilder() to construct.
  private MenuPreferences(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MenuPreferences() {
    section_ = java.util.Collections.emptyList();
    feeling_ = java.util.Collections.emptyList();
    tasteNote_ = java.util.Collections.emptyList();
    desiredPotency_ = 0;
    cannabinoidRatio_ = 0;
    species_ = java.util.Collections.emptyList();
    grow_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private MenuPreferences(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
              section_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000001;
            }
            section_.add(rawValue);
            break;
          }
          case 10: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                section_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              section_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 16: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              feeling_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000002;
            }
            feeling_.add(rawValue);
            break;
          }
          case 18: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                feeling_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000002;
              }
              feeling_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 24: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              tasteNote_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000004;
            }
            tasteNote_.add(rawValue);
            break;
          }
          case 26: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                tasteNote_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              tasteNote_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            desiredPotency_ = rawValue;
            break;
          }
          case 40: {
            int rawValue = input.readEnum();

            cannabinoidRatio_ = rawValue;
            break;
          }
          case 48: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              species_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000020;
            }
            species_.add(rawValue);
            break;
          }
          case 50: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                species_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000020;
              }
              species_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 56: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
              grow_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000040;
            }
            grow_.add(rawValue);
            break;
          }
          case 58: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                grow_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000040;
              }
              grow_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
        section_ = java.util.Collections.unmodifiableList(section_);
      }
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        feeling_ = java.util.Collections.unmodifiableList(feeling_);
      }
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        tasteNote_ = java.util.Collections.unmodifiableList(tasteNote_);
      }
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        species_ = java.util.Collections.unmodifiableList(species_);
      }
      if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
        grow_ = java.util.Collections.unmodifiableList(grow_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_MenuPreferences_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_MenuPreferences_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.MenuPreferences.class, io.bloombox.schema.identity.MenuPreferences.Builder.class);
  }

  private int bitField0_;
  public static final int SECTION_FIELD_NUMBER = 1;
  private java.util.List<java.lang.Integer> section_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.menu.section.Section> section_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.menu.section.Section>() {
            public io.opencannabis.schema.menu.section.Section convert(java.lang.Integer from) {
              io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(from);
              return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Preferred menu sections or product types.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
   */
  public java.util.List<io.opencannabis.schema.menu.section.Section> getSectionList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.menu.section.Section>(section_, section_converter_);
  }
  /**
   * <pre>
   * Preferred menu sections or product types.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
   */
  public int getSectionCount() {
    return section_.size();
  }
  /**
   * <pre>
   * Preferred menu sections or product types.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
   */
  public io.opencannabis.schema.menu.section.Section getSection(int index) {
    return section_converter_.convert(section_.get(index));
  }
  /**
   * <pre>
   * Preferred menu sections or product types.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
   */
  public java.util.List<java.lang.Integer>
  getSectionValueList() {
    return section_;
  }
  /**
   * <pre>
   * Preferred menu sections or product types.
   * </pre>
   *
   * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
   */
  public int getSectionValue(int index) {
    return section_.get(index);
  }
  private int sectionMemoizedSerializedSize;

  public static final int FEELING_FIELD_NUMBER = 2;
  private java.util.List<java.lang.Integer> feeling_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.testing.Feeling> feeling_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.testing.Feeling>() {
            public io.opencannabis.schema.product.struct.testing.Feeling convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.testing.Feeling result = io.opencannabis.schema.product.struct.testing.Feeling.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.testing.Feeling.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Preferred feelings or experiential states.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.testing.Feeling> getFeelingList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.testing.Feeling>(feeling_, feeling_converter_);
  }
  /**
   * <pre>
   * Preferred feelings or experiential states.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
   */
  public int getFeelingCount() {
    return feeling_.size();
  }
  /**
   * <pre>
   * Preferred feelings or experiential states.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
   */
  public io.opencannabis.schema.product.struct.testing.Feeling getFeeling(int index) {
    return feeling_converter_.convert(feeling_.get(index));
  }
  /**
   * <pre>
   * Preferred feelings or experiential states.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
   */
  public java.util.List<java.lang.Integer>
  getFeelingValueList() {
    return feeling_;
  }
  /**
   * <pre>
   * Preferred feelings or experiential states.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
   */
  public int getFeelingValue(int index) {
    return feeling_.get(index);
  }
  private int feelingMemoizedSerializedSize;

  public static final int TASTE_NOTE_FIELD_NUMBER = 3;
  private java.util.List<java.lang.Integer> tasteNote_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote> tasteNote_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>() {
            public io.opencannabis.schema.product.struct.testing.TasteNote convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.testing.TasteNote result = io.opencannabis.schema.product.struct.testing.TasteNote.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.testing.TasteNote.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Preferred tasting notes.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.testing.TasteNote> getTasteNoteList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>(tasteNote_, tasteNote_converter_);
  }
  /**
   * <pre>
   * Preferred tasting notes.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
   */
  public int getTasteNoteCount() {
    return tasteNote_.size();
  }
  /**
   * <pre>
   * Preferred tasting notes.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
   */
  public io.opencannabis.schema.product.struct.testing.TasteNote getTasteNote(int index) {
    return tasteNote_converter_.convert(tasteNote_.get(index));
  }
  /**
   * <pre>
   * Preferred tasting notes.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
   */
  public java.util.List<java.lang.Integer>
  getTasteNoteValueList() {
    return tasteNote_;
  }
  /**
   * <pre>
   * Preferred tasting notes.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
   */
  public int getTasteNoteValue(int index) {
    return tasteNote_.get(index);
  }
  private int tasteNoteMemoizedSerializedSize;

  public static final int DESIRED_POTENCY_FIELD_NUMBER = 4;
  private int desiredPotency_;
  /**
   * <pre>
   * Desired potency level.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
   */
  public int getDesiredPotencyValue() {
    return desiredPotency_;
  }
  /**
   * <pre>
   * Desired potency level.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
   */
  public io.opencannabis.schema.product.struct.testing.PotencyEstimate getDesiredPotency() {
    io.opencannabis.schema.product.struct.testing.PotencyEstimate result = io.opencannabis.schema.product.struct.testing.PotencyEstimate.valueOf(desiredPotency_);
    return result == null ? io.opencannabis.schema.product.struct.testing.PotencyEstimate.UNRECOGNIZED : result;
  }

  public static final int CANNABINOID_RATIO_FIELD_NUMBER = 5;
  private int cannabinoidRatio_;
  /**
   * <pre>
   * Desired cannabinoid ratio.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
   */
  public int getCannabinoidRatioValue() {
    return cannabinoidRatio_;
  }
  /**
   * <pre>
   * Desired cannabinoid ratio.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
   */
  public io.opencannabis.schema.product.struct.testing.CannabinoidRatio getCannabinoidRatio() {
    io.opencannabis.schema.product.struct.testing.CannabinoidRatio result = io.opencannabis.schema.product.struct.testing.CannabinoidRatio.valueOf(cannabinoidRatio_);
    return result == null ? io.opencannabis.schema.product.struct.testing.CannabinoidRatio.UNRECOGNIZED : result;
  }

  public static final int SPECIES_FIELD_NUMBER = 6;
  private java.util.List<java.lang.Integer> species_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.Species> species_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.Species>() {
            public io.opencannabis.schema.product.struct.Species convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.Species result = io.opencannabis.schema.product.struct.Species.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.Species.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Preferred species types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.Species> getSpeciesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.Species>(species_, species_converter_);
  }
  /**
   * <pre>
   * Preferred species types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
   */
  public int getSpeciesCount() {
    return species_.size();
  }
  /**
   * <pre>
   * Preferred species types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
   */
  public io.opencannabis.schema.product.struct.Species getSpecies(int index) {
    return species_converter_.convert(species_.get(index));
  }
  /**
   * <pre>
   * Preferred species types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
   */
  public java.util.List<java.lang.Integer>
  getSpeciesValueList() {
    return species_;
  }
  /**
   * <pre>
   * Preferred species types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
   */
  public int getSpeciesValue(int index) {
    return species_.get(index);
  }
  private int speciesMemoizedSerializedSize;

  public static final int GROW_FIELD_NUMBER = 7;
  private java.util.List<java.lang.Integer> grow_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.Grow> grow_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.Grow>() {
            public io.opencannabis.schema.product.struct.Grow convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.Grow result = io.opencannabis.schema.product.struct.Grow.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.Grow.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Preferred grow types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.Grow> getGrowList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.Grow>(grow_, grow_converter_);
  }
  /**
   * <pre>
   * Preferred grow types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
   */
  public int getGrowCount() {
    return grow_.size();
  }
  /**
   * <pre>
   * Preferred grow types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
   */
  public io.opencannabis.schema.product.struct.Grow getGrow(int index) {
    return grow_converter_.convert(grow_.get(index));
  }
  /**
   * <pre>
   * Preferred grow types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
   */
  public java.util.List<java.lang.Integer>
  getGrowValueList() {
    return grow_;
  }
  /**
   * <pre>
   * Preferred grow types.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
   */
  public int getGrowValue(int index) {
    return grow_.get(index);
  }
  private int growMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (getSectionList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(sectionMemoizedSerializedSize);
    }
    for (int i = 0; i < section_.size(); i++) {
      output.writeEnumNoTag(section_.get(i));
    }
    if (getFeelingList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(feelingMemoizedSerializedSize);
    }
    for (int i = 0; i < feeling_.size(); i++) {
      output.writeEnumNoTag(feeling_.get(i));
    }
    if (getTasteNoteList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(tasteNoteMemoizedSerializedSize);
    }
    for (int i = 0; i < tasteNote_.size(); i++) {
      output.writeEnumNoTag(tasteNote_.get(i));
    }
    if (desiredPotency_ != io.opencannabis.schema.product.struct.testing.PotencyEstimate.LIGHT.getNumber()) {
      output.writeEnum(4, desiredPotency_);
    }
    if (cannabinoidRatio_ != io.opencannabis.schema.product.struct.testing.CannabinoidRatio.NO_CANNABINOID_PREFERENCE.getNumber()) {
      output.writeEnum(5, cannabinoidRatio_);
    }
    if (getSpeciesList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(speciesMemoizedSerializedSize);
    }
    for (int i = 0; i < species_.size(); i++) {
      output.writeEnumNoTag(species_.get(i));
    }
    if (getGrowList().size() > 0) {
      output.writeUInt32NoTag(58);
      output.writeUInt32NoTag(growMemoizedSerializedSize);
    }
    for (int i = 0; i < grow_.size(); i++) {
      output.writeEnumNoTag(grow_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < section_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(section_.get(i));
      }
      size += dataSize;
      if (!getSectionList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }sectionMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < feeling_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(feeling_.get(i));
      }
      size += dataSize;
      if (!getFeelingList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }feelingMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tasteNote_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(tasteNote_.get(i));
      }
      size += dataSize;
      if (!getTasteNoteList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }tasteNoteMemoizedSerializedSize = dataSize;
    }
    if (desiredPotency_ != io.opencannabis.schema.product.struct.testing.PotencyEstimate.LIGHT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, desiredPotency_);
    }
    if (cannabinoidRatio_ != io.opencannabis.schema.product.struct.testing.CannabinoidRatio.NO_CANNABINOID_PREFERENCE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, cannabinoidRatio_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < species_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(species_.get(i));
      }
      size += dataSize;
      if (!getSpeciesList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }speciesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < grow_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(grow_.get(i));
      }
      size += dataSize;
      if (!getGrowList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }growMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.MenuPreferences)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.MenuPreferences other = (io.bloombox.schema.identity.MenuPreferences) obj;

    boolean result = true;
    result = result && section_.equals(other.section_);
    result = result && feeling_.equals(other.feeling_);
    result = result && tasteNote_.equals(other.tasteNote_);
    result = result && desiredPotency_ == other.desiredPotency_;
    result = result && cannabinoidRatio_ == other.cannabinoidRatio_;
    result = result && species_.equals(other.species_);
    result = result && grow_.equals(other.grow_);
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSectionCount() > 0) {
      hash = (37 * hash) + SECTION_FIELD_NUMBER;
      hash = (53 * hash) + section_.hashCode();
    }
    if (getFeelingCount() > 0) {
      hash = (37 * hash) + FEELING_FIELD_NUMBER;
      hash = (53 * hash) + feeling_.hashCode();
    }
    if (getTasteNoteCount() > 0) {
      hash = (37 * hash) + TASTE_NOTE_FIELD_NUMBER;
      hash = (53 * hash) + tasteNote_.hashCode();
    }
    hash = (37 * hash) + DESIRED_POTENCY_FIELD_NUMBER;
    hash = (53 * hash) + desiredPotency_;
    hash = (37 * hash) + CANNABINOID_RATIO_FIELD_NUMBER;
    hash = (53 * hash) + cannabinoidRatio_;
    if (getSpeciesCount() > 0) {
      hash = (37 * hash) + SPECIES_FIELD_NUMBER;
      hash = (53 * hash) + species_.hashCode();
    }
    if (getGrowCount() > 0) {
      hash = (37 * hash) + GROW_FIELD_NUMBER;
      hash = (53 * hash) + grow_.hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.MenuPreferences parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.MenuPreferences prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Consumer preferences related to menus and products.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.MenuPreferences}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.MenuPreferences)
      io.bloombox.schema.identity.MenuPreferencesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_MenuPreferences_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_MenuPreferences_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.MenuPreferences.class, io.bloombox.schema.identity.MenuPreferences.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.MenuPreferences.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      section_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      feeling_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      tasteNote_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      desiredPotency_ = 0;

      cannabinoidRatio_ = 0;

      species_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      grow_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_MenuPreferences_descriptor;
    }

    public io.bloombox.schema.identity.MenuPreferences getDefaultInstanceForType() {
      return io.bloombox.schema.identity.MenuPreferences.getDefaultInstance();
    }

    public io.bloombox.schema.identity.MenuPreferences build() {
      io.bloombox.schema.identity.MenuPreferences result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.MenuPreferences buildPartial() {
      io.bloombox.schema.identity.MenuPreferences result = new io.bloombox.schema.identity.MenuPreferences(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        section_ = java.util.Collections.unmodifiableList(section_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.section_ = section_;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        feeling_ = java.util.Collections.unmodifiableList(feeling_);
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.feeling_ = feeling_;
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        tasteNote_ = java.util.Collections.unmodifiableList(tasteNote_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.tasteNote_ = tasteNote_;
      result.desiredPotency_ = desiredPotency_;
      result.cannabinoidRatio_ = cannabinoidRatio_;
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        species_ = java.util.Collections.unmodifiableList(species_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.species_ = species_;
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        grow_ = java.util.Collections.unmodifiableList(grow_);
        bitField0_ = (bitField0_ & ~0x00000040);
      }
      result.grow_ = grow_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.MenuPreferences) {
        return mergeFrom((io.bloombox.schema.identity.MenuPreferences)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.MenuPreferences other) {
      if (other == io.bloombox.schema.identity.MenuPreferences.getDefaultInstance()) return this;
      if (!other.section_.isEmpty()) {
        if (section_.isEmpty()) {
          section_ = other.section_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureSectionIsMutable();
          section_.addAll(other.section_);
        }
        onChanged();
      }
      if (!other.feeling_.isEmpty()) {
        if (feeling_.isEmpty()) {
          feeling_ = other.feeling_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureFeelingIsMutable();
          feeling_.addAll(other.feeling_);
        }
        onChanged();
      }
      if (!other.tasteNote_.isEmpty()) {
        if (tasteNote_.isEmpty()) {
          tasteNote_ = other.tasteNote_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureTasteNoteIsMutable();
          tasteNote_.addAll(other.tasteNote_);
        }
        onChanged();
      }
      if (other.desiredPotency_ != 0) {
        setDesiredPotencyValue(other.getDesiredPotencyValue());
      }
      if (other.cannabinoidRatio_ != 0) {
        setCannabinoidRatioValue(other.getCannabinoidRatioValue());
      }
      if (!other.species_.isEmpty()) {
        if (species_.isEmpty()) {
          species_ = other.species_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureSpeciesIsMutable();
          species_.addAll(other.species_);
        }
        onChanged();
      }
      if (!other.grow_.isEmpty()) {
        if (grow_.isEmpty()) {
          grow_ = other.grow_;
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          ensureGrowIsMutable();
          grow_.addAll(other.grow_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.MenuPreferences parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.MenuPreferences) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<java.lang.Integer> section_ =
      java.util.Collections.emptyList();
    private void ensureSectionIsMutable() {
      if (!((bitField0_ & 0x00000001) == 0x00000001)) {
        section_ = new java.util.ArrayList<java.lang.Integer>(section_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public java.util.List<io.opencannabis.schema.menu.section.Section> getSectionList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.menu.section.Section>(section_, section_converter_);
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public int getSectionCount() {
      return section_.size();
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public io.opencannabis.schema.menu.section.Section getSection(int index) {
      return section_converter_.convert(section_.get(index));
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder setSection(
        int index, io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSectionIsMutable();
      section_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder addSection(io.opencannabis.schema.menu.section.Section value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSectionIsMutable();
      section_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder addAllSection(
        java.lang.Iterable<? extends io.opencannabis.schema.menu.section.Section> values) {
      ensureSectionIsMutable();
      for (io.opencannabis.schema.menu.section.Section value : values) {
        section_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder clearSection() {
      section_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public java.util.List<java.lang.Integer>
    getSectionValueList() {
      return java.util.Collections.unmodifiableList(section_);
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public int getSectionValue(int index) {
      return section_.get(index);
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder setSectionValue(
        int index, int value) {
      ensureSectionIsMutable();
      section_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder addSectionValue(int value) {
      ensureSectionIsMutable();
      section_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred menu sections or product types.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.section.Section section = 1 [(.gen_bq_schema.description) = "Preferred menu sections or product types."];</code>
     */
    public Builder addAllSectionValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureSectionIsMutable();
      for (int value : values) {
        section_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> feeling_ =
      java.util.Collections.emptyList();
    private void ensureFeelingIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        feeling_ = new java.util.ArrayList<java.lang.Integer>(feeling_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.Feeling> getFeelingList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.testing.Feeling>(feeling_, feeling_converter_);
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public int getFeelingCount() {
      return feeling_.size();
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public io.opencannabis.schema.product.struct.testing.Feeling getFeeling(int index) {
      return feeling_converter_.convert(feeling_.get(index));
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder setFeeling(
        int index, io.opencannabis.schema.product.struct.testing.Feeling value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFeelingIsMutable();
      feeling_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder addFeeling(io.opencannabis.schema.product.struct.testing.Feeling value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFeelingIsMutable();
      feeling_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder addAllFeeling(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.testing.Feeling> values) {
      ensureFeelingIsMutable();
      for (io.opencannabis.schema.product.struct.testing.Feeling value : values) {
        feeling_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder clearFeeling() {
      feeling_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public java.util.List<java.lang.Integer>
    getFeelingValueList() {
      return java.util.Collections.unmodifiableList(feeling_);
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public int getFeelingValue(int index) {
      return feeling_.get(index);
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder setFeelingValue(
        int index, int value) {
      ensureFeelingIsMutable();
      feeling_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder addFeelingValue(int value) {
      ensureFeelingIsMutable();
      feeling_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred feelings or experiential states.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.Feeling feeling = 2 [(.gen_bq_schema.description) = "Preferred feelings or experiential states."];</code>
     */
    public Builder addAllFeelingValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureFeelingIsMutable();
      for (int value : values) {
        feeling_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> tasteNote_ =
      java.util.Collections.emptyList();
    private void ensureTasteNoteIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        tasteNote_ = new java.util.ArrayList<java.lang.Integer>(tasteNote_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.testing.TasteNote> getTasteNoteList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.testing.TasteNote>(tasteNote_, tasteNote_converter_);
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public int getTasteNoteCount() {
      return tasteNote_.size();
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public io.opencannabis.schema.product.struct.testing.TasteNote getTasteNote(int index) {
      return tasteNote_converter_.convert(tasteNote_.get(index));
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder setTasteNote(
        int index, io.opencannabis.schema.product.struct.testing.TasteNote value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTasteNoteIsMutable();
      tasteNote_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder addTasteNote(io.opencannabis.schema.product.struct.testing.TasteNote value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTasteNoteIsMutable();
      tasteNote_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder addAllTasteNote(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.testing.TasteNote> values) {
      ensureTasteNoteIsMutable();
      for (io.opencannabis.schema.product.struct.testing.TasteNote value : values) {
        tasteNote_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder clearTasteNote() {
      tasteNote_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public java.util.List<java.lang.Integer>
    getTasteNoteValueList() {
      return java.util.Collections.unmodifiableList(tasteNote_);
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public int getTasteNoteValue(int index) {
      return tasteNote_.get(index);
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder setTasteNoteValue(
        int index, int value) {
      ensureTasteNoteIsMutable();
      tasteNote_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder addTasteNoteValue(int value) {
      ensureTasteNoteIsMutable();
      tasteNote_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred tasting notes.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.labtesting.TasteNote taste_note = 3 [(.gen_bq_schema.description) = "Preferred tasting notes."];</code>
     */
    public Builder addAllTasteNoteValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureTasteNoteIsMutable();
      for (int value : values) {
        tasteNote_.add(value);
      }
      onChanged();
      return this;
    }

    private int desiredPotency_ = 0;
    /**
     * <pre>
     * Desired potency level.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
     */
    public int getDesiredPotencyValue() {
      return desiredPotency_;
    }
    /**
     * <pre>
     * Desired potency level.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
     */
    public Builder setDesiredPotencyValue(int value) {
      desiredPotency_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Desired potency level.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
     */
    public io.opencannabis.schema.product.struct.testing.PotencyEstimate getDesiredPotency() {
      io.opencannabis.schema.product.struct.testing.PotencyEstimate result = io.opencannabis.schema.product.struct.testing.PotencyEstimate.valueOf(desiredPotency_);
      return result == null ? io.opencannabis.schema.product.struct.testing.PotencyEstimate.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Desired potency level.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
     */
    public Builder setDesiredPotency(io.opencannabis.schema.product.struct.testing.PotencyEstimate value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      desiredPotency_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Desired potency level.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.PotencyEstimate desired_potency = 4 [(.gen_bq_schema.description) = "Desired potency level."];</code>
     */
    public Builder clearDesiredPotency() {
      
      desiredPotency_ = 0;
      onChanged();
      return this;
    }

    private int cannabinoidRatio_ = 0;
    /**
     * <pre>
     * Desired cannabinoid ratio.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
     */
    public int getCannabinoidRatioValue() {
      return cannabinoidRatio_;
    }
    /**
     * <pre>
     * Desired cannabinoid ratio.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
     */
    public Builder setCannabinoidRatioValue(int value) {
      cannabinoidRatio_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Desired cannabinoid ratio.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
     */
    public io.opencannabis.schema.product.struct.testing.CannabinoidRatio getCannabinoidRatio() {
      io.opencannabis.schema.product.struct.testing.CannabinoidRatio result = io.opencannabis.schema.product.struct.testing.CannabinoidRatio.valueOf(cannabinoidRatio_);
      return result == null ? io.opencannabis.schema.product.struct.testing.CannabinoidRatio.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Desired cannabinoid ratio.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
     */
    public Builder setCannabinoidRatio(io.opencannabis.schema.product.struct.testing.CannabinoidRatio value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      cannabinoidRatio_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Desired cannabinoid ratio.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.CannabinoidRatio cannabinoid_ratio = 5 [(.gen_bq_schema.description) = "Desired cannabinoid ratio."];</code>
     */
    public Builder clearCannabinoidRatio() {
      
      cannabinoidRatio_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> species_ =
      java.util.Collections.emptyList();
    private void ensureSpeciesIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        species_ = new java.util.ArrayList<java.lang.Integer>(species_);
        bitField0_ |= 0x00000020;
      }
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.Species> getSpeciesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.Species>(species_, species_converter_);
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public int getSpeciesCount() {
      return species_.size();
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public io.opencannabis.schema.product.struct.Species getSpecies(int index) {
      return species_converter_.convert(species_.get(index));
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder setSpecies(
        int index, io.opencannabis.schema.product.struct.Species value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpeciesIsMutable();
      species_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder addSpecies(io.opencannabis.schema.product.struct.Species value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSpeciesIsMutable();
      species_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder addAllSpecies(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.Species> values) {
      ensureSpeciesIsMutable();
      for (io.opencannabis.schema.product.struct.Species value : values) {
        species_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder clearSpecies() {
      species_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public java.util.List<java.lang.Integer>
    getSpeciesValueList() {
      return java.util.Collections.unmodifiableList(species_);
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public int getSpeciesValue(int index) {
      return species_.get(index);
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder setSpeciesValue(
        int index, int value) {
      ensureSpeciesIsMutable();
      species_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder addSpeciesValue(int value) {
      ensureSpeciesIsMutable();
      species_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred species types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Species species = 6 [(.gen_bq_schema.description) = "Preferred species types."];</code>
     */
    public Builder addAllSpeciesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureSpeciesIsMutable();
      for (int value : values) {
        species_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> grow_ =
      java.util.Collections.emptyList();
    private void ensureGrowIsMutable() {
      if (!((bitField0_ & 0x00000040) == 0x00000040)) {
        grow_ = new java.util.ArrayList<java.lang.Integer>(grow_);
        bitField0_ |= 0x00000040;
      }
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.Grow> getGrowList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.Grow>(grow_, grow_converter_);
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public int getGrowCount() {
      return grow_.size();
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public io.opencannabis.schema.product.struct.Grow getGrow(int index) {
      return grow_converter_.convert(grow_.get(index));
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder setGrow(
        int index, io.opencannabis.schema.product.struct.Grow value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGrowIsMutable();
      grow_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder addGrow(io.opencannabis.schema.product.struct.Grow value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureGrowIsMutable();
      grow_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder addAllGrow(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.Grow> values) {
      ensureGrowIsMutable();
      for (io.opencannabis.schema.product.struct.Grow value : values) {
        grow_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder clearGrow() {
      grow_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public java.util.List<java.lang.Integer>
    getGrowValueList() {
      return java.util.Collections.unmodifiableList(grow_);
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public int getGrowValue(int index) {
      return grow_.get(index);
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder setGrowValue(
        int index, int value) {
      ensureGrowIsMutable();
      grow_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder addGrowValue(int value) {
      ensureGrowIsMutable();
      grow_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Preferred grow types.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.Grow grow = 7 [(.gen_bq_schema.description) = "Preferred grow types."];</code>
     */
    public Builder addAllGrowValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureGrowIsMutable();
      for (int value : values) {
        grow_.add(value);
      }
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.MenuPreferences)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.MenuPreferences)
  private static final io.bloombox.schema.identity.MenuPreferences DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.MenuPreferences();
  }

  public static io.bloombox.schema.identity.MenuPreferences getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MenuPreferences>
      PARSER = new com.google.protobuf.AbstractParser<MenuPreferences>() {
    public MenuPreferences parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new MenuPreferences(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<MenuPreferences> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MenuPreferences> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.MenuPreferences getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

