/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Represents an individual who uses software.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.User}
 */
public  final class User extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.User)
    UserOrBuilder {
private static final long serialVersionUID = 0L;
  // Use User.newBuilder() to construct.
  private User(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private User() {
    uid_ = "";
    identification_ = java.util.Collections.emptyList();
    doctorRec_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private User(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            uid_ = s;
            break;
          }
          case 18: {
            io.bloombox.schema.identity.UserFlags.Builder subBuilder = null;
            if (flags_ != null) {
              subBuilder = flags_.toBuilder();
            }
            flags_ = input.readMessage(io.bloombox.schema.identity.UserFlags.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(flags_);
              flags_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            io.opencannabis.schema.person.Person.Builder subBuilder = null;
            if (person_ != null) {
              subBuilder = person_.toBuilder();
            }
            person_ = input.readMessage(io.opencannabis.schema.person.Person.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(person_);
              person_ = subBuilder.buildPartial();
            }

            break;
          }
          case 162: {
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              identification_ = new java.util.ArrayList<io.bloombox.schema.identity.ID>();
              mutable_bitField0_ |= 0x00000008;
            }
            identification_.add(
                input.readMessage(io.bloombox.schema.identity.ID.parser(), extensionRegistry));
            break;
          }
          case 170: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              doctorRec_ = new java.util.ArrayList<io.bloombox.schema.identity.ids.UserDoctorRec>();
              mutable_bitField0_ |= 0x00000010;
            }
            doctorRec_.add(
                input.readMessage(io.bloombox.schema.identity.ids.UserDoctorRec.parser(), extensionRegistry));
            break;
          }
          case 242: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (seen_ != null) {
              subBuilder = seen_.toBuilder();
            }
            seen_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(seen_);
              seen_ = subBuilder.buildPartial();
            }

            break;
          }
          case 250: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (signup_ != null) {
              subBuilder = signup_.toBuilder();
            }
            signup_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(signup_);
              signup_ = subBuilder.buildPartial();
            }

            break;
          }
          case 322: {
            if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
              identities_ = com.google.protobuf.MapField.newMapField(
                  IdentitiesDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000080;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.bloombox.schema.identity.UserIdentity>
            identities__ = input.readMessage(
                IdentitiesDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            identities_.getMutableMap().put(
                identities__.getKey(), identities__.getValue());
            break;
          }
          case 330: {
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              media_ = com.google.protobuf.MapField.newMapField(
                  MediaDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000100;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.media.MediaItem>
            media__ = input.readMessage(
                MediaDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            media_.getMutableMap().put(
                media__.getKey(), media__.getValue());
            break;
          }
          case 802: {
            io.bloombox.schema.identity.ConsumerProfile.Builder subBuilder = null;
            if (consumer_ != null) {
              subBuilder = consumer_.toBuilder();
            }
            consumer_ = input.readMessage(io.bloombox.schema.identity.ConsumerProfile.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(consumer_);
              consumer_ = subBuilder.buildPartial();
            }

            break;
          }
          case 810: {
            io.bloombox.schema.identity.IndustryProfile.Builder subBuilder = null;
            if (industry_ != null) {
              subBuilder = industry_.toBuilder();
            }
            industry_ = input.readMessage(io.bloombox.schema.identity.IndustryProfile.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(industry_);
              industry_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        identification_ = java.util.Collections.unmodifiableList(identification_);
      }
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        doctorRec_ = java.util.Collections.unmodifiableList(doctorRec_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 40:
        return internalGetIdentities();
      case 41:
        return internalGetMedia();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.User.class, io.bloombox.schema.identity.User.Builder.class);
  }

  private int bitField0_;
  public static final int UID_FIELD_NUMBER = 1;
  private volatile java.lang.Object uid_;
  /**
   * <pre>
   * Unique ID for the user.
   * </pre>
   *
   * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
   */
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Unique ID for the user.
   * </pre>
   *
   * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
   */
  public com.google.protobuf.ByteString
      getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLAGS_FIELD_NUMBER = 2;
  private io.bloombox.schema.identity.UserFlags flags_;
  /**
   * <pre>
   * Boolean flags for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
   */
  public boolean hasFlags() {
    return flags_ != null;
  }
  /**
   * <pre>
   * Boolean flags for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
   */
  public io.bloombox.schema.identity.UserFlags getFlags() {
    return flags_ == null ? io.bloombox.schema.identity.UserFlags.getDefaultInstance() : flags_;
  }
  /**
   * <pre>
   * Boolean flags for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
   */
  public io.bloombox.schema.identity.UserFlagsOrBuilder getFlagsOrBuilder() {
    return getFlags();
  }

  public static final int PERSON_FIELD_NUMBER = 3;
  private io.opencannabis.schema.person.Person person_;
  /**
   * <pre>
   * Person's information that backs this user.
   * </pre>
   *
   * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
   */
  public boolean hasPerson() {
    return person_ != null;
  }
  /**
   * <pre>
   * Person's information that backs this user.
   * </pre>
   *
   * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
   */
  public io.opencannabis.schema.person.Person getPerson() {
    return person_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
  }
  /**
   * <pre>
   * Person's information that backs this user.
   * </pre>
   *
   * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
   */
  public io.opencannabis.schema.person.PersonOrBuilder getPersonOrBuilder() {
    return getPerson();
  }

  public static final int IDENTIFICATION_FIELD_NUMBER = 20;
  private java.util.List<io.bloombox.schema.identity.ID> identification_;
  /**
   * <pre>
   * Government ID associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
   */
  public java.util.List<io.bloombox.schema.identity.ID> getIdentificationList() {
    return identification_;
  }
  /**
   * <pre>
   * Government ID associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
   */
  public java.util.List<? extends io.bloombox.schema.identity.IDOrBuilder> 
      getIdentificationOrBuilderList() {
    return identification_;
  }
  /**
   * <pre>
   * Government ID associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
   */
  public int getIdentificationCount() {
    return identification_.size();
  }
  /**
   * <pre>
   * Government ID associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
   */
  public io.bloombox.schema.identity.ID getIdentification(int index) {
    return identification_.get(index);
  }
  /**
   * <pre>
   * Government ID associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
   */
  public io.bloombox.schema.identity.IDOrBuilder getIdentificationOrBuilder(
      int index) {
    return identification_.get(index);
  }

  public static final int DOCTOR_REC_FIELD_NUMBER = 21;
  private java.util.List<io.bloombox.schema.identity.ids.UserDoctorRec> doctorRec_;
  /**
   * <pre>
   * Doctor's recommendations associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
   */
  public java.util.List<io.bloombox.schema.identity.ids.UserDoctorRec> getDoctorRecList() {
    return doctorRec_;
  }
  /**
   * <pre>
   * Doctor's recommendations associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
   */
  public java.util.List<? extends io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> 
      getDoctorRecOrBuilderList() {
    return doctorRec_;
  }
  /**
   * <pre>
   * Doctor's recommendations associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
   */
  public int getDoctorRecCount() {
    return doctorRec_.size();
  }
  /**
   * <pre>
   * Doctor's recommendations associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
   */
  public io.bloombox.schema.identity.ids.UserDoctorRec getDoctorRec(int index) {
    return doctorRec_.get(index);
  }
  /**
   * <pre>
   * Doctor's recommendations associated with this user.
   * </pre>
   *
   * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
   */
  public io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder getDoctorRecOrBuilder(
      int index) {
    return doctorRec_.get(index);
  }

  public static final int SEEN_FIELD_NUMBER = 30;
  private io.opencannabis.schema.temporal.Instant seen_;
  /**
   * <pre>
   * Last time this user was seen, via auth/login/enrollment etc.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
   */
  public boolean hasSeen() {
    return seen_ != null;
  }
  /**
   * <pre>
   * Last time this user was seen, via auth/login/enrollment etc.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getSeen() {
    return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
  }
  /**
   * <pre>
   * Last time this user was seen, via auth/login/enrollment etc.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
    return getSeen();
  }

  public static final int SIGNUP_FIELD_NUMBER = 31;
  private io.opencannabis.schema.temporal.Instant signup_;
  /**
   * <pre>
   * Timestamp for when this user was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
   */
  public boolean hasSignup() {
    return signup_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this user was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getSignup() {
    return signup_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signup_;
  }
  /**
   * <pre>
   * Timestamp for when this user was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getSignupOrBuilder() {
    return getSignup();
  }

  public static final int IDENTITIES_FIELD_NUMBER = 40;
  private static final class IdentitiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.bloombox.schema.identity.UserIdentity> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.bloombox.schema.identity.UserIdentity>newDefaultInstance(
                io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_IdentitiesEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.bloombox.schema.identity.UserIdentity.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.bloombox.schema.identity.UserIdentity> identities_;
  private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.identity.UserIdentity>
  internalGetIdentities() {
    if (identities_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          IdentitiesDefaultEntryHolder.defaultEntry);
    }
    return identities_;
  }

  public int getIdentitiesCount() {
    return internalGetIdentities().getMap().size();
  }
  /**
   * <pre>
   * Identities associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
   */

  public boolean containsIdentities(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetIdentities().getMap().containsKey(key);
  }
  /**
   * Use {@link #getIdentitiesMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> getIdentities() {
    return getIdentitiesMap();
  }
  /**
   * <pre>
   * Identities associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
   */

  public java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> getIdentitiesMap() {
    return internalGetIdentities().getMap();
  }
  /**
   * <pre>
   * Identities associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
   */

  public io.bloombox.schema.identity.UserIdentity getIdentitiesOrDefault(
      java.lang.String key,
      io.bloombox.schema.identity.UserIdentity defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> map =
        internalGetIdentities().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Identities associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
   */

  public io.bloombox.schema.identity.UserIdentity getIdentitiesOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> map =
        internalGetIdentities().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MEDIA_FIELD_NUMBER = 41;
  private static final class MediaDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.opencannabis.schema.media.MediaItem> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.opencannabis.schema.media.MediaItem>newDefaultInstance(
                io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_MediaEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.opencannabis.schema.media.MediaItem.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.opencannabis.schema.media.MediaItem> media_;
  private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.media.MediaItem>
  internalGetMedia() {
    if (media_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MediaDefaultEntryHolder.defaultEntry);
    }
    return media_;
  }

  public int getMediaCount() {
    return internalGetMedia().getMap().size();
  }
  /**
   * <pre>
   * Media associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
   */

  public boolean containsMedia(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetMedia().getMap().containsKey(key);
  }
  /**
   * Use {@link #getMediaMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> getMedia() {
    return getMediaMap();
  }
  /**
   * <pre>
   * Media associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
   */

  public java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> getMediaMap() {
    return internalGetMedia().getMap();
  }
  /**
   * <pre>
   * Media associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
   */

  public io.opencannabis.schema.media.MediaItem getMediaOrDefault(
      java.lang.String key,
      io.opencannabis.schema.media.MediaItem defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> map =
        internalGetMedia().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Media associated with this user.
   * </pre>
   *
   * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
   */

  public io.opencannabis.schema.media.MediaItem getMediaOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> map =
        internalGetMedia().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONSUMER_FIELD_NUMBER = 100;
  private io.bloombox.schema.identity.ConsumerProfile consumer_;
  /**
   * <pre>
   * Consumer profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
   */
  public boolean hasConsumer() {
    return consumer_ != null;
  }
  /**
   * <pre>
   * Consumer profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
   */
  public io.bloombox.schema.identity.ConsumerProfile getConsumer() {
    return consumer_ == null ? io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumer_;
  }
  /**
   * <pre>
   * Consumer profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
   */
  public io.bloombox.schema.identity.ConsumerProfileOrBuilder getConsumerOrBuilder() {
    return getConsumer();
  }

  public static final int INDUSTRY_FIELD_NUMBER = 101;
  private io.bloombox.schema.identity.IndustryProfile industry_;
  /**
   * <pre>
   * Industry profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
   */
  public boolean hasIndustry() {
    return industry_ != null;
  }
  /**
   * <pre>
   * Industry profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
   */
  public io.bloombox.schema.identity.IndustryProfile getIndustry() {
    return industry_ == null ? io.bloombox.schema.identity.IndustryProfile.getDefaultInstance() : industry_;
  }
  /**
   * <pre>
   * Industry profile for this user.
   * </pre>
   *
   * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
   */
  public io.bloombox.schema.identity.IndustryProfileOrBuilder getIndustryOrBuilder() {
    return getIndustry();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getUidBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uid_);
    }
    if (flags_ != null) {
      output.writeMessage(2, getFlags());
    }
    if (person_ != null) {
      output.writeMessage(3, getPerson());
    }
    for (int i = 0; i < identification_.size(); i++) {
      output.writeMessage(20, identification_.get(i));
    }
    for (int i = 0; i < doctorRec_.size(); i++) {
      output.writeMessage(21, doctorRec_.get(i));
    }
    if (seen_ != null) {
      output.writeMessage(30, getSeen());
    }
    if (signup_ != null) {
      output.writeMessage(31, getSignup());
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetIdentities(),
        IdentitiesDefaultEntryHolder.defaultEntry,
        40);
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetMedia(),
        MediaDefaultEntryHolder.defaultEntry,
        41);
    if (consumer_ != null) {
      output.writeMessage(100, getConsumer());
    }
    if (industry_ != null) {
      output.writeMessage(101, getIndustry());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getUidBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uid_);
    }
    if (flags_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getFlags());
    }
    if (person_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getPerson());
    }
    for (int i = 0; i < identification_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(20, identification_.get(i));
    }
    for (int i = 0; i < doctorRec_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(21, doctorRec_.get(i));
    }
    if (seen_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(30, getSeen());
    }
    if (signup_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(31, getSignup());
    }
    for (java.util.Map.Entry<java.lang.String, io.bloombox.schema.identity.UserIdentity> entry
         : internalGetIdentities().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.bloombox.schema.identity.UserIdentity>
      identities__ = IdentitiesDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(40, identities__);
    }
    for (java.util.Map.Entry<java.lang.String, io.opencannabis.schema.media.MediaItem> entry
         : internalGetMedia().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.opencannabis.schema.media.MediaItem>
      media__ = MediaDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(41, media__);
    }
    if (consumer_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(100, getConsumer());
    }
    if (industry_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(101, getIndustry());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.User)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.User other = (io.bloombox.schema.identity.User) obj;

    boolean result = true;
    result = result && getUid()
        .equals(other.getUid());
    result = result && (hasFlags() == other.hasFlags());
    if (hasFlags()) {
      result = result && getFlags()
          .equals(other.getFlags());
    }
    result = result && (hasPerson() == other.hasPerson());
    if (hasPerson()) {
      result = result && getPerson()
          .equals(other.getPerson());
    }
    result = result && getIdentificationList()
        .equals(other.getIdentificationList());
    result = result && getDoctorRecList()
        .equals(other.getDoctorRecList());
    result = result && (hasSeen() == other.hasSeen());
    if (hasSeen()) {
      result = result && getSeen()
          .equals(other.getSeen());
    }
    result = result && (hasSignup() == other.hasSignup());
    if (hasSignup()) {
      result = result && getSignup()
          .equals(other.getSignup());
    }
    result = result && internalGetIdentities().equals(
        other.internalGetIdentities());
    result = result && internalGetMedia().equals(
        other.internalGetMedia());
    result = result && (hasConsumer() == other.hasConsumer());
    if (hasConsumer()) {
      result = result && getConsumer()
          .equals(other.getConsumer());
    }
    result = result && (hasIndustry() == other.hasIndustry());
    if (hasIndustry()) {
      result = result && getIndustry()
          .equals(other.getIndustry());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    if (hasFlags()) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + getFlags().hashCode();
    }
    if (hasPerson()) {
      hash = (37 * hash) + PERSON_FIELD_NUMBER;
      hash = (53 * hash) + getPerson().hashCode();
    }
    if (getIdentificationCount() > 0) {
      hash = (37 * hash) + IDENTIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getIdentificationList().hashCode();
    }
    if (getDoctorRecCount() > 0) {
      hash = (37 * hash) + DOCTOR_REC_FIELD_NUMBER;
      hash = (53 * hash) + getDoctorRecList().hashCode();
    }
    if (hasSeen()) {
      hash = (37 * hash) + SEEN_FIELD_NUMBER;
      hash = (53 * hash) + getSeen().hashCode();
    }
    if (hasSignup()) {
      hash = (37 * hash) + SIGNUP_FIELD_NUMBER;
      hash = (53 * hash) + getSignup().hashCode();
    }
    if (!internalGetIdentities().getMap().isEmpty()) {
      hash = (37 * hash) + IDENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetIdentities().hashCode();
    }
    if (!internalGetMedia().getMap().isEmpty()) {
      hash = (37 * hash) + MEDIA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMedia().hashCode();
    }
    if (hasConsumer()) {
      hash = (37 * hash) + CONSUMER_FIELD_NUMBER;
      hash = (53 * hash) + getConsumer().hashCode();
    }
    if (hasIndustry()) {
      hash = (37 * hash) + INDUSTRY_FIELD_NUMBER;
      hash = (53 * hash) + getIndustry().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.User parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.User parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.User parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.User parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.User parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.User parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.User prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an individual who uses software.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.User}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.User)
      io.bloombox.schema.identity.UserOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 40:
          return internalGetIdentities();
        case 41:
          return internalGetMedia();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 40:
          return internalGetMutableIdentities();
        case 41:
          return internalGetMutableMedia();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.User.class, io.bloombox.schema.identity.User.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.User.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getIdentificationFieldBuilder();
        getDoctorRecFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      uid_ = "";

      if (flagsBuilder_ == null) {
        flags_ = null;
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }
      if (personBuilder_ == null) {
        person_ = null;
      } else {
        person_ = null;
        personBuilder_ = null;
      }
      if (identificationBuilder_ == null) {
        identification_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
      } else {
        identificationBuilder_.clear();
      }
      if (doctorRecBuilder_ == null) {
        doctorRec_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        doctorRecBuilder_.clear();
      }
      if (seenBuilder_ == null) {
        seen_ = null;
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }
      if (signupBuilder_ == null) {
        signup_ = null;
      } else {
        signup_ = null;
        signupBuilder_ = null;
      }
      internalGetMutableIdentities().clear();
      internalGetMutableMedia().clear();
      if (consumerBuilder_ == null) {
        consumer_ = null;
      } else {
        consumer_ = null;
        consumerBuilder_ = null;
      }
      if (industryBuilder_ == null) {
        industry_ = null;
      } else {
        industry_ = null;
        industryBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_User_descriptor;
    }

    public io.bloombox.schema.identity.User getDefaultInstanceForType() {
      return io.bloombox.schema.identity.User.getDefaultInstance();
    }

    public io.bloombox.schema.identity.User build() {
      io.bloombox.schema.identity.User result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.User buildPartial() {
      io.bloombox.schema.identity.User result = new io.bloombox.schema.identity.User(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.uid_ = uid_;
      if (flagsBuilder_ == null) {
        result.flags_ = flags_;
      } else {
        result.flags_ = flagsBuilder_.build();
      }
      if (personBuilder_ == null) {
        result.person_ = person_;
      } else {
        result.person_ = personBuilder_.build();
      }
      if (identificationBuilder_ == null) {
        if (((bitField0_ & 0x00000008) == 0x00000008)) {
          identification_ = java.util.Collections.unmodifiableList(identification_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.identification_ = identification_;
      } else {
        result.identification_ = identificationBuilder_.build();
      }
      if (doctorRecBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          doctorRec_ = java.util.Collections.unmodifiableList(doctorRec_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.doctorRec_ = doctorRec_;
      } else {
        result.doctorRec_ = doctorRecBuilder_.build();
      }
      if (seenBuilder_ == null) {
        result.seen_ = seen_;
      } else {
        result.seen_ = seenBuilder_.build();
      }
      if (signupBuilder_ == null) {
        result.signup_ = signup_;
      } else {
        result.signup_ = signupBuilder_.build();
      }
      result.identities_ = internalGetIdentities();
      result.identities_.makeImmutable();
      result.media_ = internalGetMedia();
      result.media_.makeImmutable();
      if (consumerBuilder_ == null) {
        result.consumer_ = consumer_;
      } else {
        result.consumer_ = consumerBuilder_.build();
      }
      if (industryBuilder_ == null) {
        result.industry_ = industry_;
      } else {
        result.industry_ = industryBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.User) {
        return mergeFrom((io.bloombox.schema.identity.User)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.User other) {
      if (other == io.bloombox.schema.identity.User.getDefaultInstance()) return this;
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        onChanged();
      }
      if (other.hasFlags()) {
        mergeFlags(other.getFlags());
      }
      if (other.hasPerson()) {
        mergePerson(other.getPerson());
      }
      if (identificationBuilder_ == null) {
        if (!other.identification_.isEmpty()) {
          if (identification_.isEmpty()) {
            identification_ = other.identification_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureIdentificationIsMutable();
            identification_.addAll(other.identification_);
          }
          onChanged();
        }
      } else {
        if (!other.identification_.isEmpty()) {
          if (identificationBuilder_.isEmpty()) {
            identificationBuilder_.dispose();
            identificationBuilder_ = null;
            identification_ = other.identification_;
            bitField0_ = (bitField0_ & ~0x00000008);
            identificationBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getIdentificationFieldBuilder() : null;
          } else {
            identificationBuilder_.addAllMessages(other.identification_);
          }
        }
      }
      if (doctorRecBuilder_ == null) {
        if (!other.doctorRec_.isEmpty()) {
          if (doctorRec_.isEmpty()) {
            doctorRec_ = other.doctorRec_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDoctorRecIsMutable();
            doctorRec_.addAll(other.doctorRec_);
          }
          onChanged();
        }
      } else {
        if (!other.doctorRec_.isEmpty()) {
          if (doctorRecBuilder_.isEmpty()) {
            doctorRecBuilder_.dispose();
            doctorRecBuilder_ = null;
            doctorRec_ = other.doctorRec_;
            bitField0_ = (bitField0_ & ~0x00000010);
            doctorRecBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDoctorRecFieldBuilder() : null;
          } else {
            doctorRecBuilder_.addAllMessages(other.doctorRec_);
          }
        }
      }
      if (other.hasSeen()) {
        mergeSeen(other.getSeen());
      }
      if (other.hasSignup()) {
        mergeSignup(other.getSignup());
      }
      internalGetMutableIdentities().mergeFrom(
          other.internalGetIdentities());
      internalGetMutableMedia().mergeFrom(
          other.internalGetMedia());
      if (other.hasConsumer()) {
        mergeConsumer(other.getConsumer());
      }
      if (other.hasIndustry()) {
        mergeIndustry(other.getIndustry());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.User parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.User) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object uid_ = "";
    /**
     * <pre>
     * Unique ID for the user.
     * </pre>
     *
     * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Unique ID for the user.
     * </pre>
     *
     * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
     */
    public com.google.protobuf.ByteString
        getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Unique ID for the user.
     * </pre>
     *
     * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
     */
    public Builder setUid(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      uid_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unique ID for the user.
     * </pre>
     *
     * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
     */
    public Builder clearUid() {
      
      uid_ = getDefaultInstance().getUid();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Unique ID for the user.
     * </pre>
     *
     * <code>string uid = 1 [(.gen_bq_schema.description) = "Unique ID for the user."];</code>
     */
    public Builder setUidBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      uid_ = value;
      onChanged();
      return this;
    }

    private io.bloombox.schema.identity.UserFlags flags_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.UserFlags, io.bloombox.schema.identity.UserFlags.Builder, io.bloombox.schema.identity.UserFlagsOrBuilder> flagsBuilder_;
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public boolean hasFlags() {
      return flagsBuilder_ != null || flags_ != null;
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public io.bloombox.schema.identity.UserFlags getFlags() {
      if (flagsBuilder_ == null) {
        return flags_ == null ? io.bloombox.schema.identity.UserFlags.getDefaultInstance() : flags_;
      } else {
        return flagsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public Builder setFlags(io.bloombox.schema.identity.UserFlags value) {
      if (flagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        flags_ = value;
        onChanged();
      } else {
        flagsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public Builder setFlags(
        io.bloombox.schema.identity.UserFlags.Builder builderForValue) {
      if (flagsBuilder_ == null) {
        flags_ = builderForValue.build();
        onChanged();
      } else {
        flagsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public Builder mergeFlags(io.bloombox.schema.identity.UserFlags value) {
      if (flagsBuilder_ == null) {
        if (flags_ != null) {
          flags_ =
            io.bloombox.schema.identity.UserFlags.newBuilder(flags_).mergeFrom(value).buildPartial();
        } else {
          flags_ = value;
        }
        onChanged();
      } else {
        flagsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public Builder clearFlags() {
      if (flagsBuilder_ == null) {
        flags_ = null;
        onChanged();
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public io.bloombox.schema.identity.UserFlags.Builder getFlagsBuilder() {
      
      onChanged();
      return getFlagsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    public io.bloombox.schema.identity.UserFlagsOrBuilder getFlagsOrBuilder() {
      if (flagsBuilder_ != null) {
        return flagsBuilder_.getMessageOrBuilder();
      } else {
        return flags_ == null ?
            io.bloombox.schema.identity.UserFlags.getDefaultInstance() : flags_;
      }
    }
    /**
     * <pre>
     * Boolean flags for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserFlags flags = 2 [(.gen_bq_schema.description) = "Boolean flags for this user."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.UserFlags, io.bloombox.schema.identity.UserFlags.Builder, io.bloombox.schema.identity.UserFlagsOrBuilder> 
        getFlagsFieldBuilder() {
      if (flagsBuilder_ == null) {
        flagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.UserFlags, io.bloombox.schema.identity.UserFlags.Builder, io.bloombox.schema.identity.UserFlagsOrBuilder>(
                getFlags(),
                getParentForChildren(),
                isClean());
        flags_ = null;
      }
      return flagsBuilder_;
    }

    private io.opencannabis.schema.person.Person person_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> personBuilder_;
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public boolean hasPerson() {
      return personBuilder_ != null || person_ != null;
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public io.opencannabis.schema.person.Person getPerson() {
      if (personBuilder_ == null) {
        return person_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
      } else {
        return personBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public Builder setPerson(io.opencannabis.schema.person.Person value) {
      if (personBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        person_ = value;
        onChanged();
      } else {
        personBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public Builder setPerson(
        io.opencannabis.schema.person.Person.Builder builderForValue) {
      if (personBuilder_ == null) {
        person_ = builderForValue.build();
        onChanged();
      } else {
        personBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public Builder mergePerson(io.opencannabis.schema.person.Person value) {
      if (personBuilder_ == null) {
        if (person_ != null) {
          person_ =
            io.opencannabis.schema.person.Person.newBuilder(person_).mergeFrom(value).buildPartial();
        } else {
          person_ = value;
        }
        onChanged();
      } else {
        personBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public Builder clearPerson() {
      if (personBuilder_ == null) {
        person_ = null;
        onChanged();
      } else {
        person_ = null;
        personBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public io.opencannabis.schema.person.Person.Builder getPersonBuilder() {
      
      onChanged();
      return getPersonFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    public io.opencannabis.schema.person.PersonOrBuilder getPersonOrBuilder() {
      if (personBuilder_ != null) {
        return personBuilder_.getMessageOrBuilder();
      } else {
        return person_ == null ?
            io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
      }
    }
    /**
     * <pre>
     * Person's information that backs this user.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 3 [(.gen_bq_schema.description) = "Person&#92;'s information that backs this user."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> 
        getPersonFieldBuilder() {
      if (personBuilder_ == null) {
        personBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder>(
                getPerson(),
                getParentForChildren(),
                isClean());
        person_ = null;
      }
      return personBuilder_;
    }

    private java.util.List<io.bloombox.schema.identity.ID> identification_ =
      java.util.Collections.emptyList();
    private void ensureIdentificationIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        identification_ = new java.util.ArrayList<io.bloombox.schema.identity.ID>(identification_);
        bitField0_ |= 0x00000008;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder> identificationBuilder_;

    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public java.util.List<io.bloombox.schema.identity.ID> getIdentificationList() {
      if (identificationBuilder_ == null) {
        return java.util.Collections.unmodifiableList(identification_);
      } else {
        return identificationBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public int getIdentificationCount() {
      if (identificationBuilder_ == null) {
        return identification_.size();
      } else {
        return identificationBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ID getIdentification(int index) {
      if (identificationBuilder_ == null) {
        return identification_.get(index);
      } else {
        return identificationBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder setIdentification(
        int index, io.bloombox.schema.identity.ID value) {
      if (identificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentificationIsMutable();
        identification_.set(index, value);
        onChanged();
      } else {
        identificationBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder setIdentification(
        int index, io.bloombox.schema.identity.ID.Builder builderForValue) {
      if (identificationBuilder_ == null) {
        ensureIdentificationIsMutable();
        identification_.set(index, builderForValue.build());
        onChanged();
      } else {
        identificationBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder addIdentification(io.bloombox.schema.identity.ID value) {
      if (identificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentificationIsMutable();
        identification_.add(value);
        onChanged();
      } else {
        identificationBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder addIdentification(
        int index, io.bloombox.schema.identity.ID value) {
      if (identificationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIdentificationIsMutable();
        identification_.add(index, value);
        onChanged();
      } else {
        identificationBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder addIdentification(
        io.bloombox.schema.identity.ID.Builder builderForValue) {
      if (identificationBuilder_ == null) {
        ensureIdentificationIsMutable();
        identification_.add(builderForValue.build());
        onChanged();
      } else {
        identificationBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder addIdentification(
        int index, io.bloombox.schema.identity.ID.Builder builderForValue) {
      if (identificationBuilder_ == null) {
        ensureIdentificationIsMutable();
        identification_.add(index, builderForValue.build());
        onChanged();
      } else {
        identificationBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder addAllIdentification(
        java.lang.Iterable<? extends io.bloombox.schema.identity.ID> values) {
      if (identificationBuilder_ == null) {
        ensureIdentificationIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, identification_);
        onChanged();
      } else {
        identificationBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder clearIdentification() {
      if (identificationBuilder_ == null) {
        identification_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        identificationBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public Builder removeIdentification(int index) {
      if (identificationBuilder_ == null) {
        ensureIdentificationIsMutable();
        identification_.remove(index);
        onChanged();
      } else {
        identificationBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ID.Builder getIdentificationBuilder(
        int index) {
      return getIdentificationFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public io.bloombox.schema.identity.IDOrBuilder getIdentificationOrBuilder(
        int index) {
      if (identificationBuilder_ == null) {
        return identification_.get(index);  } else {
        return identificationBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public java.util.List<? extends io.bloombox.schema.identity.IDOrBuilder> 
         getIdentificationOrBuilderList() {
      if (identificationBuilder_ != null) {
        return identificationBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(identification_);
      }
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ID.Builder addIdentificationBuilder() {
      return getIdentificationFieldBuilder().addBuilder(
          io.bloombox.schema.identity.ID.getDefaultInstance());
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ID.Builder addIdentificationBuilder(
        int index) {
      return getIdentificationFieldBuilder().addBuilder(
          index, io.bloombox.schema.identity.ID.getDefaultInstance());
    }
    /**
     * <pre>
     * Government ID associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ID identification = 20 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Government ID associated with this user."];</code>
     */
    public java.util.List<io.bloombox.schema.identity.ID.Builder> 
         getIdentificationBuilderList() {
      return getIdentificationFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder> 
        getIdentificationFieldBuilder() {
      if (identificationBuilder_ == null) {
        identificationBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder>(
                identification_,
                ((bitField0_ & 0x00000008) == 0x00000008),
                getParentForChildren(),
                isClean());
        identification_ = null;
      }
      return identificationBuilder_;
    }

    private java.util.List<io.bloombox.schema.identity.ids.UserDoctorRec> doctorRec_ =
      java.util.Collections.emptyList();
    private void ensureDoctorRecIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        doctorRec_ = new java.util.ArrayList<io.bloombox.schema.identity.ids.UserDoctorRec>(doctorRec_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> doctorRecBuilder_;

    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public java.util.List<io.bloombox.schema.identity.ids.UserDoctorRec> getDoctorRecList() {
      if (doctorRecBuilder_ == null) {
        return java.util.Collections.unmodifiableList(doctorRec_);
      } else {
        return doctorRecBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public int getDoctorRecCount() {
      if (doctorRecBuilder_ == null) {
        return doctorRec_.size();
      } else {
        return doctorRecBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRec getDoctorRec(int index) {
      if (doctorRecBuilder_ == null) {
        return doctorRec_.get(index);
      } else {
        return doctorRecBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder setDoctorRec(
        int index, io.bloombox.schema.identity.ids.UserDoctorRec value) {
      if (doctorRecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDoctorRecIsMutable();
        doctorRec_.set(index, value);
        onChanged();
      } else {
        doctorRecBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder setDoctorRec(
        int index, io.bloombox.schema.identity.ids.UserDoctorRec.Builder builderForValue) {
      if (doctorRecBuilder_ == null) {
        ensureDoctorRecIsMutable();
        doctorRec_.set(index, builderForValue.build());
        onChanged();
      } else {
        doctorRecBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder addDoctorRec(io.bloombox.schema.identity.ids.UserDoctorRec value) {
      if (doctorRecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDoctorRecIsMutable();
        doctorRec_.add(value);
        onChanged();
      } else {
        doctorRecBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder addDoctorRec(
        int index, io.bloombox.schema.identity.ids.UserDoctorRec value) {
      if (doctorRecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDoctorRecIsMutable();
        doctorRec_.add(index, value);
        onChanged();
      } else {
        doctorRecBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder addDoctorRec(
        io.bloombox.schema.identity.ids.UserDoctorRec.Builder builderForValue) {
      if (doctorRecBuilder_ == null) {
        ensureDoctorRecIsMutable();
        doctorRec_.add(builderForValue.build());
        onChanged();
      } else {
        doctorRecBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder addDoctorRec(
        int index, io.bloombox.schema.identity.ids.UserDoctorRec.Builder builderForValue) {
      if (doctorRecBuilder_ == null) {
        ensureDoctorRecIsMutable();
        doctorRec_.add(index, builderForValue.build());
        onChanged();
      } else {
        doctorRecBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder addAllDoctorRec(
        java.lang.Iterable<? extends io.bloombox.schema.identity.ids.UserDoctorRec> values) {
      if (doctorRecBuilder_ == null) {
        ensureDoctorRecIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, doctorRec_);
        onChanged();
      } else {
        doctorRecBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder clearDoctorRec() {
      if (doctorRecBuilder_ == null) {
        doctorRec_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        doctorRecBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public Builder removeDoctorRec(int index) {
      if (doctorRecBuilder_ == null) {
        ensureDoctorRecIsMutable();
        doctorRec_.remove(index);
        onChanged();
      } else {
        doctorRecBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRec.Builder getDoctorRecBuilder(
        int index) {
      return getDoctorRecFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder getDoctorRecOrBuilder(
        int index) {
      if (doctorRecBuilder_ == null) {
        return doctorRec_.get(index);  } else {
        return doctorRecBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public java.util.List<? extends io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> 
         getDoctorRecOrBuilderList() {
      if (doctorRecBuilder_ != null) {
        return doctorRecBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(doctorRec_);
      }
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRec.Builder addDoctorRecBuilder() {
      return getDoctorRecFieldBuilder().addBuilder(
          io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance());
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRec.Builder addDoctorRecBuilder(
        int index) {
      return getDoctorRecFieldBuilder().addBuilder(
          index, io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance());
    }
    /**
     * <pre>
     * Doctor's recommendations associated with this user.
     * </pre>
     *
     * <code>repeated .bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 21 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Doctor&#92;'s recommendations associated with this user."];</code>
     */
    public java.util.List<io.bloombox.schema.identity.ids.UserDoctorRec.Builder> 
         getDoctorRecBuilderList() {
      return getDoctorRecFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> 
        getDoctorRecFieldBuilder() {
      if (doctorRecBuilder_ == null) {
        doctorRecBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder>(
                doctorRec_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        doctorRec_ = null;
      }
      return doctorRecBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant seen_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> seenBuilder_;
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public boolean hasSeen() {
      return seenBuilder_ != null || seen_ != null;
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getSeen() {
      if (seenBuilder_ == null) {
        return seen_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      } else {
        return seenBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public Builder setSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        seen_ = value;
        onChanged();
      } else {
        seenBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public Builder setSeen(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (seenBuilder_ == null) {
        seen_ = builderForValue.build();
        onChanged();
      } else {
        seenBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public Builder mergeSeen(io.opencannabis.schema.temporal.Instant value) {
      if (seenBuilder_ == null) {
        if (seen_ != null) {
          seen_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(seen_).mergeFrom(value).buildPartial();
        } else {
          seen_ = value;
        }
        onChanged();
      } else {
        seenBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public Builder clearSeen() {
      if (seenBuilder_ == null) {
        seen_ = null;
        onChanged();
      } else {
        seen_ = null;
        seenBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSeenBuilder() {
      
      onChanged();
      return getSeenFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSeenOrBuilder() {
      if (seenBuilder_ != null) {
        return seenBuilder_.getMessageOrBuilder();
      } else {
        return seen_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : seen_;
      }
    }
    /**
     * <pre>
     * Last time this user was seen, via auth/login/enrollment etc.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant seen = 30 [(.gen_bq_schema.description) = "Last time this user was seen, via auth/login/enrollment etc."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSeenFieldBuilder() {
      if (seenBuilder_ == null) {
        seenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSeen(),
                getParentForChildren(),
                isClean());
        seen_ = null;
      }
      return seenBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant signup_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> signupBuilder_;
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public boolean hasSignup() {
      return signupBuilder_ != null || signup_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getSignup() {
      if (signupBuilder_ == null) {
        return signup_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signup_;
      } else {
        return signupBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public Builder setSignup(io.opencannabis.schema.temporal.Instant value) {
      if (signupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        signup_ = value;
        onChanged();
      } else {
        signupBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public Builder setSignup(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (signupBuilder_ == null) {
        signup_ = builderForValue.build();
        onChanged();
      } else {
        signupBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public Builder mergeSignup(io.opencannabis.schema.temporal.Instant value) {
      if (signupBuilder_ == null) {
        if (signup_ != null) {
          signup_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(signup_).mergeFrom(value).buildPartial();
        } else {
          signup_ = value;
        }
        onChanged();
      } else {
        signupBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public Builder clearSignup() {
      if (signupBuilder_ == null) {
        signup_ = null;
        onChanged();
      } else {
        signup_ = null;
        signupBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getSignupBuilder() {
      
      onChanged();
      return getSignupFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getSignupOrBuilder() {
      if (signupBuilder_ != null) {
        return signupBuilder_.getMessageOrBuilder();
      } else {
        return signup_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : signup_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this user was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant signup = 31 [(.gen_bq_schema.description) = "Timestamp for when this user was created."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getSignupFieldBuilder() {
      if (signupBuilder_ == null) {
        signupBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getSignup(),
                getParentForChildren(),
                isClean());
        signup_ = null;
      }
      return signupBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.bloombox.schema.identity.UserIdentity> identities_;
    private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.identity.UserIdentity>
    internalGetIdentities() {
      if (identities_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            IdentitiesDefaultEntryHolder.defaultEntry);
      }
      return identities_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.identity.UserIdentity>
    internalGetMutableIdentities() {
      onChanged();;
      if (identities_ == null) {
        identities_ = com.google.protobuf.MapField.newMapField(
            IdentitiesDefaultEntryHolder.defaultEntry);
      }
      if (!identities_.isMutable()) {
        identities_ = identities_.copy();
      }
      return identities_;
    }

    public int getIdentitiesCount() {
      return internalGetIdentities().getMap().size();
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public boolean containsIdentities(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetIdentities().getMap().containsKey(key);
    }
    /**
     * Use {@link #getIdentitiesMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> getIdentities() {
      return getIdentitiesMap();
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> getIdentitiesMap() {
      return internalGetIdentities().getMap();
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public io.bloombox.schema.identity.UserIdentity getIdentitiesOrDefault(
        java.lang.String key,
        io.bloombox.schema.identity.UserIdentity defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> map =
          internalGetIdentities().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public io.bloombox.schema.identity.UserIdentity getIdentitiesOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> map =
          internalGetIdentities().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearIdentities() {
      internalGetMutableIdentities().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public Builder removeIdentities(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableIdentities().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity>
    getMutableIdentities() {
      return internalGetMutableIdentities().getMutableMap();
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */
    public Builder putIdentities(
        java.lang.String key,
        io.bloombox.schema.identity.UserIdentity value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableIdentities().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Identities associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.identity.UserIdentity&gt; identities = 40 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Identities associated with this user."];</code>
     */

    public Builder putAllIdentities(
        java.util.Map<java.lang.String, io.bloombox.schema.identity.UserIdentity> values) {
      internalGetMutableIdentities().getMutableMap()
          .putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.opencannabis.schema.media.MediaItem> media_;
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.media.MediaItem>
    internalGetMedia() {
      if (media_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MediaDefaultEntryHolder.defaultEntry);
      }
      return media_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.opencannabis.schema.media.MediaItem>
    internalGetMutableMedia() {
      onChanged();;
      if (media_ == null) {
        media_ = com.google.protobuf.MapField.newMapField(
            MediaDefaultEntryHolder.defaultEntry);
      }
      if (!media_.isMutable()) {
        media_ = media_.copy();
      }
      return media_;
    }

    public int getMediaCount() {
      return internalGetMedia().getMap().size();
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public boolean containsMedia(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetMedia().getMap().containsKey(key);
    }
    /**
     * Use {@link #getMediaMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> getMedia() {
      return getMediaMap();
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> getMediaMap() {
      return internalGetMedia().getMap();
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public io.opencannabis.schema.media.MediaItem getMediaOrDefault(
        java.lang.String key,
        io.opencannabis.schema.media.MediaItem defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> map =
          internalGetMedia().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public io.opencannabis.schema.media.MediaItem getMediaOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> map =
          internalGetMedia().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMedia() {
      internalGetMutableMedia().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public Builder removeMedia(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableMedia().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem>
    getMutableMedia() {
      return internalGetMutableMedia().getMutableMap();
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */
    public Builder putMedia(
        java.lang.String key,
        io.opencannabis.schema.media.MediaItem value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableMedia().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Media associated with this user.
     * </pre>
     *
     * <code>map&lt;string, .opencannabis.media.MediaItem&gt; media = 41 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "Media associated with this user."];</code>
     */

    public Builder putAllMedia(
        java.util.Map<java.lang.String, io.opencannabis.schema.media.MediaItem> values) {
      internalGetMutableMedia().getMutableMap()
          .putAll(values);
      return this;
    }

    private io.bloombox.schema.identity.ConsumerProfile consumer_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder> consumerBuilder_;
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public boolean hasConsumer() {
      return consumerBuilder_ != null || consumer_ != null;
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public io.bloombox.schema.identity.ConsumerProfile getConsumer() {
      if (consumerBuilder_ == null) {
        return consumer_ == null ? io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumer_;
      } else {
        return consumerBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public Builder setConsumer(io.bloombox.schema.identity.ConsumerProfile value) {
      if (consumerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        consumer_ = value;
        onChanged();
      } else {
        consumerBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public Builder setConsumer(
        io.bloombox.schema.identity.ConsumerProfile.Builder builderForValue) {
      if (consumerBuilder_ == null) {
        consumer_ = builderForValue.build();
        onChanged();
      } else {
        consumerBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public Builder mergeConsumer(io.bloombox.schema.identity.ConsumerProfile value) {
      if (consumerBuilder_ == null) {
        if (consumer_ != null) {
          consumer_ =
            io.bloombox.schema.identity.ConsumerProfile.newBuilder(consumer_).mergeFrom(value).buildPartial();
        } else {
          consumer_ = value;
        }
        onChanged();
      } else {
        consumerBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public Builder clearConsumer() {
      if (consumerBuilder_ == null) {
        consumer_ = null;
        onChanged();
      } else {
        consumer_ = null;
        consumerBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public io.bloombox.schema.identity.ConsumerProfile.Builder getConsumerBuilder() {
      
      onChanged();
      return getConsumerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    public io.bloombox.schema.identity.ConsumerProfileOrBuilder getConsumerOrBuilder() {
      if (consumerBuilder_ != null) {
        return consumerBuilder_.getMessageOrBuilder();
      } else {
        return consumer_ == null ?
            io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumer_;
      }
    }
    /**
     * <pre>
     * Consumer profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer = 100 [(.gen_bq_schema.description) = "Consumer profile for this user."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder> 
        getConsumerFieldBuilder() {
      if (consumerBuilder_ == null) {
        consumerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder>(
                getConsumer(),
                getParentForChildren(),
                isClean());
        consumer_ = null;
      }
      return consumerBuilder_;
    }

    private io.bloombox.schema.identity.IndustryProfile industry_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.IndustryProfile, io.bloombox.schema.identity.IndustryProfile.Builder, io.bloombox.schema.identity.IndustryProfileOrBuilder> industryBuilder_;
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public boolean hasIndustry() {
      return industryBuilder_ != null || industry_ != null;
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public io.bloombox.schema.identity.IndustryProfile getIndustry() {
      if (industryBuilder_ == null) {
        return industry_ == null ? io.bloombox.schema.identity.IndustryProfile.getDefaultInstance() : industry_;
      } else {
        return industryBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public Builder setIndustry(io.bloombox.schema.identity.IndustryProfile value) {
      if (industryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        industry_ = value;
        onChanged();
      } else {
        industryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public Builder setIndustry(
        io.bloombox.schema.identity.IndustryProfile.Builder builderForValue) {
      if (industryBuilder_ == null) {
        industry_ = builderForValue.build();
        onChanged();
      } else {
        industryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public Builder mergeIndustry(io.bloombox.schema.identity.IndustryProfile value) {
      if (industryBuilder_ == null) {
        if (industry_ != null) {
          industry_ =
            io.bloombox.schema.identity.IndustryProfile.newBuilder(industry_).mergeFrom(value).buildPartial();
        } else {
          industry_ = value;
        }
        onChanged();
      } else {
        industryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public Builder clearIndustry() {
      if (industryBuilder_ == null) {
        industry_ = null;
        onChanged();
      } else {
        industry_ = null;
        industryBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public io.bloombox.schema.identity.IndustryProfile.Builder getIndustryBuilder() {
      
      onChanged();
      return getIndustryFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    public io.bloombox.schema.identity.IndustryProfileOrBuilder getIndustryOrBuilder() {
      if (industryBuilder_ != null) {
        return industryBuilder_.getMessageOrBuilder();
      } else {
        return industry_ == null ?
            io.bloombox.schema.identity.IndustryProfile.getDefaultInstance() : industry_;
      }
    }
    /**
     * <pre>
     * Industry profile for this user.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IndustryProfile industry = 101 [(.gen_bq_schema.description) = "Industry profile for this user."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.identity.IndustryProfile, io.bloombox.schema.identity.IndustryProfile.Builder, io.bloombox.schema.identity.IndustryProfileOrBuilder> 
        getIndustryFieldBuilder() {
      if (industryBuilder_ == null) {
        industryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.identity.IndustryProfile, io.bloombox.schema.identity.IndustryProfile.Builder, io.bloombox.schema.identity.IndustryProfileOrBuilder>(
                getIndustry(),
                getParentForChildren(),
                isClean());
        industry_ = null;
      }
      return industryBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.User)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.User)
  private static final io.bloombox.schema.identity.User DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.User();
  }

  public static io.bloombox.schema.identity.User getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<User>
      PARSER = new com.google.protobuf.AbstractParser<User>() {
    public User parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new User(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<User> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<User> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.User getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

