/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/User.proto

package io.bloombox.schema.identity;

/**
 * <pre>
 * Boolean flags that may be set on a user account.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.UserFlags}
 */
public  final class UserFlags extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.UserFlags)
    UserFlagsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use UserFlags.newBuilder() to construct.
  private UserFlags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private UserFlags() {
    validated_ = false;
    suspended_ = false;
    admin_ = false;
    beta_ = false;
    sandbox_ = false;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private UserFlags(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            validated_ = input.readBool();
            break;
          }
          case 16: {

            suspended_ = input.readBool();
            break;
          }
          case 24: {

            admin_ = input.readBool();
            break;
          }
          case 32: {

            beta_ = input.readBool();
            break;
          }
          case 40: {

            sandbox_ = input.readBool();
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_UserFlags_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_UserFlags_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.UserFlags.class, io.bloombox.schema.identity.UserFlags.Builder.class);
  }

  public static final int VALIDATED_FIELD_NUMBER = 1;
  private boolean validated_;
  /**
   * <pre>
   * Indicates that the account has been validated.
   * </pre>
   *
   * <code>bool validated = 1 [(.gen_bq_schema.description) = "Indicates that the account has been validated."];</code>
   */
  public boolean getValidated() {
    return validated_;
  }

  public static final int SUSPENDED_FIELD_NUMBER = 2;
  private boolean suspended_;
  /**
   * <pre>
   * Indicates that the account is currently suspended.
   * </pre>
   *
   * <code>bool suspended = 2 [(.gen_bq_schema.description) = "Indicates that the account is currently suspended."];</code>
   */
  public boolean getSuspended() {
    return suspended_;
  }

  public static final int ADMIN_FIELD_NUMBER = 3;
  private boolean admin_;
  /**
   * <pre>
   * Indicates that the account has admin privileges.
   * </pre>
   *
   * <code>bool admin = 3 [(.gen_bq_schema.description) = "Indicates that the account has admin privileges."];</code>
   */
  public boolean getAdmin() {
    return admin_;
  }

  public static final int BETA_FIELD_NUMBER = 4;
  private boolean beta_;
  /**
   * <pre>
   * Indicates that the account has access to beta systems.
   * </pre>
   *
   * <code>bool beta = 4 [(.gen_bq_schema.description) = "Indicates that the account has access to beta systems."];</code>
   */
  public boolean getBeta() {
    return beta_;
  }

  public static final int SANDBOX_FIELD_NUMBER = 5;
  private boolean sandbox_;
  /**
   * <pre>
   * Indicates that the account has access to sandbox systems.
   * </pre>
   *
   * <code>bool sandbox = 5 [(.gen_bq_schema.description) = "Indicates that the account has access to sandbox systems."];</code>
   */
  public boolean getSandbox() {
    return sandbox_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (validated_ != false) {
      output.writeBool(1, validated_);
    }
    if (suspended_ != false) {
      output.writeBool(2, suspended_);
    }
    if (admin_ != false) {
      output.writeBool(3, admin_);
    }
    if (beta_ != false) {
      output.writeBool(4, beta_);
    }
    if (sandbox_ != false) {
      output.writeBool(5, sandbox_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (validated_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, validated_);
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(2, suspended_);
    }
    if (admin_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, admin_);
    }
    if (beta_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(4, beta_);
    }
    if (sandbox_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(5, sandbox_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.UserFlags)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.UserFlags other = (io.bloombox.schema.identity.UserFlags) obj;

    boolean result = true;
    result = result && (getValidated()
        == other.getValidated());
    result = result && (getSuspended()
        == other.getSuspended());
    result = result && (getAdmin()
        == other.getAdmin());
    result = result && (getBeta()
        == other.getBeta());
    result = result && (getSandbox()
        == other.getSandbox());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VALIDATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getValidated());
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSuspended());
    hash = (37 * hash) + ADMIN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAdmin());
    hash = (37 * hash) + BETA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getBeta());
    hash = (37 * hash) + SANDBOX_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSandbox());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.UserFlags parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.UserFlags parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.UserFlags parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.UserFlags parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.UserFlags prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Boolean flags that may be set on a user account.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.UserFlags}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.UserFlags)
      io.bloombox.schema.identity.UserFlagsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_UserFlags_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_UserFlags_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.UserFlags.class, io.bloombox.schema.identity.UserFlags.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.UserFlags.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      validated_ = false;

      suspended_ = false;

      admin_ = false;

      beta_ = false;

      sandbox_ = false;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.UserOuterClass.internal_static_bloombox_schema_identity_UserFlags_descriptor;
    }

    public io.bloombox.schema.identity.UserFlags getDefaultInstanceForType() {
      return io.bloombox.schema.identity.UserFlags.getDefaultInstance();
    }

    public io.bloombox.schema.identity.UserFlags build() {
      io.bloombox.schema.identity.UserFlags result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.UserFlags buildPartial() {
      io.bloombox.schema.identity.UserFlags result = new io.bloombox.schema.identity.UserFlags(this);
      result.validated_ = validated_;
      result.suspended_ = suspended_;
      result.admin_ = admin_;
      result.beta_ = beta_;
      result.sandbox_ = sandbox_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.UserFlags) {
        return mergeFrom((io.bloombox.schema.identity.UserFlags)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.UserFlags other) {
      if (other == io.bloombox.schema.identity.UserFlags.getDefaultInstance()) return this;
      if (other.getValidated() != false) {
        setValidated(other.getValidated());
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      if (other.getAdmin() != false) {
        setAdmin(other.getAdmin());
      }
      if (other.getBeta() != false) {
        setBeta(other.getBeta());
      }
      if (other.getSandbox() != false) {
        setSandbox(other.getSandbox());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.UserFlags parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.UserFlags) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private boolean validated_ ;
    /**
     * <pre>
     * Indicates that the account has been validated.
     * </pre>
     *
     * <code>bool validated = 1 [(.gen_bq_schema.description) = "Indicates that the account has been validated."];</code>
     */
    public boolean getValidated() {
      return validated_;
    }
    /**
     * <pre>
     * Indicates that the account has been validated.
     * </pre>
     *
     * <code>bool validated = 1 [(.gen_bq_schema.description) = "Indicates that the account has been validated."];</code>
     */
    public Builder setValidated(boolean value) {
      
      validated_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the account has been validated.
     * </pre>
     *
     * <code>bool validated = 1 [(.gen_bq_schema.description) = "Indicates that the account has been validated."];</code>
     */
    public Builder clearValidated() {
      
      validated_ = false;
      onChanged();
      return this;
    }

    private boolean suspended_ ;
    /**
     * <pre>
     * Indicates that the account is currently suspended.
     * </pre>
     *
     * <code>bool suspended = 2 [(.gen_bq_schema.description) = "Indicates that the account is currently suspended."];</code>
     */
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     * <pre>
     * Indicates that the account is currently suspended.
     * </pre>
     *
     * <code>bool suspended = 2 [(.gen_bq_schema.description) = "Indicates that the account is currently suspended."];</code>
     */
    public Builder setSuspended(boolean value) {
      
      suspended_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the account is currently suspended.
     * </pre>
     *
     * <code>bool suspended = 2 [(.gen_bq_schema.description) = "Indicates that the account is currently suspended."];</code>
     */
    public Builder clearSuspended() {
      
      suspended_ = false;
      onChanged();
      return this;
    }

    private boolean admin_ ;
    /**
     * <pre>
     * Indicates that the account has admin privileges.
     * </pre>
     *
     * <code>bool admin = 3 [(.gen_bq_schema.description) = "Indicates that the account has admin privileges."];</code>
     */
    public boolean getAdmin() {
      return admin_;
    }
    /**
     * <pre>
     * Indicates that the account has admin privileges.
     * </pre>
     *
     * <code>bool admin = 3 [(.gen_bq_schema.description) = "Indicates that the account has admin privileges."];</code>
     */
    public Builder setAdmin(boolean value) {
      
      admin_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the account has admin privileges.
     * </pre>
     *
     * <code>bool admin = 3 [(.gen_bq_schema.description) = "Indicates that the account has admin privileges."];</code>
     */
    public Builder clearAdmin() {
      
      admin_ = false;
      onChanged();
      return this;
    }

    private boolean beta_ ;
    /**
     * <pre>
     * Indicates that the account has access to beta systems.
     * </pre>
     *
     * <code>bool beta = 4 [(.gen_bq_schema.description) = "Indicates that the account has access to beta systems."];</code>
     */
    public boolean getBeta() {
      return beta_;
    }
    /**
     * <pre>
     * Indicates that the account has access to beta systems.
     * </pre>
     *
     * <code>bool beta = 4 [(.gen_bq_schema.description) = "Indicates that the account has access to beta systems."];</code>
     */
    public Builder setBeta(boolean value) {
      
      beta_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the account has access to beta systems.
     * </pre>
     *
     * <code>bool beta = 4 [(.gen_bq_schema.description) = "Indicates that the account has access to beta systems."];</code>
     */
    public Builder clearBeta() {
      
      beta_ = false;
      onChanged();
      return this;
    }

    private boolean sandbox_ ;
    /**
     * <pre>
     * Indicates that the account has access to sandbox systems.
     * </pre>
     *
     * <code>bool sandbox = 5 [(.gen_bq_schema.description) = "Indicates that the account has access to sandbox systems."];</code>
     */
    public boolean getSandbox() {
      return sandbox_;
    }
    /**
     * <pre>
     * Indicates that the account has access to sandbox systems.
     * </pre>
     *
     * <code>bool sandbox = 5 [(.gen_bq_schema.description) = "Indicates that the account has access to sandbox systems."];</code>
     */
    public Builder setSandbox(boolean value) {
      
      sandbox_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the account has access to sandbox systems.
     * </pre>
     *
     * <code>bool sandbox = 5 [(.gen_bq_schema.description) = "Indicates that the account has access to sandbox systems."];</code>
     */
    public Builder clearSandbox() {
      
      sandbox_ = false;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.UserFlags)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.UserFlags)
  private static final io.bloombox.schema.identity.UserFlags DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.UserFlags();
  }

  public static io.bloombox.schema.identity.UserFlags getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserFlags>
      PARSER = new com.google.protobuf.AbstractParser<UserFlags>() {
    public UserFlags parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new UserFlags(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<UserFlags> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserFlags> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.UserFlags getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

