/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: identity/ids/UserDoctorRec.proto

package io.bloombox.schema.identity.ids;

/**
 * <pre>
 * Doctor recommendation to allow a consumer to purchase cannabis in a restricted market.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.identity.ids.UserDoctorRec}
 */
public  final class UserDoctorRec extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.identity.ids.UserDoctorRec)
    UserDoctorRecOrBuilder {
private static final long serialVersionUID = 0L;
  // Use UserDoctorRec.newBuilder() to construct.
  private UserDoctorRec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private UserDoctorRec() {
    id_ = "";
    barcode_ = "";
    state_ = 0;
    country_ = "";
    doctorId_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private UserDoctorRec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 18: {
            io.opencannabis.schema.temporal.Date.Builder subBuilder = null;
            if (expirationDate_ != null) {
              subBuilder = expirationDate_.toBuilder();
            }
            expirationDate_ = input.readMessage(io.opencannabis.schema.temporal.Date.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(expirationDate_);
              expirationDate_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            barcode_ = s;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            state_ = rawValue;
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();

            country_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();

            doctorId_ = s;
            break;
          }
          case 58: {
            io.opencannabis.schema.person.Person.Builder subBuilder = null;
            if (doctor_ != null) {
              subBuilder = doctor_.toBuilder();
            }
            doctor_ = input.readMessage(io.opencannabis.schema.person.Person.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(doctor_);
              doctor_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.identity.ids.UserDoctorRecOuterClass.internal_static_bloombox_schema_identity_ids_UserDoctorRec_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.identity.ids.UserDoctorRecOuterClass.internal_static_bloombox_schema_identity_ids_UserDoctorRec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.identity.ids.UserDoctorRec.class, io.bloombox.schema.identity.ids.UserDoctorRec.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * ID number/unique code.
   * </pre>
   *
   * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * ID number/unique code.
   * </pre>
   *
   * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRATION_DATE_FIELD_NUMBER = 2;
  private io.opencannabis.schema.temporal.Date expirationDate_;
  /**
   * <pre>
   * Expiration date for the recommendation.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
   */
  public boolean hasExpirationDate() {
    return expirationDate_ != null;
  }
  /**
   * <pre>
   * Expiration date for the recommendation.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
   */
  public io.opencannabis.schema.temporal.Date getExpirationDate() {
    return expirationDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : expirationDate_;
  }
  /**
   * <pre>
   * Expiration date for the recommendation.
   * </pre>
   *
   * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
   */
  public io.opencannabis.schema.temporal.DateOrBuilder getExpirationDateOrBuilder() {
    return getExpirationDate();
  }

  public static final int BARCODE_FIELD_NUMBER = 3;
  private volatile java.lang.Object barcode_;
  /**
   * <pre>
   * Raw barcode value.
   * </pre>
   *
   * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
   */
  public java.lang.String getBarcode() {
    java.lang.Object ref = barcode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      barcode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Raw barcode value.
   * </pre>
   *
   * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
   */
  public com.google.protobuf.ByteString
      getBarcodeBytes() {
    java.lang.Object ref = barcode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      barcode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   * <pre>
   * US state where the recommendation is valid.
   * </pre>
   *
   * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
   */
  public int getStateValue() {
    return state_;
  }
  /**
   * <pre>
   * US state where the recommendation is valid.
   * </pre>
   *
   * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
   */
  public io.opencannabis.schema.geo.usa.USState getState() {
    io.opencannabis.schema.geo.usa.USState result = io.opencannabis.schema.geo.usa.USState.valueOf(state_);
    return result == null ? io.opencannabis.schema.geo.usa.USState.UNRECOGNIZED : result;
  }

  public static final int COUNTRY_FIELD_NUMBER = 5;
  private volatile java.lang.Object country_;
  /**
   * <pre>
   * Country for the recommendation.
   * </pre>
   *
   * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
   */
  public java.lang.String getCountry() {
    java.lang.Object ref = country_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      country_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Country for the recommendation.
   * </pre>
   *
   * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
   */
  public com.google.protobuf.ByteString
      getCountryBytes() {
    java.lang.Object ref = country_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      country_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCTOR_ID_FIELD_NUMBER = 6;
  private volatile java.lang.Object doctorId_;
  /**
   * <pre>
   * Doctor's unique ID.
   * </pre>
   *
   * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
   */
  public java.lang.String getDoctorId() {
    java.lang.Object ref = doctorId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      doctorId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Doctor's unique ID.
   * </pre>
   *
   * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
   */
  public com.google.protobuf.ByteString
      getDoctorIdBytes() {
    java.lang.Object ref = doctorId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      doctorId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOCTOR_FIELD_NUMBER = 7;
  private io.opencannabis.schema.person.Person doctor_;
  /**
   * <pre>
   * Personal information about the physician.
   * </pre>
   *
   * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
   */
  public boolean hasDoctor() {
    return doctor_ != null;
  }
  /**
   * <pre>
   * Personal information about the physician.
   * </pre>
   *
   * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
   */
  public io.opencannabis.schema.person.Person getDoctor() {
    return doctor_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : doctor_;
  }
  /**
   * <pre>
   * Personal information about the physician.
   * </pre>
   *
   * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
   */
  public io.opencannabis.schema.person.PersonOrBuilder getDoctorOrBuilder() {
    return getDoctor();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (expirationDate_ != null) {
      output.writeMessage(2, getExpirationDate());
    }
    if (!getBarcodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, barcode_);
    }
    if (state_ != io.opencannabis.schema.geo.usa.USState.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (!getCountryBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, country_);
    }
    if (!getDoctorIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, doctorId_);
    }
    if (doctor_ != null) {
      output.writeMessage(7, getDoctor());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (expirationDate_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getExpirationDate());
    }
    if (!getBarcodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, barcode_);
    }
    if (state_ != io.opencannabis.schema.geo.usa.USState.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, state_);
    }
    if (!getCountryBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, country_);
    }
    if (!getDoctorIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, doctorId_);
    }
    if (doctor_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getDoctor());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.identity.ids.UserDoctorRec)) {
      return super.equals(obj);
    }
    io.bloombox.schema.identity.ids.UserDoctorRec other = (io.bloombox.schema.identity.ids.UserDoctorRec) obj;

    boolean result = true;
    result = result && getId()
        .equals(other.getId());
    result = result && (hasExpirationDate() == other.hasExpirationDate());
    if (hasExpirationDate()) {
      result = result && getExpirationDate()
          .equals(other.getExpirationDate());
    }
    result = result && getBarcode()
        .equals(other.getBarcode());
    result = result && state_ == other.state_;
    result = result && getCountry()
        .equals(other.getCountry());
    result = result && getDoctorId()
        .equals(other.getDoctorId());
    result = result && (hasDoctor() == other.hasDoctor());
    if (hasDoctor()) {
      result = result && getDoctor()
          .equals(other.getDoctor());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (hasExpirationDate()) {
      hash = (37 * hash) + EXPIRATION_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getExpirationDate().hashCode();
    }
    hash = (37 * hash) + BARCODE_FIELD_NUMBER;
    hash = (53 * hash) + getBarcode().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
    hash = (53 * hash) + getCountry().hashCode();
    hash = (37 * hash) + DOCTOR_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDoctorId().hashCode();
    if (hasDoctor()) {
      hash = (37 * hash) + DOCTOR_FIELD_NUMBER;
      hash = (53 * hash) + getDoctor().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.identity.ids.UserDoctorRec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.identity.ids.UserDoctorRec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Doctor recommendation to allow a consumer to purchase cannabis in a restricted market.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.identity.ids.UserDoctorRec}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.identity.ids.UserDoctorRec)
      io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.identity.ids.UserDoctorRecOuterClass.internal_static_bloombox_schema_identity_ids_UserDoctorRec_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.identity.ids.UserDoctorRecOuterClass.internal_static_bloombox_schema_identity_ids_UserDoctorRec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.identity.ids.UserDoctorRec.class, io.bloombox.schema.identity.ids.UserDoctorRec.Builder.class);
    }

    // Construct using io.bloombox.schema.identity.ids.UserDoctorRec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      if (expirationDateBuilder_ == null) {
        expirationDate_ = null;
      } else {
        expirationDate_ = null;
        expirationDateBuilder_ = null;
      }
      barcode_ = "";

      state_ = 0;

      country_ = "";

      doctorId_ = "";

      if (doctorBuilder_ == null) {
        doctor_ = null;
      } else {
        doctor_ = null;
        doctorBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.identity.ids.UserDoctorRecOuterClass.internal_static_bloombox_schema_identity_ids_UserDoctorRec_descriptor;
    }

    public io.bloombox.schema.identity.ids.UserDoctorRec getDefaultInstanceForType() {
      return io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance();
    }

    public io.bloombox.schema.identity.ids.UserDoctorRec build() {
      io.bloombox.schema.identity.ids.UserDoctorRec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.identity.ids.UserDoctorRec buildPartial() {
      io.bloombox.schema.identity.ids.UserDoctorRec result = new io.bloombox.schema.identity.ids.UserDoctorRec(this);
      result.id_ = id_;
      if (expirationDateBuilder_ == null) {
        result.expirationDate_ = expirationDate_;
      } else {
        result.expirationDate_ = expirationDateBuilder_.build();
      }
      result.barcode_ = barcode_;
      result.state_ = state_;
      result.country_ = country_;
      result.doctorId_ = doctorId_;
      if (doctorBuilder_ == null) {
        result.doctor_ = doctor_;
      } else {
        result.doctor_ = doctorBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.identity.ids.UserDoctorRec) {
        return mergeFrom((io.bloombox.schema.identity.ids.UserDoctorRec)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.identity.ids.UserDoctorRec other) {
      if (other == io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (other.hasExpirationDate()) {
        mergeExpirationDate(other.getExpirationDate());
      }
      if (!other.getBarcode().isEmpty()) {
        barcode_ = other.barcode_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getCountry().isEmpty()) {
        country_ = other.country_;
        onChanged();
      }
      if (!other.getDoctorId().isEmpty()) {
        doctorId_ = other.doctorId_;
        onChanged();
      }
      if (other.hasDoctor()) {
        mergeDoctor(other.getDoctor());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.identity.ids.UserDoctorRec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.identity.ids.UserDoctorRec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * ID number/unique code.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * ID number/unique code.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * ID number/unique code.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID number/unique code.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * ID number/unique code.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.description) = "ID number/unique code."];</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Date expirationDate_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> expirationDateBuilder_;
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public boolean hasExpirationDate() {
      return expirationDateBuilder_ != null || expirationDate_ != null;
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public io.opencannabis.schema.temporal.Date getExpirationDate() {
      if (expirationDateBuilder_ == null) {
        return expirationDate_ == null ? io.opencannabis.schema.temporal.Date.getDefaultInstance() : expirationDate_;
      } else {
        return expirationDateBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public Builder setExpirationDate(io.opencannabis.schema.temporal.Date value) {
      if (expirationDateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expirationDate_ = value;
        onChanged();
      } else {
        expirationDateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public Builder setExpirationDate(
        io.opencannabis.schema.temporal.Date.Builder builderForValue) {
      if (expirationDateBuilder_ == null) {
        expirationDate_ = builderForValue.build();
        onChanged();
      } else {
        expirationDateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public Builder mergeExpirationDate(io.opencannabis.schema.temporal.Date value) {
      if (expirationDateBuilder_ == null) {
        if (expirationDate_ != null) {
          expirationDate_ =
            io.opencannabis.schema.temporal.Date.newBuilder(expirationDate_).mergeFrom(value).buildPartial();
        } else {
          expirationDate_ = value;
        }
        onChanged();
      } else {
        expirationDateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public Builder clearExpirationDate() {
      if (expirationDateBuilder_ == null) {
        expirationDate_ = null;
        onChanged();
      } else {
        expirationDate_ = null;
        expirationDateBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public io.opencannabis.schema.temporal.Date.Builder getExpirationDateBuilder() {
      
      onChanged();
      return getExpirationDateFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    public io.opencannabis.schema.temporal.DateOrBuilder getExpirationDateOrBuilder() {
      if (expirationDateBuilder_ != null) {
        return expirationDateBuilder_.getMessageOrBuilder();
      } else {
        return expirationDate_ == null ?
            io.opencannabis.schema.temporal.Date.getDefaultInstance() : expirationDate_;
      }
    }
    /**
     * <pre>
     * Expiration date for the recommendation.
     * </pre>
     *
     * <code>.opencannabis.temporal.Date expiration_date = 2 [(.gen_bq_schema.description) = "Expiration date for the recommendation."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder> 
        getExpirationDateFieldBuilder() {
      if (expirationDateBuilder_ == null) {
        expirationDateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Date, io.opencannabis.schema.temporal.Date.Builder, io.opencannabis.schema.temporal.DateOrBuilder>(
                getExpirationDate(),
                getParentForChildren(),
                isClean());
        expirationDate_ = null;
      }
      return expirationDateBuilder_;
    }

    private java.lang.Object barcode_ = "";
    /**
     * <pre>
     * Raw barcode value.
     * </pre>
     *
     * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
     */
    public java.lang.String getBarcode() {
      java.lang.Object ref = barcode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        barcode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Raw barcode value.
     * </pre>
     *
     * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
     */
    public com.google.protobuf.ByteString
        getBarcodeBytes() {
      java.lang.Object ref = barcode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        barcode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Raw barcode value.
     * </pre>
     *
     * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
     */
    public Builder setBarcode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      barcode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw barcode value.
     * </pre>
     *
     * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
     */
    public Builder clearBarcode() {
      
      barcode_ = getDefaultInstance().getBarcode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw barcode value.
     * </pre>
     *
     * <code>string barcode = 3 [(.gen_bq_schema.description) = "Raw barcode value."];</code>
     */
    public Builder setBarcodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      barcode_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     * <pre>
     * US state where the recommendation is valid.
     * </pre>
     *
     * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
     */
    public int getStateValue() {
      return state_;
    }
    /**
     * <pre>
     * US state where the recommendation is valid.
     * </pre>
     *
     * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * US state where the recommendation is valid.
     * </pre>
     *
     * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
     */
    public io.opencannabis.schema.geo.usa.USState getState() {
      io.opencannabis.schema.geo.usa.USState result = io.opencannabis.schema.geo.usa.USState.valueOf(state_);
      return result == null ? io.opencannabis.schema.geo.usa.USState.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * US state where the recommendation is valid.
     * </pre>
     *
     * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
     */
    public Builder setState(io.opencannabis.schema.geo.usa.USState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * US state where the recommendation is valid.
     * </pre>
     *
     * <code>.opencannabis.geo.usa.USState state = 4 [(.gen_bq_schema.description) = "US state where the recommendation is valid."];</code>
     */
    public Builder clearState() {
      
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object country_ = "";
    /**
     * <pre>
     * Country for the recommendation.
     * </pre>
     *
     * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
     */
    public java.lang.String getCountry() {
      java.lang.Object ref = country_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        country_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Country for the recommendation.
     * </pre>
     *
     * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
     */
    public com.google.protobuf.ByteString
        getCountryBytes() {
      java.lang.Object ref = country_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        country_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Country for the recommendation.
     * </pre>
     *
     * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
     */
    public Builder setCountry(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      country_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Country for the recommendation.
     * </pre>
     *
     * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
     */
    public Builder clearCountry() {
      
      country_ = getDefaultInstance().getCountry();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Country for the recommendation.
     * </pre>
     *
     * <code>string country = 5 [(.gen_bq_schema.description) = "Country for the recommendation."];</code>
     */
    public Builder setCountryBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      country_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object doctorId_ = "";
    /**
     * <pre>
     * Doctor's unique ID.
     * </pre>
     *
     * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
     */
    public java.lang.String getDoctorId() {
      java.lang.Object ref = doctorId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        doctorId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Doctor's unique ID.
     * </pre>
     *
     * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
     */
    public com.google.protobuf.ByteString
        getDoctorIdBytes() {
      java.lang.Object ref = doctorId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        doctorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Doctor's unique ID.
     * </pre>
     *
     * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
     */
    public Builder setDoctorId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      doctorId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Doctor's unique ID.
     * </pre>
     *
     * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
     */
    public Builder clearDoctorId() {
      
      doctorId_ = getDefaultInstance().getDoctorId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Doctor's unique ID.
     * </pre>
     *
     * <code>string doctor_id = 6 [(.gen_bq_schema.description) = "Doctor&#92;'s unique ID."];</code>
     */
    public Builder setDoctorIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      doctorId_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.person.Person doctor_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> doctorBuilder_;
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public boolean hasDoctor() {
      return doctorBuilder_ != null || doctor_ != null;
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public io.opencannabis.schema.person.Person getDoctor() {
      if (doctorBuilder_ == null) {
        return doctor_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : doctor_;
      } else {
        return doctorBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public Builder setDoctor(io.opencannabis.schema.person.Person value) {
      if (doctorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        doctor_ = value;
        onChanged();
      } else {
        doctorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public Builder setDoctor(
        io.opencannabis.schema.person.Person.Builder builderForValue) {
      if (doctorBuilder_ == null) {
        doctor_ = builderForValue.build();
        onChanged();
      } else {
        doctorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public Builder mergeDoctor(io.opencannabis.schema.person.Person value) {
      if (doctorBuilder_ == null) {
        if (doctor_ != null) {
          doctor_ =
            io.opencannabis.schema.person.Person.newBuilder(doctor_).mergeFrom(value).buildPartial();
        } else {
          doctor_ = value;
        }
        onChanged();
      } else {
        doctorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public Builder clearDoctor() {
      if (doctorBuilder_ == null) {
        doctor_ = null;
        onChanged();
      } else {
        doctor_ = null;
        doctorBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public io.opencannabis.schema.person.Person.Builder getDoctorBuilder() {
      
      onChanged();
      return getDoctorFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    public io.opencannabis.schema.person.PersonOrBuilder getDoctorOrBuilder() {
      if (doctorBuilder_ != null) {
        return doctorBuilder_.getMessageOrBuilder();
      } else {
        return doctor_ == null ?
            io.opencannabis.schema.person.Person.getDefaultInstance() : doctor_;
      }
    }
    /**
     * <pre>
     * Personal information about the physician.
     * </pre>
     *
     * <code>.opencannabis.person.Person doctor = 7 [(.gen_bq_schema.description) = "Personal information about the physician."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> 
        getDoctorFieldBuilder() {
      if (doctorBuilder_ == null) {
        doctorBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder>(
                getDoctor(),
                getParentForChildren(),
                isClean());
        doctor_ = null;
      }
      return doctorBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.identity.ids.UserDoctorRec)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.identity.ids.UserDoctorRec)
  private static final io.bloombox.schema.identity.ids.UserDoctorRec DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.identity.ids.UserDoctorRec();
  }

  public static io.bloombox.schema.identity.ids.UserDoctorRec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserDoctorRec>
      PARSER = new com.google.protobuf.AbstractParser<UserDoctorRec>() {
    public UserDoctorRec parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new UserDoctorRec(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<UserDoctorRec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserDoctorRec> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.identity.ids.UserDoctorRec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

