/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/Campaign.proto

package io.bloombox.schema.marketing;

public final class MarketingCampaign {
  private MarketingCampaign() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies channels which marketing campaigns may be associated with.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.marketing.Channel}
   */
  public enum Channel
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unspecified, or default, channel type.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     * <pre>
     * Email channel type.
     * </pre>
     *
     * <code>EMAIL = 1;</code>
     */
    EMAIL(1),
    /**
     * <pre>
     * SMS, or text, channel type.
     * </pre>
     *
     * <code>SMS = 2;</code>
     */
    SMS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unspecified, or default, channel type.
     * </pre>
     *
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * Email channel type.
     * </pre>
     *
     * <code>EMAIL = 1;</code>
     */
    public static final int EMAIL_VALUE = 1;
    /**
     * <pre>
     * SMS, or text, channel type.
     * </pre>
     *
     * <code>SMS = 2;</code>
     */
    public static final int SMS_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Channel valueOf(int value) {
      return forNumber(value);
    }

    public static Channel forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED;
        case 1: return EMAIL;
        case 2: return SMS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Channel>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Channel> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Channel>() {
            public Channel findValueByNumber(int number) {
              return Channel.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.getDescriptor().getEnumTypes().get(0);
    }

    private static final Channel[] VALUES = values();

    public static Channel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Channel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.marketing.Channel)
  }

  /**
   * <pre>
   * Enumerates the statuses a campaign object may live in.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.marketing.CampaignStatus}
   */
  public enum CampaignStatus
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The campaign draft status is unspecified, or not-yet-written.
     * </pre>
     *
     * <code>PENDING = 0;</code>
     */
    PENDING(0),
    /**
     * <pre>
     * The campaign is a draft and has not yet been sent.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    DRAFT(1),
    /**
     * <pre>
     * The campaign is queued for sending, but has not yet been sent.
     * </pre>
     *
     * <code>QUEUED = 2;</code>
     */
    QUEUED(2),
    /**
     * <pre>
     * The campaign is actively sending.
     * </pre>
     *
     * <code>SENDING = 3;</code>
     */
    SENDING(3),
    /**
     * <pre>
     * The campaign is finished.
     * </pre>
     *
     * <code>DONE = 4;</code>
     */
    DONE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The campaign draft status is unspecified, or not-yet-written.
     * </pre>
     *
     * <code>PENDING = 0;</code>
     */
    public static final int PENDING_VALUE = 0;
    /**
     * <pre>
     * The campaign is a draft and has not yet been sent.
     * </pre>
     *
     * <code>DRAFT = 1;</code>
     */
    public static final int DRAFT_VALUE = 1;
    /**
     * <pre>
     * The campaign is queued for sending, but has not yet been sent.
     * </pre>
     *
     * <code>QUEUED = 2;</code>
     */
    public static final int QUEUED_VALUE = 2;
    /**
     * <pre>
     * The campaign is actively sending.
     * </pre>
     *
     * <code>SENDING = 3;</code>
     */
    public static final int SENDING_VALUE = 3;
    /**
     * <pre>
     * The campaign is finished.
     * </pre>
     *
     * <code>DONE = 4;</code>
     */
    public static final int DONE_VALUE = 4;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CampaignStatus valueOf(int value) {
      return forNumber(value);
    }

    public static CampaignStatus forNumber(int value) {
      switch (value) {
        case 0: return PENDING;
        case 1: return DRAFT;
        case 2: return QUEUED;
        case 3: return SENDING;
        case 4: return DONE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CampaignStatus>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        CampaignStatus> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<CampaignStatus>() {
            public CampaignStatus findValueByNumber(int number) {
              return CampaignStatus.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.getDescriptor().getEnumTypes().get(1);
    }

    private static final CampaignStatus[] VALUES = values();

    public static CampaignStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CampaignStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.marketing.CampaignStatus)
  }

  public interface CampaignTagOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.CampaignTag)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Unique ID for this campaign tag.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * Unique ID for this campaign tag.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Label, or category, for a campaign.
     * </pre>
     *
     * <code>string label = 2;</code>
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * Label, or category, for a campaign.
     * </pre>
     *
     * <code>string label = 2;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();
  }
  /**
   * <pre>
   * Tags applied to a campaign to organize/group similar marketing efforts.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.CampaignTag}
   */
  public  static final class CampaignTag extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.CampaignTag)
      CampaignTagOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CampaignTag.newBuilder() to construct.
    private CampaignTag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CampaignTag() {
      id_ = "";
      label_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CampaignTag(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTag_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * Unique ID for this campaign tag.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Unique ID for this campaign tag.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABEL_FIELD_NUMBER = 2;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * Label, or category, for a campaign.
     * </pre>
     *
     * <code>string label = 2;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Label, or category, for a campaign.
     * </pre>
     *
     * <code>string label = 2;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignTag)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.CampaignTag other = (io.bloombox.schema.marketing.MarketingCampaign.CampaignTag) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Tags applied to a campaign to organize/group similar marketing efforts.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.CampaignTag}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.CampaignTag)
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTag_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        label_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTag_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag build() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag result = new io.bloombox.schema.marketing.MarketingCampaign.CampaignTag(this);
        result.id_ = id_;
        result.label_ = label_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignTag) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.CampaignTag)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.CampaignTag) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * Unique ID for this campaign tag.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for this campaign tag.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for this campaign tag.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for this campaign tag.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for this campaign tag.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <pre>
       * Label, or category, for a campaign.
       * </pre>
       *
       * <code>string label = 2;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Label, or category, for a campaign.
       * </pre>
       *
       * <code>string label = 2;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Label, or category, for a campaign.
       * </pre>
       *
       * <code>string label = 2;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Label, or category, for a campaign.
       * </pre>
       *
       * <code>string label = 2;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Label, or category, for a campaign.
       * </pre>
       *
       * <code>string label = 2;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.CampaignTag)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.CampaignTag)
    private static final io.bloombox.schema.marketing.MarketingCampaign.CampaignTag DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.CampaignTag();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CampaignTag>
        PARSER = new com.google.protobuf.AbstractParser<CampaignTag>() {
      public CampaignTag parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CampaignTag(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CampaignTag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CampaignTag> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ChannelSettingsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.ChannelSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Channel for which we are specifying settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
     */
    int getChannelValue();
    /**
     * <pre>
     * Channel for which we are specifying settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel();

    /**
     * <pre>
     * Whether this channel is active or not.
     * </pre>
     *
     * <code>bool active = 2;</code>
     */
    boolean getActive();

    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    boolean hasSms();
    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getSms();
    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder getSmsOrBuilder();

    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    boolean hasEmail();
    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getEmail();
    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder getEmailOrBuilder();

    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SettingsCase getSettingsCase();
  }
  /**
   * <pre>
   * Settings for a given channel.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.ChannelSettings}
   */
  public  static final class ChannelSettings extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.ChannelSettings)
      ChannelSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ChannelSettings.newBuilder() to construct.
    private ChannelSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ChannelSettings() {
      channel_ = 0;
      active_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ChannelSettings(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              channel_ = rawValue;
              break;
            }
            case 16: {

              active_ = input.readBool();
              break;
            }
            case 162: {
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder subBuilder = null;
              if (settingsCase_ == 20) {
                subBuilder = ((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_).toBuilder();
              }
              settings_ =
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_);
                settings_ = subBuilder.buildPartial();
              }
              settingsCase_ = 20;
              break;
            }
            case 170: {
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder subBuilder = null;
              if (settingsCase_ == 21) {
                subBuilder = ((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_).toBuilder();
              }
              settings_ =
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_);
                settings_ = subBuilder.buildPartial();
              }
              settingsCase_ = 21;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder.class);
    }

    public interface SMSOrBuilder extends
        // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.ChannelSettings.SMS)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Origin phone number to send the SMS from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      java.lang.String getSender();
      /**
       * <pre>
       * Origin phone number to send the SMS from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      com.google.protobuf.ByteString
          getSenderBytes();
    }
    /**
     * <pre>
     * SMS-specific settings.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.ChannelSettings.SMS}
     */
    public  static final class SMS extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.ChannelSettings.SMS)
        SMSOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use SMS.newBuilder() to construct.
      private SMS(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private SMS() {
        sender_ = "";
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private SMS(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownFieldProto3(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                sender_ = s;
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_SMS_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder.class);
      }

      public static final int SENDER_FIELD_NUMBER = 1;
      private volatile java.lang.Object sender_;
      /**
       * <pre>
       * Origin phone number to send the SMS from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      public java.lang.String getSender() {
        java.lang.Object ref = sender_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sender_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Origin phone number to send the SMS from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSenderBytes() {
        java.lang.Object ref = sender_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sender_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!getSenderBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sender_);
        }
        unknownFields.writeTo(output);
      }

      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getSenderBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sender_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS)) {
          return super.equals(obj);
        }
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS other = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) obj;

        boolean result = true;
        result = result && getSender()
            .equals(other.getSender());
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SENDER_FIELD_NUMBER;
        hash = (53 * hash) + getSender().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * SMS-specific settings.
       * </pre>
       *
       * Protobuf type {@code bloombox.schema.marketing.ChannelSettings.SMS}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.ChannelSettings.SMS)
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor;
        }

        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_SMS_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder.class);
        }

        // Construct using io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        public Builder clear() {
          super.clear();
          sender_ = "";

          return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor;
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getDefaultInstanceForType() {
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS build() {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS buildPartial() {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS result = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS(this);
          result.sender_ = sender_;
          onBuilt();
          return result;
        }

        public Builder clone() {
          return (Builder) super.clone();
        }
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) {
            return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS other) {
          if (other == io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance()) return this;
          if (!other.getSender().isEmpty()) {
            sender_ = other.sender_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        public final boolean isInitialized() {
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object sender_ = "";
        /**
         * <pre>
         * Origin phone number to send the SMS from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public java.lang.String getSender() {
          java.lang.Object ref = sender_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sender_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Origin phone number to send the SMS from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public com.google.protobuf.ByteString
            getSenderBytes() {
          java.lang.Object ref = sender_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            sender_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Origin phone number to send the SMS from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder setSender(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          sender_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Origin phone number to send the SMS from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder clearSender() {
          
          sender_ = getDefaultInstance().getSender();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Origin phone number to send the SMS from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder setSenderBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          sender_ = value;
          onChanged();
          return this;
        }
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.ChannelSettings.SMS)
      }

      // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.ChannelSettings.SMS)
      private static final io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS();
      }

      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SMS>
          PARSER = new com.google.protobuf.AbstractParser<SMS>() {
        public SMS parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SMS(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<SMS> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SMS> getParserForType() {
        return PARSER;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface EmailOrBuilder extends
        // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.ChannelSettings.Email)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Origin email address to send the email from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      java.lang.String getSender();
      /**
       * <pre>
       * Origin email address to send the email from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      com.google.protobuf.ByteString
          getSenderBytes();

      /**
       * <pre>
       * Reply-to email address, if different from sender.
       * </pre>
       *
       * <code>string reply_to = 2;</code>
       */
      java.lang.String getReplyTo();
      /**
       * <pre>
       * Reply-to email address, if different from sender.
       * </pre>
       *
       * <code>string reply_to = 2;</code>
       */
      com.google.protobuf.ByteString
          getReplyToBytes();

      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      java.util.List<java.lang.String>
          getCcList();
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      int getCcCount();
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      java.lang.String getCc(int index);
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      com.google.protobuf.ByteString
          getCcBytes(int index);

      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      java.util.List<java.lang.String>
          getBccList();
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      int getBccCount();
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      java.lang.String getBcc(int index);
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      com.google.protobuf.ByteString
          getBccBytes(int index);
    }
    /**
     * <pre>
     * Email-specific settings.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.ChannelSettings.Email}
     */
    public  static final class Email extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.ChannelSettings.Email)
        EmailOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Email.newBuilder() to construct.
      private Email(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Email() {
        sender_ = "";
        replyTo_ = "";
        cc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bcc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Email(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!parseUnknownFieldProto3(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                sender_ = s;
                break;
              }
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();

                replyTo_ = s;
                break;
              }
              case 26: {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                  cc_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000004;
                }
                cc_.add(s);
                break;
              }
              case 34: {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                  bcc_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000008;
                }
                bcc_.add(s);
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
            cc_ = cc_.getUnmodifiableView();
          }
          if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
            bcc_ = bcc_.getUnmodifiableView();
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_Email_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder.class);
      }

      private int bitField0_;
      public static final int SENDER_FIELD_NUMBER = 1;
      private volatile java.lang.Object sender_;
      /**
       * <pre>
       * Origin email address to send the email from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      public java.lang.String getSender() {
        java.lang.Object ref = sender_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sender_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Origin email address to send the email from.
       * </pre>
       *
       * <code>string sender = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSenderBytes() {
        java.lang.Object ref = sender_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sender_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REPLY_TO_FIELD_NUMBER = 2;
      private volatile java.lang.Object replyTo_;
      /**
       * <pre>
       * Reply-to email address, if different from sender.
       * </pre>
       *
       * <code>string reply_to = 2;</code>
       */
      public java.lang.String getReplyTo() {
        java.lang.Object ref = replyTo_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          replyTo_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Reply-to email address, if different from sender.
       * </pre>
       *
       * <code>string reply_to = 2;</code>
       */
      public com.google.protobuf.ByteString
          getReplyToBytes() {
        java.lang.Object ref = replyTo_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          replyTo_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CC_FIELD_NUMBER = 3;
      private com.google.protobuf.LazyStringList cc_;
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getCcList() {
        return cc_;
      }
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      public int getCcCount() {
        return cc_.size();
      }
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      public java.lang.String getCc(int index) {
        return cc_.get(index);
      }
      /**
       * <pre>
       * Email addresses to include via CC.
       * </pre>
       *
       * <code>repeated string cc = 3;</code>
       */
      public com.google.protobuf.ByteString
          getCcBytes(int index) {
        return cc_.getByteString(index);
      }

      public static final int BCC_FIELD_NUMBER = 4;
      private com.google.protobuf.LazyStringList bcc_;
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getBccList() {
        return bcc_;
      }
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      public int getBccCount() {
        return bcc_.size();
      }
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      public java.lang.String getBcc(int index) {
        return bcc_.get(index);
      }
      /**
       * <pre>
       * Email addresses to include via BCC.
       * </pre>
       *
       * <code>repeated string bcc = 4;</code>
       */
      public com.google.protobuf.ByteString
          getBccBytes(int index) {
        return bcc_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!getSenderBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sender_);
        }
        if (!getReplyToBytes().isEmpty()) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, replyTo_);
        }
        for (int i = 0; i < cc_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, cc_.getRaw(i));
        }
        for (int i = 0; i < bcc_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, bcc_.getRaw(i));
        }
        unknownFields.writeTo(output);
      }

      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!getSenderBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sender_);
        }
        if (!getReplyToBytes().isEmpty()) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, replyTo_);
        }
        {
          int dataSize = 0;
          for (int i = 0; i < cc_.size(); i++) {
            dataSize += computeStringSizeNoTag(cc_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getCcList().size();
        }
        {
          int dataSize = 0;
          for (int i = 0; i < bcc_.size(); i++) {
            dataSize += computeStringSizeNoTag(bcc_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getBccList().size();
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email)) {
          return super.equals(obj);
        }
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email other = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) obj;

        boolean result = true;
        result = result && getSender()
            .equals(other.getSender());
        result = result && getReplyTo()
            .equals(other.getReplyTo());
        result = result && getCcList()
            .equals(other.getCcList());
        result = result && getBccList()
            .equals(other.getBccList());
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SENDER_FIELD_NUMBER;
        hash = (53 * hash) + getSender().hashCode();
        hash = (37 * hash) + REPLY_TO_FIELD_NUMBER;
        hash = (53 * hash) + getReplyTo().hashCode();
        if (getCcCount() > 0) {
          hash = (37 * hash) + CC_FIELD_NUMBER;
          hash = (53 * hash) + getCcList().hashCode();
        }
        if (getBccCount() > 0) {
          hash = (37 * hash) + BCC_FIELD_NUMBER;
          hash = (53 * hash) + getBccList().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Email-specific settings.
       * </pre>
       *
       * Protobuf type {@code bloombox.schema.marketing.ChannelSettings.Email}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.ChannelSettings.Email)
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor;
        }

        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_Email_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder.class);
        }

        // Construct using io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        public Builder clear() {
          super.clear();
          sender_ = "";

          replyTo_ = "";

          cc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000004);
          bcc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }

        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor;
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getDefaultInstanceForType() {
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email build() {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email buildPartial() {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email result = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          result.sender_ = sender_;
          result.replyTo_ = replyTo_;
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            cc_ = cc_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.cc_ = cc_;
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            bcc_ = bcc_.getUnmodifiableView();
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.bcc_ = bcc_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        public Builder clone() {
          return (Builder) super.clone();
        }
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) {
            return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email other) {
          if (other == io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance()) return this;
          if (!other.getSender().isEmpty()) {
            sender_ = other.sender_;
            onChanged();
          }
          if (!other.getReplyTo().isEmpty()) {
            replyTo_ = other.replyTo_;
            onChanged();
          }
          if (!other.cc_.isEmpty()) {
            if (cc_.isEmpty()) {
              cc_ = other.cc_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureCcIsMutable();
              cc_.addAll(other.cc_);
            }
            onChanged();
          }
          if (!other.bcc_.isEmpty()) {
            if (bcc_.isEmpty()) {
              bcc_ = other.bcc_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureBccIsMutable();
              bcc_.addAll(other.bcc_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        public final boolean isInitialized() {
          return true;
        }

        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object sender_ = "";
        /**
         * <pre>
         * Origin email address to send the email from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public java.lang.String getSender() {
          java.lang.Object ref = sender_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sender_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Origin email address to send the email from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public com.google.protobuf.ByteString
            getSenderBytes() {
          java.lang.Object ref = sender_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            sender_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Origin email address to send the email from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder setSender(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          sender_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Origin email address to send the email from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder clearSender() {
          
          sender_ = getDefaultInstance().getSender();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Origin email address to send the email from.
         * </pre>
         *
         * <code>string sender = 1;</code>
         */
        public Builder setSenderBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          sender_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object replyTo_ = "";
        /**
         * <pre>
         * Reply-to email address, if different from sender.
         * </pre>
         *
         * <code>string reply_to = 2;</code>
         */
        public java.lang.String getReplyTo() {
          java.lang.Object ref = replyTo_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            replyTo_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Reply-to email address, if different from sender.
         * </pre>
         *
         * <code>string reply_to = 2;</code>
         */
        public com.google.protobuf.ByteString
            getReplyToBytes() {
          java.lang.Object ref = replyTo_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            replyTo_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Reply-to email address, if different from sender.
         * </pre>
         *
         * <code>string reply_to = 2;</code>
         */
        public Builder setReplyTo(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          replyTo_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Reply-to email address, if different from sender.
         * </pre>
         *
         * <code>string reply_to = 2;</code>
         */
        public Builder clearReplyTo() {
          
          replyTo_ = getDefaultInstance().getReplyTo();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Reply-to email address, if different from sender.
         * </pre>
         *
         * <code>string reply_to = 2;</code>
         */
        public Builder setReplyToBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          replyTo_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringList cc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        private void ensureCcIsMutable() {
          if (!((bitField0_ & 0x00000004) == 0x00000004)) {
            cc_ = new com.google.protobuf.LazyStringArrayList(cc_);
            bitField0_ |= 0x00000004;
           }
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public com.google.protobuf.ProtocolStringList
            getCcList() {
          return cc_.getUnmodifiableView();
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public int getCcCount() {
          return cc_.size();
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public java.lang.String getCc(int index) {
          return cc_.get(index);
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public com.google.protobuf.ByteString
            getCcBytes(int index) {
          return cc_.getByteString(index);
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public Builder setCc(
            int index, java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  ensureCcIsMutable();
          cc_.set(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public Builder addCc(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  ensureCcIsMutable();
          cc_.add(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public Builder addAllCc(
            java.lang.Iterable<java.lang.String> values) {
          ensureCcIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, cc_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public Builder clearCc() {
          cc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via CC.
         * </pre>
         *
         * <code>repeated string cc = 3;</code>
         */
        public Builder addCcBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          ensureCcIsMutable();
          cc_.add(value);
          onChanged();
          return this;
        }

        private com.google.protobuf.LazyStringList bcc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        private void ensureBccIsMutable() {
          if (!((bitField0_ & 0x00000008) == 0x00000008)) {
            bcc_ = new com.google.protobuf.LazyStringArrayList(bcc_);
            bitField0_ |= 0x00000008;
           }
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public com.google.protobuf.ProtocolStringList
            getBccList() {
          return bcc_.getUnmodifiableView();
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public int getBccCount() {
          return bcc_.size();
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public java.lang.String getBcc(int index) {
          return bcc_.get(index);
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public com.google.protobuf.ByteString
            getBccBytes(int index) {
          return bcc_.getByteString(index);
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public Builder setBcc(
            int index, java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  ensureBccIsMutable();
          bcc_.set(index, value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public Builder addBcc(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  ensureBccIsMutable();
          bcc_.add(value);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public Builder addAllBcc(
            java.lang.Iterable<java.lang.String> values) {
          ensureBccIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, bcc_);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public Builder clearBcc() {
          bcc_ = com.google.protobuf.LazyStringArrayList.EMPTY;
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Email addresses to include via BCC.
         * </pre>
         *
         * <code>repeated string bcc = 4;</code>
         */
        public Builder addBccBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          ensureBccIsMutable();
          bcc_.add(value);
          onChanged();
          return this;
        }
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFieldsProto3(unknownFields);
        }

        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.ChannelSettings.Email)
      }

      // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.ChannelSettings.Email)
      private static final io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email();
      }

      public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Email>
          PARSER = new com.google.protobuf.AbstractParser<Email>() {
        public Email parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Email(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Email> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Email> getParserForType() {
        return PARSER;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int settingsCase_ = 0;
    private java.lang.Object settings_;
    public enum SettingsCase
        implements com.google.protobuf.Internal.EnumLite {
      SMS(20),
      EMAIL(21),
      SETTINGS_NOT_SET(0);
      private final int value;
      private SettingsCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SettingsCase valueOf(int value) {
        return forNumber(value);
      }

      public static SettingsCase forNumber(int value) {
        switch (value) {
          case 20: return SMS;
          case 21: return EMAIL;
          case 0: return SETTINGS_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public SettingsCase
    getSettingsCase() {
      return SettingsCase.forNumber(
          settingsCase_);
    }

    public static final int CHANNEL_FIELD_NUMBER = 1;
    private int channel_;
    /**
     * <pre>
     * Channel for which we are specifying settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
     */
    public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Channel for which we are specifying settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
      io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
      return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
    }

    public static final int ACTIVE_FIELD_NUMBER = 2;
    private boolean active_;
    /**
     * <pre>
     * Whether this channel is active or not.
     * </pre>
     *
     * <code>bool active = 2;</code>
     */
    public boolean getActive() {
      return active_;
    }

    public static final int SMS_FIELD_NUMBER = 20;
    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    public boolean hasSms() {
      return settingsCase_ == 20;
    }
    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getSms() {
      if (settingsCase_ == 20) {
         return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
    }
    /**
     * <pre>
     * SMS settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder getSmsOrBuilder() {
      if (settingsCase_ == 20) {
         return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
    }

    public static final int EMAIL_FIELD_NUMBER = 21;
    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    public boolean hasEmail() {
      return settingsCase_ == 21;
    }
    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getEmail() {
      if (settingsCase_ == 21) {
         return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
    }
    /**
     * <pre>
     * Email settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder getEmailOrBuilder() {
      if (settingsCase_ == 21) {
         return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        output.writeEnum(1, channel_);
      }
      if (active_ != false) {
        output.writeBool(2, active_);
      }
      if (settingsCase_ == 20) {
        output.writeMessage(20, (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_);
      }
      if (settingsCase_ == 21) {
        output.writeMessage(21, (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, channel_);
      }
      if (active_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, active_);
      }
      if (settingsCase_ == 20) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(20, (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_);
      }
      if (settingsCase_ == 21) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(21, (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings other = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings) obj;

      boolean result = true;
      result = result && channel_ == other.channel_;
      result = result && (getActive()
          == other.getActive());
      result = result && getSettingsCase().equals(
          other.getSettingsCase());
      if (!result) return false;
      switch (settingsCase_) {
        case 20:
          result = result && getSms()
              .equals(other.getSms());
          break;
        case 21:
          result = result && getEmail()
              .equals(other.getEmail());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + channel_;
      hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getActive());
      switch (settingsCase_) {
        case 20:
          hash = (37 * hash) + SMS_FIELD_NUMBER;
          hash = (53 * hash) + getSms().hashCode();
          break;
        case 21:
          hash = (37 * hash) + EMAIL_FIELD_NUMBER;
          hash = (53 * hash) + getEmail().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Settings for a given channel.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.ChannelSettings}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.ChannelSettings)
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.class, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        channel_ = 0;

        active_ = false;

        settingsCase_ = 0;
        settings_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_ChannelSettings_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings build() {
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings result = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings(this);
        result.channel_ = channel_;
        result.active_ = active_;
        if (settingsCase_ == 20) {
          if (smsBuilder_ == null) {
            result.settings_ = settings_;
          } else {
            result.settings_ = smsBuilder_.build();
          }
        }
        if (settingsCase_ == 21) {
          if (emailBuilder_ == null) {
            result.settings_ = settings_;
          } else {
            result.settings_ = emailBuilder_.build();
          }
        }
        result.settingsCase_ = settingsCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance()) return this;
        if (other.channel_ != 0) {
          setChannelValue(other.getChannelValue());
        }
        if (other.getActive() != false) {
          setActive(other.getActive());
        }
        switch (other.getSettingsCase()) {
          case SMS: {
            mergeSms(other.getSms());
            break;
          }
          case EMAIL: {
            mergeEmail(other.getEmail());
            break;
          }
          case SETTINGS_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int settingsCase_ = 0;
      private java.lang.Object settings_;
      public SettingsCase
          getSettingsCase() {
        return SettingsCase.forNumber(
            settingsCase_);
      }

      public Builder clearSettings() {
        settingsCase_ = 0;
        settings_ = null;
        onChanged();
        return this;
      }


      private int channel_ = 0;
      /**
       * <pre>
       * Channel for which we are specifying settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
       */
      public int getChannelValue() {
        return channel_;
      }
      /**
       * <pre>
       * Channel for which we are specifying settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
       */
      public Builder setChannelValue(int value) {
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel for which we are specifying settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
        io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
        return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Channel for which we are specifying settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
       */
      public Builder setChannel(io.bloombox.schema.marketing.MarketingCampaign.Channel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel for which we are specifying settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 1;</code>
       */
      public Builder clearChannel() {
        
        channel_ = 0;
        onChanged();
        return this;
      }

      private boolean active_ ;
      /**
       * <pre>
       * Whether this channel is active or not.
       * </pre>
       *
       * <code>bool active = 2;</code>
       */
      public boolean getActive() {
        return active_;
      }
      /**
       * <pre>
       * Whether this channel is active or not.
       * </pre>
       *
       * <code>bool active = 2;</code>
       */
      public Builder setActive(boolean value) {
        
        active_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this channel is active or not.
       * </pre>
       *
       * <code>bool active = 2;</code>
       */
      public Builder clearActive() {
        
        active_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder> smsBuilder_;
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public boolean hasSms() {
        return settingsCase_ == 20;
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS getSms() {
        if (smsBuilder_ == null) {
          if (settingsCase_ == 20) {
            return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
        } else {
          if (settingsCase_ == 20) {
            return smsBuilder_.getMessage();
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public Builder setSms(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS value) {
        if (smsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          settings_ = value;
          onChanged();
        } else {
          smsBuilder_.setMessage(value);
        }
        settingsCase_ = 20;
        return this;
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public Builder setSms(
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder builderForValue) {
        if (smsBuilder_ == null) {
          settings_ = builderForValue.build();
          onChanged();
        } else {
          smsBuilder_.setMessage(builderForValue.build());
        }
        settingsCase_ = 20;
        return this;
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public Builder mergeSms(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS value) {
        if (smsBuilder_ == null) {
          if (settingsCase_ == 20 &&
              settings_ != io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance()) {
            settings_ = io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.newBuilder((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_)
                .mergeFrom(value).buildPartial();
          } else {
            settings_ = value;
          }
          onChanged();
        } else {
          if (settingsCase_ == 20) {
            smsBuilder_.mergeFrom(value);
          }
          smsBuilder_.setMessage(value);
        }
        settingsCase_ = 20;
        return this;
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public Builder clearSms() {
        if (smsBuilder_ == null) {
          if (settingsCase_ == 20) {
            settingsCase_ = 0;
            settings_ = null;
            onChanged();
          }
        } else {
          if (settingsCase_ == 20) {
            settingsCase_ = 0;
            settings_ = null;
          }
          smsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder getSmsBuilder() {
        return getSmsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder getSmsOrBuilder() {
        if ((settingsCase_ == 20) && (smsBuilder_ != null)) {
          return smsBuilder_.getMessageOrBuilder();
        } else {
          if (settingsCase_ == 20) {
            return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * SMS settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.SMS sms = 20;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder> 
          getSmsFieldBuilder() {
        if (smsBuilder_ == null) {
          if (!(settingsCase_ == 20)) {
            settings_ = io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.getDefaultInstance();
          }
          smsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMSOrBuilder>(
                  (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.SMS) settings_,
                  getParentForChildren(),
                  isClean());
          settings_ = null;
        }
        settingsCase_ = 20;
        onChanged();;
        return smsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder> emailBuilder_;
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public boolean hasEmail() {
        return settingsCase_ == 21;
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email getEmail() {
        if (emailBuilder_ == null) {
          if (settingsCase_ == 21) {
            return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
        } else {
          if (settingsCase_ == 21) {
            return emailBuilder_.getMessage();
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public Builder setEmail(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email value) {
        if (emailBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          settings_ = value;
          onChanged();
        } else {
          emailBuilder_.setMessage(value);
        }
        settingsCase_ = 21;
        return this;
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public Builder setEmail(
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder builderForValue) {
        if (emailBuilder_ == null) {
          settings_ = builderForValue.build();
          onChanged();
        } else {
          emailBuilder_.setMessage(builderForValue.build());
        }
        settingsCase_ = 21;
        return this;
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public Builder mergeEmail(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email value) {
        if (emailBuilder_ == null) {
          if (settingsCase_ == 21 &&
              settings_ != io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance()) {
            settings_ = io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.newBuilder((io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_)
                .mergeFrom(value).buildPartial();
          } else {
            settings_ = value;
          }
          onChanged();
        } else {
          if (settingsCase_ == 21) {
            emailBuilder_.mergeFrom(value);
          }
          emailBuilder_.setMessage(value);
        }
        settingsCase_ = 21;
        return this;
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public Builder clearEmail() {
        if (emailBuilder_ == null) {
          if (settingsCase_ == 21) {
            settingsCase_ = 0;
            settings_ = null;
            onChanged();
          }
        } else {
          if (settingsCase_ == 21) {
            settingsCase_ = 0;
            settings_ = null;
          }
          emailBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder getEmailBuilder() {
        return getEmailFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder getEmailOrBuilder() {
        if ((settingsCase_ == 21) && (emailBuilder_ != null)) {
          return emailBuilder_.getMessageOrBuilder();
        } else {
          if (settingsCase_ == 21) {
            return (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Email settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.ChannelSettings.Email email = 21;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder> 
          getEmailFieldBuilder() {
        if (emailBuilder_ == null) {
          if (!(settingsCase_ == 21)) {
            settings_ = io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.getDefaultInstance();
          }
          emailBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.EmailOrBuilder>(
                  (io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Email) settings_,
                  getParentForChildren(),
                  isClean());
          settings_ = null;
        }
        settingsCase_ = 21;
        onChanged();;
        return emailBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.ChannelSettings)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.ChannelSettings)
    private static final io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ChannelSettings>
        PARSER = new com.google.protobuf.AbstractParser<ChannelSettings>() {
      public ChannelSettings parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ChannelSettings(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ChannelSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ChannelSettings> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SMSContentOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.SMSContent)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Optional SMS subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    java.lang.String getSubject();
    /**
     * <pre>
     * Optional SMS subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    com.google.protobuf.ByteString
        getSubjectBytes();

    /**
     * <pre>
     * SMS content to send.
     * </pre>
     *
     * <code>string content = 2;</code>
     */
    java.lang.String getContent();
    /**
     * <pre>
     * SMS content to send.
     * </pre>
     *
     * <code>string content = 2;</code>
     */
    com.google.protobuf.ByteString
        getContentBytes();

    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    boolean hasMedia();
    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    io.opencannabis.schema.media.MediaItem getMedia();
    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    io.opencannabis.schema.media.MediaItemOrBuilder getMediaOrBuilder();
  }
  /**
   * <pre>
   * Specifies SMS content for a given ad group.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.SMSContent}
   */
  public  static final class SMSContent extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.SMSContent)
      SMSContentOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SMSContent.newBuilder() to construct.
    private SMSContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SMSContent() {
      subject_ = "";
      content_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private SMSContent(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              subject_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              content_ = s;
              break;
            }
            case 26: {
              io.opencannabis.schema.media.MediaItem.Builder subBuilder = null;
              if (media_ != null) {
                subBuilder = media_.toBuilder();
              }
              media_ = input.readMessage(io.opencannabis.schema.media.MediaItem.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(media_);
                media_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_SMSContent_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_SMSContent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.SMSContent.class, io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder.class);
    }

    public static final int SUBJECT_FIELD_NUMBER = 1;
    private volatile java.lang.Object subject_;
    /**
     * <pre>
     * Optional SMS subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Optional SMS subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    public com.google.protobuf.ByteString
        getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 2;
    private volatile java.lang.Object content_;
    /**
     * <pre>
     * SMS content to send.
     * </pre>
     *
     * <code>string content = 2;</code>
     */
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * SMS content to send.
     * </pre>
     *
     * <code>string content = 2;</code>
     */
    public com.google.protobuf.ByteString
        getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MEDIA_FIELD_NUMBER = 3;
    private io.opencannabis.schema.media.MediaItem media_;
    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    public boolean hasMedia() {
      return media_ != null;
    }
    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    public io.opencannabis.schema.media.MediaItem getMedia() {
      return media_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : media_;
    }
    /**
     * <pre>
     * Attached media item, if applicable.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem media = 3;</code>
     */
    public io.opencannabis.schema.media.MediaItemOrBuilder getMediaOrBuilder() {
      return getMedia();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getSubjectBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, subject_);
      }
      if (!getContentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, content_);
      }
      if (media_ != null) {
        output.writeMessage(3, getMedia());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getSubjectBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, subject_);
      }
      if (!getContentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, content_);
      }
      if (media_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getMedia());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.SMSContent)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.SMSContent other = (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) obj;

      boolean result = true;
      result = result && getSubject()
          .equals(other.getSubject());
      result = result && getContent()
          .equals(other.getContent());
      result = result && (hasMedia() == other.hasMedia());
      if (hasMedia()) {
        result = result && getMedia()
            .equals(other.getMedia());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSubject().hashCode();
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContent().hashCode();
      if (hasMedia()) {
        hash = (37 * hash) + MEDIA_FIELD_NUMBER;
        hash = (53 * hash) + getMedia().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.SMSContent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies SMS content for a given ad group.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.SMSContent}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.SMSContent)
        io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_SMSContent_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_SMSContent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.SMSContent.class, io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.SMSContent.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        subject_ = "";

        content_ = "";

        if (mediaBuilder_ == null) {
          media_ = null;
        } else {
          media_ = null;
          mediaBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_SMSContent_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.SMSContent getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.SMSContent build() {
        io.bloombox.schema.marketing.MarketingCampaign.SMSContent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.SMSContent buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.SMSContent result = new io.bloombox.schema.marketing.MarketingCampaign.SMSContent(this);
        result.subject_ = subject_;
        result.content_ = content_;
        if (mediaBuilder_ == null) {
          result.media_ = media_;
        } else {
          result.media_ = mediaBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.SMSContent) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.SMSContent)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.SMSContent other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance()) return this;
        if (!other.getSubject().isEmpty()) {
          subject_ = other.subject_;
          onChanged();
        }
        if (!other.getContent().isEmpty()) {
          content_ = other.content_;
          onChanged();
        }
        if (other.hasMedia()) {
          mergeMedia(other.getMedia());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.SMSContent parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object subject_ = "";
      /**
       * <pre>
       * Optional SMS subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Optional SMS subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Optional SMS subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder setSubject(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        subject_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional SMS subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder clearSubject() {
        
        subject_ = getDefaultInstance().getSubject();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Optional SMS subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder setSubjectBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        subject_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object content_ = "";
      /**
       * <pre>
       * SMS content to send.
       * </pre>
       *
       * <code>string content = 2;</code>
       */
      public java.lang.String getContent() {
        java.lang.Object ref = content_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          content_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * SMS content to send.
       * </pre>
       *
       * <code>string content = 2;</code>
       */
      public com.google.protobuf.ByteString
          getContentBytes() {
        java.lang.Object ref = content_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          content_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * SMS content to send.
       * </pre>
       *
       * <code>string content = 2;</code>
       */
      public Builder setContent(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        content_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * SMS content to send.
       * </pre>
       *
       * <code>string content = 2;</code>
       */
      public Builder clearContent() {
        
        content_ = getDefaultInstance().getContent();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * SMS content to send.
       * </pre>
       *
       * <code>string content = 2;</code>
       */
      public Builder setContentBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        content_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.media.MediaItem media_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> mediaBuilder_;
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public boolean hasMedia() {
        return mediaBuilder_ != null || media_ != null;
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem getMedia() {
        if (mediaBuilder_ == null) {
          return media_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : media_;
        } else {
          return mediaBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public Builder setMedia(io.opencannabis.schema.media.MediaItem value) {
        if (mediaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          media_ = value;
          onChanged();
        } else {
          mediaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public Builder setMedia(
          io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
        if (mediaBuilder_ == null) {
          media_ = builderForValue.build();
          onChanged();
        } else {
          mediaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public Builder mergeMedia(io.opencannabis.schema.media.MediaItem value) {
        if (mediaBuilder_ == null) {
          if (media_ != null) {
            media_ =
              io.opencannabis.schema.media.MediaItem.newBuilder(media_).mergeFrom(value).buildPartial();
          } else {
            media_ = value;
          }
          onChanged();
        } else {
          mediaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public Builder clearMedia() {
        if (mediaBuilder_ == null) {
          media_ = null;
          onChanged();
        } else {
          media_ = null;
          mediaBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem.Builder getMediaBuilder() {
        
        onChanged();
        return getMediaFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItemOrBuilder getMediaOrBuilder() {
        if (mediaBuilder_ != null) {
          return mediaBuilder_.getMessageOrBuilder();
        } else {
          return media_ == null ?
              io.opencannabis.schema.media.MediaItem.getDefaultInstance() : media_;
        }
      }
      /**
       * <pre>
       * Attached media item, if applicable.
       * </pre>
       *
       * <code>.opencannabis.media.MediaItem media = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> 
          getMediaFieldBuilder() {
        if (mediaBuilder_ == null) {
          mediaBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder>(
                  getMedia(),
                  getParentForChildren(),
                  isClean());
          media_ = null;
        }
        return mediaBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.SMSContent)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.SMSContent)
    private static final io.bloombox.schema.marketing.MarketingCampaign.SMSContent DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.SMSContent();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.SMSContent getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SMSContent>
        PARSER = new com.google.protobuf.AbstractParser<SMSContent>() {
      public SMSContent parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SMSContent(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<SMSContent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SMSContent> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.SMSContent getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface EmailContentOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.EmailContent)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Email subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    java.lang.String getSubject();
    /**
     * <pre>
     * Email subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    com.google.protobuf.ByteString
        getSubjectBytes();

    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    java.util.List<io.opencannabis.schema.content.Content> 
        getContentList();
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    io.opencannabis.schema.content.Content getContent(int index);
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    int getContentCount();
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    java.util.List<? extends io.opencannabis.schema.content.ContentOrBuilder> 
        getContentOrBuilderList();
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    io.opencannabis.schema.content.ContentOrBuilder getContentOrBuilder(
        int index);

    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    java.util.List<io.opencannabis.schema.media.MediaItem> 
        getAttachmentList();
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    io.opencannabis.schema.media.MediaItem getAttachment(int index);
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    int getAttachmentCount();
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    java.util.List<? extends io.opencannabis.schema.media.MediaItemOrBuilder> 
        getAttachmentOrBuilderList();
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    io.opencannabis.schema.media.MediaItemOrBuilder getAttachmentOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Specifies email content for a given ad group.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.EmailContent}
   */
  public  static final class EmailContent extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.EmailContent)
      EmailContentOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use EmailContent.newBuilder() to construct.
    private EmailContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private EmailContent() {
      subject_ = "";
      content_ = java.util.Collections.emptyList();
      attachment_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private EmailContent(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              subject_ = s;
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                content_ = new java.util.ArrayList<io.opencannabis.schema.content.Content>();
                mutable_bitField0_ |= 0x00000002;
              }
              content_.add(
                  input.readMessage(io.opencannabis.schema.content.Content.parser(), extensionRegistry));
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                attachment_ = new java.util.ArrayList<io.opencannabis.schema.media.MediaItem>();
                mutable_bitField0_ |= 0x00000004;
              }
              attachment_.add(
                  input.readMessage(io.opencannabis.schema.media.MediaItem.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          content_ = java.util.Collections.unmodifiableList(content_);
        }
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          attachment_ = java.util.Collections.unmodifiableList(attachment_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_EmailContent_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_EmailContent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.EmailContent.class, io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder.class);
    }

    private int bitField0_;
    public static final int SUBJECT_FIELD_NUMBER = 1;
    private volatile java.lang.Object subject_;
    /**
     * <pre>
     * Email subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    public java.lang.String getSubject() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subject_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Email subject line.
     * </pre>
     *
     * <code>string subject = 1;</code>
     */
    public com.google.protobuf.ByteString
        getSubjectBytes() {
      java.lang.Object ref = subject_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        subject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTENT_FIELD_NUMBER = 2;
    private java.util.List<io.opencannabis.schema.content.Content> content_;
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    public java.util.List<io.opencannabis.schema.content.Content> getContentList() {
      return content_;
    }
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.content.ContentOrBuilder> 
        getContentOrBuilderList() {
      return content_;
    }
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    public int getContentCount() {
      return content_.size();
    }
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    public io.opencannabis.schema.content.Content getContent(int index) {
      return content_.get(index);
    }
    /**
     * <pre>
     * Email content.
     * </pre>
     *
     * <code>repeated .opencannabis.content.Content content = 2;</code>
     */
    public io.opencannabis.schema.content.ContentOrBuilder getContentOrBuilder(
        int index) {
      return content_.get(index);
    }

    public static final int ATTACHMENT_FIELD_NUMBER = 3;
    private java.util.List<io.opencannabis.schema.media.MediaItem> attachment_;
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    public java.util.List<io.opencannabis.schema.media.MediaItem> getAttachmentList() {
      return attachment_;
    }
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.media.MediaItemOrBuilder> 
        getAttachmentOrBuilderList() {
      return attachment_;
    }
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    public int getAttachmentCount() {
      return attachment_.size();
    }
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    public io.opencannabis.schema.media.MediaItem getAttachment(int index) {
      return attachment_.get(index);
    }
    /**
     * <pre>
     * Email attachments.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
     */
    public io.opencannabis.schema.media.MediaItemOrBuilder getAttachmentOrBuilder(
        int index) {
      return attachment_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getSubjectBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, subject_);
      }
      for (int i = 0; i < content_.size(); i++) {
        output.writeMessage(2, content_.get(i));
      }
      for (int i = 0; i < attachment_.size(); i++) {
        output.writeMessage(3, attachment_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getSubjectBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, subject_);
      }
      for (int i = 0; i < content_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, content_.get(i));
      }
      for (int i = 0; i < attachment_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, attachment_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.EmailContent)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.EmailContent other = (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) obj;

      boolean result = true;
      result = result && getSubject()
          .equals(other.getSubject());
      result = result && getContentList()
          .equals(other.getContentList());
      result = result && getAttachmentList()
          .equals(other.getAttachmentList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
      hash = (53 * hash) + getSubject().hashCode();
      if (getContentCount() > 0) {
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContentList().hashCode();
      }
      if (getAttachmentCount() > 0) {
        hash = (37 * hash) + ATTACHMENT_FIELD_NUMBER;
        hash = (53 * hash) + getAttachmentList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.EmailContent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies email content for a given ad group.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.EmailContent}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.EmailContent)
        io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_EmailContent_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_EmailContent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.EmailContent.class, io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.EmailContent.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getContentFieldBuilder();
          getAttachmentFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        subject_ = "";

        if (contentBuilder_ == null) {
          content_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          contentBuilder_.clear();
        }
        if (attachmentBuilder_ == null) {
          attachment_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          attachmentBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_EmailContent_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.EmailContent getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.EmailContent build() {
        io.bloombox.schema.marketing.MarketingCampaign.EmailContent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.EmailContent buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.EmailContent result = new io.bloombox.schema.marketing.MarketingCampaign.EmailContent(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.subject_ = subject_;
        if (contentBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            content_ = java.util.Collections.unmodifiableList(content_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.content_ = content_;
        } else {
          result.content_ = contentBuilder_.build();
        }
        if (attachmentBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            attachment_ = java.util.Collections.unmodifiableList(attachment_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.attachment_ = attachment_;
        } else {
          result.attachment_ = attachmentBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.EmailContent) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.EmailContent)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.EmailContent other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance()) return this;
        if (!other.getSubject().isEmpty()) {
          subject_ = other.subject_;
          onChanged();
        }
        if (contentBuilder_ == null) {
          if (!other.content_.isEmpty()) {
            if (content_.isEmpty()) {
              content_ = other.content_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureContentIsMutable();
              content_.addAll(other.content_);
            }
            onChanged();
          }
        } else {
          if (!other.content_.isEmpty()) {
            if (contentBuilder_.isEmpty()) {
              contentBuilder_.dispose();
              contentBuilder_ = null;
              content_ = other.content_;
              bitField0_ = (bitField0_ & ~0x00000002);
              contentBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getContentFieldBuilder() : null;
            } else {
              contentBuilder_.addAllMessages(other.content_);
            }
          }
        }
        if (attachmentBuilder_ == null) {
          if (!other.attachment_.isEmpty()) {
            if (attachment_.isEmpty()) {
              attachment_ = other.attachment_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureAttachmentIsMutable();
              attachment_.addAll(other.attachment_);
            }
            onChanged();
          }
        } else {
          if (!other.attachment_.isEmpty()) {
            if (attachmentBuilder_.isEmpty()) {
              attachmentBuilder_.dispose();
              attachmentBuilder_ = null;
              attachment_ = other.attachment_;
              bitField0_ = (bitField0_ & ~0x00000004);
              attachmentBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getAttachmentFieldBuilder() : null;
            } else {
              attachmentBuilder_.addAllMessages(other.attachment_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.EmailContent parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object subject_ = "";
      /**
       * <pre>
       * Email subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public java.lang.String getSubject() {
        java.lang.Object ref = subject_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          subject_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Email subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSubjectBytes() {
        java.lang.Object ref = subject_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          subject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Email subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder setSubject(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        subject_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Email subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder clearSubject() {
        
        subject_ = getDefaultInstance().getSubject();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Email subject line.
       * </pre>
       *
       * <code>string subject = 1;</code>
       */
      public Builder setSubjectBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        subject_ = value;
        onChanged();
        return this;
      }

      private java.util.List<io.opencannabis.schema.content.Content> content_ =
        java.util.Collections.emptyList();
      private void ensureContentIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          content_ = new java.util.ArrayList<io.opencannabis.schema.content.Content>(content_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> contentBuilder_;

      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.content.Content> getContentList() {
        if (contentBuilder_ == null) {
          return java.util.Collections.unmodifiableList(content_);
        } else {
          return contentBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public int getContentCount() {
        if (contentBuilder_ == null) {
          return content_.size();
        } else {
          return contentBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public io.opencannabis.schema.content.Content getContent(int index) {
        if (contentBuilder_ == null) {
          return content_.get(index);
        } else {
          return contentBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder setContent(
          int index, io.opencannabis.schema.content.Content value) {
        if (contentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContentIsMutable();
          content_.set(index, value);
          onChanged();
        } else {
          contentBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder setContent(
          int index, io.opencannabis.schema.content.Content.Builder builderForValue) {
        if (contentBuilder_ == null) {
          ensureContentIsMutable();
          content_.set(index, builderForValue.build());
          onChanged();
        } else {
          contentBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder addContent(io.opencannabis.schema.content.Content value) {
        if (contentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContentIsMutable();
          content_.add(value);
          onChanged();
        } else {
          contentBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder addContent(
          int index, io.opencannabis.schema.content.Content value) {
        if (contentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureContentIsMutable();
          content_.add(index, value);
          onChanged();
        } else {
          contentBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder addContent(
          io.opencannabis.schema.content.Content.Builder builderForValue) {
        if (contentBuilder_ == null) {
          ensureContentIsMutable();
          content_.add(builderForValue.build());
          onChanged();
        } else {
          contentBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder addContent(
          int index, io.opencannabis.schema.content.Content.Builder builderForValue) {
        if (contentBuilder_ == null) {
          ensureContentIsMutable();
          content_.add(index, builderForValue.build());
          onChanged();
        } else {
          contentBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder addAllContent(
          java.lang.Iterable<? extends io.opencannabis.schema.content.Content> values) {
        if (contentBuilder_ == null) {
          ensureContentIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, content_);
          onChanged();
        } else {
          contentBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder clearContent() {
        if (contentBuilder_ == null) {
          content_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          contentBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public Builder removeContent(int index) {
        if (contentBuilder_ == null) {
          ensureContentIsMutable();
          content_.remove(index);
          onChanged();
        } else {
          contentBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public io.opencannabis.schema.content.Content.Builder getContentBuilder(
          int index) {
        return getContentFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public io.opencannabis.schema.content.ContentOrBuilder getContentOrBuilder(
          int index) {
        if (contentBuilder_ == null) {
          return content_.get(index);  } else {
          return contentBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.content.ContentOrBuilder> 
           getContentOrBuilderList() {
        if (contentBuilder_ != null) {
          return contentBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(content_);
        }
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public io.opencannabis.schema.content.Content.Builder addContentBuilder() {
        return getContentFieldBuilder().addBuilder(
            io.opencannabis.schema.content.Content.getDefaultInstance());
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public io.opencannabis.schema.content.Content.Builder addContentBuilder(
          int index) {
        return getContentFieldBuilder().addBuilder(
            index, io.opencannabis.schema.content.Content.getDefaultInstance());
      }
      /**
       * <pre>
       * Email content.
       * </pre>
       *
       * <code>repeated .opencannabis.content.Content content = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.content.Content.Builder> 
           getContentBuilderList() {
        return getContentFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> 
          getContentFieldBuilder() {
        if (contentBuilder_ == null) {
          contentBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder>(
                  content_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        return contentBuilder_;
      }

      private java.util.List<io.opencannabis.schema.media.MediaItem> attachment_ =
        java.util.Collections.emptyList();
      private void ensureAttachmentIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          attachment_ = new java.util.ArrayList<io.opencannabis.schema.media.MediaItem>(attachment_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> attachmentBuilder_;

      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.media.MediaItem> getAttachmentList() {
        if (attachmentBuilder_ == null) {
          return java.util.Collections.unmodifiableList(attachment_);
        } else {
          return attachmentBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public int getAttachmentCount() {
        if (attachmentBuilder_ == null) {
          return attachment_.size();
        } else {
          return attachmentBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem getAttachment(int index) {
        if (attachmentBuilder_ == null) {
          return attachment_.get(index);
        } else {
          return attachmentBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder setAttachment(
          int index, io.opencannabis.schema.media.MediaItem value) {
        if (attachmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentIsMutable();
          attachment_.set(index, value);
          onChanged();
        } else {
          attachmentBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder setAttachment(
          int index, io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
        if (attachmentBuilder_ == null) {
          ensureAttachmentIsMutable();
          attachment_.set(index, builderForValue.build());
          onChanged();
        } else {
          attachmentBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder addAttachment(io.opencannabis.schema.media.MediaItem value) {
        if (attachmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentIsMutable();
          attachment_.add(value);
          onChanged();
        } else {
          attachmentBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder addAttachment(
          int index, io.opencannabis.schema.media.MediaItem value) {
        if (attachmentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAttachmentIsMutable();
          attachment_.add(index, value);
          onChanged();
        } else {
          attachmentBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder addAttachment(
          io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
        if (attachmentBuilder_ == null) {
          ensureAttachmentIsMutable();
          attachment_.add(builderForValue.build());
          onChanged();
        } else {
          attachmentBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder addAttachment(
          int index, io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
        if (attachmentBuilder_ == null) {
          ensureAttachmentIsMutable();
          attachment_.add(index, builderForValue.build());
          onChanged();
        } else {
          attachmentBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder addAllAttachment(
          java.lang.Iterable<? extends io.opencannabis.schema.media.MediaItem> values) {
        if (attachmentBuilder_ == null) {
          ensureAttachmentIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, attachment_);
          onChanged();
        } else {
          attachmentBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder clearAttachment() {
        if (attachmentBuilder_ == null) {
          attachment_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          attachmentBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public Builder removeAttachment(int index) {
        if (attachmentBuilder_ == null) {
          ensureAttachmentIsMutable();
          attachment_.remove(index);
          onChanged();
        } else {
          attachmentBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem.Builder getAttachmentBuilder(
          int index) {
        return getAttachmentFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItemOrBuilder getAttachmentOrBuilder(
          int index) {
        if (attachmentBuilder_ == null) {
          return attachment_.get(index);  } else {
          return attachmentBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.media.MediaItemOrBuilder> 
           getAttachmentOrBuilderList() {
        if (attachmentBuilder_ != null) {
          return attachmentBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(attachment_);
        }
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem.Builder addAttachmentBuilder() {
        return getAttachmentFieldBuilder().addBuilder(
            io.opencannabis.schema.media.MediaItem.getDefaultInstance());
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public io.opencannabis.schema.media.MediaItem.Builder addAttachmentBuilder(
          int index) {
        return getAttachmentFieldBuilder().addBuilder(
            index, io.opencannabis.schema.media.MediaItem.getDefaultInstance());
      }
      /**
       * <pre>
       * Email attachments.
       * </pre>
       *
       * <code>repeated .opencannabis.media.MediaItem attachment = 3;</code>
       */
      public java.util.List<io.opencannabis.schema.media.MediaItem.Builder> 
           getAttachmentBuilderList() {
        return getAttachmentFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> 
          getAttachmentFieldBuilder() {
        if (attachmentBuilder_ == null) {
          attachmentBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder>(
                  attachment_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          attachment_ = null;
        }
        return attachmentBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.EmailContent)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.EmailContent)
    private static final io.bloombox.schema.marketing.MarketingCampaign.EmailContent DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.EmailContent();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.EmailContent getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EmailContent>
        PARSER = new com.google.protobuf.AbstractParser<EmailContent>() {
      public EmailContent parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EmailContent(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<EmailContent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EmailContent> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.EmailContent getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CreativeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.Creative)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    boolean hasSms();
    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.SMSContent getSms();
    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder getSmsOrBuilder();

    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    boolean hasEmail();
    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.EmailContent getEmail();
    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder getEmailOrBuilder();

    public io.bloombox.schema.marketing.MarketingCampaign.Creative.ContentCase getContentCase();
  }
  /**
   * <pre>
   * Specifies the actual content of a marketing campaign ad group.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.Creative}
   */
  public  static final class Creative extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.Creative)
      CreativeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Creative.newBuilder() to construct.
    private Creative(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Creative() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Creative(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 82: {
              io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder subBuilder = null;
              if (contentCase_ == 10) {
                subBuilder = ((io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_).toBuilder();
              }
              content_ =
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.SMSContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_);
                content_ = subBuilder.buildPartial();
              }
              contentCase_ = 10;
              break;
            }
            case 90: {
              io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder subBuilder = null;
              if (contentCase_ == 11) {
                subBuilder = ((io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_).toBuilder();
              }
              content_ =
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.EmailContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_);
                content_ = subBuilder.buildPartial();
              }
              contentCase_ = 11;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Creative_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Creative_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.Creative.class, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder.class);
    }

    private int contentCase_ = 0;
    private java.lang.Object content_;
    public enum ContentCase
        implements com.google.protobuf.Internal.EnumLite {
      SMS(10),
      EMAIL(11),
      CONTENT_NOT_SET(0);
      private final int value;
      private ContentCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ContentCase valueOf(int value) {
        return forNumber(value);
      }

      public static ContentCase forNumber(int value) {
        switch (value) {
          case 10: return SMS;
          case 11: return EMAIL;
          case 0: return CONTENT_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public ContentCase
    getContentCase() {
      return ContentCase.forNumber(
          contentCase_);
    }

    public static final int SMS_FIELD_NUMBER = 10;
    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    public boolean hasSms() {
      return contentCase_ == 10;
    }
    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.SMSContent getSms() {
      if (contentCase_ == 10) {
         return (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
    }
    /**
     * <pre>
     * SMS-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder getSmsOrBuilder() {
      if (contentCase_ == 10) {
         return (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
    }

    public static final int EMAIL_FIELD_NUMBER = 11;
    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    public boolean hasEmail() {
      return contentCase_ == 11;
    }
    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.EmailContent getEmail() {
      if (contentCase_ == 11) {
         return (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
    }
    /**
     * <pre>
     * Email-specific content.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder getEmailOrBuilder() {
      if (contentCase_ == 11) {
         return (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_;
      }
      return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (contentCase_ == 10) {
        output.writeMessage(10, (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_);
      }
      if (contentCase_ == 11) {
        output.writeMessage(11, (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (contentCase_ == 10) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_);
      }
      if (contentCase_ == 11) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.Creative)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.Creative other = (io.bloombox.schema.marketing.MarketingCampaign.Creative) obj;

      boolean result = true;
      result = result && getContentCase().equals(
          other.getContentCase());
      if (!result) return false;
      switch (contentCase_) {
        case 10:
          result = result && getSms()
              .equals(other.getSms());
          break;
        case 11:
          result = result && getEmail()
              .equals(other.getEmail());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (contentCase_) {
        case 10:
          hash = (37 * hash) + SMS_FIELD_NUMBER;
          hash = (53 * hash) + getSms().hashCode();
          break;
        case 11:
          hash = (37 * hash) + EMAIL_FIELD_NUMBER;
          hash = (53 * hash) + getEmail().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Creative parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.Creative prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the actual content of a marketing campaign ad group.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.Creative}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.Creative)
        io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Creative_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Creative_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.Creative.class, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.Creative.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        contentCase_ = 0;
        content_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Creative_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Creative getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Creative build() {
        io.bloombox.schema.marketing.MarketingCampaign.Creative result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Creative buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.Creative result = new io.bloombox.schema.marketing.MarketingCampaign.Creative(this);
        if (contentCase_ == 10) {
          if (smsBuilder_ == null) {
            result.content_ = content_;
          } else {
            result.content_ = smsBuilder_.build();
          }
        }
        if (contentCase_ == 11) {
          if (emailBuilder_ == null) {
            result.content_ = content_;
          } else {
            result.content_ = emailBuilder_.build();
          }
        }
        result.contentCase_ = contentCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.Creative) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.Creative)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.Creative other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance()) return this;
        switch (other.getContentCase()) {
          case SMS: {
            mergeSms(other.getSms());
            break;
          }
          case EMAIL: {
            mergeEmail(other.getEmail());
            break;
          }
          case CONTENT_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.Creative parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.Creative) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int contentCase_ = 0;
      private java.lang.Object content_;
      public ContentCase
          getContentCase() {
        return ContentCase.forNumber(
            contentCase_);
      }

      public Builder clearContent() {
        contentCase_ = 0;
        content_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.SMSContent, io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder> smsBuilder_;
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public boolean hasSms() {
        return contentCase_ == 10;
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.SMSContent getSms() {
        if (smsBuilder_ == null) {
          if (contentCase_ == 10) {
            return (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
        } else {
          if (contentCase_ == 10) {
            return smsBuilder_.getMessage();
          }
          return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public Builder setSms(io.bloombox.schema.marketing.MarketingCampaign.SMSContent value) {
        if (smsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          smsBuilder_.setMessage(value);
        }
        contentCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public Builder setSms(
          io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder builderForValue) {
        if (smsBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          smsBuilder_.setMessage(builderForValue.build());
        }
        contentCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public Builder mergeSms(io.bloombox.schema.marketing.MarketingCampaign.SMSContent value) {
        if (smsBuilder_ == null) {
          if (contentCase_ == 10 &&
              content_ != io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance()) {
            content_ = io.bloombox.schema.marketing.MarketingCampaign.SMSContent.newBuilder((io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_)
                .mergeFrom(value).buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          if (contentCase_ == 10) {
            smsBuilder_.mergeFrom(value);
          }
          smsBuilder_.setMessage(value);
        }
        contentCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public Builder clearSms() {
        if (smsBuilder_ == null) {
          if (contentCase_ == 10) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
        } else {
          if (contentCase_ == 10) {
            contentCase_ = 0;
            content_ = null;
          }
          smsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder getSmsBuilder() {
        return getSmsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder getSmsOrBuilder() {
        if ((contentCase_ == 10) && (smsBuilder_ != null)) {
          return smsBuilder_.getMessageOrBuilder();
        } else {
          if (contentCase_ == 10) {
            return (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * SMS-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.SMSContent sms = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.SMSContent, io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder> 
          getSmsFieldBuilder() {
        if (smsBuilder_ == null) {
          if (!(contentCase_ == 10)) {
            content_ = io.bloombox.schema.marketing.MarketingCampaign.SMSContent.getDefaultInstance();
          }
          smsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.SMSContent, io.bloombox.schema.marketing.MarketingCampaign.SMSContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.SMSContentOrBuilder>(
                  (io.bloombox.schema.marketing.MarketingCampaign.SMSContent) content_,
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        contentCase_ = 10;
        onChanged();;
        return smsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.EmailContent, io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder> emailBuilder_;
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public boolean hasEmail() {
        return contentCase_ == 11;
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.EmailContent getEmail() {
        if (emailBuilder_ == null) {
          if (contentCase_ == 11) {
            return (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
        } else {
          if (contentCase_ == 11) {
            return emailBuilder_.getMessage();
          }
          return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public Builder setEmail(io.bloombox.schema.marketing.MarketingCampaign.EmailContent value) {
        if (emailBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          emailBuilder_.setMessage(value);
        }
        contentCase_ = 11;
        return this;
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public Builder setEmail(
          io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder builderForValue) {
        if (emailBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          emailBuilder_.setMessage(builderForValue.build());
        }
        contentCase_ = 11;
        return this;
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public Builder mergeEmail(io.bloombox.schema.marketing.MarketingCampaign.EmailContent value) {
        if (emailBuilder_ == null) {
          if (contentCase_ == 11 &&
              content_ != io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance()) {
            content_ = io.bloombox.schema.marketing.MarketingCampaign.EmailContent.newBuilder((io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_)
                .mergeFrom(value).buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          if (contentCase_ == 11) {
            emailBuilder_.mergeFrom(value);
          }
          emailBuilder_.setMessage(value);
        }
        contentCase_ = 11;
        return this;
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public Builder clearEmail() {
        if (emailBuilder_ == null) {
          if (contentCase_ == 11) {
            contentCase_ = 0;
            content_ = null;
            onChanged();
          }
        } else {
          if (contentCase_ == 11) {
            contentCase_ = 0;
            content_ = null;
          }
          emailBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder getEmailBuilder() {
        return getEmailFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder getEmailOrBuilder() {
        if ((contentCase_ == 11) && (emailBuilder_ != null)) {
          return emailBuilder_.getMessageOrBuilder();
        } else {
          if (contentCase_ == 11) {
            return (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_;
          }
          return io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Email-specific content.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.EmailContent email = 11;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.EmailContent, io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder> 
          getEmailFieldBuilder() {
        if (emailBuilder_ == null) {
          if (!(contentCase_ == 11)) {
            content_ = io.bloombox.schema.marketing.MarketingCampaign.EmailContent.getDefaultInstance();
          }
          emailBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.EmailContent, io.bloombox.schema.marketing.MarketingCampaign.EmailContent.Builder, io.bloombox.schema.marketing.MarketingCampaign.EmailContentOrBuilder>(
                  (io.bloombox.schema.marketing.MarketingCampaign.EmailContent) content_,
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        contentCase_ = 11;
        onChanged();;
        return emailBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.Creative)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.Creative)
    private static final io.bloombox.schema.marketing.MarketingCampaign.Creative DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.Creative();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.Creative getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Creative>
        PARSER = new com.google.protobuf.AbstractParser<Creative>() {
      public Creative parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Creative(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Creative> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Creative> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.Creative getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AdGroupOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.AdGroup)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Unique ID for this particular ad group.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * Unique ID for this particular ad group.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    boolean hasCampaign();
    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getCampaign();
    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getCampaignOrBuilder();

    /**
     * <pre>
     * Channel for this specification.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
     */
    int getChannelValue();
    /**
     * <pre>
     * Channel for this specification.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel();

    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> 
        getCreativeList();
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index);
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    int getCreativeCount();
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
        getCreativeOrBuilderList();
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Specifies campaign settings for a given channel.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.AdGroup}
   */
  public  static final class AdGroup extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.AdGroup)
      AdGroupOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AdGroup.newBuilder() to construct.
    private AdGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AdGroup() {
      id_ = "";
      channel_ = 0;
      creative_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private AdGroup(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder subBuilder = null;
              if (campaign_ != null) {
                subBuilder = campaign_.toBuilder();
              }
              campaign_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(campaign_);
                campaign_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              channel_ = rawValue;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                creative_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.Creative>();
                mutable_bitField0_ |= 0x00000008;
              }
              creative_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.Creative.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          creative_ = java.util.Collections.unmodifiableList(creative_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_AdGroup_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_AdGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup.class, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * Unique ID for this particular ad group.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Unique ID for this particular ad group.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CAMPAIGN_FIELD_NUMBER = 2;
    private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey campaign_;
    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    public boolean hasCampaign() {
      return campaign_ != null;
    }
    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getCampaign() {
      return campaign_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : campaign_;
    }
    /**
     * <pre>
     * Key for this ad group's owning campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getCampaignOrBuilder() {
      return getCampaign();
    }

    public static final int CHANNEL_FIELD_NUMBER = 3;
    private int channel_;
    /**
     * <pre>
     * Channel for this specification.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
     */
    public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Channel for this specification.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
      io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
      return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
    }

    public static final int CREATIVE_FIELD_NUMBER = 4;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> creative_;
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> getCreativeList() {
      return creative_;
    }
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
        getCreativeOrBuilderList() {
      return creative_;
    }
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    public int getCreativeCount() {
      return creative_.size();
    }
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index) {
      return creative_.get(index);
    }
    /**
     * <pre>
     * Attached content/creatives for this ad group.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
        int index) {
      return creative_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (campaign_ != null) {
        output.writeMessage(2, getCampaign());
      }
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        output.writeEnum(3, channel_);
      }
      for (int i = 0; i < creative_.size(); i++) {
        output.writeMessage(4, creative_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (campaign_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getCampaign());
      }
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, channel_);
      }
      for (int i = 0; i < creative_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, creative_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.AdGroup)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.AdGroup other = (io.bloombox.schema.marketing.MarketingCampaign.AdGroup) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && (hasCampaign() == other.hasCampaign());
      if (hasCampaign()) {
        result = result && getCampaign()
            .equals(other.getCampaign());
      }
      result = result && channel_ == other.channel_;
      result = result && getCreativeList()
          .equals(other.getCreativeList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasCampaign()) {
        hash = (37 * hash) + CAMPAIGN_FIELD_NUMBER;
        hash = (53 * hash) + getCampaign().hashCode();
      }
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + channel_;
      if (getCreativeCount() > 0) {
        hash = (37 * hash) + CREATIVE_FIELD_NUMBER;
        hash = (53 * hash) + getCreativeList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.AdGroup prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies campaign settings for a given channel.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.AdGroup}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.AdGroup)
        io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_AdGroup_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_AdGroup_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.AdGroup.class, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.AdGroup.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCreativeFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        if (campaignBuilder_ == null) {
          campaign_ = null;
        } else {
          campaign_ = null;
          campaignBuilder_ = null;
        }
        channel_ = 0;

        if (creativeBuilder_ == null) {
          creative_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          creativeBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_AdGroup_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup build() {
        io.bloombox.schema.marketing.MarketingCampaign.AdGroup result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.AdGroup result = new io.bloombox.schema.marketing.MarketingCampaign.AdGroup(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        if (campaignBuilder_ == null) {
          result.campaign_ = campaign_;
        } else {
          result.campaign_ = campaignBuilder_.build();
        }
        result.channel_ = channel_;
        if (creativeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            creative_ = java.util.Collections.unmodifiableList(creative_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.creative_ = creative_;
        } else {
          result.creative_ = creativeBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.AdGroup) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.AdGroup)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.AdGroup other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (other.hasCampaign()) {
          mergeCampaign(other.getCampaign());
        }
        if (other.channel_ != 0) {
          setChannelValue(other.getChannelValue());
        }
        if (creativeBuilder_ == null) {
          if (!other.creative_.isEmpty()) {
            if (creative_.isEmpty()) {
              creative_ = other.creative_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureCreativeIsMutable();
              creative_.addAll(other.creative_);
            }
            onChanged();
          }
        } else {
          if (!other.creative_.isEmpty()) {
            if (creativeBuilder_.isEmpty()) {
              creativeBuilder_.dispose();
              creativeBuilder_ = null;
              creative_ = other.creative_;
              bitField0_ = (bitField0_ & ~0x00000008);
              creativeBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getCreativeFieldBuilder() : null;
            } else {
              creativeBuilder_.addAllMessages(other.creative_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.AdGroup parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.AdGroup) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * Unique ID for this particular ad group.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for this particular ad group.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for this particular ad group.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for this particular ad group.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for this particular ad group.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey campaign_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> campaignBuilder_;
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public boolean hasCampaign() {
        return campaignBuilder_ != null || campaign_ != null;
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getCampaign() {
        if (campaignBuilder_ == null) {
          return campaign_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : campaign_;
        } else {
          return campaignBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public Builder setCampaign(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
        if (campaignBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          campaign_ = value;
          onChanged();
        } else {
          campaignBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public Builder setCampaign(
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder builderForValue) {
        if (campaignBuilder_ == null) {
          campaign_ = builderForValue.build();
          onChanged();
        } else {
          campaignBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public Builder mergeCampaign(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
        if (campaignBuilder_ == null) {
          if (campaign_ != null) {
            campaign_ =
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.newBuilder(campaign_).mergeFrom(value).buildPartial();
          } else {
            campaign_ = value;
          }
          onChanged();
        } else {
          campaignBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public Builder clearCampaign() {
        if (campaignBuilder_ == null) {
          campaign_ = null;
          onChanged();
        } else {
          campaign_ = null;
          campaignBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder getCampaignBuilder() {
        
        onChanged();
        return getCampaignFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getCampaignOrBuilder() {
        if (campaignBuilder_ != null) {
          return campaignBuilder_.getMessageOrBuilder();
        } else {
          return campaign_ == null ?
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : campaign_;
        }
      }
      /**
       * <pre>
       * Key for this ad group's owning campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey campaign = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> 
          getCampaignFieldBuilder() {
        if (campaignBuilder_ == null) {
          campaignBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder>(
                  getCampaign(),
                  getParentForChildren(),
                  isClean());
          campaign_ = null;
        }
        return campaignBuilder_;
      }

      private int channel_ = 0;
      /**
       * <pre>
       * Channel for this specification.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
       */
      public int getChannelValue() {
        return channel_;
      }
      /**
       * <pre>
       * Channel for this specification.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
       */
      public Builder setChannelValue(int value) {
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel for this specification.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
        io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
        return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Channel for this specification.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
       */
      public Builder setChannel(io.bloombox.schema.marketing.MarketingCampaign.Channel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel for this specification.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 3;</code>
       */
      public Builder clearChannel() {
        
        channel_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> creative_ =
        java.util.Collections.emptyList();
      private void ensureCreativeIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          creative_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.Creative>(creative_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> creativeBuilder_;

      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> getCreativeList() {
        if (creativeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(creative_);
        } else {
          return creativeBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public int getCreativeCount() {
        if (creativeBuilder_ == null) {
          return creative_.size();
        } else {
          return creativeBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index) {
        if (creativeBuilder_ == null) {
          return creative_.get(index);
        } else {
          return creativeBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder setCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.set(index, value);
          onChanged();
        } else {
          creativeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder setCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.set(index, builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder addCreative(io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.add(value);
          onChanged();
        } else {
          creativeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder addCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.add(index, value);
          onChanged();
        } else {
          creativeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder addCreative(
          io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.add(builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder addCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.add(index, builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder addAllCreative(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.Creative> values) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, creative_);
          onChanged();
        } else {
          creativeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder clearCreative() {
        if (creativeBuilder_ == null) {
          creative_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          creativeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public Builder removeCreative(int index) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.remove(index);
          onChanged();
        } else {
          creativeBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder getCreativeBuilder(
          int index) {
        return getCreativeFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
          int index) {
        if (creativeBuilder_ == null) {
          return creative_.get(index);  } else {
          return creativeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
           getCreativeOrBuilderList() {
        if (creativeBuilder_ != null) {
          return creativeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(creative_);
        }
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder addCreativeBuilder() {
        return getCreativeFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance());
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder addCreativeBuilder(
          int index) {
        return getCreativeFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance());
      }
      /**
       * <pre>
       * Attached content/creatives for this ad group.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 4;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder> 
           getCreativeBuilderList() {
        return getCreativeFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
          getCreativeFieldBuilder() {
        if (creativeBuilder_ == null) {
          creativeBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder>(
                  creative_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          creative_ = null;
        }
        return creativeBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.AdGroup)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.AdGroup)
    private static final io.bloombox.schema.marketing.MarketingCampaign.AdGroup DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.AdGroup();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.AdGroup getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AdGroup>
        PARSER = new com.google.protobuf.AbstractParser<AdGroup>() {
      public AdGroup parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AdGroup(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<AdGroup> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AdGroup> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CampaignTargetingOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.CampaignTargeting)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Only target users matching filters.
     * </pre>
     *
     * <code>bool strict = 1;</code>
     */
    boolean getStrict();

    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    java.util.List<io.bloombox.schema.marketing.TargetingPolicy> 
        getBlockList();
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    io.bloombox.schema.marketing.TargetingPolicy getBlock(int index);
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    int getBlockCount();
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.TargetingPolicyOrBuilder> 
        getBlockOrBuilderList();
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    io.bloombox.schema.marketing.TargetingPolicyOrBuilder getBlockOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Marketing campaign targeting parameters/configuration.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.CampaignTargeting}
   */
  public  static final class CampaignTargeting extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.CampaignTargeting)
      CampaignTargetingOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CampaignTargeting.newBuilder() to construct.
    private CampaignTargeting(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CampaignTargeting() {
      strict_ = false;
      block_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CampaignTargeting(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              strict_ = input.readBool();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                block_ = new java.util.ArrayList<io.bloombox.schema.marketing.TargetingPolicy>();
                mutable_bitField0_ |= 0x00000002;
              }
              block_.add(
                  input.readMessage(io.bloombox.schema.marketing.TargetingPolicy.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          block_ = java.util.Collections.unmodifiableList(block_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTargeting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder.class);
    }

    private int bitField0_;
    public static final int STRICT_FIELD_NUMBER = 1;
    private boolean strict_;
    /**
     * <pre>
     * Only target users matching filters.
     * </pre>
     *
     * <code>bool strict = 1;</code>
     */
    public boolean getStrict() {
      return strict_;
    }

    public static final int BLOCK_FIELD_NUMBER = 2;
    private java.util.List<io.bloombox.schema.marketing.TargetingPolicy> block_;
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.TargetingPolicy> getBlockList() {
      return block_;
    }
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.TargetingPolicyOrBuilder> 
        getBlockOrBuilderList() {
      return block_;
    }
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    public int getBlockCount() {
      return block_.size();
    }
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    public io.bloombox.schema.marketing.TargetingPolicy getBlock(int index) {
      return block_.get(index);
    }
    /**
     * <pre>
     * Targeting policy payload block.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
     */
    public io.bloombox.schema.marketing.TargetingPolicyOrBuilder getBlockOrBuilder(
        int index) {
      return block_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (strict_ != false) {
        output.writeBool(1, strict_);
      }
      for (int i = 0; i < block_.size(); i++) {
        output.writeMessage(2, block_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (strict_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, strict_);
      }
      for (int i = 0; i < block_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, block_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting other = (io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting) obj;

      boolean result = true;
      result = result && (getStrict()
          == other.getStrict());
      result = result && getBlockList()
          .equals(other.getBlockList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STRICT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getStrict());
      if (getBlockCount() > 0) {
        hash = (37 * hash) + BLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getBlockList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Marketing campaign targeting parameters/configuration.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.CampaignTargeting}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.CampaignTargeting)
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTargeting_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getBlockFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        strict_ = false;

        if (blockBuilder_ == null) {
          block_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          blockBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting build() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting result = new io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.strict_ = strict_;
        if (blockBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            block_ = java.util.Collections.unmodifiableList(block_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.block_ = block_;
        } else {
          result.block_ = blockBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.getDefaultInstance()) return this;
        if (other.getStrict() != false) {
          setStrict(other.getStrict());
        }
        if (blockBuilder_ == null) {
          if (!other.block_.isEmpty()) {
            if (block_.isEmpty()) {
              block_ = other.block_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureBlockIsMutable();
              block_.addAll(other.block_);
            }
            onChanged();
          }
        } else {
          if (!other.block_.isEmpty()) {
            if (blockBuilder_.isEmpty()) {
              blockBuilder_.dispose();
              blockBuilder_ = null;
              block_ = other.block_;
              bitField0_ = (bitField0_ & ~0x00000002);
              blockBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getBlockFieldBuilder() : null;
            } else {
              blockBuilder_.addAllMessages(other.block_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private boolean strict_ ;
      /**
       * <pre>
       * Only target users matching filters.
       * </pre>
       *
       * <code>bool strict = 1;</code>
       */
      public boolean getStrict() {
        return strict_;
      }
      /**
       * <pre>
       * Only target users matching filters.
       * </pre>
       *
       * <code>bool strict = 1;</code>
       */
      public Builder setStrict(boolean value) {
        
        strict_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Only target users matching filters.
       * </pre>
       *
       * <code>bool strict = 1;</code>
       */
      public Builder clearStrict() {
        
        strict_ = false;
        onChanged();
        return this;
      }

      private java.util.List<io.bloombox.schema.marketing.TargetingPolicy> block_ =
        java.util.Collections.emptyList();
      private void ensureBlockIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          block_ = new java.util.ArrayList<io.bloombox.schema.marketing.TargetingPolicy>(block_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.TargetingPolicy, io.bloombox.schema.marketing.TargetingPolicy.Builder, io.bloombox.schema.marketing.TargetingPolicyOrBuilder> blockBuilder_;

      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.TargetingPolicy> getBlockList() {
        if (blockBuilder_ == null) {
          return java.util.Collections.unmodifiableList(block_);
        } else {
          return blockBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public int getBlockCount() {
        if (blockBuilder_ == null) {
          return block_.size();
        } else {
          return blockBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public io.bloombox.schema.marketing.TargetingPolicy getBlock(int index) {
        if (blockBuilder_ == null) {
          return block_.get(index);
        } else {
          return blockBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder setBlock(
          int index, io.bloombox.schema.marketing.TargetingPolicy value) {
        if (blockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlockIsMutable();
          block_.set(index, value);
          onChanged();
        } else {
          blockBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder setBlock(
          int index, io.bloombox.schema.marketing.TargetingPolicy.Builder builderForValue) {
        if (blockBuilder_ == null) {
          ensureBlockIsMutable();
          block_.set(index, builderForValue.build());
          onChanged();
        } else {
          blockBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder addBlock(io.bloombox.schema.marketing.TargetingPolicy value) {
        if (blockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlockIsMutable();
          block_.add(value);
          onChanged();
        } else {
          blockBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder addBlock(
          int index, io.bloombox.schema.marketing.TargetingPolicy value) {
        if (blockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBlockIsMutable();
          block_.add(index, value);
          onChanged();
        } else {
          blockBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder addBlock(
          io.bloombox.schema.marketing.TargetingPolicy.Builder builderForValue) {
        if (blockBuilder_ == null) {
          ensureBlockIsMutable();
          block_.add(builderForValue.build());
          onChanged();
        } else {
          blockBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder addBlock(
          int index, io.bloombox.schema.marketing.TargetingPolicy.Builder builderForValue) {
        if (blockBuilder_ == null) {
          ensureBlockIsMutable();
          block_.add(index, builderForValue.build());
          onChanged();
        } else {
          blockBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder addAllBlock(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.TargetingPolicy> values) {
        if (blockBuilder_ == null) {
          ensureBlockIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, block_);
          onChanged();
        } else {
          blockBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder clearBlock() {
        if (blockBuilder_ == null) {
          block_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          blockBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public Builder removeBlock(int index) {
        if (blockBuilder_ == null) {
          ensureBlockIsMutable();
          block_.remove(index);
          onChanged();
        } else {
          blockBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public io.bloombox.schema.marketing.TargetingPolicy.Builder getBlockBuilder(
          int index) {
        return getBlockFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public io.bloombox.schema.marketing.TargetingPolicyOrBuilder getBlockOrBuilder(
          int index) {
        if (blockBuilder_ == null) {
          return block_.get(index);  } else {
          return blockBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.TargetingPolicyOrBuilder> 
           getBlockOrBuilderList() {
        if (blockBuilder_ != null) {
          return blockBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(block_);
        }
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public io.bloombox.schema.marketing.TargetingPolicy.Builder addBlockBuilder() {
        return getBlockFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.TargetingPolicy.getDefaultInstance());
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public io.bloombox.schema.marketing.TargetingPolicy.Builder addBlockBuilder(
          int index) {
        return getBlockFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.TargetingPolicy.getDefaultInstance());
      }
      /**
       * <pre>
       * Targeting policy payload block.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.TargetingPolicy block = 2;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.TargetingPolicy.Builder> 
           getBlockBuilderList() {
        return getBlockFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.TargetingPolicy, io.bloombox.schema.marketing.TargetingPolicy.Builder, io.bloombox.schema.marketing.TargetingPolicyOrBuilder> 
          getBlockFieldBuilder() {
        if (blockBuilder_ == null) {
          blockBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.TargetingPolicy, io.bloombox.schema.marketing.TargetingPolicy.Builder, io.bloombox.schema.marketing.TargetingPolicyOrBuilder>(
                  block_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          block_ = null;
        }
        return blockBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.CampaignTargeting)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.CampaignTargeting)
    private static final io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CampaignTargeting>
        PARSER = new com.google.protobuf.AbstractParser<CampaignTargeting>() {
      public CampaignTargeting parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CampaignTargeting(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CampaignTargeting> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CampaignTargeting> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CampaignKeyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.CampaignKey)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Unique ID for the campaign.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * Unique ID for the campaign.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Partner ID for this campaign.
     * </pre>
     *
     * <code>string partner = 2;</code>
     */
    java.lang.String getPartner();
    /**
     * <pre>
     * Partner ID for this campaign.
     * </pre>
     *
     * <code>string partner = 2;</code>
     */
    com.google.protobuf.ByteString
        getPartnerBytes();

    /**
     * <pre>
     * Location ID for this campaign.
     * </pre>
     *
     * <code>string location = 3;</code>
     */
    java.lang.String getLocation();
    /**
     * <pre>
     * Location ID for this campaign.
     * </pre>
     *
     * <code>string location = 3;</code>
     */
    com.google.protobuf.ByteString
        getLocationBytes();
  }
  /**
   * <pre>
   * Specifies the structure of a marketing campaign's unique primary key.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.CampaignKey}
   */
  public  static final class CampaignKey extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.CampaignKey)
      CampaignKeyOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CampaignKey.newBuilder() to construct.
    private CampaignKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CampaignKey() {
      id_ = "";
      partner_ = "";
      location_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CampaignKey(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              partner_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignKey_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * Unique ID for the campaign.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Unique ID for the campaign.
     * </pre>
     *
     * <code>string id = 1 [(.core.field) = { ... }</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTNER_FIELD_NUMBER = 2;
    private volatile java.lang.Object partner_;
    /**
     * <pre>
     * Partner ID for this campaign.
     * </pre>
     *
     * <code>string partner = 2;</code>
     */
    public java.lang.String getPartner() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partner_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partner ID for this campaign.
     * </pre>
     *
     * <code>string partner = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPartnerBytes() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 3;
    private volatile java.lang.Object location_;
    /**
     * <pre>
     * Location ID for this campaign.
     * </pre>
     *
     * <code>string location = 3;</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Location ID for this campaign.
     * </pre>
     *
     * <code>string location = 3;</code>
     */
    public com.google.protobuf.ByteString
        getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!getPartnerBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, location_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!getPartnerBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, location_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignKey)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.CampaignKey other = (io.bloombox.schema.marketing.MarketingCampaign.CampaignKey) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && getPartner()
          .equals(other.getPartner());
      result = result && getLocation()
          .equals(other.getLocation());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + PARTNER_FIELD_NUMBER;
      hash = (53 * hash) + getPartner().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the structure of a marketing campaign's unique primary key.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.CampaignKey}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.CampaignKey)
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignKey_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignKey_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.class, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        partner_ = "";

        location_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_CampaignKey_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey build() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey result = new io.bloombox.schema.marketing.MarketingCampaign.CampaignKey(this);
        result.id_ = id_;
        result.partner_ = partner_;
        result.location_ = location_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.CampaignKey) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.CampaignKey)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getPartner().isEmpty()) {
          partner_ = other.partner_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.CampaignKey) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * Unique ID for the campaign.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for the campaign.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Unique ID for the campaign.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for the campaign.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique ID for the campaign.
       * </pre>
       *
       * <code>string id = 1 [(.core.field) = { ... }</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object partner_ = "";
      /**
       * <pre>
       * Partner ID for this campaign.
       * </pre>
       *
       * <code>string partner = 2;</code>
       */
      public java.lang.String getPartner() {
        java.lang.Object ref = partner_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partner_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partner ID for this campaign.
       * </pre>
       *
       * <code>string partner = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPartnerBytes() {
        java.lang.Object ref = partner_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partner_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partner ID for this campaign.
       * </pre>
       *
       * <code>string partner = 2;</code>
       */
      public Builder setPartner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partner_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID for this campaign.
       * </pre>
       *
       * <code>string partner = 2;</code>
       */
      public Builder clearPartner() {
        
        partner_ = getDefaultInstance().getPartner();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID for this campaign.
       * </pre>
       *
       * <code>string partner = 2;</code>
       */
      public Builder setPartnerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partner_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       * <pre>
       * Location ID for this campaign.
       * </pre>
       *
       * <code>string location = 3;</code>
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Location ID for this campaign.
       * </pre>
       *
       * <code>string location = 3;</code>
       */
      public com.google.protobuf.ByteString
          getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Location ID for this campaign.
       * </pre>
       *
       * <code>string location = 3;</code>
       */
      public Builder setLocation(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        location_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID for this campaign.
       * </pre>
       *
       * <code>string location = 3;</code>
       */
      public Builder clearLocation() {
        
        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID for this campaign.
       * </pre>
       *
       * <code>string location = 3;</code>
       */
      public Builder setLocationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        location_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.CampaignKey)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.CampaignKey)
    private static final io.bloombox.schema.marketing.MarketingCampaign.CampaignKey DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.CampaignKey();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CampaignKey>
        PARSER = new com.google.protobuf.AbstractParser<CampaignKey>() {
      public CampaignKey parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CampaignKey(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CampaignKey> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CampaignKey> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CampaignOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.marketing.Campaign)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getKey();
    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    java.lang.String getName();
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <pre>
     * Status of this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
     */
    int getStatusValue();
    /**
     * <pre>
     * Status of this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus getStatus();

    /**
     * <pre>
     * Visibility status of this campaign in a location/partner.
     * </pre>
     *
     * <code>bool live = 5;</code>
     */
    boolean getLive();

    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    boolean hasTargeting();
    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getTargeting();
    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder getTargetingOrBuilder();

    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> 
        getChannelList();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index);
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    int getChannelCount();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
        getChannelOrBuilderList();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
        int index);

    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> 
        getTagList();
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getTag(int index);
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    int getTagCount();
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
        getTagOrBuilderList();
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder getTagOrBuilder(
        int index);

    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> 
        getGroupList();
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroup getGroup(int index);
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    int getGroupCount();
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
        getGroupOrBuilderList();
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getGroupOrBuilder(
        int index);

    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    boolean hasPublished();
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    io.opencannabis.schema.temporal.Instant getPublished();
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getPublishedOrBuilder();

    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    boolean hasCreated();
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    io.opencannabis.schema.temporal.Instant getCreated();
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder();

    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    boolean hasModified();
    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    io.opencannabis.schema.temporal.Instant getModified();
    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder();
  }
  /**
   * <pre>
   * Represents a single marketing operation, involving outreach and potentially other forms of engagement building, in a
   * concentrated effort towards specific, defined conversion goals.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.marketing.Campaign}
   */
  public  static final class Campaign extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.marketing.Campaign)
      CampaignOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Campaign.newBuilder() to construct.
    private Campaign(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Campaign() {
      name_ = "";
      description_ = "";
      status_ = 0;
      live_ = false;
      channel_ = java.util.Collections.emptyList();
      tag_ = java.util.Collections.emptyList();
      group_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Campaign(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
            case 32: {
              int rawValue = input.readEnum();

              status_ = rawValue;
              break;
            }
            case 40: {

              live_ = input.readBool();
              break;
            }
            case 50: {
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder subBuilder = null;
              if (targeting_ != null) {
                subBuilder = targeting_.toBuilder();
              }
              targeting_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(targeting_);
                targeting_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                channel_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings>();
                mutable_bitField0_ |= 0x00000040;
              }
              channel_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.parser(), extensionRegistry));
              break;
            }
            case 66: {
              if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
                tag_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag>();
                mutable_bitField0_ |= 0x00000080;
              }
              tag_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.parser(), extensionRegistry));
              break;
            }
            case 74: {
              if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
                group_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.AdGroup>();
                mutable_bitField0_ |= 0x00000100;
              }
              group_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.AdGroup.parser(), extensionRegistry));
              break;
            }
            case 82: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (published_ != null) {
                subBuilder = published_.toBuilder();
              }
              published_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(published_);
                published_ = subBuilder.buildPartial();
              }

              break;
            }
            case 90: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (created_ != null) {
                subBuilder = created_.toBuilder();
              }
              created_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(created_);
                created_ = subBuilder.buildPartial();
              }

              break;
            }
            case 98: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (modified_ != null) {
                subBuilder = modified_.toBuilder();
              }
              modified_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modified_);
                modified_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          channel_ = java.util.Collections.unmodifiableList(channel_);
        }
        if (((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
          tag_ = java.util.Collections.unmodifiableList(tag_);
        }
        if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
          group_ = java.util.Collections.unmodifiableList(group_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Campaign_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Campaign_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.marketing.MarketingCampaign.Campaign.class, io.bloombox.schema.marketing.MarketingCampaign.Campaign.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey key_;
    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getKey() {
      return key_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Unique key for this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 3;
    private volatile java.lang.Object description_;
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 4;
    private int status_;
    /**
     * <pre>
     * Status of this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Status of this campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus getStatus() {
      io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus result = io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.valueOf(status_);
      return result == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.UNRECOGNIZED : result;
    }

    public static final int LIVE_FIELD_NUMBER = 5;
    private boolean live_;
    /**
     * <pre>
     * Visibility status of this campaign in a location/partner.
     * </pre>
     *
     * <code>bool live = 5;</code>
     */
    public boolean getLive() {
      return live_;
    }

    public static final int TARGETING_FIELD_NUMBER = 6;
    private io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting targeting_;
    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    public boolean hasTargeting() {
      return targeting_ != null;
    }
    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getTargeting() {
      return targeting_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.getDefaultInstance() : targeting_;
    }
    /**
     * <pre>
     * Campaign audience targeting settings.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder getTargetingOrBuilder() {
      return getTargeting();
    }

    public static final int CHANNEL_FIELD_NUMBER = 7;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> channel_;
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> getChannelList() {
      return channel_;
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
        getChannelOrBuilderList() {
      return channel_;
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    public int getChannelCount() {
      return channel_.size();
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index) {
      return channel_.get(index);
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
        int index) {
      return channel_.get(index);
    }

    public static final int TAG_FIELD_NUMBER = 8;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> tag_;
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> getTagList() {
      return tag_;
    }
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
        getTagOrBuilderList() {
      return tag_;
    }
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    public int getTagCount() {
      return tag_.size();
    }
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getTag(int index) {
      return tag_.get(index);
    }
    /**
     * <pre>
     * Tags for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder getTagOrBuilder(
        int index) {
      return tag_.get(index);
    }

    public static final int GROUP_FIELD_NUMBER = 9;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> group_;
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> getGroupList() {
      return group_;
    }
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
        getGroupOrBuilderList() {
      return group_;
    }
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    public int getGroupCount() {
      return group_.size();
    }
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getGroup(int index) {
      return group_.get(index);
    }
    /**
     * <pre>
     * Ad groups attached to this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getGroupOrBuilder(
        int index) {
      return group_.get(index);
    }

    public static final int PUBLISHED_FIELD_NUMBER = 10;
    private io.opencannabis.schema.temporal.Instant published_;
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    public boolean hasPublished() {
      return published_ != null;
    }
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    public io.opencannabis.schema.temporal.Instant getPublished() {
      return published_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
    }
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant published = 10;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getPublishedOrBuilder() {
      return getPublished();
    }

    public static final int CREATED_FIELD_NUMBER = 11;
    private io.opencannabis.schema.temporal.Instant created_;
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    public boolean hasCreated() {
      return created_ != null;
    }
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    public io.opencannabis.schema.temporal.Instant getCreated() {
      return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
    }
    /**
     * <pre>
     * Timestamp indicating when this campaign was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 11;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
      return getCreated();
    }

    public static final int MODIFIED_FIELD_NUMBER = 12;
    private io.opencannabis.schema.temporal.Instant modified_;
    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    public boolean hasModified() {
      return modified_ != null;
    }
    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    public io.opencannabis.schema.temporal.Instant getModified() {
      return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
    }
    /**
     * <pre>
     * When this campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 12;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
      return getModified();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
      }
      if (status_ != io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.PENDING.getNumber()) {
        output.writeEnum(4, status_);
      }
      if (live_ != false) {
        output.writeBool(5, live_);
      }
      if (targeting_ != null) {
        output.writeMessage(6, getTargeting());
      }
      for (int i = 0; i < channel_.size(); i++) {
        output.writeMessage(7, channel_.get(i));
      }
      for (int i = 0; i < tag_.size(); i++) {
        output.writeMessage(8, tag_.get(i));
      }
      for (int i = 0; i < group_.size(); i++) {
        output.writeMessage(9, group_.get(i));
      }
      if (published_ != null) {
        output.writeMessage(10, getPublished());
      }
      if (created_ != null) {
        output.writeMessage(11, getCreated());
      }
      if (modified_ != null) {
        output.writeMessage(12, getModified());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
      }
      if (status_ != io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.PENDING.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, status_);
      }
      if (live_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(5, live_);
      }
      if (targeting_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getTargeting());
      }
      for (int i = 0; i < channel_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, channel_.get(i));
      }
      for (int i = 0; i < tag_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, tag_.get(i));
      }
      for (int i = 0; i < group_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, group_.get(i));
      }
      if (published_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getPublished());
      }
      if (created_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, getCreated());
      }
      if (modified_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, getModified());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.marketing.MarketingCampaign.Campaign)) {
        return super.equals(obj);
      }
      io.bloombox.schema.marketing.MarketingCampaign.Campaign other = (io.bloombox.schema.marketing.MarketingCampaign.Campaign) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && getName()
          .equals(other.getName());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && status_ == other.status_;
      result = result && (getLive()
          == other.getLive());
      result = result && (hasTargeting() == other.hasTargeting());
      if (hasTargeting()) {
        result = result && getTargeting()
            .equals(other.getTargeting());
      }
      result = result && getChannelList()
          .equals(other.getChannelList());
      result = result && getTagList()
          .equals(other.getTagList());
      result = result && getGroupList()
          .equals(other.getGroupList());
      result = result && (hasPublished() == other.hasPublished());
      if (hasPublished()) {
        result = result && getPublished()
            .equals(other.getPublished());
      }
      result = result && (hasCreated() == other.hasCreated());
      if (hasCreated()) {
        result = result && getCreated()
            .equals(other.getCreated());
      }
      result = result && (hasModified() == other.hasModified());
      if (hasModified()) {
        result = result && getModified()
            .equals(other.getModified());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
      hash = (37 * hash) + LIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLive());
      if (hasTargeting()) {
        hash = (37 * hash) + TARGETING_FIELD_NUMBER;
        hash = (53 * hash) + getTargeting().hashCode();
      }
      if (getChannelCount() > 0) {
        hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
        hash = (53 * hash) + getChannelList().hashCode();
      }
      if (getTagCount() > 0) {
        hash = (37 * hash) + TAG_FIELD_NUMBER;
        hash = (53 * hash) + getTagList().hashCode();
      }
      if (getGroupCount() > 0) {
        hash = (37 * hash) + GROUP_FIELD_NUMBER;
        hash = (53 * hash) + getGroupList().hashCode();
      }
      if (hasPublished()) {
        hash = (37 * hash) + PUBLISHED_FIELD_NUMBER;
        hash = (53 * hash) + getPublished().hashCode();
      }
      if (hasCreated()) {
        hash = (37 * hash) + CREATED_FIELD_NUMBER;
        hash = (53 * hash) + getCreated().hashCode();
      }
      if (hasModified()) {
        hash = (37 * hash) + MODIFIED_FIELD_NUMBER;
        hash = (53 * hash) + getModified().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.marketing.MarketingCampaign.Campaign prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Represents a single marketing operation, involving outreach and potentially other forms of engagement building, in a
     * concentrated effort towards specific, defined conversion goals.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.marketing.Campaign}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.marketing.Campaign)
        io.bloombox.schema.marketing.MarketingCampaign.CampaignOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Campaign_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Campaign_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.marketing.MarketingCampaign.Campaign.class, io.bloombox.schema.marketing.MarketingCampaign.Campaign.Builder.class);
      }

      // Construct using io.bloombox.schema.marketing.MarketingCampaign.Campaign.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getChannelFieldBuilder();
          getTagFieldBuilder();
          getGroupFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        name_ = "";

        description_ = "";

        status_ = 0;

        live_ = false;

        if (targetingBuilder_ == null) {
          targeting_ = null;
        } else {
          targeting_ = null;
          targetingBuilder_ = null;
        }
        if (channelBuilder_ == null) {
          channel_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          channelBuilder_.clear();
        }
        if (tagBuilder_ == null) {
          tag_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          tagBuilder_.clear();
        }
        if (groupBuilder_ == null) {
          group_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          groupBuilder_.clear();
        }
        if (publishedBuilder_ == null) {
          published_ = null;
        } else {
          published_ = null;
          publishedBuilder_ = null;
        }
        if (createdBuilder_ == null) {
          created_ = null;
        } else {
          created_ = null;
          createdBuilder_ = null;
        }
        if (modifiedBuilder_ == null) {
          modified_ = null;
        } else {
          modified_ = null;
          modifiedBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.internal_static_bloombox_schema_marketing_Campaign_descriptor;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Campaign getDefaultInstanceForType() {
        return io.bloombox.schema.marketing.MarketingCampaign.Campaign.getDefaultInstance();
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Campaign build() {
        io.bloombox.schema.marketing.MarketingCampaign.Campaign result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.marketing.MarketingCampaign.Campaign buildPartial() {
        io.bloombox.schema.marketing.MarketingCampaign.Campaign result = new io.bloombox.schema.marketing.MarketingCampaign.Campaign(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.name_ = name_;
        result.description_ = description_;
        result.status_ = status_;
        result.live_ = live_;
        if (targetingBuilder_ == null) {
          result.targeting_ = targeting_;
        } else {
          result.targeting_ = targetingBuilder_.build();
        }
        if (channelBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            channel_ = java.util.Collections.unmodifiableList(channel_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.channel_ = channel_;
        } else {
          result.channel_ = channelBuilder_.build();
        }
        if (tagBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080)) {
            tag_ = java.util.Collections.unmodifiableList(tag_);
            bitField0_ = (bitField0_ & ~0x00000080);
          }
          result.tag_ = tag_;
        } else {
          result.tag_ = tagBuilder_.build();
        }
        if (groupBuilder_ == null) {
          if (((bitField0_ & 0x00000100) == 0x00000100)) {
            group_ = java.util.Collections.unmodifiableList(group_);
            bitField0_ = (bitField0_ & ~0x00000100);
          }
          result.group_ = group_;
        } else {
          result.group_ = groupBuilder_.build();
        }
        if (publishedBuilder_ == null) {
          result.published_ = published_;
        } else {
          result.published_ = publishedBuilder_.build();
        }
        if (createdBuilder_ == null) {
          result.created_ = created_;
        } else {
          result.created_ = createdBuilder_.build();
        }
        if (modifiedBuilder_ == null) {
          result.modified_ = modified_;
        } else {
          result.modified_ = modifiedBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.marketing.MarketingCampaign.Campaign) {
          return mergeFrom((io.bloombox.schema.marketing.MarketingCampaign.Campaign)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.marketing.MarketingCampaign.Campaign other) {
        if (other == io.bloombox.schema.marketing.MarketingCampaign.Campaign.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (other.status_ != 0) {
          setStatusValue(other.getStatusValue());
        }
        if (other.getLive() != false) {
          setLive(other.getLive());
        }
        if (other.hasTargeting()) {
          mergeTargeting(other.getTargeting());
        }
        if (channelBuilder_ == null) {
          if (!other.channel_.isEmpty()) {
            if (channel_.isEmpty()) {
              channel_ = other.channel_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureChannelIsMutable();
              channel_.addAll(other.channel_);
            }
            onChanged();
          }
        } else {
          if (!other.channel_.isEmpty()) {
            if (channelBuilder_.isEmpty()) {
              channelBuilder_.dispose();
              channelBuilder_ = null;
              channel_ = other.channel_;
              bitField0_ = (bitField0_ & ~0x00000040);
              channelBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getChannelFieldBuilder() : null;
            } else {
              channelBuilder_.addAllMessages(other.channel_);
            }
          }
        }
        if (tagBuilder_ == null) {
          if (!other.tag_.isEmpty()) {
            if (tag_.isEmpty()) {
              tag_ = other.tag_;
              bitField0_ = (bitField0_ & ~0x00000080);
            } else {
              ensureTagIsMutable();
              tag_.addAll(other.tag_);
            }
            onChanged();
          }
        } else {
          if (!other.tag_.isEmpty()) {
            if (tagBuilder_.isEmpty()) {
              tagBuilder_.dispose();
              tagBuilder_ = null;
              tag_ = other.tag_;
              bitField0_ = (bitField0_ & ~0x00000080);
              tagBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTagFieldBuilder() : null;
            } else {
              tagBuilder_.addAllMessages(other.tag_);
            }
          }
        }
        if (groupBuilder_ == null) {
          if (!other.group_.isEmpty()) {
            if (group_.isEmpty()) {
              group_ = other.group_;
              bitField0_ = (bitField0_ & ~0x00000100);
            } else {
              ensureGroupIsMutable();
              group_.addAll(other.group_);
            }
            onChanged();
          }
        } else {
          if (!other.group_.isEmpty()) {
            if (groupBuilder_.isEmpty()) {
              groupBuilder_.dispose();
              groupBuilder_ = null;
              group_ = other.group_;
              bitField0_ = (bitField0_ & ~0x00000100);
              groupBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getGroupFieldBuilder() : null;
            } else {
              groupBuilder_.addAllMessages(other.group_);
            }
          }
        }
        if (other.hasPublished()) {
          mergePublished(other.getPublished());
        }
        if (other.hasCreated()) {
          mergeCreated(other.getCreated());
        }
        if (other.hasModified()) {
          mergeModified(other.getModified());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.marketing.MarketingCampaign.Campaign parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.marketing.MarketingCampaign.Campaign) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public Builder setKey(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public Builder setKey(
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public Builder mergeKey(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Unique key for this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignKey key = 1 [(.core.field) = { ... }</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 2;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 2;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 2;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 2;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 3;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 3;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 3;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 3;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 3;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }

      private int status_ = 0;
      /**
       * <pre>
       * Status of this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
       */
      public int getStatusValue() {
        return status_;
      }
      /**
       * <pre>
       * Status of this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
       */
      public Builder setStatusValue(int value) {
        status_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status of this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus getStatus() {
        io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus result = io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.valueOf(status_);
        return result == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Status of this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
       */
      public Builder setStatus(io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        status_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Status of this campaign.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignStatus status = 4;</code>
       */
      public Builder clearStatus() {
        
        status_ = 0;
        onChanged();
        return this;
      }

      private boolean live_ ;
      /**
       * <pre>
       * Visibility status of this campaign in a location/partner.
       * </pre>
       *
       * <code>bool live = 5;</code>
       */
      public boolean getLive() {
        return live_;
      }
      /**
       * <pre>
       * Visibility status of this campaign in a location/partner.
       * </pre>
       *
       * <code>bool live = 5;</code>
       */
      public Builder setLive(boolean value) {
        
        live_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Visibility status of this campaign in a location/partner.
       * </pre>
       *
       * <code>bool live = 5;</code>
       */
      public Builder clearLive() {
        
        live_ = false;
        onChanged();
        return this;
      }

      private io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting targeting_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder> targetingBuilder_;
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public boolean hasTargeting() {
        return targetingBuilder_ != null || targeting_ != null;
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting getTargeting() {
        if (targetingBuilder_ == null) {
          return targeting_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.getDefaultInstance() : targeting_;
        } else {
          return targetingBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public Builder setTargeting(io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting value) {
        if (targetingBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          targeting_ = value;
          onChanged();
        } else {
          targetingBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public Builder setTargeting(
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder builderForValue) {
        if (targetingBuilder_ == null) {
          targeting_ = builderForValue.build();
          onChanged();
        } else {
          targetingBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public Builder mergeTargeting(io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting value) {
        if (targetingBuilder_ == null) {
          if (targeting_ != null) {
            targeting_ =
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.newBuilder(targeting_).mergeFrom(value).buildPartial();
          } else {
            targeting_ = value;
          }
          onChanged();
        } else {
          targetingBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public Builder clearTargeting() {
        if (targetingBuilder_ == null) {
          targeting_ = null;
          onChanged();
        } else {
          targeting_ = null;
          targetingBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder getTargetingBuilder() {
        
        onChanged();
        return getTargetingFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder getTargetingOrBuilder() {
        if (targetingBuilder_ != null) {
          return targetingBuilder_.getMessageOrBuilder();
        } else {
          return targeting_ == null ?
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.getDefaultInstance() : targeting_;
        }
      }
      /**
       * <pre>
       * Campaign audience targeting settings.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.CampaignTargeting targeting = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder> 
          getTargetingFieldBuilder() {
        if (targetingBuilder_ == null) {
          targetingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargeting.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTargetingOrBuilder>(
                  getTargeting(),
                  getParentForChildren(),
                  isClean());
          targeting_ = null;
        }
        return targetingBuilder_;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> channel_ =
        java.util.Collections.emptyList();
      private void ensureChannelIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          channel_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings>(channel_);
          bitField0_ |= 0x00000040;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> channelBuilder_;

      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> getChannelList() {
        if (channelBuilder_ == null) {
          return java.util.Collections.unmodifiableList(channel_);
        } else {
          return channelBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public int getChannelCount() {
        if (channelBuilder_ == null) {
          return channel_.size();
        } else {
          return channelBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index) {
        if (channelBuilder_ == null) {
          return channel_.get(index);
        } else {
          return channelBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder setChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.set(index, value);
          onChanged();
        } else {
          channelBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder setChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.set(index, builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder addChannel(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.add(value);
          onChanged();
        } else {
          channelBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder addChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.add(index, value);
          onChanged();
        } else {
          channelBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder addChannel(
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.add(builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder addChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.add(index, builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder addAllChannel(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> values) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, channel_);
          onChanged();
        } else {
          channelBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder clearChannel() {
        if (channelBuilder_ == null) {
          channel_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          channelBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public Builder removeChannel(int index) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.remove(index);
          onChanged();
        } else {
          channelBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder getChannelBuilder(
          int index) {
        return getChannelFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
          int index) {
        if (channelBuilder_ == null) {
          return channel_.get(index);  } else {
          return channelBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
           getChannelOrBuilderList() {
        if (channelBuilder_ != null) {
          return channelBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(channel_);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder addChannelBuilder() {
        return getChannelFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance());
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder addChannelBuilder(
          int index) {
        return getChannelFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance());
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 7;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder> 
           getChannelBuilderList() {
        return getChannelFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
          getChannelFieldBuilder() {
        if (channelBuilder_ == null) {
          channelBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder>(
                  channel_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          channel_ = null;
        }
        return channelBuilder_;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> tag_ =
        java.util.Collections.emptyList();
      private void ensureTagIsMutable() {
        if (!((bitField0_ & 0x00000080) == 0x00000080)) {
          tag_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag>(tag_);
          bitField0_ |= 0x00000080;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> tagBuilder_;

      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> getTagList() {
        if (tagBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tag_);
        } else {
          return tagBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public int getTagCount() {
        if (tagBuilder_ == null) {
          return tag_.size();
        } else {
          return tagBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getTag(int index) {
        if (tagBuilder_ == null) {
          return tag_.get(index);
        } else {
          return tagBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder setTag(
          int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
        if (tagBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagIsMutable();
          tag_.set(index, value);
          onChanged();
        } else {
          tagBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder setTag(
          int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
        if (tagBuilder_ == null) {
          ensureTagIsMutable();
          tag_.set(index, builderForValue.build());
          onChanged();
        } else {
          tagBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder addTag(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
        if (tagBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagIsMutable();
          tag_.add(value);
          onChanged();
        } else {
          tagBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder addTag(
          int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
        if (tagBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagIsMutable();
          tag_.add(index, value);
          onChanged();
        } else {
          tagBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder addTag(
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
        if (tagBuilder_ == null) {
          ensureTagIsMutable();
          tag_.add(builderForValue.build());
          onChanged();
        } else {
          tagBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder addTag(
          int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
        if (tagBuilder_ == null) {
          ensureTagIsMutable();
          tag_.add(index, builderForValue.build());
          onChanged();
        } else {
          tagBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder addAllTag(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> values) {
        if (tagBuilder_ == null) {
          ensureTagIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tag_);
          onChanged();
        } else {
          tagBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder clearTag() {
        if (tagBuilder_ == null) {
          tag_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000080);
          onChanged();
        } else {
          tagBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public Builder removeTag(int index) {
        if (tagBuilder_ == null) {
          ensureTagIsMutable();
          tag_.remove(index);
          onChanged();
        } else {
          tagBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder getTagBuilder(
          int index) {
        return getTagFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder getTagOrBuilder(
          int index) {
        if (tagBuilder_ == null) {
          return tag_.get(index);  } else {
          return tagBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
           getTagOrBuilderList() {
        if (tagBuilder_ != null) {
          return tagBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tag_);
        }
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder addTagBuilder() {
        return getTagFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance());
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder addTagBuilder(
          int index) {
        return getTagFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance());
      }
      /**
       * <pre>
       * Tags for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8 [(.core.collection) = { ... }</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder> 
           getTagBuilderList() {
        return getTagFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
          getTagFieldBuilder() {
        if (tagBuilder_ == null) {
          tagBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder>(
                  tag_,
                  ((bitField0_ & 0x00000080) == 0x00000080),
                  getParentForChildren(),
                  isClean());
          tag_ = null;
        }
        return tagBuilder_;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> group_ =
        java.util.Collections.emptyList();
      private void ensureGroupIsMutable() {
        if (!((bitField0_ & 0x00000100) == 0x00000100)) {
          group_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.AdGroup>(group_);
          bitField0_ |= 0x00000100;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> groupBuilder_;

      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> getGroupList() {
        if (groupBuilder_ == null) {
          return java.util.Collections.unmodifiableList(group_);
        } else {
          return groupBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public int getGroupCount() {
        if (groupBuilder_ == null) {
          return group_.size();
        } else {
          return groupBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getGroup(int index) {
        if (groupBuilder_ == null) {
          return group_.get(index);
        } else {
          return groupBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder setGroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (groupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupIsMutable();
          group_.set(index, value);
          onChanged();
        } else {
          groupBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder setGroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (groupBuilder_ == null) {
          ensureGroupIsMutable();
          group_.set(index, builderForValue.build());
          onChanged();
        } else {
          groupBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder addGroup(io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (groupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupIsMutable();
          group_.add(value);
          onChanged();
        } else {
          groupBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder addGroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (groupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGroupIsMutable();
          group_.add(index, value);
          onChanged();
        } else {
          groupBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder addGroup(
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (groupBuilder_ == null) {
          ensureGroupIsMutable();
          group_.add(builderForValue.build());
          onChanged();
        } else {
          groupBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder addGroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (groupBuilder_ == null) {
          ensureGroupIsMutable();
          group_.add(index, builderForValue.build());
          onChanged();
        } else {
          groupBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder addAllGroup(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroup> values) {
        if (groupBuilder_ == null) {
          ensureGroupIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, group_);
          onChanged();
        } else {
          groupBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder clearGroup() {
        if (groupBuilder_ == null) {
          group_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000100);
          onChanged();
        } else {
          groupBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public Builder removeGroup(int index) {
        if (groupBuilder_ == null) {
          ensureGroupIsMutable();
          group_.remove(index);
          onChanged();
        } else {
          groupBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder getGroupBuilder(
          int index) {
        return getGroupFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getGroupOrBuilder(
          int index) {
        if (groupBuilder_ == null) {
          return group_.get(index);  } else {
          return groupBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
           getGroupOrBuilderList() {
        if (groupBuilder_ != null) {
          return groupBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(group_);
        }
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder addGroupBuilder() {
        return getGroupFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance());
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder addGroupBuilder(
          int index) {
        return getGroupFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance());
      }
      /**
       * <pre>
       * Ad groups attached to this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup group = 9 [(.core.collection) = { ... }</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder> 
           getGroupBuilderList() {
        return getGroupFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
          getGroupFieldBuilder() {
        if (groupBuilder_ == null) {
          groupBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder>(
                  group_,
                  ((bitField0_ & 0x00000100) == 0x00000100),
                  getParentForChildren(),
                  isClean());
          group_ = null;
        }
        return groupBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant published_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> publishedBuilder_;
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public boolean hasPublished() {
        return publishedBuilder_ != null || published_ != null;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public io.opencannabis.schema.temporal.Instant getPublished() {
        if (publishedBuilder_ == null) {
          return published_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
        } else {
          return publishedBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public Builder setPublished(io.opencannabis.schema.temporal.Instant value) {
        if (publishedBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          published_ = value;
          onChanged();
        } else {
          publishedBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public Builder setPublished(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (publishedBuilder_ == null) {
          published_ = builderForValue.build();
          onChanged();
        } else {
          publishedBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public Builder mergePublished(io.opencannabis.schema.temporal.Instant value) {
        if (publishedBuilder_ == null) {
          if (published_ != null) {
            published_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(published_).mergeFrom(value).buildPartial();
          } else {
            published_ = value;
          }
          onChanged();
        } else {
          publishedBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public Builder clearPublished() {
        if (publishedBuilder_ == null) {
          published_ = null;
          onChanged();
        } else {
          published_ = null;
          publishedBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getPublishedBuilder() {
        
        onChanged();
        return getPublishedFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getPublishedOrBuilder() {
        if (publishedBuilder_ != null) {
          return publishedBuilder_.getMessageOrBuilder();
        } else {
          return published_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : published_;
        }
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant published = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getPublishedFieldBuilder() {
        if (publishedBuilder_ == null) {
          publishedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getPublished(),
                  getParentForChildren(),
                  isClean());
          published_ = null;
        }
        return publishedBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant created_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> createdBuilder_;
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public boolean hasCreated() {
        return createdBuilder_ != null || created_ != null;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public io.opencannabis.schema.temporal.Instant getCreated() {
        if (createdBuilder_ == null) {
          return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
        } else {
          return createdBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public Builder setCreated(io.opencannabis.schema.temporal.Instant value) {
        if (createdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          created_ = value;
          onChanged();
        } else {
          createdBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public Builder setCreated(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (createdBuilder_ == null) {
          created_ = builderForValue.build();
          onChanged();
        } else {
          createdBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public Builder mergeCreated(io.opencannabis.schema.temporal.Instant value) {
        if (createdBuilder_ == null) {
          if (created_ != null) {
            created_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(created_).mergeFrom(value).buildPartial();
          } else {
            created_ = value;
          }
          onChanged();
        } else {
          createdBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public Builder clearCreated() {
        if (createdBuilder_ == null) {
          created_ = null;
          onChanged();
        } else {
          created_ = null;
          createdBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getCreatedBuilder() {
        
        onChanged();
        return getCreatedFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
        if (createdBuilder_ != null) {
          return createdBuilder_.getMessageOrBuilder();
        } else {
          return created_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
        }
      }
      /**
       * <pre>
       * Timestamp indicating when this campaign was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created = 11;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getCreatedFieldBuilder() {
        if (createdBuilder_ == null) {
          createdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getCreated(),
                  getParentForChildren(),
                  isClean());
          created_ = null;
        }
        return createdBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant modified_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> modifiedBuilder_;
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public boolean hasModified() {
        return modifiedBuilder_ != null || modified_ != null;
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public io.opencannabis.schema.temporal.Instant getModified() {
        if (modifiedBuilder_ == null) {
          return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
        } else {
          return modifiedBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public Builder setModified(io.opencannabis.schema.temporal.Instant value) {
        if (modifiedBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          modified_ = value;
          onChanged();
        } else {
          modifiedBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public Builder setModified(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (modifiedBuilder_ == null) {
          modified_ = builderForValue.build();
          onChanged();
        } else {
          modifiedBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public Builder mergeModified(io.opencannabis.schema.temporal.Instant value) {
        if (modifiedBuilder_ == null) {
          if (modified_ != null) {
            modified_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(modified_).mergeFrom(value).buildPartial();
          } else {
            modified_ = value;
          }
          onChanged();
        } else {
          modifiedBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public Builder clearModified() {
        if (modifiedBuilder_ == null) {
          modified_ = null;
          onChanged();
        } else {
          modified_ = null;
          modifiedBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getModifiedBuilder() {
        
        onChanged();
        return getModifiedFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
        if (modifiedBuilder_ != null) {
          return modifiedBuilder_.getMessageOrBuilder();
        } else {
          return modified_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
        }
      }
      /**
       * <pre>
       * When this campaign was last modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getModifiedFieldBuilder() {
        if (modifiedBuilder_ == null) {
          modifiedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getModified(),
                  getParentForChildren(),
                  isClean());
          modified_ = null;
        }
        return modifiedBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.marketing.Campaign)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.marketing.Campaign)
    private static final io.bloombox.schema.marketing.MarketingCampaign.Campaign DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.marketing.MarketingCampaign.Campaign();
    }

    public static io.bloombox.schema.marketing.MarketingCampaign.Campaign getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Campaign>
        PARSER = new com.google.protobuf.AbstractParser<Campaign>() {
      public Campaign parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Campaign(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Campaign> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Campaign> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.marketing.MarketingCampaign.Campaign getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_CampaignTag_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_CampaignTag_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_ChannelSettings_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_ChannelSettings_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_ChannelSettings_SMS_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_ChannelSettings_Email_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_SMSContent_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_SMSContent_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_EmailContent_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_EmailContent_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_Creative_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_Creative_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_AdGroup_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_AdGroup_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_CampaignTargeting_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_CampaignKey_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_CampaignKey_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_marketing_Campaign_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_marketing_Campaign_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\030marketing/Campaign.proto\022\031bloombox.sch" +
      "ema.marketing\032\024core/Datamodel.proto\032\025med" +
      "ia/MediaItem.proto\032\025content/Content.prot" +
      "o\032\026temporal/Instant.proto\032\031marketing/Tar" +
      "geting.proto\"0\n\013CampaignTag\022\022\n\002id\030\001 \001(\tB" +
      "\006\302\265\003\002\010\002\022\r\n\005label\030\002 \001(\t\"\277\002\n\017ChannelSettin" +
      "gs\0223\n\007channel\030\001 \001(\0162\".bloombox.schema.ma" +
      "rketing.Channel\022\016\n\006active\030\002 \001(\010\022=\n\003sms\030\024" +
      " \001(\0132..bloombox.schema.marketing.Channel" +
      "Settings.SMSH\000\022A\n\005email\030\025 \001(\01320.bloombox" +
      ".schema.marketing.ChannelSettings.EmailH" +
      "\000\032\025\n\003SMS\022\016\n\006sender\030\001 \001(\t\032B\n\005Email\022\016\n\006sen" +
      "der\030\001 \001(\t\022\020\n\010reply_to\030\002 \001(\t\022\n\n\002cc\030\003 \003(\t\022" +
      "\013\n\003bcc\030\004 \003(\tB\n\n\010settings\"\\\n\nSMSContent\022\017" +
      "\n\007subject\030\001 \001(\t\022\017\n\007content\030\002 \001(\t\022,\n\005medi" +
      "a\030\003 \001(\0132\035.opencannabis.media.MediaItem\"\202" +
      "\001\n\014EmailContent\022\017\n\007subject\030\001 \001(\t\022.\n\007cont" +
      "ent\030\002 \003(\0132\035.opencannabis.content.Content" +
      "\0221\n\nattachment\030\003 \003(\0132\035.opencannabis.medi" +
      "a.MediaItem\"\205\001\n\010Creative\0224\n\003sms\030\n \001(\0132%." +
      "bloombox.schema.marketing.SMSContentH\000\0228" +
      "\n\005email\030\013 \001(\0132\'.bloombox.schema.marketin" +
      "g.EmailContentH\000B\t\n\007content\"\313\001\n\007AdGroup\022" +
      "\022\n\002id\030\001 \001(\tB\006\302\265\003\002\010\002\0228\n\010campaign\030\002 \001(\0132&." +
      "bloombox.schema.marketing.CampaignKey\0223\n" +
      "\007channel\030\003 \001(\0162\".bloombox.schema.marketi" +
      "ng.Channel\0225\n\010creative\030\004 \003(\0132#.bloombox." +
      "schema.marketing.Creative:\006\202\367\002\002\010\001\"^\n\021Cam" +
      "paignTargeting\022\016\n\006strict\030\001 \001(\010\0229\n\005block\030" +
      "\002 \003(\0132*.bloombox.schema.marketing.Target" +
      "ingPolicy\"D\n\013CampaignKey\022\022\n\002id\030\001 \001(\tB\006\302\265" +
      "\003\002\010\002\022\017\n\007partner\030\002 \001(\t\022\020\n\010location\030\003 \001(\t\"" +
      "\330\004\n\010Campaign\022;\n\003key\030\001 \001(\0132&.bloombox.sch" +
      "ema.marketing.CampaignKeyB\006\302\265\003\002\010\001\022\014\n\004nam" +
      "e\030\002 \001(\t\022\023\n\013description\030\003 \001(\t\0229\n\006status\030\004" +
      " \001(\0162).bloombox.schema.marketing.Campaig" +
      "nStatus\022\014\n\004live\030\005 \001(\010\022?\n\ttargeting\030\006 \001(\013" +
      "2,.bloombox.schema.marketing.CampaignTar" +
      "geting\022;\n\007channel\030\007 \003(\0132*.bloombox.schem" +
      "a.marketing.ChannelSettings\022A\n\003tag\030\010 \003(\013" +
      "2&.bloombox.schema.marketing.CampaignTag" +
      "B\014\322\265\003\010\010\001\032\004tags\0229\n\005group\030\t \003(\0132\".bloombox" +
      ".schema.marketing.AdGroupB\006\322\265\003\002\010\001\0221\n\tpub" +
      "lished\030\n \001(\0132\036.opencannabis.temporal.Ins" +
      "tant\022/\n\007created\030\013 \001(\0132\036.opencannabis.tem" +
      "poral.Instant\0220\n\010modified\030\014 \001(\0132\036.openca" +
      "nnabis.temporal.Instant:\021\202\367\002\r\010\002\022\tcampaig" +
      "ns*.\n\007Channel\022\017\n\013UNSPECIFIED\020\000\022\t\n\005EMAIL\020" +
      "\001\022\007\n\003SMS\020\002*K\n\016CampaignStatus\022\013\n\007PENDING\020" +
      "\000\022\t\n\005DRAFT\020\001\022\n\n\006QUEUED\020\002\022\013\n\007SENDING\020\003\022\010\n" +
      "\004DONE\020\004B;\n\034io.bloombox.schema.marketingB" +
      "\021MarketingCampaignH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          core.Datamodel.getDescriptor(),
          io.opencannabis.schema.media.AttachedMedia.getDescriptor(),
          io.opencannabis.schema.content.GenericContent.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
          io.bloombox.schema.marketing.Targeting.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_marketing_CampaignTag_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_marketing_CampaignTag_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_CampaignTag_descriptor,
        new java.lang.String[] { "Id", "Label", });
    internal_static_bloombox_schema_marketing_ChannelSettings_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_marketing_ChannelSettings_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_ChannelSettings_descriptor,
        new java.lang.String[] { "Channel", "Active", "Sms", "Email", "Settings", });
    internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor =
      internal_static_bloombox_schema_marketing_ChannelSettings_descriptor.getNestedTypes().get(0);
    internal_static_bloombox_schema_marketing_ChannelSettings_SMS_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_ChannelSettings_SMS_descriptor,
        new java.lang.String[] { "Sender", });
    internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor =
      internal_static_bloombox_schema_marketing_ChannelSettings_descriptor.getNestedTypes().get(1);
    internal_static_bloombox_schema_marketing_ChannelSettings_Email_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_ChannelSettings_Email_descriptor,
        new java.lang.String[] { "Sender", "ReplyTo", "Cc", "Bcc", });
    internal_static_bloombox_schema_marketing_SMSContent_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_marketing_SMSContent_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_SMSContent_descriptor,
        new java.lang.String[] { "Subject", "Content", "Media", });
    internal_static_bloombox_schema_marketing_EmailContent_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_bloombox_schema_marketing_EmailContent_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_EmailContent_descriptor,
        new java.lang.String[] { "Subject", "Content", "Attachment", });
    internal_static_bloombox_schema_marketing_Creative_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_bloombox_schema_marketing_Creative_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_Creative_descriptor,
        new java.lang.String[] { "Sms", "Email", "Content", });
    internal_static_bloombox_schema_marketing_AdGroup_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_bloombox_schema_marketing_AdGroup_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_AdGroup_descriptor,
        new java.lang.String[] { "Id", "Campaign", "Channel", "Creative", });
    internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_bloombox_schema_marketing_CampaignTargeting_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_CampaignTargeting_descriptor,
        new java.lang.String[] { "Strict", "Block", });
    internal_static_bloombox_schema_marketing_CampaignKey_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_bloombox_schema_marketing_CampaignKey_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_CampaignKey_descriptor,
        new java.lang.String[] { "Id", "Partner", "Location", });
    internal_static_bloombox_schema_marketing_Campaign_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_bloombox_schema_marketing_Campaign_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_marketing_Campaign_descriptor,
        new java.lang.String[] { "Key", "Name", "Description", "Status", "Live", "Targeting", "Channel", "Tag", "Group", "Published", "Created", "Modified", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(core.Datamodel.collection);
    registry.add(core.Datamodel.db);
    registry.add(core.Datamodel.field);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    core.Datamodel.getDescriptor();
    io.opencannabis.schema.media.AttachedMedia.getDescriptor();
    io.opencannabis.schema.content.GenericContent.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
    io.bloombox.schema.marketing.Targeting.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
