/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/Partner.proto

package io.bloombox.schema.partner;

/**
 * <pre>
 * Specifies information about a partner organization that has an account opened with Bloombox. A partner can own/manage
 * multiple `Location`s, and is identified uniquely by a short `code`, which is a lowercase string suitable for use in
 * a URL as a slug.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.partner.Partner}
 */
public  final class Partner extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.partner.Partner)
    PartnerOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Partner.newBuilder() to construct.
  private Partner(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Partner() {
    code_ = "";
    name_ = "";
    legalName_ = "";
    channel_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Partner(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            code_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 26: {
            io.bloombox.schema.partner.PartnerFlags.Builder subBuilder = null;
            if (flags_ != null) {
              subBuilder = flags_.toBuilder();
            }
            flags_ = input.readMessage(io.bloombox.schema.partner.PartnerFlags.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(flags_);
              flags_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            legalName_ = s;
            break;
          }
          case 42: {
            io.opencannabis.schema.contact.ContactInfo.Builder subBuilder = null;
            if (contact_ != null) {
              subBuilder = contact_.toBuilder();
            }
            contact_ = input.readMessage(io.opencannabis.schema.contact.ContactInfo.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(contact_);
              contact_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            io.opencannabis.schema.media.MediaItem.Builder subBuilder = null;
            if (branding_ != null) {
              subBuilder = branding_.toBuilder();
            }
            branding_ = input.readMessage(io.opencannabis.schema.media.MediaItem.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(branding_);
              branding_ = subBuilder.buildPartial();
            }

            break;
          }
          case 56: {
            int rawValue = input.readEnum();

            channel_ = rawValue;
            break;
          }
          case 802: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (created_ != null) {
              subBuilder = created_.toBuilder();
            }
            created_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(created_);
              created_ = subBuilder.buildPartial();
            }

            break;
          }
          case 810: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (modified_ != null) {
              subBuilder = modified_.toBuilder();
            }
            modified_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(modified_);
              modified_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.partner.PartnerOuterClass.internal_static_bloombox_schema_partner_Partner_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.partner.PartnerOuterClass.internal_static_bloombox_schema_partner_Partner_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.partner.Partner.class, io.bloombox.schema.partner.Partner.Builder.class);
  }

  public static final int CODE_FIELD_NUMBER = 1;
  private volatile java.lang.Object code_;
  /**
   * <pre>
   * Short string that uniquely identifies this partner organization.
   * </pre>
   *
   * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
   */
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Short string that uniquely identifies this partner organization.
   * </pre>
   *
   * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
   */
  public com.google.protobuf.ByteString
      getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Full human-readable label for this partner organization.
   * </pre>
   *
   * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Full human-readable label for this partner organization.
   * </pre>
   *
   * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLAGS_FIELD_NUMBER = 3;
  private io.bloombox.schema.partner.PartnerFlags flags_;
  /**
   * <pre>
   * Flags for various things about this partner account.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
   */
  public boolean hasFlags() {
    return flags_ != null;
  }
  /**
   * <pre>
   * Flags for various things about this partner account.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
   */
  public io.bloombox.schema.partner.PartnerFlags getFlags() {
    return flags_ == null ? io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
  }
  /**
   * <pre>
   * Flags for various things about this partner account.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
   */
  public io.bloombox.schema.partner.PartnerFlagsOrBuilder getFlagsOrBuilder() {
    return getFlags();
  }

  public static final int LEGAL_NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object legalName_;
  /**
   * <pre>
   * Legal name of the partner organization.
   * </pre>
   *
   * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
   */
  public java.lang.String getLegalName() {
    java.lang.Object ref = legalName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      legalName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Legal name of the partner organization.
   * </pre>
   *
   * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
   */
  public com.google.protobuf.ByteString
      getLegalNameBytes() {
    java.lang.Object ref = legalName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      legalName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTACT_FIELD_NUMBER = 5;
  private io.opencannabis.schema.contact.ContactInfo contact_;
  /**
   * <pre>
   * Contact information for this organization.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
   */
  public boolean hasContact() {
    return contact_ != null;
  }
  /**
   * <pre>
   * Contact information for this organization.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfo getContact() {
    return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
  }
  /**
   * <pre>
   * Contact information for this organization.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
    return getContact();
  }

  public static final int BRANDING_FIELD_NUMBER = 6;
  private io.opencannabis.schema.media.MediaItem branding_;
  /**
   * <pre>
   * Branding information for this organization.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
   */
  public boolean hasBranding() {
    return branding_ != null;
  }
  /**
   * <pre>
   * Branding information for this organization.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
   */
  public io.opencannabis.schema.media.MediaItem getBranding() {
    return branding_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
  }
  /**
   * <pre>
   * Branding information for this organization.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
   */
  public io.opencannabis.schema.media.MediaItemOrBuilder getBrandingOrBuilder() {
    return getBranding();
  }

  public static final int CHANNEL_FIELD_NUMBER = 7;
  private int channel_;
  /**
   * <pre>
   * Channel through which this partner organization interacts with Bloombox.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
   */
  public int getChannelValue() {
    return channel_;
  }
  /**
   * <pre>
   * Channel through which this partner organization interacts with Bloombox.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
   */
  public io.bloombox.schema.partner.PartnerChannel getChannel() {
    io.bloombox.schema.partner.PartnerChannel result = io.bloombox.schema.partner.PartnerChannel.valueOf(channel_);
    return result == null ? io.bloombox.schema.partner.PartnerChannel.UNRECOGNIZED : result;
  }

  public static final int CREATED_FIELD_NUMBER = 100;
  private io.opencannabis.schema.temporal.Instant created_;
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public boolean hasCreated() {
    return created_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getCreated() {
    return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
  }
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
    return getCreated();
  }

  public static final int MODIFIED_FIELD_NUMBER = 101;
  private io.opencannabis.schema.temporal.Instant modified_;
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public boolean hasModified() {
    return modified_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getModified() {
    return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
  }
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
    return getModified();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, code_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (flags_ != null) {
      output.writeMessage(3, getFlags());
    }
    if (!getLegalNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, legalName_);
    }
    if (contact_ != null) {
      output.writeMessage(5, getContact());
    }
    if (branding_ != null) {
      output.writeMessage(6, getBranding());
    }
    if (channel_ != io.bloombox.schema.partner.PartnerChannel.DIRECT.getNumber()) {
      output.writeEnum(7, channel_);
    }
    if (created_ != null) {
      output.writeMessage(100, getCreated());
    }
    if (modified_ != null) {
      output.writeMessage(101, getModified());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, code_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (flags_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getFlags());
    }
    if (!getLegalNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, legalName_);
    }
    if (contact_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getContact());
    }
    if (branding_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getBranding());
    }
    if (channel_ != io.bloombox.schema.partner.PartnerChannel.DIRECT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, channel_);
    }
    if (created_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(100, getCreated());
    }
    if (modified_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(101, getModified());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.partner.Partner)) {
      return super.equals(obj);
    }
    io.bloombox.schema.partner.Partner other = (io.bloombox.schema.partner.Partner) obj;

    boolean result = true;
    result = result && getCode()
        .equals(other.getCode());
    result = result && getName()
        .equals(other.getName());
    result = result && (hasFlags() == other.hasFlags());
    if (hasFlags()) {
      result = result && getFlags()
          .equals(other.getFlags());
    }
    result = result && getLegalName()
        .equals(other.getLegalName());
    result = result && (hasContact() == other.hasContact());
    if (hasContact()) {
      result = result && getContact()
          .equals(other.getContact());
    }
    result = result && (hasBranding() == other.hasBranding());
    if (hasBranding()) {
      result = result && getBranding()
          .equals(other.getBranding());
    }
    result = result && channel_ == other.channel_;
    result = result && (hasCreated() == other.hasCreated());
    if (hasCreated()) {
      result = result && getCreated()
          .equals(other.getCreated());
    }
    result = result && (hasModified() == other.hasModified());
    if (hasModified()) {
      result = result && getModified()
          .equals(other.getModified());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasFlags()) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + getFlags().hashCode();
    }
    hash = (37 * hash) + LEGAL_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getLegalName().hashCode();
    if (hasContact()) {
      hash = (37 * hash) + CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getContact().hashCode();
    }
    if (hasBranding()) {
      hash = (37 * hash) + BRANDING_FIELD_NUMBER;
      hash = (53 * hash) + getBranding().hashCode();
    }
    hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
    hash = (53 * hash) + channel_;
    if (hasCreated()) {
      hash = (37 * hash) + CREATED_FIELD_NUMBER;
      hash = (53 * hash) + getCreated().hashCode();
    }
    if (hasModified()) {
      hash = (37 * hash) + MODIFIED_FIELD_NUMBER;
      hash = (53 * hash) + getModified().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.partner.Partner parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.Partner parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.Partner parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.Partner parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.partner.Partner prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies information about a partner organization that has an account opened with Bloombox. A partner can own/manage
   * multiple `Location`s, and is identified uniquely by a short `code`, which is a lowercase string suitable for use in
   * a URL as a slug.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.partner.Partner}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.partner.Partner)
      io.bloombox.schema.partner.PartnerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.partner.PartnerOuterClass.internal_static_bloombox_schema_partner_Partner_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.partner.PartnerOuterClass.internal_static_bloombox_schema_partner_Partner_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.partner.Partner.class, io.bloombox.schema.partner.Partner.Builder.class);
    }

    // Construct using io.bloombox.schema.partner.Partner.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      code_ = "";

      name_ = "";

      if (flagsBuilder_ == null) {
        flags_ = null;
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }
      legalName_ = "";

      if (contactBuilder_ == null) {
        contact_ = null;
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }
      if (brandingBuilder_ == null) {
        branding_ = null;
      } else {
        branding_ = null;
        brandingBuilder_ = null;
      }
      channel_ = 0;

      if (createdBuilder_ == null) {
        created_ = null;
      } else {
        created_ = null;
        createdBuilder_ = null;
      }
      if (modifiedBuilder_ == null) {
        modified_ = null;
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.partner.PartnerOuterClass.internal_static_bloombox_schema_partner_Partner_descriptor;
    }

    public io.bloombox.schema.partner.Partner getDefaultInstanceForType() {
      return io.bloombox.schema.partner.Partner.getDefaultInstance();
    }

    public io.bloombox.schema.partner.Partner build() {
      io.bloombox.schema.partner.Partner result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.partner.Partner buildPartial() {
      io.bloombox.schema.partner.Partner result = new io.bloombox.schema.partner.Partner(this);
      result.code_ = code_;
      result.name_ = name_;
      if (flagsBuilder_ == null) {
        result.flags_ = flags_;
      } else {
        result.flags_ = flagsBuilder_.build();
      }
      result.legalName_ = legalName_;
      if (contactBuilder_ == null) {
        result.contact_ = contact_;
      } else {
        result.contact_ = contactBuilder_.build();
      }
      if (brandingBuilder_ == null) {
        result.branding_ = branding_;
      } else {
        result.branding_ = brandingBuilder_.build();
      }
      result.channel_ = channel_;
      if (createdBuilder_ == null) {
        result.created_ = created_;
      } else {
        result.created_ = createdBuilder_.build();
      }
      if (modifiedBuilder_ == null) {
        result.modified_ = modified_;
      } else {
        result.modified_ = modifiedBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.partner.Partner) {
        return mergeFrom((io.bloombox.schema.partner.Partner)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.partner.Partner other) {
      if (other == io.bloombox.schema.partner.Partner.getDefaultInstance()) return this;
      if (!other.getCode().isEmpty()) {
        code_ = other.code_;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasFlags()) {
        mergeFlags(other.getFlags());
      }
      if (!other.getLegalName().isEmpty()) {
        legalName_ = other.legalName_;
        onChanged();
      }
      if (other.hasContact()) {
        mergeContact(other.getContact());
      }
      if (other.hasBranding()) {
        mergeBranding(other.getBranding());
      }
      if (other.channel_ != 0) {
        setChannelValue(other.getChannelValue());
      }
      if (other.hasCreated()) {
        mergeCreated(other.getCreated());
      }
      if (other.hasModified()) {
        mergeModified(other.getModified());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.partner.Partner parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.partner.Partner) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     * <pre>
     * Short string that uniquely identifies this partner organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Short string that uniquely identifies this partner organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
     */
    public com.google.protobuf.ByteString
        getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Short string that uniquely identifies this partner organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
     */
    public Builder setCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      code_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short string that uniquely identifies this partner organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
     */
    public Builder clearCode() {
      
      code_ = getDefaultInstance().getCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short string that uniquely identifies this partner organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short string that uniquely identifies this partner organization."];</code>
     */
    public Builder setCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      code_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Full human-readable label for this partner organization.
     * </pre>
     *
     * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Full human-readable label for this partner organization.
     * </pre>
     *
     * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Full human-readable label for this partner organization.
     * </pre>
     *
     * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Full human-readable label for this partner organization.
     * </pre>
     *
     * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Full human-readable label for this partner organization.
     * </pre>
     *
     * <code>string name = 2 [(.gen_bq_schema.description) = "Full human-readable label for this partner organization."];</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private io.bloombox.schema.partner.PartnerFlags flags_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder> flagsBuilder_;
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public boolean hasFlags() {
      return flagsBuilder_ != null || flags_ != null;
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlags getFlags() {
      if (flagsBuilder_ == null) {
        return flags_ == null ? io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
      } else {
        return flagsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public Builder setFlags(io.bloombox.schema.partner.PartnerFlags value) {
      if (flagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        flags_ = value;
        onChanged();
      } else {
        flagsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public Builder setFlags(
        io.bloombox.schema.partner.PartnerFlags.Builder builderForValue) {
      if (flagsBuilder_ == null) {
        flags_ = builderForValue.build();
        onChanged();
      } else {
        flagsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public Builder mergeFlags(io.bloombox.schema.partner.PartnerFlags value) {
      if (flagsBuilder_ == null) {
        if (flags_ != null) {
          flags_ =
            io.bloombox.schema.partner.PartnerFlags.newBuilder(flags_).mergeFrom(value).buildPartial();
        } else {
          flags_ = value;
        }
        onChanged();
      } else {
        flagsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public Builder clearFlags() {
      if (flagsBuilder_ == null) {
        flags_ = null;
        onChanged();
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlags.Builder getFlagsBuilder() {
      
      onChanged();
      return getFlagsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlagsOrBuilder getFlagsOrBuilder() {
      if (flagsBuilder_ != null) {
        return flagsBuilder_.getMessageOrBuilder();
      } else {
        return flags_ == null ?
            io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
      }
    }
    /**
     * <pre>
     * Flags for various things about this partner account.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 3 [(.gen_bq_schema.description) = "Flags for various things about this partner account."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder> 
        getFlagsFieldBuilder() {
      if (flagsBuilder_ == null) {
        flagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder>(
                getFlags(),
                getParentForChildren(),
                isClean());
        flags_ = null;
      }
      return flagsBuilder_;
    }

    private java.lang.Object legalName_ = "";
    /**
     * <pre>
     * Legal name of the partner organization.
     * </pre>
     *
     * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
     */
    public java.lang.String getLegalName() {
      java.lang.Object ref = legalName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        legalName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Legal name of the partner organization.
     * </pre>
     *
     * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
     */
    public com.google.protobuf.ByteString
        getLegalNameBytes() {
      java.lang.Object ref = legalName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        legalName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Legal name of the partner organization.
     * </pre>
     *
     * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
     */
    public Builder setLegalName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      legalName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Legal name of the partner organization.
     * </pre>
     *
     * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
     */
    public Builder clearLegalName() {
      
      legalName_ = getDefaultInstance().getLegalName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Legal name of the partner organization.
     * </pre>
     *
     * <code>string legal_name = 4 [(.gen_bq_schema.description) = "Legal name of the partner organization."];</code>
     */
    public Builder setLegalNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      legalName_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.contact.ContactInfo contact_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> contactBuilder_;
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public boolean hasContact() {
      return contactBuilder_ != null || contact_ != null;
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo getContact() {
      if (contactBuilder_ == null) {
        return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      } else {
        return contactBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public Builder setContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contact_ = value;
        onChanged();
      } else {
        contactBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public Builder setContact(
        io.opencannabis.schema.contact.ContactInfo.Builder builderForValue) {
      if (contactBuilder_ == null) {
        contact_ = builderForValue.build();
        onChanged();
      } else {
        contactBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public Builder mergeContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (contact_ != null) {
          contact_ =
            io.opencannabis.schema.contact.ContactInfo.newBuilder(contact_).mergeFrom(value).buildPartial();
        } else {
          contact_ = value;
        }
        onChanged();
      } else {
        contactBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public Builder clearContact() {
      if (contactBuilder_ == null) {
        contact_ = null;
        onChanged();
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo.Builder getContactBuilder() {
      
      onChanged();
      return getContactFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
      if (contactBuilder_ != null) {
        return contactBuilder_.getMessageOrBuilder();
      } else {
        return contact_ == null ?
            io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      }
    }
    /**
     * <pre>
     * Contact information for this organization.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 5 [(.gen_bq_schema.description) = "Contact information for this organization."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> 
        getContactFieldBuilder() {
      if (contactBuilder_ == null) {
        contactBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder>(
                getContact(),
                getParentForChildren(),
                isClean());
        contact_ = null;
      }
      return contactBuilder_;
    }

    private io.opencannabis.schema.media.MediaItem branding_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> brandingBuilder_;
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public boolean hasBranding() {
      return brandingBuilder_ != null || branding_ != null;
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public io.opencannabis.schema.media.MediaItem getBranding() {
      if (brandingBuilder_ == null) {
        return branding_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
      } else {
        return brandingBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public Builder setBranding(io.opencannabis.schema.media.MediaItem value) {
      if (brandingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        branding_ = value;
        onChanged();
      } else {
        brandingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public Builder setBranding(
        io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
      if (brandingBuilder_ == null) {
        branding_ = builderForValue.build();
        onChanged();
      } else {
        brandingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public Builder mergeBranding(io.opencannabis.schema.media.MediaItem value) {
      if (brandingBuilder_ == null) {
        if (branding_ != null) {
          branding_ =
            io.opencannabis.schema.media.MediaItem.newBuilder(branding_).mergeFrom(value).buildPartial();
        } else {
          branding_ = value;
        }
        onChanged();
      } else {
        brandingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public Builder clearBranding() {
      if (brandingBuilder_ == null) {
        branding_ = null;
        onChanged();
      } else {
        branding_ = null;
        brandingBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public io.opencannabis.schema.media.MediaItem.Builder getBrandingBuilder() {
      
      onChanged();
      return getBrandingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    public io.opencannabis.schema.media.MediaItemOrBuilder getBrandingOrBuilder() {
      if (brandingBuilder_ != null) {
        return brandingBuilder_.getMessageOrBuilder();
      } else {
        return branding_ == null ?
            io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
      }
    }
    /**
     * <pre>
     * Branding information for this organization.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding information for this organization."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> 
        getBrandingFieldBuilder() {
      if (brandingBuilder_ == null) {
        brandingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder>(
                getBranding(),
                getParentForChildren(),
                isClean());
        branding_ = null;
      }
      return brandingBuilder_;
    }

    private int channel_ = 0;
    /**
     * <pre>
     * Channel through which this partner organization interacts with Bloombox.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
     */
    public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Channel through which this partner organization interacts with Bloombox.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
     */
    public Builder setChannelValue(int value) {
      channel_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Channel through which this partner organization interacts with Bloombox.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
     */
    public io.bloombox.schema.partner.PartnerChannel getChannel() {
      io.bloombox.schema.partner.PartnerChannel result = io.bloombox.schema.partner.PartnerChannel.valueOf(channel_);
      return result == null ? io.bloombox.schema.partner.PartnerChannel.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Channel through which this partner organization interacts with Bloombox.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
     */
    public Builder setChannel(io.bloombox.schema.partner.PartnerChannel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      channel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Channel through which this partner organization interacts with Bloombox.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerChannel channel = 7 [(.gen_bq_schema.description) = "Channel through which this partner organization interacts with Bloombox."];</code>
     */
    public Builder clearChannel() {
      
      channel_ = 0;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant created_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> createdBuilder_;
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public boolean hasCreated() {
      return createdBuilder_ != null || created_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getCreated() {
      if (createdBuilder_ == null) {
        return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
      } else {
        return createdBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder setCreated(io.opencannabis.schema.temporal.Instant value) {
      if (createdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        created_ = value;
        onChanged();
      } else {
        createdBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder setCreated(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (createdBuilder_ == null) {
        created_ = builderForValue.build();
        onChanged();
      } else {
        createdBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder mergeCreated(io.opencannabis.schema.temporal.Instant value) {
      if (createdBuilder_ == null) {
        if (created_ != null) {
          created_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(created_).mergeFrom(value).buildPartial();
        } else {
          created_ = value;
        }
        onChanged();
      } else {
        createdBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder clearCreated() {
      if (createdBuilder_ == null) {
        created_ = null;
        onChanged();
      } else {
        created_ = null;
        createdBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getCreatedBuilder() {
      
      onChanged();
      return getCreatedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
      if (createdBuilder_ != null) {
        return createdBuilder_.getMessageOrBuilder();
      } else {
        return created_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 100 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getCreatedFieldBuilder() {
      if (createdBuilder_ == null) {
        createdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getCreated(),
                getParentForChildren(),
                isClean());
        created_ = null;
      }
      return createdBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant modified_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> modifiedBuilder_;
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public boolean hasModified() {
      return modifiedBuilder_ != null || modified_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getModified() {
      if (modifiedBuilder_ == null) {
        return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      } else {
        return modifiedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder setModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modified_ = value;
        onChanged();
      } else {
        modifiedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder setModified(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (modifiedBuilder_ == null) {
        modified_ = builderForValue.build();
        onChanged();
      } else {
        modifiedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder mergeModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (modified_ != null) {
          modified_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(modified_).mergeFrom(value).buildPartial();
        } else {
          modified_ = value;
        }
        onChanged();
      } else {
        modifiedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder clearModified() {
      if (modifiedBuilder_ == null) {
        modified_ = null;
        onChanged();
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getModifiedBuilder() {
      
      onChanged();
      return getModifiedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
      if (modifiedBuilder_ != null) {
        return modifiedBuilder_.getMessageOrBuilder();
      } else {
        return modified_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 101 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getModifiedFieldBuilder() {
      if (modifiedBuilder_ == null) {
        modifiedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getModified(),
                getParentForChildren(),
                isClean());
        modified_ = null;
      }
      return modifiedBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.partner.Partner)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.partner.Partner)
  private static final io.bloombox.schema.partner.Partner DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.partner.Partner();
  }

  public static io.bloombox.schema.partner.Partner getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Partner>
      PARSER = new com.google.protobuf.AbstractParser<Partner>() {
    public Partner parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Partner(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Partner> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Partner> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.partner.Partner getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

