/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/PartnerLocation.proto

package io.bloombox.schema.partner;

/**
 * <pre>
 * Specifies information about a brick-and-mortar location owned by a partner organization that has an active account
 * with Bloombox.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.partner.PartnerLocation}
 */
public  final class PartnerLocation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.partner.PartnerLocation)
    PartnerLocationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use PartnerLocation.newBuilder() to construct.
  private PartnerLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PartnerLocation() {
    code_ = "";
    name_ = "";
    label_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private PartnerLocation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            code_ = s;
            break;
          }
          case 18: {
            io.bloombox.schema.partner.Partner.Builder subBuilder = null;
            if (partner_ != null) {
              subBuilder = partner_.toBuilder();
            }
            partner_ = input.readMessage(io.bloombox.schema.partner.Partner.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(partner_);
              partner_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            label_ = s;
            break;
          }
          case 42: {
            io.bloombox.schema.partner.PartnerFlags.Builder subBuilder = null;
            if (flags_ != null) {
              subBuilder = flags_.toBuilder();
            }
            flags_ = input.readMessage(io.bloombox.schema.partner.PartnerFlags.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(flags_);
              flags_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            io.opencannabis.schema.media.MediaItem.Builder subBuilder = null;
            if (branding_ != null) {
              subBuilder = branding_.toBuilder();
            }
            branding_ = input.readMessage(io.opencannabis.schema.media.MediaItem.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(branding_);
              branding_ = subBuilder.buildPartial();
            }

            break;
          }
          case 58: {
            io.opencannabis.schema.contact.ContactInfo.Builder subBuilder = null;
            if (contact_ != null) {
              subBuilder = contact_.toBuilder();
            }
            contact_ = input.readMessage(io.opencannabis.schema.contact.ContactInfo.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(contact_);
              contact_ = subBuilder.buildPartial();
            }

            break;
          }
          case 66: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (created_ != null) {
              subBuilder = created_.toBuilder();
            }
            created_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(created_);
              created_ = subBuilder.buildPartial();
            }

            break;
          }
          case 74: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (modified_ != null) {
              subBuilder = modified_.toBuilder();
            }
            modified_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(modified_);
              modified_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.partner.PartnerLocationOuterClass.internal_static_bloombox_schema_partner_PartnerLocation_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.partner.PartnerLocationOuterClass.internal_static_bloombox_schema_partner_PartnerLocation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.partner.PartnerLocation.class, io.bloombox.schema.partner.PartnerLocation.Builder.class);
  }

  public static final int CODE_FIELD_NUMBER = 1;
  private volatile java.lang.Object code_;
  /**
   * <pre>
   * Short, unique string that identifies this location, scoped to the parent organization.
   * </pre>
   *
   * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
   */
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Short, unique string that identifies this location, scoped to the parent organization.
   * </pre>
   *
   * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
   */
  public com.google.protobuf.ByteString
      getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTNER_FIELD_NUMBER = 2;
  private io.bloombox.schema.partner.Partner partner_;
  /**
   * <pre>
   * Partner record that owns this location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public boolean hasPartner() {
    return partner_ != null;
  }
  /**
   * <pre>
   * Partner record that owns this location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public io.bloombox.schema.partner.Partner getPartner() {
    return partner_ == null ? io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
  }
  /**
   * <pre>
   * Partner record that owns this location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public io.bloombox.schema.partner.PartnerOrBuilder getPartnerOrBuilder() {
    return getPartner();
  }

  public static final int NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Name of this location, in human-readable verbose form.
   * </pre>
   *
   * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name of this location, in human-readable verbose form.
   * </pre>
   *
   * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FIELD_NUMBER = 4;
  private volatile java.lang.Object label_;
  /**
   * <pre>
   * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
   * </pre>
   *
   * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
   */
  public java.lang.String getLabel() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      label_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
   * </pre>
   *
   * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
   */
  public com.google.protobuf.ByteString
      getLabelBytes() {
    java.lang.Object ref = label_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      label_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLAGS_FIELD_NUMBER = 5;
  private io.bloombox.schema.partner.PartnerFlags flags_;
  /**
   * <pre>
   * Flags that specify conditions applied to this partner location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
   */
  public boolean hasFlags() {
    return flags_ != null;
  }
  /**
   * <pre>
   * Flags that specify conditions applied to this partner location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
   */
  public io.bloombox.schema.partner.PartnerFlags getFlags() {
    return flags_ == null ? io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
  }
  /**
   * <pre>
   * Flags that specify conditions applied to this partner location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
   */
  public io.bloombox.schema.partner.PartnerFlagsOrBuilder getFlagsOrBuilder() {
    return getFlags();
  }

  public static final int CONTACT_FIELD_NUMBER = 7;
  private io.opencannabis.schema.contact.ContactInfo contact_;
  /**
   * <pre>
   * Contact information for this location.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
   */
  public boolean hasContact() {
    return contact_ != null;
  }
  /**
   * <pre>
   * Contact information for this location.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfo getContact() {
    return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
  }
  /**
   * <pre>
   * Contact information for this location.
   * </pre>
   *
   * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
   */
  public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
    return getContact();
  }

  public static final int BRANDING_FIELD_NUMBER = 6;
  private io.opencannabis.schema.media.MediaItem branding_;
  /**
   * <pre>
   * Branding specific to this location. Partner-level branding is used if this is left unspecified.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
   */
  public boolean hasBranding() {
    return branding_ != null;
  }
  /**
   * <pre>
   * Branding specific to this location. Partner-level branding is used if this is left unspecified.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
   */
  public io.opencannabis.schema.media.MediaItem getBranding() {
    return branding_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
  }
  /**
   * <pre>
   * Branding specific to this location. Partner-level branding is used if this is left unspecified.
   * </pre>
   *
   * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
   */
  public io.opencannabis.schema.media.MediaItemOrBuilder getBrandingOrBuilder() {
    return getBranding();
  }

  public static final int CREATED_FIELD_NUMBER = 8;
  private io.opencannabis.schema.temporal.Instant created_;
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public boolean hasCreated() {
    return created_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getCreated() {
    return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
  }
  /**
   * <pre>
   * Timestamp for when this record was created.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
    return getCreated();
  }

  public static final int MODIFIED_FIELD_NUMBER = 9;
  private io.opencannabis.schema.temporal.Instant modified_;
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public boolean hasModified() {
    return modified_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public io.opencannabis.schema.temporal.Instant getModified() {
    return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
  }
  /**
   * <pre>
   * Timestamp for when this record was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
    return getModified();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, code_);
    }
    if (partner_ != null) {
      output.writeMessage(2, getPartner());
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    if (!getLabelBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, label_);
    }
    if (flags_ != null) {
      output.writeMessage(5, getFlags());
    }
    if (branding_ != null) {
      output.writeMessage(6, getBranding());
    }
    if (contact_ != null) {
      output.writeMessage(7, getContact());
    }
    if (created_ != null) {
      output.writeMessage(8, getCreated());
    }
    if (modified_ != null) {
      output.writeMessage(9, getModified());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, code_);
    }
    if (partner_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getPartner());
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    if (!getLabelBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, label_);
    }
    if (flags_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getFlags());
    }
    if (branding_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getBranding());
    }
    if (contact_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getContact());
    }
    if (created_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getCreated());
    }
    if (modified_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, getModified());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.partner.PartnerLocation)) {
      return super.equals(obj);
    }
    io.bloombox.schema.partner.PartnerLocation other = (io.bloombox.schema.partner.PartnerLocation) obj;

    boolean result = true;
    result = result && getCode()
        .equals(other.getCode());
    result = result && (hasPartner() == other.hasPartner());
    if (hasPartner()) {
      result = result && getPartner()
          .equals(other.getPartner());
    }
    result = result && getName()
        .equals(other.getName());
    result = result && getLabel()
        .equals(other.getLabel());
    result = result && (hasFlags() == other.hasFlags());
    if (hasFlags()) {
      result = result && getFlags()
          .equals(other.getFlags());
    }
    result = result && (hasContact() == other.hasContact());
    if (hasContact()) {
      result = result && getContact()
          .equals(other.getContact());
    }
    result = result && (hasBranding() == other.hasBranding());
    if (hasBranding()) {
      result = result && getBranding()
          .equals(other.getBranding());
    }
    result = result && (hasCreated() == other.hasCreated());
    if (hasCreated()) {
      result = result && getCreated()
          .equals(other.getCreated());
    }
    result = result && (hasModified() == other.hasModified());
    if (hasModified()) {
      result = result && getModified()
          .equals(other.getModified());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode().hashCode();
    if (hasPartner()) {
      hash = (37 * hash) + PARTNER_FIELD_NUMBER;
      hash = (53 * hash) + getPartner().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getLabel().hashCode();
    if (hasFlags()) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + getFlags().hashCode();
    }
    if (hasContact()) {
      hash = (37 * hash) + CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getContact().hashCode();
    }
    if (hasBranding()) {
      hash = (37 * hash) + BRANDING_FIELD_NUMBER;
      hash = (53 * hash) + getBranding().hashCode();
    }
    if (hasCreated()) {
      hash = (37 * hash) + CREATED_FIELD_NUMBER;
      hash = (53 * hash) + getCreated().hashCode();
    }
    if (hasModified()) {
      hash = (37 * hash) + MODIFIED_FIELD_NUMBER;
      hash = (53 * hash) + getModified().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.PartnerLocation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.partner.PartnerLocation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies information about a brick-and-mortar location owned by a partner organization that has an active account
   * with Bloombox.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.partner.PartnerLocation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.partner.PartnerLocation)
      io.bloombox.schema.partner.PartnerLocationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.partner.PartnerLocationOuterClass.internal_static_bloombox_schema_partner_PartnerLocation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.partner.PartnerLocationOuterClass.internal_static_bloombox_schema_partner_PartnerLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.partner.PartnerLocation.class, io.bloombox.schema.partner.PartnerLocation.Builder.class);
    }

    // Construct using io.bloombox.schema.partner.PartnerLocation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      code_ = "";

      if (partnerBuilder_ == null) {
        partner_ = null;
      } else {
        partner_ = null;
        partnerBuilder_ = null;
      }
      name_ = "";

      label_ = "";

      if (flagsBuilder_ == null) {
        flags_ = null;
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }
      if (contactBuilder_ == null) {
        contact_ = null;
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }
      if (brandingBuilder_ == null) {
        branding_ = null;
      } else {
        branding_ = null;
        brandingBuilder_ = null;
      }
      if (createdBuilder_ == null) {
        created_ = null;
      } else {
        created_ = null;
        createdBuilder_ = null;
      }
      if (modifiedBuilder_ == null) {
        modified_ = null;
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.partner.PartnerLocationOuterClass.internal_static_bloombox_schema_partner_PartnerLocation_descriptor;
    }

    public io.bloombox.schema.partner.PartnerLocation getDefaultInstanceForType() {
      return io.bloombox.schema.partner.PartnerLocation.getDefaultInstance();
    }

    public io.bloombox.schema.partner.PartnerLocation build() {
      io.bloombox.schema.partner.PartnerLocation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.partner.PartnerLocation buildPartial() {
      io.bloombox.schema.partner.PartnerLocation result = new io.bloombox.schema.partner.PartnerLocation(this);
      result.code_ = code_;
      if (partnerBuilder_ == null) {
        result.partner_ = partner_;
      } else {
        result.partner_ = partnerBuilder_.build();
      }
      result.name_ = name_;
      result.label_ = label_;
      if (flagsBuilder_ == null) {
        result.flags_ = flags_;
      } else {
        result.flags_ = flagsBuilder_.build();
      }
      if (contactBuilder_ == null) {
        result.contact_ = contact_;
      } else {
        result.contact_ = contactBuilder_.build();
      }
      if (brandingBuilder_ == null) {
        result.branding_ = branding_;
      } else {
        result.branding_ = brandingBuilder_.build();
      }
      if (createdBuilder_ == null) {
        result.created_ = created_;
      } else {
        result.created_ = createdBuilder_.build();
      }
      if (modifiedBuilder_ == null) {
        result.modified_ = modified_;
      } else {
        result.modified_ = modifiedBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.partner.PartnerLocation) {
        return mergeFrom((io.bloombox.schema.partner.PartnerLocation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.partner.PartnerLocation other) {
      if (other == io.bloombox.schema.partner.PartnerLocation.getDefaultInstance()) return this;
      if (!other.getCode().isEmpty()) {
        code_ = other.code_;
        onChanged();
      }
      if (other.hasPartner()) {
        mergePartner(other.getPartner());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getLabel().isEmpty()) {
        label_ = other.label_;
        onChanged();
      }
      if (other.hasFlags()) {
        mergeFlags(other.getFlags());
      }
      if (other.hasContact()) {
        mergeContact(other.getContact());
      }
      if (other.hasBranding()) {
        mergeBranding(other.getBranding());
      }
      if (other.hasCreated()) {
        mergeCreated(other.getCreated());
      }
      if (other.hasModified()) {
        mergeModified(other.getModified());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.partner.PartnerLocation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.partner.PartnerLocation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object code_ = "";
    /**
     * <pre>
     * Short, unique string that identifies this location, scoped to the parent organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Short, unique string that identifies this location, scoped to the parent organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
     */
    public com.google.protobuf.ByteString
        getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Short, unique string that identifies this location, scoped to the parent organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
     */
    public Builder setCode(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      code_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short, unique string that identifies this location, scoped to the parent organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
     */
    public Builder clearCode() {
      
      code_ = getDefaultInstance().getCode();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Short, unique string that identifies this location, scoped to the parent organization.
     * </pre>
     *
     * <code>string code = 1 [(.gen_bq_schema.description) = "Short, unique string that identifies this location, scoped to the parent organization."];</code>
     */
    public Builder setCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      code_ = value;
      onChanged();
      return this;
    }

    private io.bloombox.schema.partner.Partner partner_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder> partnerBuilder_;
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public boolean hasPartner() {
      return partnerBuilder_ != null || partner_ != null;
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public io.bloombox.schema.partner.Partner getPartner() {
      if (partnerBuilder_ == null) {
        return partner_ == null ? io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
      } else {
        return partnerBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setPartner(io.bloombox.schema.partner.Partner value) {
      if (partnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partner_ = value;
        onChanged();
      } else {
        partnerBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setPartner(
        io.bloombox.schema.partner.Partner.Builder builderForValue) {
      if (partnerBuilder_ == null) {
        partner_ = builderForValue.build();
        onChanged();
      } else {
        partnerBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder mergePartner(io.bloombox.schema.partner.Partner value) {
      if (partnerBuilder_ == null) {
        if (partner_ != null) {
          partner_ =
            io.bloombox.schema.partner.Partner.newBuilder(partner_).mergeFrom(value).buildPartial();
        } else {
          partner_ = value;
        }
        onChanged();
      } else {
        partnerBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearPartner() {
      if (partnerBuilder_ == null) {
        partner_ = null;
        onChanged();
      } else {
        partner_ = null;
        partnerBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public io.bloombox.schema.partner.Partner.Builder getPartnerBuilder() {
      
      onChanged();
      return getPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public io.bloombox.schema.partner.PartnerOrBuilder getPartnerOrBuilder() {
      if (partnerBuilder_ != null) {
        return partnerBuilder_.getMessageOrBuilder();
      } else {
        return partner_ == null ?
            io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
      }
    }
    /**
     * <pre>
     * Partner record that owns this location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder> 
        getPartnerFieldBuilder() {
      if (partnerBuilder_ == null) {
        partnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder>(
                getPartner(),
                getParentForChildren(),
                isClean());
        partner_ = null;
      }
      return partnerBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Name of this location, in human-readable verbose form.
     * </pre>
     *
     * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name of this location, in human-readable verbose form.
     * </pre>
     *
     * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name of this location, in human-readable verbose form.
     * </pre>
     *
     * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of this location, in human-readable verbose form.
     * </pre>
     *
     * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of this location, in human-readable verbose form.
     * </pre>
     *
     * <code>string name = 3 [(.gen_bq_schema.description) = "Name of this location, in human-readable verbose form."];</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object label_ = "";
    /**
     * <pre>
     * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
     * </pre>
     *
     * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
     * </pre>
     *
     * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
     * </pre>
     *
     * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
     */
    public Builder setLabel(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      label_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
     * </pre>
     *
     * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
     */
    public Builder clearLabel() {
      
      label_ = getDefaultInstance().getLabel();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Label for this location in the administrative dashboard. If this is not specified, `name` is shown.
     * </pre>
     *
     * <code>string label = 4 [(.gen_bq_schema.description) = "Label for this location in the administrative dashboard. If this is not specified, `name` is shown."];</code>
     */
    public Builder setLabelBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      label_ = value;
      onChanged();
      return this;
    }

    private io.bloombox.schema.partner.PartnerFlags flags_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder> flagsBuilder_;
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public boolean hasFlags() {
      return flagsBuilder_ != null || flags_ != null;
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlags getFlags() {
      if (flagsBuilder_ == null) {
        return flags_ == null ? io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
      } else {
        return flagsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public Builder setFlags(io.bloombox.schema.partner.PartnerFlags value) {
      if (flagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        flags_ = value;
        onChanged();
      } else {
        flagsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public Builder setFlags(
        io.bloombox.schema.partner.PartnerFlags.Builder builderForValue) {
      if (flagsBuilder_ == null) {
        flags_ = builderForValue.build();
        onChanged();
      } else {
        flagsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public Builder mergeFlags(io.bloombox.schema.partner.PartnerFlags value) {
      if (flagsBuilder_ == null) {
        if (flags_ != null) {
          flags_ =
            io.bloombox.schema.partner.PartnerFlags.newBuilder(flags_).mergeFrom(value).buildPartial();
        } else {
          flags_ = value;
        }
        onChanged();
      } else {
        flagsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public Builder clearFlags() {
      if (flagsBuilder_ == null) {
        flags_ = null;
        onChanged();
      } else {
        flags_ = null;
        flagsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlags.Builder getFlagsBuilder() {
      
      onChanged();
      return getFlagsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    public io.bloombox.schema.partner.PartnerFlagsOrBuilder getFlagsOrBuilder() {
      if (flagsBuilder_ != null) {
        return flagsBuilder_.getMessageOrBuilder();
      } else {
        return flags_ == null ?
            io.bloombox.schema.partner.PartnerFlags.getDefaultInstance() : flags_;
      }
    }
    /**
     * <pre>
     * Flags that specify conditions applied to this partner location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerFlags flags = 5 [(.gen_bq_schema.description) = "Flags that specify conditions applied to this partner location."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder> 
        getFlagsFieldBuilder() {
      if (flagsBuilder_ == null) {
        flagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.PartnerFlags, io.bloombox.schema.partner.PartnerFlags.Builder, io.bloombox.schema.partner.PartnerFlagsOrBuilder>(
                getFlags(),
                getParentForChildren(),
                isClean());
        flags_ = null;
      }
      return flagsBuilder_;
    }

    private io.opencannabis.schema.contact.ContactInfo contact_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> contactBuilder_;
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public boolean hasContact() {
      return contactBuilder_ != null || contact_ != null;
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo getContact() {
      if (contactBuilder_ == null) {
        return contact_ == null ? io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      } else {
        return contactBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public Builder setContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contact_ = value;
        onChanged();
      } else {
        contactBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public Builder setContact(
        io.opencannabis.schema.contact.ContactInfo.Builder builderForValue) {
      if (contactBuilder_ == null) {
        contact_ = builderForValue.build();
        onChanged();
      } else {
        contactBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public Builder mergeContact(io.opencannabis.schema.contact.ContactInfo value) {
      if (contactBuilder_ == null) {
        if (contact_ != null) {
          contact_ =
            io.opencannabis.schema.contact.ContactInfo.newBuilder(contact_).mergeFrom(value).buildPartial();
        } else {
          contact_ = value;
        }
        onChanged();
      } else {
        contactBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public Builder clearContact() {
      if (contactBuilder_ == null) {
        contact_ = null;
        onChanged();
      } else {
        contact_ = null;
        contactBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfo.Builder getContactBuilder() {
      
      onChanged();
      return getContactFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    public io.opencannabis.schema.contact.ContactInfoOrBuilder getContactOrBuilder() {
      if (contactBuilder_ != null) {
        return contactBuilder_.getMessageOrBuilder();
      } else {
        return contact_ == null ?
            io.opencannabis.schema.contact.ContactInfo.getDefaultInstance() : contact_;
      }
    }
    /**
     * <pre>
     * Contact information for this location.
     * </pre>
     *
     * <code>.opencannabis.contact.ContactInfo contact = 7 [(.gen_bq_schema.description) = "Contact information for this location."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder> 
        getContactFieldBuilder() {
      if (contactBuilder_ == null) {
        contactBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.contact.ContactInfo, io.opencannabis.schema.contact.ContactInfo.Builder, io.opencannabis.schema.contact.ContactInfoOrBuilder>(
                getContact(),
                getParentForChildren(),
                isClean());
        contact_ = null;
      }
      return contactBuilder_;
    }

    private io.opencannabis.schema.media.MediaItem branding_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> brandingBuilder_;
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public boolean hasBranding() {
      return brandingBuilder_ != null || branding_ != null;
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public io.opencannabis.schema.media.MediaItem getBranding() {
      if (brandingBuilder_ == null) {
        return branding_ == null ? io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
      } else {
        return brandingBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public Builder setBranding(io.opencannabis.schema.media.MediaItem value) {
      if (brandingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        branding_ = value;
        onChanged();
      } else {
        brandingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public Builder setBranding(
        io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
      if (brandingBuilder_ == null) {
        branding_ = builderForValue.build();
        onChanged();
      } else {
        brandingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public Builder mergeBranding(io.opencannabis.schema.media.MediaItem value) {
      if (brandingBuilder_ == null) {
        if (branding_ != null) {
          branding_ =
            io.opencannabis.schema.media.MediaItem.newBuilder(branding_).mergeFrom(value).buildPartial();
        } else {
          branding_ = value;
        }
        onChanged();
      } else {
        brandingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public Builder clearBranding() {
      if (brandingBuilder_ == null) {
        branding_ = null;
        onChanged();
      } else {
        branding_ = null;
        brandingBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public io.opencannabis.schema.media.MediaItem.Builder getBrandingBuilder() {
      
      onChanged();
      return getBrandingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    public io.opencannabis.schema.media.MediaItemOrBuilder getBrandingOrBuilder() {
      if (brandingBuilder_ != null) {
        return brandingBuilder_.getMessageOrBuilder();
      } else {
        return branding_ == null ?
            io.opencannabis.schema.media.MediaItem.getDefaultInstance() : branding_;
      }
    }
    /**
     * <pre>
     * Branding specific to this location. Partner-level branding is used if this is left unspecified.
     * </pre>
     *
     * <code>.opencannabis.media.MediaItem branding = 6 [(.gen_bq_schema.description) = "Branding specific to this location. Partner-level branding is used if this is left unspecified."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> 
        getBrandingFieldBuilder() {
      if (brandingBuilder_ == null) {
        brandingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder>(
                getBranding(),
                getParentForChildren(),
                isClean());
        branding_ = null;
      }
      return brandingBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant created_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> createdBuilder_;
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public boolean hasCreated() {
      return createdBuilder_ != null || created_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getCreated() {
      if (createdBuilder_ == null) {
        return created_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
      } else {
        return createdBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder setCreated(io.opencannabis.schema.temporal.Instant value) {
      if (createdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        created_ = value;
        onChanged();
      } else {
        createdBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder setCreated(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (createdBuilder_ == null) {
        created_ = builderForValue.build();
        onChanged();
      } else {
        createdBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder mergeCreated(io.opencannabis.schema.temporal.Instant value) {
      if (createdBuilder_ == null) {
        if (created_ != null) {
          created_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(created_).mergeFrom(value).buildPartial();
        } else {
          created_ = value;
        }
        onChanged();
      } else {
        createdBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public Builder clearCreated() {
      if (createdBuilder_ == null) {
        created_ = null;
        onChanged();
      } else {
        created_ = null;
        createdBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getCreatedBuilder() {
      
      onChanged();
      return getCreatedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedOrBuilder() {
      if (createdBuilder_ != null) {
        return createdBuilder_.getMessageOrBuilder();
      } else {
        return created_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : created_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created = 8 [(.gen_bq_schema.description) = "Timestamp for when this record was created."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getCreatedFieldBuilder() {
      if (createdBuilder_ == null) {
        createdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getCreated(),
                getParentForChildren(),
                isClean());
        created_ = null;
      }
      return createdBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant modified_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> modifiedBuilder_;
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public boolean hasModified() {
      return modifiedBuilder_ != null || modified_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getModified() {
      if (modifiedBuilder_ == null) {
        return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      } else {
        return modifiedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder setModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modified_ = value;
        onChanged();
      } else {
        modifiedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder setModified(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (modifiedBuilder_ == null) {
        modified_ = builderForValue.build();
        onChanged();
      } else {
        modifiedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder mergeModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (modified_ != null) {
          modified_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(modified_).mergeFrom(value).buildPartial();
        } else {
          modified_ = value;
        }
        onChanged();
      } else {
        modifiedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public Builder clearModified() {
      if (modifiedBuilder_ == null) {
        modified_ = null;
        onChanged();
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getModifiedBuilder() {
      
      onChanged();
      return getModifiedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
      if (modifiedBuilder_ != null) {
        return modifiedBuilder_.getMessageOrBuilder();
      } else {
        return modified_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this record was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9 [(.gen_bq_schema.description) = "Timestamp for when this record was last modified."];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getModifiedFieldBuilder() {
      if (modifiedBuilder_ == null) {
        modifiedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getModified(),
                getParentForChildren(),
                isClean());
        modified_ = null;
      }
      return modifiedBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.partner.PartnerLocation)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.partner.PartnerLocation)
  private static final io.bloombox.schema.partner.PartnerLocation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.partner.PartnerLocation();
  }

  public static io.bloombox.schema.partner.PartnerLocation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartnerLocation>
      PARSER = new com.google.protobuf.AbstractParser<PartnerLocation>() {
    public PartnerLocation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new PartnerLocation(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<PartnerLocation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartnerLocation> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.partner.PartnerLocation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

