/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/integrations/IntegrationSettings.proto

package io.bloombox.schema.partner.integrations;

/**
 * <pre>
 * Specifies a generic set of settings for a given integration.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.partner.integrations.GenericIntegrationSettings}
 */
public  final class GenericIntegrationSettings extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.partner.integrations.GenericIntegrationSettings)
    GenericIntegrationSettingsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use GenericIntegrationSettings.newBuilder() to construct.
  private GenericIntegrationSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private GenericIntegrationSettings() {
    partner_ = 0;
    enabled_ = false;
    fullySetup_ = false;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private GenericIntegrationSettings(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            partner_ = rawValue;
            break;
          }
          case 16: {

            enabled_ = input.readBool();
            break;
          }
          case 24: {

            fullySetup_ = input.readBool();
            break;
          }
          case 34: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (lastTested_ != null) {
              subBuilder = lastTested_.toBuilder();
            }
            lastTested_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(lastTested_);
              lastTested_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_GenericIntegrationSettings_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_GenericIntegrationSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.partner.integrations.GenericIntegrationSettings.class, io.bloombox.schema.partner.integrations.GenericIntegrationSettings.Builder.class);
  }

  public static final int PARTNER_FIELD_NUMBER = 1;
  private int partner_;
  /**
   * <pre>
   * Specifies the integration partner to which these settings apply for a given location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
   */
  public int getPartnerValue() {
    return partner_;
  }
  /**
   * <pre>
   * Specifies the integration partner to which these settings apply for a given location.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
   */
  public io.bloombox.schema.partner.integrations.IntegrationPartner getPartner() {
    io.bloombox.schema.partner.integrations.IntegrationPartner result = io.bloombox.schema.partner.integrations.IntegrationPartner.valueOf(partner_);
    return result == null ? io.bloombox.schema.partner.integrations.IntegrationPartner.UNRECOGNIZED : result;
  }

  public static final int ENABLED_FIELD_NUMBER = 2;
  private boolean enabled_;
  /**
   * <pre>
   * Whether this integration is currently enabled.
   * </pre>
   *
   * <code>bool enabled = 2;</code>
   */
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int FULLY_SETUP_FIELD_NUMBER = 3;
  private boolean fullySetup_;
  /**
   * <pre>
   * Whether this integration has been fully setup.
   * </pre>
   *
   * <code>bool fully_setup = 3;</code>
   */
  public boolean getFullySetup() {
    return fullySetup_;
  }

  public static final int LAST_TESTED_FIELD_NUMBER = 4;
  private io.opencannabis.schema.temporal.Instant lastTested_;
  /**
   * <pre>
   * Timestamp for when this integration was last tested.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
   */
  public boolean hasLastTested() {
    return lastTested_ != null;
  }
  /**
   * <pre>
   * Timestamp for when this integration was last tested.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
   */
  public io.opencannabis.schema.temporal.Instant getLastTested() {
    return lastTested_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastTested_;
  }
  /**
   * <pre>
   * Timestamp for when this integration was last tested.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getLastTestedOrBuilder() {
    return getLastTested();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (partner_ != io.bloombox.schema.partner.integrations.IntegrationPartner.INTERNAL.getNumber()) {
      output.writeEnum(1, partner_);
    }
    if (enabled_ != false) {
      output.writeBool(2, enabled_);
    }
    if (fullySetup_ != false) {
      output.writeBool(3, fullySetup_);
    }
    if (lastTested_ != null) {
      output.writeMessage(4, getLastTested());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (partner_ != io.bloombox.schema.partner.integrations.IntegrationPartner.INTERNAL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, partner_);
    }
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(2, enabled_);
    }
    if (fullySetup_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(3, fullySetup_);
    }
    if (lastTested_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getLastTested());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.partner.integrations.GenericIntegrationSettings)) {
      return super.equals(obj);
    }
    io.bloombox.schema.partner.integrations.GenericIntegrationSettings other = (io.bloombox.schema.partner.integrations.GenericIntegrationSettings) obj;

    boolean result = true;
    result = result && partner_ == other.partner_;
    result = result && (getEnabled()
        == other.getEnabled());
    result = result && (getFullySetup()
        == other.getFullySetup());
    result = result && (hasLastTested() == other.hasLastTested());
    if (hasLastTested()) {
      result = result && getLastTested()
          .equals(other.getLastTested());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTNER_FIELD_NUMBER;
    hash = (53 * hash) + partner_;
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getEnabled());
    hash = (37 * hash) + FULLY_SETUP_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getFullySetup());
    if (hasLastTested()) {
      hash = (37 * hash) + LAST_TESTED_FIELD_NUMBER;
      hash = (53 * hash) + getLastTested().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.partner.integrations.GenericIntegrationSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a generic set of settings for a given integration.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.partner.integrations.GenericIntegrationSettings}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.partner.integrations.GenericIntegrationSettings)
      io.bloombox.schema.partner.integrations.GenericIntegrationSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_GenericIntegrationSettings_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_GenericIntegrationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.partner.integrations.GenericIntegrationSettings.class, io.bloombox.schema.partner.integrations.GenericIntegrationSettings.Builder.class);
    }

    // Construct using io.bloombox.schema.partner.integrations.GenericIntegrationSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      partner_ = 0;

      enabled_ = false;

      fullySetup_ = false;

      if (lastTestedBuilder_ == null) {
        lastTested_ = null;
      } else {
        lastTested_ = null;
        lastTestedBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_GenericIntegrationSettings_descriptor;
    }

    public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getDefaultInstanceForType() {
      return io.bloombox.schema.partner.integrations.GenericIntegrationSettings.getDefaultInstance();
    }

    public io.bloombox.schema.partner.integrations.GenericIntegrationSettings build() {
      io.bloombox.schema.partner.integrations.GenericIntegrationSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.partner.integrations.GenericIntegrationSettings buildPartial() {
      io.bloombox.schema.partner.integrations.GenericIntegrationSettings result = new io.bloombox.schema.partner.integrations.GenericIntegrationSettings(this);
      result.partner_ = partner_;
      result.enabled_ = enabled_;
      result.fullySetup_ = fullySetup_;
      if (lastTestedBuilder_ == null) {
        result.lastTested_ = lastTested_;
      } else {
        result.lastTested_ = lastTestedBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.partner.integrations.GenericIntegrationSettings) {
        return mergeFrom((io.bloombox.schema.partner.integrations.GenericIntegrationSettings)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.partner.integrations.GenericIntegrationSettings other) {
      if (other == io.bloombox.schema.partner.integrations.GenericIntegrationSettings.getDefaultInstance()) return this;
      if (other.partner_ != 0) {
        setPartnerValue(other.getPartnerValue());
      }
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (other.getFullySetup() != false) {
        setFullySetup(other.getFullySetup());
      }
      if (other.hasLastTested()) {
        mergeLastTested(other.getLastTested());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.partner.integrations.GenericIntegrationSettings parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.partner.integrations.GenericIntegrationSettings) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int partner_ = 0;
    /**
     * <pre>
     * Specifies the integration partner to which these settings apply for a given location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
     */
    public int getPartnerValue() {
      return partner_;
    }
    /**
     * <pre>
     * Specifies the integration partner to which these settings apply for a given location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
     */
    public Builder setPartnerValue(int value) {
      partner_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the integration partner to which these settings apply for a given location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
     */
    public io.bloombox.schema.partner.integrations.IntegrationPartner getPartner() {
      io.bloombox.schema.partner.integrations.IntegrationPartner result = io.bloombox.schema.partner.integrations.IntegrationPartner.valueOf(partner_);
      return result == null ? io.bloombox.schema.partner.integrations.IntegrationPartner.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the integration partner to which these settings apply for a given location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
     */
    public Builder setPartner(io.bloombox.schema.partner.integrations.IntegrationPartner value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      partner_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the integration partner to which these settings apply for a given location.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.IntegrationPartner partner = 1;</code>
     */
    public Builder clearPartner() {
      
      partner_ = 0;
      onChanged();
      return this;
    }

    private boolean enabled_ ;
    /**
     * <pre>
     * Whether this integration is currently enabled.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     */
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     * <pre>
     * Whether this integration is currently enabled.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     */
    public Builder setEnabled(boolean value) {
      
      enabled_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this integration is currently enabled.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     */
    public Builder clearEnabled() {
      
      enabled_ = false;
      onChanged();
      return this;
    }

    private boolean fullySetup_ ;
    /**
     * <pre>
     * Whether this integration has been fully setup.
     * </pre>
     *
     * <code>bool fully_setup = 3;</code>
     */
    public boolean getFullySetup() {
      return fullySetup_;
    }
    /**
     * <pre>
     * Whether this integration has been fully setup.
     * </pre>
     *
     * <code>bool fully_setup = 3;</code>
     */
    public Builder setFullySetup(boolean value) {
      
      fullySetup_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this integration has been fully setup.
     * </pre>
     *
     * <code>bool fully_setup = 3;</code>
     */
    public Builder clearFullySetup() {
      
      fullySetup_ = false;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant lastTested_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> lastTestedBuilder_;
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public boolean hasLastTested() {
      return lastTestedBuilder_ != null || lastTested_ != null;
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getLastTested() {
      if (lastTestedBuilder_ == null) {
        return lastTested_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastTested_;
      } else {
        return lastTestedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public Builder setLastTested(io.opencannabis.schema.temporal.Instant value) {
      if (lastTestedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTested_ = value;
        onChanged();
      } else {
        lastTestedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public Builder setLastTested(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (lastTestedBuilder_ == null) {
        lastTested_ = builderForValue.build();
        onChanged();
      } else {
        lastTestedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public Builder mergeLastTested(io.opencannabis.schema.temporal.Instant value) {
      if (lastTestedBuilder_ == null) {
        if (lastTested_ != null) {
          lastTested_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(lastTested_).mergeFrom(value).buildPartial();
        } else {
          lastTested_ = value;
        }
        onChanged();
      } else {
        lastTestedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public Builder clearLastTested() {
      if (lastTestedBuilder_ == null) {
        lastTested_ = null;
        onChanged();
      } else {
        lastTested_ = null;
        lastTestedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getLastTestedBuilder() {
      
      onChanged();
      return getLastTestedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getLastTestedOrBuilder() {
      if (lastTestedBuilder_ != null) {
        return lastTestedBuilder_.getMessageOrBuilder();
      } else {
        return lastTested_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : lastTested_;
      }
    }
    /**
     * <pre>
     * Timestamp for when this integration was last tested.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant last_tested = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getLastTestedFieldBuilder() {
      if (lastTestedBuilder_ == null) {
        lastTestedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getLastTested(),
                getParentForChildren(),
                isClean());
        lastTested_ = null;
      }
      return lastTestedBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.partner.integrations.GenericIntegrationSettings)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.partner.integrations.GenericIntegrationSettings)
  private static final io.bloombox.schema.partner.integrations.GenericIntegrationSettings DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.partner.integrations.GenericIntegrationSettings();
  }

  public static io.bloombox.schema.partner.integrations.GenericIntegrationSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenericIntegrationSettings>
      PARSER = new com.google.protobuf.AbstractParser<GenericIntegrationSettings>() {
    public GenericIntegrationSettings parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new GenericIntegrationSettings(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<GenericIntegrationSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenericIntegrationSettings> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

