/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/integrations/IntegrationSettings.proto

package io.bloombox.schema.partner.integrations;

/**
 * <pre>
 * Location-level integration settings.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.partner.integrations.LocationIntegrationSettings}
 */
public  final class LocationIntegrationSettings extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.partner.integrations.LocationIntegrationSettings)
    LocationIntegrationSettingsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use LocationIntegrationSettings.newBuilder() to construct.
  private LocationIntegrationSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private LocationIntegrationSettings() {
    integrations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private LocationIntegrationSettings(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
              integrations_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000001;
            }
            integrations_.add(rawValue);
            break;
          }
          case 10: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                integrations_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              integrations_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              generic_ = com.google.protobuf.MapField.newMapField(
                  GenericDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000002;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
            generic__ = input.readMessage(
                GenericDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            generic_.getMutableMap().put(
                generic__.getKey(), generic__.getValue());
            break;
          }
          case 82: {
            io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder subBuilder = null;
            if (greenbits_ != null) {
              subBuilder = greenbits_.toBuilder();
            }
            greenbits_ = input.readMessage(io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(greenbits_);
              greenbits_ = subBuilder.buildPartial();
            }

            break;
          }
          case 90: {
            io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder subBuilder = null;
            if (mailchimp_ != null) {
              subBuilder = mailchimp_.toBuilder();
            }
            mailchimp_ = input.readMessage(io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(mailchimp_);
              mailchimp_ = subBuilder.buildPartial();
            }

            break;
          }
          case 98: {
            io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder subBuilder = null;
            if (sendgrid_ != null) {
              subBuilder = sendgrid_.toBuilder();
            }
            sendgrid_ = input.readMessage(io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(sendgrid_);
              sendgrid_ = subBuilder.buildPartial();
            }

            break;
          }
          case 106: {
            io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder subBuilder = null;
            if (twilio_ != null) {
              subBuilder = twilio_.toBuilder();
            }
            twilio_ = input.readMessage(io.bloombox.schema.partner.integrations.twilio.TwilioSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(twilio_);
              twilio_ = subBuilder.buildPartial();
            }

            break;
          }
          case 114: {
            io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder subBuilder = null;
            if (onfleet_ != null) {
              subBuilder = onfleet_.toBuilder();
            }
            onfleet_ = input.readMessage(io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(onfleet_);
              onfleet_ = subBuilder.buildPartial();
            }

            break;
          }
          case 122: {
            io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder subBuilder = null;
            if (treez_ != null) {
              subBuilder = treez_.toBuilder();
            }
            treez_ = input.readMessage(io.bloombox.schema.partner.integrations.treez.TreezSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(treez_);
              treez_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
        integrations_ = java.util.Collections.unmodifiableList(integrations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 2:
        return internalGetGeneric();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.partner.integrations.LocationIntegrationSettings.class, io.bloombox.schema.partner.integrations.LocationIntegrationSettings.Builder.class);
  }

  private int bitField0_;
  public static final int INTEGRATIONS_FIELD_NUMBER = 1;
  private java.util.List<java.lang.Integer> integrations_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.bloombox.schema.partner.integrations.IntegrationPartner> integrations_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.bloombox.schema.partner.integrations.IntegrationPartner>() {
            public io.bloombox.schema.partner.integrations.IntegrationPartner convert(java.lang.Integer from) {
              io.bloombox.schema.partner.integrations.IntegrationPartner result = io.bloombox.schema.partner.integrations.IntegrationPartner.valueOf(from);
              return result == null ? io.bloombox.schema.partner.integrations.IntegrationPartner.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Specifies integrations that a specific location has setup.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
   */
  public java.util.List<io.bloombox.schema.partner.integrations.IntegrationPartner> getIntegrationsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.bloombox.schema.partner.integrations.IntegrationPartner>(integrations_, integrations_converter_);
  }
  /**
   * <pre>
   * Specifies integrations that a specific location has setup.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
   */
  public int getIntegrationsCount() {
    return integrations_.size();
  }
  /**
   * <pre>
   * Specifies integrations that a specific location has setup.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
   */
  public io.bloombox.schema.partner.integrations.IntegrationPartner getIntegrations(int index) {
    return integrations_converter_.convert(integrations_.get(index));
  }
  /**
   * <pre>
   * Specifies integrations that a specific location has setup.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
   */
  public java.util.List<java.lang.Integer>
  getIntegrationsValueList() {
    return integrations_;
  }
  /**
   * <pre>
   * Specifies integrations that a specific location has setup.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
   */
  public int getIntegrationsValue(int index) {
    return integrations_.get(index);
  }
  private int integrationsMemoizedSerializedSize;

  public static final int GENERIC_FIELD_NUMBER = 2;
  private static final class GenericDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>newDefaultInstance(
                io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_GenericEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.bloombox.schema.partner.integrations.GenericIntegrationSettings.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> generic_;
  private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
  internalGetGeneric() {
    if (generic_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          GenericDefaultEntryHolder.defaultEntry);
    }
    return generic_;
  }

  public int getGenericCount() {
    return internalGetGeneric().getMap().size();
  }
  /**
   * <pre>
   * Generic settings, specified for each integration.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
   */

  public boolean containsGeneric(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetGeneric().getMap().containsKey(key);
  }
  /**
   * Use {@link #getGenericMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> getGeneric() {
    return getGenericMap();
  }
  /**
   * <pre>
   * Generic settings, specified for each integration.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
   */

  public java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> getGenericMap() {
    return internalGetGeneric().getMap();
  }
  /**
   * <pre>
   * Generic settings, specified for each integration.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
   */

  public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getGenericOrDefault(
      java.lang.String key,
      io.bloombox.schema.partner.integrations.GenericIntegrationSettings defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> map =
        internalGetGeneric().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Generic settings, specified for each integration.
   * </pre>
   *
   * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
   */

  public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getGenericOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> map =
        internalGetGeneric().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int GREENBITS_FIELD_NUMBER = 10;
  private io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits_;
  /**
   * <pre>
   * Specifies location-specific integration settings with Greenbits.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
   */
  public boolean hasGreenbits() {
    return greenbits_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Greenbits.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
   */
  public io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings getGreenbits() {
    return greenbits_ == null ? io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.getDefaultInstance() : greenbits_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Greenbits.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
   */
  public io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettingsOrBuilder getGreenbitsOrBuilder() {
    return getGreenbits();
  }

  public static final int MAILCHIMP_FIELD_NUMBER = 11;
  private io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp_;
  /**
   * <pre>
   * Specifies location-specific integration settings with MailChimp.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
   */
  public boolean hasMailchimp() {
    return mailchimp_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with MailChimp.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
   */
  public io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings getMailchimp() {
    return mailchimp_ == null ? io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.getDefaultInstance() : mailchimp_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with MailChimp.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
   */
  public io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettingsOrBuilder getMailchimpOrBuilder() {
    return getMailchimp();
  }

  public static final int SENDGRID_FIELD_NUMBER = 12;
  private io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid_;
  /**
   * <pre>
   * Specifies location-specific integration settings with Sendgrid.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
   */
  public boolean hasSendgrid() {
    return sendgrid_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Sendgrid.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
   */
  public io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings getSendgrid() {
    return sendgrid_ == null ? io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.getDefaultInstance() : sendgrid_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Sendgrid.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
   */
  public io.bloombox.schema.partner.integrations.sendgrid.SendgridSettingsOrBuilder getSendgridOrBuilder() {
    return getSendgrid();
  }

  public static final int TWILIO_FIELD_NUMBER = 13;
  private io.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio_;
  /**
   * <pre>
   * Specifies location-specific integration settings with Twilio.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
   */
  public boolean hasTwilio() {
    return twilio_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Twilio.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
   */
  public io.bloombox.schema.partner.integrations.twilio.TwilioSettings getTwilio() {
    return twilio_ == null ? io.bloombox.schema.partner.integrations.twilio.TwilioSettings.getDefaultInstance() : twilio_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Twilio.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
   */
  public io.bloombox.schema.partner.integrations.twilio.TwilioSettingsOrBuilder getTwilioOrBuilder() {
    return getTwilio();
  }

  public static final int ONFLEET_FIELD_NUMBER = 14;
  private io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet_;
  /**
   * <pre>
   * Specifies location-specific integration settings with OnFleet.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
   */
  public boolean hasOnfleet() {
    return onfleet_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with OnFleet.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
   */
  public io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings getOnfleet() {
    return onfleet_ == null ? io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.getDefaultInstance() : onfleet_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with OnFleet.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
   */
  public io.bloombox.schema.partner.integrations.onfleet.OnFleetSettingsOrBuilder getOnfleetOrBuilder() {
    return getOnfleet();
  }

  public static final int TREEZ_FIELD_NUMBER = 15;
  private io.bloombox.schema.partner.integrations.treez.TreezSettings treez_;
  /**
   * <pre>
   * Specifies location-specific integration settings with Treez.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
   */
  public boolean hasTreez() {
    return treez_ != null;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Treez.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
   */
  public io.bloombox.schema.partner.integrations.treez.TreezSettings getTreez() {
    return treez_ == null ? io.bloombox.schema.partner.integrations.treez.TreezSettings.getDefaultInstance() : treez_;
  }
  /**
   * <pre>
   * Specifies location-specific integration settings with Treez.
   * </pre>
   *
   * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
   */
  public io.bloombox.schema.partner.integrations.treez.TreezSettingsOrBuilder getTreezOrBuilder() {
    return getTreez();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (getIntegrationsList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(integrationsMemoizedSerializedSize);
    }
    for (int i = 0; i < integrations_.size(); i++) {
      output.writeEnumNoTag(integrations_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetGeneric(),
        GenericDefaultEntryHolder.defaultEntry,
        2);
    if (greenbits_ != null) {
      output.writeMessage(10, getGreenbits());
    }
    if (mailchimp_ != null) {
      output.writeMessage(11, getMailchimp());
    }
    if (sendgrid_ != null) {
      output.writeMessage(12, getSendgrid());
    }
    if (twilio_ != null) {
      output.writeMessage(13, getTwilio());
    }
    if (onfleet_ != null) {
      output.writeMessage(14, getOnfleet());
    }
    if (treez_ != null) {
      output.writeMessage(15, getTreez());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < integrations_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(integrations_.get(i));
      }
      size += dataSize;
      if (!getIntegrationsList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }integrationsMemoizedSerializedSize = dataSize;
    }
    for (java.util.Map.Entry<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> entry
         : internalGetGeneric().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
      generic__ = GenericDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, generic__);
    }
    if (greenbits_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getGreenbits());
    }
    if (mailchimp_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, getMailchimp());
    }
    if (sendgrid_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, getSendgrid());
    }
    if (twilio_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(13, getTwilio());
    }
    if (onfleet_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(14, getOnfleet());
    }
    if (treez_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(15, getTreez());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.partner.integrations.LocationIntegrationSettings)) {
      return super.equals(obj);
    }
    io.bloombox.schema.partner.integrations.LocationIntegrationSettings other = (io.bloombox.schema.partner.integrations.LocationIntegrationSettings) obj;

    boolean result = true;
    result = result && integrations_.equals(other.integrations_);
    result = result && internalGetGeneric().equals(
        other.internalGetGeneric());
    result = result && (hasGreenbits() == other.hasGreenbits());
    if (hasGreenbits()) {
      result = result && getGreenbits()
          .equals(other.getGreenbits());
    }
    result = result && (hasMailchimp() == other.hasMailchimp());
    if (hasMailchimp()) {
      result = result && getMailchimp()
          .equals(other.getMailchimp());
    }
    result = result && (hasSendgrid() == other.hasSendgrid());
    if (hasSendgrid()) {
      result = result && getSendgrid()
          .equals(other.getSendgrid());
    }
    result = result && (hasTwilio() == other.hasTwilio());
    if (hasTwilio()) {
      result = result && getTwilio()
          .equals(other.getTwilio());
    }
    result = result && (hasOnfleet() == other.hasOnfleet());
    if (hasOnfleet()) {
      result = result && getOnfleet()
          .equals(other.getOnfleet());
    }
    result = result && (hasTreez() == other.hasTreez());
    if (hasTreez()) {
      result = result && getTreez()
          .equals(other.getTreez());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIntegrationsCount() > 0) {
      hash = (37 * hash) + INTEGRATIONS_FIELD_NUMBER;
      hash = (53 * hash) + integrations_.hashCode();
    }
    if (!internalGetGeneric().getMap().isEmpty()) {
      hash = (37 * hash) + GENERIC_FIELD_NUMBER;
      hash = (53 * hash) + internalGetGeneric().hashCode();
    }
    if (hasGreenbits()) {
      hash = (37 * hash) + GREENBITS_FIELD_NUMBER;
      hash = (53 * hash) + getGreenbits().hashCode();
    }
    if (hasMailchimp()) {
      hash = (37 * hash) + MAILCHIMP_FIELD_NUMBER;
      hash = (53 * hash) + getMailchimp().hashCode();
    }
    if (hasSendgrid()) {
      hash = (37 * hash) + SENDGRID_FIELD_NUMBER;
      hash = (53 * hash) + getSendgrid().hashCode();
    }
    if (hasTwilio()) {
      hash = (37 * hash) + TWILIO_FIELD_NUMBER;
      hash = (53 * hash) + getTwilio().hashCode();
    }
    if (hasOnfleet()) {
      hash = (37 * hash) + ONFLEET_FIELD_NUMBER;
      hash = (53 * hash) + getOnfleet().hashCode();
    }
    if (hasTreez()) {
      hash = (37 * hash) + TREEZ_FIELD_NUMBER;
      hash = (53 * hash) + getTreez().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.partner.integrations.LocationIntegrationSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Location-level integration settings.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.partner.integrations.LocationIntegrationSettings}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.partner.integrations.LocationIntegrationSettings)
      io.bloombox.schema.partner.integrations.LocationIntegrationSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 2:
          return internalGetGeneric();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 2:
          return internalGetMutableGeneric();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.partner.integrations.LocationIntegrationSettings.class, io.bloombox.schema.partner.integrations.LocationIntegrationSettings.Builder.class);
    }

    // Construct using io.bloombox.schema.partner.integrations.LocationIntegrationSettings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      integrations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableGeneric().clear();
      if (greenbitsBuilder_ == null) {
        greenbits_ = null;
      } else {
        greenbits_ = null;
        greenbitsBuilder_ = null;
      }
      if (mailchimpBuilder_ == null) {
        mailchimp_ = null;
      } else {
        mailchimp_ = null;
        mailchimpBuilder_ = null;
      }
      if (sendgridBuilder_ == null) {
        sendgrid_ = null;
      } else {
        sendgrid_ = null;
        sendgridBuilder_ = null;
      }
      if (twilioBuilder_ == null) {
        twilio_ = null;
      } else {
        twilio_ = null;
        twilioBuilder_ = null;
      }
      if (onfleetBuilder_ == null) {
        onfleet_ = null;
      } else {
        onfleet_ = null;
        onfleetBuilder_ = null;
      }
      if (treezBuilder_ == null) {
        treez_ = null;
      } else {
        treez_ = null;
        treezBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.partner.integrations.IntegrationSettings.internal_static_bloombox_schema_partner_integrations_LocationIntegrationSettings_descriptor;
    }

    public io.bloombox.schema.partner.integrations.LocationIntegrationSettings getDefaultInstanceForType() {
      return io.bloombox.schema.partner.integrations.LocationIntegrationSettings.getDefaultInstance();
    }

    public io.bloombox.schema.partner.integrations.LocationIntegrationSettings build() {
      io.bloombox.schema.partner.integrations.LocationIntegrationSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.partner.integrations.LocationIntegrationSettings buildPartial() {
      io.bloombox.schema.partner.integrations.LocationIntegrationSettings result = new io.bloombox.schema.partner.integrations.LocationIntegrationSettings(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        integrations_ = java.util.Collections.unmodifiableList(integrations_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.integrations_ = integrations_;
      result.generic_ = internalGetGeneric();
      result.generic_.makeImmutable();
      if (greenbitsBuilder_ == null) {
        result.greenbits_ = greenbits_;
      } else {
        result.greenbits_ = greenbitsBuilder_.build();
      }
      if (mailchimpBuilder_ == null) {
        result.mailchimp_ = mailchimp_;
      } else {
        result.mailchimp_ = mailchimpBuilder_.build();
      }
      if (sendgridBuilder_ == null) {
        result.sendgrid_ = sendgrid_;
      } else {
        result.sendgrid_ = sendgridBuilder_.build();
      }
      if (twilioBuilder_ == null) {
        result.twilio_ = twilio_;
      } else {
        result.twilio_ = twilioBuilder_.build();
      }
      if (onfleetBuilder_ == null) {
        result.onfleet_ = onfleet_;
      } else {
        result.onfleet_ = onfleetBuilder_.build();
      }
      if (treezBuilder_ == null) {
        result.treez_ = treez_;
      } else {
        result.treez_ = treezBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.partner.integrations.LocationIntegrationSettings) {
        return mergeFrom((io.bloombox.schema.partner.integrations.LocationIntegrationSettings)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.partner.integrations.LocationIntegrationSettings other) {
      if (other == io.bloombox.schema.partner.integrations.LocationIntegrationSettings.getDefaultInstance()) return this;
      if (!other.integrations_.isEmpty()) {
        if (integrations_.isEmpty()) {
          integrations_ = other.integrations_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureIntegrationsIsMutable();
          integrations_.addAll(other.integrations_);
        }
        onChanged();
      }
      internalGetMutableGeneric().mergeFrom(
          other.internalGetGeneric());
      if (other.hasGreenbits()) {
        mergeGreenbits(other.getGreenbits());
      }
      if (other.hasMailchimp()) {
        mergeMailchimp(other.getMailchimp());
      }
      if (other.hasSendgrid()) {
        mergeSendgrid(other.getSendgrid());
      }
      if (other.hasTwilio()) {
        mergeTwilio(other.getTwilio());
      }
      if (other.hasOnfleet()) {
        mergeOnfleet(other.getOnfleet());
      }
      if (other.hasTreez()) {
        mergeTreez(other.getTreez());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.partner.integrations.LocationIntegrationSettings parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.partner.integrations.LocationIntegrationSettings) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<java.lang.Integer> integrations_ =
      java.util.Collections.emptyList();
    private void ensureIntegrationsIsMutable() {
      if (!((bitField0_ & 0x00000001) == 0x00000001)) {
        integrations_ = new java.util.ArrayList<java.lang.Integer>(integrations_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public java.util.List<io.bloombox.schema.partner.integrations.IntegrationPartner> getIntegrationsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.bloombox.schema.partner.integrations.IntegrationPartner>(integrations_, integrations_converter_);
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public int getIntegrationsCount() {
      return integrations_.size();
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public io.bloombox.schema.partner.integrations.IntegrationPartner getIntegrations(int index) {
      return integrations_converter_.convert(integrations_.get(index));
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder setIntegrations(
        int index, io.bloombox.schema.partner.integrations.IntegrationPartner value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIntegrationsIsMutable();
      integrations_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder addIntegrations(io.bloombox.schema.partner.integrations.IntegrationPartner value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIntegrationsIsMutable();
      integrations_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder addAllIntegrations(
        java.lang.Iterable<? extends io.bloombox.schema.partner.integrations.IntegrationPartner> values) {
      ensureIntegrationsIsMutable();
      for (io.bloombox.schema.partner.integrations.IntegrationPartner value : values) {
        integrations_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder clearIntegrations() {
      integrations_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public java.util.List<java.lang.Integer>
    getIntegrationsValueList() {
      return java.util.Collections.unmodifiableList(integrations_);
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public int getIntegrationsValue(int index) {
      return integrations_.get(index);
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder setIntegrationsValue(
        int index, int value) {
      ensureIntegrationsIsMutable();
      integrations_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder addIntegrationsValue(int value) {
      ensureIntegrationsIsMutable();
      integrations_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies integrations that a specific location has setup.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.integrations.IntegrationPartner integrations = 1;</code>
     */
    public Builder addAllIntegrationsValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureIntegrationsIsMutable();
      for (int value : values) {
        integrations_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> generic_;
    private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
    internalGetGeneric() {
      if (generic_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            GenericDefaultEntryHolder.defaultEntry);
      }
      return generic_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
    internalGetMutableGeneric() {
      onChanged();;
      if (generic_ == null) {
        generic_ = com.google.protobuf.MapField.newMapField(
            GenericDefaultEntryHolder.defaultEntry);
      }
      if (!generic_.isMutable()) {
        generic_ = generic_.copy();
      }
      return generic_;
    }

    public int getGenericCount() {
      return internalGetGeneric().getMap().size();
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public boolean containsGeneric(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetGeneric().getMap().containsKey(key);
    }
    /**
     * Use {@link #getGenericMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> getGeneric() {
      return getGenericMap();
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> getGenericMap() {
      return internalGetGeneric().getMap();
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getGenericOrDefault(
        java.lang.String key,
        io.bloombox.schema.partner.integrations.GenericIntegrationSettings defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> map =
          internalGetGeneric().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public io.bloombox.schema.partner.integrations.GenericIntegrationSettings getGenericOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> map =
          internalGetGeneric().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearGeneric() {
      internalGetMutableGeneric().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public Builder removeGeneric(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableGeneric().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings>
    getMutableGeneric() {
      return internalGetMutableGeneric().getMutableMap();
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */
    public Builder putGeneric(
        java.lang.String key,
        io.bloombox.schema.partner.integrations.GenericIntegrationSettings value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableGeneric().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Generic settings, specified for each integration.
     * </pre>
     *
     * <code>map&lt;string, .bloombox.schema.partner.integrations.GenericIntegrationSettings&gt; generic = 2;</code>
     */

    public Builder putAllGeneric(
        java.util.Map<java.lang.String, io.bloombox.schema.partner.integrations.GenericIntegrationSettings> values) {
      internalGetMutableGeneric().getMutableMap()
          .putAll(values);
      return this;
    }

    private io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettingsOrBuilder> greenbitsBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public boolean hasGreenbits() {
      return greenbitsBuilder_ != null || greenbits_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings getGreenbits() {
      if (greenbitsBuilder_ == null) {
        return greenbits_ == null ? io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.getDefaultInstance() : greenbits_;
      } else {
        return greenbitsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public Builder setGreenbits(io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings value) {
      if (greenbitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        greenbits_ = value;
        onChanged();
      } else {
        greenbitsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public Builder setGreenbits(
        io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder builderForValue) {
      if (greenbitsBuilder_ == null) {
        greenbits_ = builderForValue.build();
        onChanged();
      } else {
        greenbitsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public Builder mergeGreenbits(io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings value) {
      if (greenbitsBuilder_ == null) {
        if (greenbits_ != null) {
          greenbits_ =
            io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.newBuilder(greenbits_).mergeFrom(value).buildPartial();
        } else {
          greenbits_ = value;
        }
        onChanged();
      } else {
        greenbitsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public Builder clearGreenbits() {
      if (greenbitsBuilder_ == null) {
        greenbits_ = null;
        onChanged();
      } else {
        greenbits_ = null;
        greenbitsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder getGreenbitsBuilder() {
      
      onChanged();
      return getGreenbitsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    public io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettingsOrBuilder getGreenbitsOrBuilder() {
      if (greenbitsBuilder_ != null) {
        return greenbitsBuilder_.getMessageOrBuilder();
      } else {
        return greenbits_ == null ?
            io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.getDefaultInstance() : greenbits_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Greenbits.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings greenbits = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettingsOrBuilder> 
        getGreenbitsFieldBuilder() {
      if (greenbitsBuilder_ == null) {
        greenbitsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettings.Builder, io.bloombox.schema.partner.integrations.greenbits.GreenbitsSettingsOrBuilder>(
                getGreenbits(),
                getParentForChildren(),
                isClean());
        greenbits_ = null;
      }
      return greenbitsBuilder_;
    }

    private io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettingsOrBuilder> mailchimpBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public boolean hasMailchimp() {
      return mailchimpBuilder_ != null || mailchimp_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings getMailchimp() {
      if (mailchimpBuilder_ == null) {
        return mailchimp_ == null ? io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.getDefaultInstance() : mailchimp_;
      } else {
        return mailchimpBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public Builder setMailchimp(io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings value) {
      if (mailchimpBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mailchimp_ = value;
        onChanged();
      } else {
        mailchimpBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public Builder setMailchimp(
        io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder builderForValue) {
      if (mailchimpBuilder_ == null) {
        mailchimp_ = builderForValue.build();
        onChanged();
      } else {
        mailchimpBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public Builder mergeMailchimp(io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings value) {
      if (mailchimpBuilder_ == null) {
        if (mailchimp_ != null) {
          mailchimp_ =
            io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.newBuilder(mailchimp_).mergeFrom(value).buildPartial();
        } else {
          mailchimp_ = value;
        }
        onChanged();
      } else {
        mailchimpBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public Builder clearMailchimp() {
      if (mailchimpBuilder_ == null) {
        mailchimp_ = null;
        onChanged();
      } else {
        mailchimp_ = null;
        mailchimpBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder getMailchimpBuilder() {
      
      onChanged();
      return getMailchimpFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    public io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettingsOrBuilder getMailchimpOrBuilder() {
      if (mailchimpBuilder_ != null) {
        return mailchimpBuilder_.getMessageOrBuilder();
      } else {
        return mailchimp_ == null ?
            io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.getDefaultInstance() : mailchimp_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with MailChimp.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings mailchimp = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettingsOrBuilder> 
        getMailchimpFieldBuilder() {
      if (mailchimpBuilder_ == null) {
        mailchimpBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettings.Builder, io.bloombox.schema.partner.integrations.mailchimp.MailchimpSettingsOrBuilder>(
                getMailchimp(),
                getParentForChildren(),
                isClean());
        mailchimp_ = null;
      }
      return mailchimpBuilder_;
    }

    private io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettingsOrBuilder> sendgridBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public boolean hasSendgrid() {
      return sendgridBuilder_ != null || sendgrid_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings getSendgrid() {
      if (sendgridBuilder_ == null) {
        return sendgrid_ == null ? io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.getDefaultInstance() : sendgrid_;
      } else {
        return sendgridBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public Builder setSendgrid(io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings value) {
      if (sendgridBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sendgrid_ = value;
        onChanged();
      } else {
        sendgridBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public Builder setSendgrid(
        io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder builderForValue) {
      if (sendgridBuilder_ == null) {
        sendgrid_ = builderForValue.build();
        onChanged();
      } else {
        sendgridBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public Builder mergeSendgrid(io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings value) {
      if (sendgridBuilder_ == null) {
        if (sendgrid_ != null) {
          sendgrid_ =
            io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.newBuilder(sendgrid_).mergeFrom(value).buildPartial();
        } else {
          sendgrid_ = value;
        }
        onChanged();
      } else {
        sendgridBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public Builder clearSendgrid() {
      if (sendgridBuilder_ == null) {
        sendgrid_ = null;
        onChanged();
      } else {
        sendgrid_ = null;
        sendgridBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder getSendgridBuilder() {
      
      onChanged();
      return getSendgridFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    public io.bloombox.schema.partner.integrations.sendgrid.SendgridSettingsOrBuilder getSendgridOrBuilder() {
      if (sendgridBuilder_ != null) {
        return sendgridBuilder_.getMessageOrBuilder();
      } else {
        return sendgrid_ == null ?
            io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.getDefaultInstance() : sendgrid_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Sendgrid.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.sendgrid.SendgridSettings sendgrid = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettingsOrBuilder> 
        getSendgridFieldBuilder() {
      if (sendgridBuilder_ == null) {
        sendgridBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettings.Builder, io.bloombox.schema.partner.integrations.sendgrid.SendgridSettingsOrBuilder>(
                getSendgrid(),
                getParentForChildren(),
                isClean());
        sendgrid_ = null;
      }
      return sendgridBuilder_;
    }

    private io.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.twilio.TwilioSettings, io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder, io.bloombox.schema.partner.integrations.twilio.TwilioSettingsOrBuilder> twilioBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public boolean hasTwilio() {
      return twilioBuilder_ != null || twilio_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public io.bloombox.schema.partner.integrations.twilio.TwilioSettings getTwilio() {
      if (twilioBuilder_ == null) {
        return twilio_ == null ? io.bloombox.schema.partner.integrations.twilio.TwilioSettings.getDefaultInstance() : twilio_;
      } else {
        return twilioBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public Builder setTwilio(io.bloombox.schema.partner.integrations.twilio.TwilioSettings value) {
      if (twilioBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        twilio_ = value;
        onChanged();
      } else {
        twilioBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public Builder setTwilio(
        io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder builderForValue) {
      if (twilioBuilder_ == null) {
        twilio_ = builderForValue.build();
        onChanged();
      } else {
        twilioBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public Builder mergeTwilio(io.bloombox.schema.partner.integrations.twilio.TwilioSettings value) {
      if (twilioBuilder_ == null) {
        if (twilio_ != null) {
          twilio_ =
            io.bloombox.schema.partner.integrations.twilio.TwilioSettings.newBuilder(twilio_).mergeFrom(value).buildPartial();
        } else {
          twilio_ = value;
        }
        onChanged();
      } else {
        twilioBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public Builder clearTwilio() {
      if (twilioBuilder_ == null) {
        twilio_ = null;
        onChanged();
      } else {
        twilio_ = null;
        twilioBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder getTwilioBuilder() {
      
      onChanged();
      return getTwilioFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    public io.bloombox.schema.partner.integrations.twilio.TwilioSettingsOrBuilder getTwilioOrBuilder() {
      if (twilioBuilder_ != null) {
        return twilioBuilder_.getMessageOrBuilder();
      } else {
        return twilio_ == null ?
            io.bloombox.schema.partner.integrations.twilio.TwilioSettings.getDefaultInstance() : twilio_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Twilio.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.twilio.TwilioSettings twilio = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.twilio.TwilioSettings, io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder, io.bloombox.schema.partner.integrations.twilio.TwilioSettingsOrBuilder> 
        getTwilioFieldBuilder() {
      if (twilioBuilder_ == null) {
        twilioBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.twilio.TwilioSettings, io.bloombox.schema.partner.integrations.twilio.TwilioSettings.Builder, io.bloombox.schema.partner.integrations.twilio.TwilioSettingsOrBuilder>(
                getTwilio(),
                getParentForChildren(),
                isClean());
        twilio_ = null;
      }
      return twilioBuilder_;
    }

    private io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettingsOrBuilder> onfleetBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public boolean hasOnfleet() {
      return onfleetBuilder_ != null || onfleet_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings getOnfleet() {
      if (onfleetBuilder_ == null) {
        return onfleet_ == null ? io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.getDefaultInstance() : onfleet_;
      } else {
        return onfleetBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public Builder setOnfleet(io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings value) {
      if (onfleetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onfleet_ = value;
        onChanged();
      } else {
        onfleetBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public Builder setOnfleet(
        io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder builderForValue) {
      if (onfleetBuilder_ == null) {
        onfleet_ = builderForValue.build();
        onChanged();
      } else {
        onfleetBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public Builder mergeOnfleet(io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings value) {
      if (onfleetBuilder_ == null) {
        if (onfleet_ != null) {
          onfleet_ =
            io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.newBuilder(onfleet_).mergeFrom(value).buildPartial();
        } else {
          onfleet_ = value;
        }
        onChanged();
      } else {
        onfleetBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public Builder clearOnfleet() {
      if (onfleetBuilder_ == null) {
        onfleet_ = null;
        onChanged();
      } else {
        onfleet_ = null;
        onfleetBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder getOnfleetBuilder() {
      
      onChanged();
      return getOnfleetFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    public io.bloombox.schema.partner.integrations.onfleet.OnFleetSettingsOrBuilder getOnfleetOrBuilder() {
      if (onfleetBuilder_ != null) {
        return onfleetBuilder_.getMessageOrBuilder();
      } else {
        return onfleet_ == null ?
            io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.getDefaultInstance() : onfleet_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with OnFleet.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.onfleet.OnFleetSettings onfleet = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettingsOrBuilder> 
        getOnfleetFieldBuilder() {
      if (onfleetBuilder_ == null) {
        onfleetBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettings.Builder, io.bloombox.schema.partner.integrations.onfleet.OnFleetSettingsOrBuilder>(
                getOnfleet(),
                getParentForChildren(),
                isClean());
        onfleet_ = null;
      }
      return onfleetBuilder_;
    }

    private io.bloombox.schema.partner.integrations.treez.TreezSettings treez_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.treez.TreezSettings, io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder, io.bloombox.schema.partner.integrations.treez.TreezSettingsOrBuilder> treezBuilder_;
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public boolean hasTreez() {
      return treezBuilder_ != null || treez_ != null;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public io.bloombox.schema.partner.integrations.treez.TreezSettings getTreez() {
      if (treezBuilder_ == null) {
        return treez_ == null ? io.bloombox.schema.partner.integrations.treez.TreezSettings.getDefaultInstance() : treez_;
      } else {
        return treezBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public Builder setTreez(io.bloombox.schema.partner.integrations.treez.TreezSettings value) {
      if (treezBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        treez_ = value;
        onChanged();
      } else {
        treezBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public Builder setTreez(
        io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder builderForValue) {
      if (treezBuilder_ == null) {
        treez_ = builderForValue.build();
        onChanged();
      } else {
        treezBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public Builder mergeTreez(io.bloombox.schema.partner.integrations.treez.TreezSettings value) {
      if (treezBuilder_ == null) {
        if (treez_ != null) {
          treez_ =
            io.bloombox.schema.partner.integrations.treez.TreezSettings.newBuilder(treez_).mergeFrom(value).buildPartial();
        } else {
          treez_ = value;
        }
        onChanged();
      } else {
        treezBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public Builder clearTreez() {
      if (treezBuilder_ == null) {
        treez_ = null;
        onChanged();
      } else {
        treez_ = null;
        treezBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder getTreezBuilder() {
      
      onChanged();
      return getTreezFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    public io.bloombox.schema.partner.integrations.treez.TreezSettingsOrBuilder getTreezOrBuilder() {
      if (treezBuilder_ != null) {
        return treezBuilder_.getMessageOrBuilder();
      } else {
        return treez_ == null ?
            io.bloombox.schema.partner.integrations.treez.TreezSettings.getDefaultInstance() : treez_;
      }
    }
    /**
     * <pre>
     * Specifies location-specific integration settings with Treez.
     * </pre>
     *
     * <code>.bloombox.schema.partner.integrations.treez.TreezSettings treez = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.integrations.treez.TreezSettings, io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder, io.bloombox.schema.partner.integrations.treez.TreezSettingsOrBuilder> 
        getTreezFieldBuilder() {
      if (treezBuilder_ == null) {
        treezBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.integrations.treez.TreezSettings, io.bloombox.schema.partner.integrations.treez.TreezSettings.Builder, io.bloombox.schema.partner.integrations.treez.TreezSettingsOrBuilder>(
                getTreez(),
                getParentForChildren(),
                isClean());
        treez_ = null;
      }
      return treezBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.partner.integrations.LocationIntegrationSettings)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.partner.integrations.LocationIntegrationSettings)
  private static final io.bloombox.schema.partner.integrations.LocationIntegrationSettings DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.partner.integrations.LocationIntegrationSettings();
  }

  public static io.bloombox.schema.partner.integrations.LocationIntegrationSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocationIntegrationSettings>
      PARSER = new com.google.protobuf.AbstractParser<LocationIntegrationSettings>() {
    public LocationIntegrationSettings parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new LocationIntegrationSettings(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<LocationIntegrationSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocationIntegrationSettings> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.partner.integrations.LocationIntegrationSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

