/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/settings/PartnerLocationSettings.proto

package io.bloombox.schema.partner.settings;

/**
 * <pre>
 * Specifies a particular type of communication settings, usually keyed by its type.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.partner.settings.CommsSettingsPayload}
 */
public  final class CommsSettingsPayload extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.partner.settings.CommsSettingsPayload)
    CommsSettingsPayloadOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CommsSettingsPayload.newBuilder() to construct.
  private CommsSettingsPayload(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CommsSettingsPayload() {
    type_ = 0;
    contacts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CommsSettingsPayload(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
              contacts_ = new java.util.ArrayList<io.bloombox.schema.partner.settings.ShopContactTarget>();
              mutable_bitField0_ |= 0x00000002;
            }
            contacts_.add(
                input.readMessage(io.bloombox.schema.partner.settings.ShopContactTarget.parser(), extensionRegistry));
            break;
          }
          case 26: {
            io.bloombox.schema.partner.settings.CommsSenderSettings.Builder subBuilder = null;
            if (sender_ != null) {
              subBuilder = sender_.toBuilder();
            }
            sender_ = input.readMessage(io.bloombox.schema.partner.settings.CommsSenderSettings.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(sender_);
              sender_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        contacts_ = java.util.Collections.unmodifiableList(contacts_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.internal_static_bloombox_schema_partner_settings_CommsSettingsPayload_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.internal_static_bloombox_schema_partner_settings_CommsSettingsPayload_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.partner.settings.CommsSettingsPayload.class, io.bloombox.schema.partner.settings.CommsSettingsPayload.Builder.class);
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_;
  /**
   * <pre>
   * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
   * message is used as a map value, since this value is used as its key.
   * </pre>
   *
   * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
   * message is used as a map value, since this value is used as its key.
   * </pre>
   *
   * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
   */
  public io.bloombox.schema.partner.settings.ShopCommsType getType() {
    io.bloombox.schema.partner.settings.ShopCommsType result = io.bloombox.schema.partner.settings.ShopCommsType.valueOf(type_);
    return result == null ? io.bloombox.schema.partner.settings.ShopCommsType.UNRECOGNIZED : result;
  }

  public static final int CONTACTS_FIELD_NUMBER = 2;
  private java.util.List<io.bloombox.schema.partner.settings.ShopContactTarget> contacts_;
  /**
   * <pre>
   * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
   * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
   */
  public java.util.List<io.bloombox.schema.partner.settings.ShopContactTarget> getContactsList() {
    return contacts_;
  }
  /**
   * <pre>
   * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
   * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
   */
  public java.util.List<? extends io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder> 
      getContactsOrBuilderList() {
    return contacts_;
  }
  /**
   * <pre>
   * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
   * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
   */
  public int getContactsCount() {
    return contacts_.size();
  }
  /**
   * <pre>
   * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
   * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
   */
  public io.bloombox.schema.partner.settings.ShopContactTarget getContacts(int index) {
    return contacts_.get(index);
  }
  /**
   * <pre>
   * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
   * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
   * </pre>
   *
   * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
   */
  public io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder getContactsOrBuilder(
      int index) {
    return contacts_.get(index);
  }

  public static final int SENDER_FIELD_NUMBER = 3;
  private io.bloombox.schema.partner.settings.CommsSenderSettings sender_;
  /**
   * <pre>
   * Specifies settings for where messages should come from when they are sent for shop communications, including email
   * (source email address), and SMS (source phone number).
   * </pre>
   *
   * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
   */
  public boolean hasSender() {
    return sender_ != null;
  }
  /**
   * <pre>
   * Specifies settings for where messages should come from when they are sent for shop communications, including email
   * (source email address), and SMS (source phone number).
   * </pre>
   *
   * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
   */
  public io.bloombox.schema.partner.settings.CommsSenderSettings getSender() {
    return sender_ == null ? io.bloombox.schema.partner.settings.CommsSenderSettings.getDefaultInstance() : sender_;
  }
  /**
   * <pre>
   * Specifies settings for where messages should come from when they are sent for shop communications, including email
   * (source email address), and SMS (source phone number).
   * </pre>
   *
   * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
   */
  public io.bloombox.schema.partner.settings.CommsSenderSettingsOrBuilder getSenderOrBuilder() {
    return getSender();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (type_ != io.bloombox.schema.partner.settings.ShopCommsType.INTERNAL.getNumber()) {
      output.writeEnum(1, type_);
    }
    for (int i = 0; i < contacts_.size(); i++) {
      output.writeMessage(2, contacts_.get(i));
    }
    if (sender_ != null) {
      output.writeMessage(3, getSender());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != io.bloombox.schema.partner.settings.ShopCommsType.INTERNAL.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, type_);
    }
    for (int i = 0; i < contacts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, contacts_.get(i));
    }
    if (sender_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getSender());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.partner.settings.CommsSettingsPayload)) {
      return super.equals(obj);
    }
    io.bloombox.schema.partner.settings.CommsSettingsPayload other = (io.bloombox.schema.partner.settings.CommsSettingsPayload) obj;

    boolean result = true;
    result = result && type_ == other.type_;
    result = result && getContactsList()
        .equals(other.getContactsList());
    result = result && (hasSender() == other.hasSender());
    if (hasSender()) {
      result = result && getSender()
          .equals(other.getSender());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getContactsCount() > 0) {
      hash = (37 * hash) + CONTACTS_FIELD_NUMBER;
      hash = (53 * hash) + getContactsList().hashCode();
    }
    if (hasSender()) {
      hash = (37 * hash) + SENDER_FIELD_NUMBER;
      hash = (53 * hash) + getSender().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.partner.settings.CommsSettingsPayload parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.partner.settings.CommsSettingsPayload prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a particular type of communication settings, usually keyed by its type.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.partner.settings.CommsSettingsPayload}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.partner.settings.CommsSettingsPayload)
      io.bloombox.schema.partner.settings.CommsSettingsPayloadOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.internal_static_bloombox_schema_partner_settings_CommsSettingsPayload_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.internal_static_bloombox_schema_partner_settings_CommsSettingsPayload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.partner.settings.CommsSettingsPayload.class, io.bloombox.schema.partner.settings.CommsSettingsPayload.Builder.class);
    }

    // Construct using io.bloombox.schema.partner.settings.CommsSettingsPayload.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getContactsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      type_ = 0;

      if (contactsBuilder_ == null) {
        contacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        contactsBuilder_.clear();
      }
      if (senderBuilder_ == null) {
        sender_ = null;
      } else {
        sender_ = null;
        senderBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.internal_static_bloombox_schema_partner_settings_CommsSettingsPayload_descriptor;
    }

    public io.bloombox.schema.partner.settings.CommsSettingsPayload getDefaultInstanceForType() {
      return io.bloombox.schema.partner.settings.CommsSettingsPayload.getDefaultInstance();
    }

    public io.bloombox.schema.partner.settings.CommsSettingsPayload build() {
      io.bloombox.schema.partner.settings.CommsSettingsPayload result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.partner.settings.CommsSettingsPayload buildPartial() {
      io.bloombox.schema.partner.settings.CommsSettingsPayload result = new io.bloombox.schema.partner.settings.CommsSettingsPayload(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.type_ = type_;
      if (contactsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          contacts_ = java.util.Collections.unmodifiableList(contacts_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.contacts_ = contacts_;
      } else {
        result.contacts_ = contactsBuilder_.build();
      }
      if (senderBuilder_ == null) {
        result.sender_ = sender_;
      } else {
        result.sender_ = senderBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.partner.settings.CommsSettingsPayload) {
        return mergeFrom((io.bloombox.schema.partner.settings.CommsSettingsPayload)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.partner.settings.CommsSettingsPayload other) {
      if (other == io.bloombox.schema.partner.settings.CommsSettingsPayload.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (contactsBuilder_ == null) {
        if (!other.contacts_.isEmpty()) {
          if (contacts_.isEmpty()) {
            contacts_ = other.contacts_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureContactsIsMutable();
            contacts_.addAll(other.contacts_);
          }
          onChanged();
        }
      } else {
        if (!other.contacts_.isEmpty()) {
          if (contactsBuilder_.isEmpty()) {
            contactsBuilder_.dispose();
            contactsBuilder_ = null;
            contacts_ = other.contacts_;
            bitField0_ = (bitField0_ & ~0x00000002);
            contactsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getContactsFieldBuilder() : null;
          } else {
            contactsBuilder_.addAllMessages(other.contacts_);
          }
        }
      }
      if (other.hasSender()) {
        mergeSender(other.getSender());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.partner.settings.CommsSettingsPayload parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.partner.settings.CommsSettingsPayload) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int type_ = 0;
    /**
     * <pre>
     * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
     * message is used as a map value, since this value is used as its key.
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
     * message is used as a map value, since this value is used as its key.
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
     * message is used as a map value, since this value is used as its key.
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
     */
    public io.bloombox.schema.partner.settings.ShopCommsType getType() {
      io.bloombox.schema.partner.settings.ShopCommsType result = io.bloombox.schema.partner.settings.ShopCommsType.valueOf(type_);
      return result == null ? io.bloombox.schema.partner.settings.ShopCommsType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
     * message is used as a map value, since this value is used as its key.
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
     */
    public Builder setType(io.bloombox.schema.partner.settings.ShopCommsType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the type communications this settings payload should apply to. Sometimes left unspecified when this
     * message is used as a map value, since this value is used as its key.
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.ShopCommsType type = 1;</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<io.bloombox.schema.partner.settings.ShopContactTarget> contacts_ =
      java.util.Collections.emptyList();
    private void ensureContactsIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        contacts_ = new java.util.ArrayList<io.bloombox.schema.partner.settings.ShopContactTarget>(contacts_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.partner.settings.ShopContactTarget, io.bloombox.schema.partner.settings.ShopContactTarget.Builder, io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder> contactsBuilder_;

    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public java.util.List<io.bloombox.schema.partner.settings.ShopContactTarget> getContactsList() {
      if (contactsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(contacts_);
      } else {
        return contactsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public int getContactsCount() {
      if (contactsBuilder_ == null) {
        return contacts_.size();
      } else {
        return contactsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public io.bloombox.schema.partner.settings.ShopContactTarget getContacts(int index) {
      if (contactsBuilder_ == null) {
        return contacts_.get(index);
      } else {
        return contactsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder setContacts(
        int index, io.bloombox.schema.partner.settings.ShopContactTarget value) {
      if (contactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContactsIsMutable();
        contacts_.set(index, value);
        onChanged();
      } else {
        contactsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder setContacts(
        int index, io.bloombox.schema.partner.settings.ShopContactTarget.Builder builderForValue) {
      if (contactsBuilder_ == null) {
        ensureContactsIsMutable();
        contacts_.set(index, builderForValue.build());
        onChanged();
      } else {
        contactsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder addContacts(io.bloombox.schema.partner.settings.ShopContactTarget value) {
      if (contactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContactsIsMutable();
        contacts_.add(value);
        onChanged();
      } else {
        contactsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder addContacts(
        int index, io.bloombox.schema.partner.settings.ShopContactTarget value) {
      if (contactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureContactsIsMutable();
        contacts_.add(index, value);
        onChanged();
      } else {
        contactsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder addContacts(
        io.bloombox.schema.partner.settings.ShopContactTarget.Builder builderForValue) {
      if (contactsBuilder_ == null) {
        ensureContactsIsMutable();
        contacts_.add(builderForValue.build());
        onChanged();
      } else {
        contactsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder addContacts(
        int index, io.bloombox.schema.partner.settings.ShopContactTarget.Builder builderForValue) {
      if (contactsBuilder_ == null) {
        ensureContactsIsMutable();
        contacts_.add(index, builderForValue.build());
        onChanged();
      } else {
        contactsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder addAllContacts(
        java.lang.Iterable<? extends io.bloombox.schema.partner.settings.ShopContactTarget> values) {
      if (contactsBuilder_ == null) {
        ensureContactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, contacts_);
        onChanged();
      } else {
        contactsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder clearContacts() {
      if (contactsBuilder_ == null) {
        contacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        contactsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public Builder removeContacts(int index) {
      if (contactsBuilder_ == null) {
        ensureContactsIsMutable();
        contacts_.remove(index);
        onChanged();
      } else {
        contactsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public io.bloombox.schema.partner.settings.ShopContactTarget.Builder getContactsBuilder(
        int index) {
      return getContactsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder getContactsOrBuilder(
        int index) {
      if (contactsBuilder_ == null) {
        return contacts_.get(index);  } else {
        return contactsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public java.util.List<? extends io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder> 
         getContactsOrBuilderList() {
      if (contactsBuilder_ != null) {
        return contactsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(contacts_);
      }
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public io.bloombox.schema.partner.settings.ShopContactTarget.Builder addContactsBuilder() {
      return getContactsFieldBuilder().addBuilder(
          io.bloombox.schema.partner.settings.ShopContactTarget.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public io.bloombox.schema.partner.settings.ShopContactTarget.Builder addContactsBuilder(
        int index) {
      return getContactsFieldBuilder().addBuilder(
          index, io.bloombox.schema.partner.settings.ShopContactTarget.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies contacts attached to this type of shop communication. In an internal context, these represent the full
     * set of contacts reached-out-to when things occur. In an external context, these are like a BCC function.
     * </pre>
     *
     * <code>repeated .bloombox.schema.partner.settings.ShopContactTarget contacts = 2;</code>
     */
    public java.util.List<io.bloombox.schema.partner.settings.ShopContactTarget.Builder> 
         getContactsBuilderList() {
      return getContactsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.partner.settings.ShopContactTarget, io.bloombox.schema.partner.settings.ShopContactTarget.Builder, io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder> 
        getContactsFieldBuilder() {
      if (contactsBuilder_ == null) {
        contactsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.bloombox.schema.partner.settings.ShopContactTarget, io.bloombox.schema.partner.settings.ShopContactTarget.Builder, io.bloombox.schema.partner.settings.ShopContactTargetOrBuilder>(
                contacts_,
                ((bitField0_ & 0x00000002) == 0x00000002),
                getParentForChildren(),
                isClean());
        contacts_ = null;
      }
      return contactsBuilder_;
    }

    private io.bloombox.schema.partner.settings.CommsSenderSettings sender_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.settings.CommsSenderSettings, io.bloombox.schema.partner.settings.CommsSenderSettings.Builder, io.bloombox.schema.partner.settings.CommsSenderSettingsOrBuilder> senderBuilder_;
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public boolean hasSender() {
      return senderBuilder_ != null || sender_ != null;
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public io.bloombox.schema.partner.settings.CommsSenderSettings getSender() {
      if (senderBuilder_ == null) {
        return sender_ == null ? io.bloombox.schema.partner.settings.CommsSenderSettings.getDefaultInstance() : sender_;
      } else {
        return senderBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public Builder setSender(io.bloombox.schema.partner.settings.CommsSenderSettings value) {
      if (senderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sender_ = value;
        onChanged();
      } else {
        senderBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public Builder setSender(
        io.bloombox.schema.partner.settings.CommsSenderSettings.Builder builderForValue) {
      if (senderBuilder_ == null) {
        sender_ = builderForValue.build();
        onChanged();
      } else {
        senderBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public Builder mergeSender(io.bloombox.schema.partner.settings.CommsSenderSettings value) {
      if (senderBuilder_ == null) {
        if (sender_ != null) {
          sender_ =
            io.bloombox.schema.partner.settings.CommsSenderSettings.newBuilder(sender_).mergeFrom(value).buildPartial();
        } else {
          sender_ = value;
        }
        onChanged();
      } else {
        senderBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public Builder clearSender() {
      if (senderBuilder_ == null) {
        sender_ = null;
        onChanged();
      } else {
        sender_ = null;
        senderBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public io.bloombox.schema.partner.settings.CommsSenderSettings.Builder getSenderBuilder() {
      
      onChanged();
      return getSenderFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    public io.bloombox.schema.partner.settings.CommsSenderSettingsOrBuilder getSenderOrBuilder() {
      if (senderBuilder_ != null) {
        return senderBuilder_.getMessageOrBuilder();
      } else {
        return sender_ == null ?
            io.bloombox.schema.partner.settings.CommsSenderSettings.getDefaultInstance() : sender_;
      }
    }
    /**
     * <pre>
     * Specifies settings for where messages should come from when they are sent for shop communications, including email
     * (source email address), and SMS (source phone number).
     * </pre>
     *
     * <code>.bloombox.schema.partner.settings.CommsSenderSettings sender = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.settings.CommsSenderSettings, io.bloombox.schema.partner.settings.CommsSenderSettings.Builder, io.bloombox.schema.partner.settings.CommsSenderSettingsOrBuilder> 
        getSenderFieldBuilder() {
      if (senderBuilder_ == null) {
        senderBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.settings.CommsSenderSettings, io.bloombox.schema.partner.settings.CommsSenderSettings.Builder, io.bloombox.schema.partner.settings.CommsSenderSettingsOrBuilder>(
                getSender(),
                getParentForChildren(),
                isClean());
        sender_ = null;
      }
      return senderBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.partner.settings.CommsSettingsPayload)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.partner.settings.CommsSettingsPayload)
  private static final io.bloombox.schema.partner.settings.CommsSettingsPayload DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.partner.settings.CommsSettingsPayload();
  }

  public static io.bloombox.schema.partner.settings.CommsSettingsPayload getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CommsSettingsPayload>
      PARSER = new com.google.protobuf.AbstractParser<CommsSettingsPayload>() {
    public CommsSettingsPayload parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CommsSettingsPayload(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CommsSettingsPayload> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CommsSettingsPayload> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.partner.settings.CommsSettingsPayload getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

