/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: partner/settings/PartnerLocationSettings.proto

package io.bloombox.schema.partner.settings;

/**
 * <pre>
 * Specifies statuses that an online shop itself may take, where it is either open/closed or only open for pickup or
 * delivery.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.partner.settings.ShopStatus}
 */
public enum ShopStatus
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * The shop is currently open for business, for both delivery and pickup.
   * </pre>
   *
   * <code>OPEN = 0;</code>
   */
  OPEN(0),
  /**
   * <pre>
   * The shop is currently closed.
   * </pre>
   *
   * <code>CLOSED = 1;</code>
   */
  CLOSED(1),
  /**
   * <pre>
   * The shop is open, but for delivery only.
   * </pre>
   *
   * <code>DELIVERY_ONLY = 2;</code>
   */
  DELIVERY_ONLY(2),
  /**
   * <pre>
   * The shop is open, but for pickup only.
   * </pre>
   *
   * <code>PICKUP_ONLY = 3;</code>
   */
  PICKUP_ONLY(3),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * The shop is currently open for business, for both delivery and pickup.
   * </pre>
   *
   * <code>OPEN = 0;</code>
   */
  public static final int OPEN_VALUE = 0;
  /**
   * <pre>
   * The shop is currently closed.
   * </pre>
   *
   * <code>CLOSED = 1;</code>
   */
  public static final int CLOSED_VALUE = 1;
  /**
   * <pre>
   * The shop is open, but for delivery only.
   * </pre>
   *
   * <code>DELIVERY_ONLY = 2;</code>
   */
  public static final int DELIVERY_ONLY_VALUE = 2;
  /**
   * <pre>
   * The shop is open, but for pickup only.
   * </pre>
   *
   * <code>PICKUP_ONLY = 3;</code>
   */
  public static final int PICKUP_ONLY_VALUE = 3;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ShopStatus valueOf(int value) {
    return forNumber(value);
  }

  public static ShopStatus forNumber(int value) {
    switch (value) {
      case 0: return OPEN;
      case 1: return CLOSED;
      case 2: return DELIVERY_ONLY;
      case 3: return PICKUP_ONLY;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ShopStatus>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      ShopStatus> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ShopStatus>() {
          public ShopStatus findValueByNumber(int number) {
            return ShopStatus.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.partner.settings.PartnerLocationSettingsOuterClass.getDescriptor().getEnumTypes().get(4);
  }

  private static final ShopStatus[] VALUES = values();

  public static ShopStatus valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ShopStatus(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.partner.settings.ShopStatus)
}

