/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: search/SearchSpec.proto

package io.bloombox.schema.search;

/**
 * <pre>
 * Specifies available modes to highlight terms in search results.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.search.ResultHighlightMode}
 */
public enum ResultHighlightMode
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * No highlighting is requested.
   * </pre>
   *
   * <code>NO_HIGHLIGHTING = 0;</code>
   */
  NO_HIGHLIGHTING(0),
  /**
   * <pre>
   * HTML highlighting is requested.
   * </pre>
   *
   * <code>HTML = 1;</code>
   */
  HTML(1),
  /**
   * <pre>
   * Markdown highlighting is requested.
   * </pre>
   *
   * <code>MARKDOWN = 2;</code>
   */
  MARKDOWN(2),
  /**
   * <pre>
   * Only return snippets of matching text.
   * </pre>
   *
   * <code>SNIPPET = 3;</code>
   */
  SNIPPET(3),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * No highlighting is requested.
   * </pre>
   *
   * <code>NO_HIGHLIGHTING = 0;</code>
   */
  public static final int NO_HIGHLIGHTING_VALUE = 0;
  /**
   * <pre>
   * HTML highlighting is requested.
   * </pre>
   *
   * <code>HTML = 1;</code>
   */
  public static final int HTML_VALUE = 1;
  /**
   * <pre>
   * Markdown highlighting is requested.
   * </pre>
   *
   * <code>MARKDOWN = 2;</code>
   */
  public static final int MARKDOWN_VALUE = 2;
  /**
   * <pre>
   * Only return snippets of matching text.
   * </pre>
   *
   * <code>SNIPPET = 3;</code>
   */
  public static final int SNIPPET_VALUE = 3;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ResultHighlightMode valueOf(int value) {
    return forNumber(value);
  }

  public static ResultHighlightMode forNumber(int value) {
    switch (value) {
      case 0: return NO_HIGHLIGHTING;
      case 1: return HTML;
      case 2: return MARKDOWN;
      case 3: return SNIPPET;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ResultHighlightMode>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      ResultHighlightMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResultHighlightMode>() {
          public ResultHighlightMode findValueByNumber(int number) {
            return ResultHighlightMode.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.search.SearchSpecOuterClass.getDescriptor().getEnumTypes().get(2);
  }

  private static final ResultHighlightMode[] VALUES = values();

  public static ResultHighlightMode valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ResultHighlightMode(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.search.ResultHighlightMode)
}

