/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: search/SearchResult.proto

package io.bloombox.schema.search;

/**
 * <pre>
 * Specifies an individual matching result to a search operation, regardless of type.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.search.SearchResult}
 */
public  final class SearchResult extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.search.SearchResult)
    SearchResultOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SearchResult.newBuilder() to construct.
  private SearchResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SearchResult() {
    rank_ = 0;
    relevance_ = 0D;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SearchResult(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            rank_ = input.readUInt32();
            break;
          }
          case 17: {

            relevance_ = input.readDouble();
            break;
          }
          case 26: {
            com.google.protobuf.FieldMask.Builder subBuilder = null;
            if (fields_ != null) {
              subBuilder = fields_.toBuilder();
            }
            fields_ = input.readMessage(com.google.protobuf.FieldMask.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(fields_);
              fields_ = subBuilder.buildPartial();
            }

            break;
          }
          case 82: {
            io.bloombox.schema.search.ProductSearchResult.Builder subBuilder = null;
            if (resultCase_ == 10) {
              subBuilder = ((io.bloombox.schema.search.ProductSearchResult) result_).toBuilder();
            }
            result_ =
                input.readMessage(io.bloombox.schema.search.ProductSearchResult.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.search.ProductSearchResult) result_);
              result_ = subBuilder.buildPartial();
            }
            resultCase_ = 10;
            break;
          }
          case 90: {
            io.bloombox.schema.search.UserSearchResult.Builder subBuilder = null;
            if (resultCase_ == 11) {
              subBuilder = ((io.bloombox.schema.search.UserSearchResult) result_).toBuilder();
            }
            result_ =
                input.readMessage(io.bloombox.schema.search.UserSearchResult.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.search.UserSearchResult) result_);
              result_ = subBuilder.buildPartial();
            }
            resultCase_ = 11;
            break;
          }
          case 98: {
            io.bloombox.schema.search.PartnerSearchResult.Builder subBuilder = null;
            if (resultCase_ == 12) {
              subBuilder = ((io.bloombox.schema.search.PartnerSearchResult) result_).toBuilder();
            }
            result_ =
                input.readMessage(io.bloombox.schema.search.PartnerSearchResult.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.search.PartnerSearchResult) result_);
              result_ = subBuilder.buildPartial();
            }
            resultCase_ = 12;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.search.SearchResultOuterClass.internal_static_bloombox_schema_search_SearchResult_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.search.SearchResultOuterClass.internal_static_bloombox_schema_search_SearchResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.search.SearchResult.class, io.bloombox.schema.search.SearchResult.Builder.class);
  }

  private int resultCase_ = 0;
  private java.lang.Object result_;
  public enum ResultCase
      implements com.google.protobuf.Internal.EnumLite {
    PRODUCT(10),
    PROFILE(11),
    PARTNER(12),
    RESULT_NOT_SET(0);
    private final int value;
    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 10: return PRODUCT;
        case 11: return PROFILE;
        case 12: return PARTNER;
        case 0: return RESULT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase
  getResultCase() {
    return ResultCase.forNumber(
        resultCase_);
  }

  public static final int RANK_FIELD_NUMBER = 1;
  private int rank_;
  /**
   * <pre>
   * Rank of this item in the search result set.
   * </pre>
   *
   * <code>uint32 rank = 1;</code>
   */
  public int getRank() {
    return rank_;
  }

  public static final int RELEVANCE_FIELD_NUMBER = 2;
  private double relevance_;
  /**
   * <pre>
   * Relevance score of this item as it relates to the specifies search terms.
   * </pre>
   *
   * <code>double relevance = 2;</code>
   */
  public double getRelevance() {
    return relevance_;
  }

  public static final int FIELDS_FIELD_NUMBER = 3;
  private com.google.protobuf.FieldMask fields_;
  /**
   * <pre>
   * Fields that matched the provided search query.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask fields = 3;</code>
   */
  public boolean hasFields() {
    return fields_ != null;
  }
  /**
   * <pre>
   * Fields that matched the provided search query.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask fields = 3;</code>
   */
  public com.google.protobuf.FieldMask getFields() {
    return fields_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fields_;
  }
  /**
   * <pre>
   * Fields that matched the provided search query.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask fields = 3;</code>
   */
  public com.google.protobuf.FieldMaskOrBuilder getFieldsOrBuilder() {
    return getFields();
  }

  public static final int PRODUCT_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Resulting data that is a catalog product.
   * </pre>
   *
   * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
   */
  public boolean hasProduct() {
    return resultCase_ == 10;
  }
  /**
   * <pre>
   * Resulting data that is a catalog product.
   * </pre>
   *
   * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
   */
  public io.bloombox.schema.search.ProductSearchResult getProduct() {
    if (resultCase_ == 10) {
       return (io.bloombox.schema.search.ProductSearchResult) result_;
    }
    return io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
  }
  /**
   * <pre>
   * Resulting data that is a catalog product.
   * </pre>
   *
   * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
   */
  public io.bloombox.schema.search.ProductSearchResultOrBuilder getProductOrBuilder() {
    if (resultCase_ == 10) {
       return (io.bloombox.schema.search.ProductSearchResult) result_;
    }
    return io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
  }

  public static final int PROFILE_FIELD_NUMBER = 11;
  /**
   * <pre>
   * Resulting data that is a user or user profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
   */
  public boolean hasProfile() {
    return resultCase_ == 11;
  }
  /**
   * <pre>
   * Resulting data that is a user or user profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
   */
  public io.bloombox.schema.search.UserSearchResult getProfile() {
    if (resultCase_ == 11) {
       return (io.bloombox.schema.search.UserSearchResult) result_;
    }
    return io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
  }
  /**
   * <pre>
   * Resulting data that is a user or user profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
   */
  public io.bloombox.schema.search.UserSearchResultOrBuilder getProfileOrBuilder() {
    if (resultCase_ == 11) {
       return (io.bloombox.schema.search.UserSearchResult) result_;
    }
    return io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
  }

  public static final int PARTNER_FIELD_NUMBER = 12;
  /**
   * <pre>
   * Resulting data that is a partner or partner location profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
   */
  public boolean hasPartner() {
    return resultCase_ == 12;
  }
  /**
   * <pre>
   * Resulting data that is a partner or partner location profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
   */
  public io.bloombox.schema.search.PartnerSearchResult getPartner() {
    if (resultCase_ == 12) {
       return (io.bloombox.schema.search.PartnerSearchResult) result_;
    }
    return io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
  }
  /**
   * <pre>
   * Resulting data that is a partner or partner location profile.
   * </pre>
   *
   * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
   */
  public io.bloombox.schema.search.PartnerSearchResultOrBuilder getPartnerOrBuilder() {
    if (resultCase_ == 12) {
       return (io.bloombox.schema.search.PartnerSearchResult) result_;
    }
    return io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (rank_ != 0) {
      output.writeUInt32(1, rank_);
    }
    if (relevance_ != 0D) {
      output.writeDouble(2, relevance_);
    }
    if (fields_ != null) {
      output.writeMessage(3, getFields());
    }
    if (resultCase_ == 10) {
      output.writeMessage(10, (io.bloombox.schema.search.ProductSearchResult) result_);
    }
    if (resultCase_ == 11) {
      output.writeMessage(11, (io.bloombox.schema.search.UserSearchResult) result_);
    }
    if (resultCase_ == 12) {
      output.writeMessage(12, (io.bloombox.schema.search.PartnerSearchResult) result_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (rank_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeUInt32Size(1, rank_);
    }
    if (relevance_ != 0D) {
      size += com.google.protobuf.CodedOutputStream
        .computeDoubleSize(2, relevance_);
    }
    if (fields_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getFields());
    }
    if (resultCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (io.bloombox.schema.search.ProductSearchResult) result_);
    }
    if (resultCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, (io.bloombox.schema.search.UserSearchResult) result_);
    }
    if (resultCase_ == 12) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, (io.bloombox.schema.search.PartnerSearchResult) result_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.search.SearchResult)) {
      return super.equals(obj);
    }
    io.bloombox.schema.search.SearchResult other = (io.bloombox.schema.search.SearchResult) obj;

    boolean result = true;
    result = result && (getRank()
        == other.getRank());
    result = result && (
        java.lang.Double.doubleToLongBits(getRelevance())
        == java.lang.Double.doubleToLongBits(
            other.getRelevance()));
    result = result && (hasFields() == other.hasFields());
    if (hasFields()) {
      result = result && getFields()
          .equals(other.getFields());
    }
    result = result && getResultCase().equals(
        other.getResultCase());
    if (!result) return false;
    switch (resultCase_) {
      case 10:
        result = result && getProduct()
            .equals(other.getProduct());
        break;
      case 11:
        result = result && getProfile()
            .equals(other.getProfile());
        break;
      case 12:
        result = result && getPartner()
            .equals(other.getPartner());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RANK_FIELD_NUMBER;
    hash = (53 * hash) + getRank();
    hash = (37 * hash) + RELEVANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        java.lang.Double.doubleToLongBits(getRelevance()));
    if (hasFields()) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFields().hashCode();
    }
    switch (resultCase_) {
      case 10:
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
        break;
      case 11:
        hash = (37 * hash) + PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getProfile().hashCode();
        break;
      case 12:
        hash = (37 * hash) + PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getPartner().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.search.SearchResult parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResult parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResult parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.search.SearchResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an individual matching result to a search operation, regardless of type.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.search.SearchResult}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.search.SearchResult)
      io.bloombox.schema.search.SearchResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.search.SearchResultOuterClass.internal_static_bloombox_schema_search_SearchResult_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.search.SearchResultOuterClass.internal_static_bloombox_schema_search_SearchResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.search.SearchResult.class, io.bloombox.schema.search.SearchResult.Builder.class);
    }

    // Construct using io.bloombox.schema.search.SearchResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      rank_ = 0;

      relevance_ = 0D;

      if (fieldsBuilder_ == null) {
        fields_ = null;
      } else {
        fields_ = null;
        fieldsBuilder_ = null;
      }
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.search.SearchResultOuterClass.internal_static_bloombox_schema_search_SearchResult_descriptor;
    }

    public io.bloombox.schema.search.SearchResult getDefaultInstanceForType() {
      return io.bloombox.schema.search.SearchResult.getDefaultInstance();
    }

    public io.bloombox.schema.search.SearchResult build() {
      io.bloombox.schema.search.SearchResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.search.SearchResult buildPartial() {
      io.bloombox.schema.search.SearchResult result = new io.bloombox.schema.search.SearchResult(this);
      result.rank_ = rank_;
      result.relevance_ = relevance_;
      if (fieldsBuilder_ == null) {
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
      if (resultCase_ == 10) {
        if (productBuilder_ == null) {
          result.result_ = result_;
        } else {
          result.result_ = productBuilder_.build();
        }
      }
      if (resultCase_ == 11) {
        if (profileBuilder_ == null) {
          result.result_ = result_;
        } else {
          result.result_ = profileBuilder_.build();
        }
      }
      if (resultCase_ == 12) {
        if (partnerBuilder_ == null) {
          result.result_ = result_;
        } else {
          result.result_ = partnerBuilder_.build();
        }
      }
      result.resultCase_ = resultCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.search.SearchResult) {
        return mergeFrom((io.bloombox.schema.search.SearchResult)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.search.SearchResult other) {
      if (other == io.bloombox.schema.search.SearchResult.getDefaultInstance()) return this;
      if (other.getRank() != 0) {
        setRank(other.getRank());
      }
      if (other.getRelevance() != 0D) {
        setRelevance(other.getRelevance());
      }
      if (other.hasFields()) {
        mergeFields(other.getFields());
      }
      switch (other.getResultCase()) {
        case PRODUCT: {
          mergeProduct(other.getProduct());
          break;
        }
        case PROFILE: {
          mergeProfile(other.getProfile());
          break;
        }
        case PARTNER: {
          mergePartner(other.getPartner());
          break;
        }
        case RESULT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.search.SearchResult parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.search.SearchResult) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int resultCase_ = 0;
    private java.lang.Object result_;
    public ResultCase
        getResultCase() {
      return ResultCase.forNumber(
          resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }


    private int rank_ ;
    /**
     * <pre>
     * Rank of this item in the search result set.
     * </pre>
     *
     * <code>uint32 rank = 1;</code>
     */
    public int getRank() {
      return rank_;
    }
    /**
     * <pre>
     * Rank of this item in the search result set.
     * </pre>
     *
     * <code>uint32 rank = 1;</code>
     */
    public Builder setRank(int value) {
      
      rank_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Rank of this item in the search result set.
     * </pre>
     *
     * <code>uint32 rank = 1;</code>
     */
    public Builder clearRank() {
      
      rank_ = 0;
      onChanged();
      return this;
    }

    private double relevance_ ;
    /**
     * <pre>
     * Relevance score of this item as it relates to the specifies search terms.
     * </pre>
     *
     * <code>double relevance = 2;</code>
     */
    public double getRelevance() {
      return relevance_;
    }
    /**
     * <pre>
     * Relevance score of this item as it relates to the specifies search terms.
     * </pre>
     *
     * <code>double relevance = 2;</code>
     */
    public Builder setRelevance(double value) {
      
      relevance_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Relevance score of this item as it relates to the specifies search terms.
     * </pre>
     *
     * <code>double relevance = 2;</code>
     */
    public Builder clearRelevance() {
      
      relevance_ = 0D;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask fields_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.FieldMask, com.google.protobuf.FieldMask.Builder, com.google.protobuf.FieldMaskOrBuilder> fieldsBuilder_;
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public boolean hasFields() {
      return fieldsBuilder_ != null || fields_ != null;
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public com.google.protobuf.FieldMask getFields() {
      if (fieldsBuilder_ == null) {
        return fields_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : fields_;
      } else {
        return fieldsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public Builder setFields(com.google.protobuf.FieldMask value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fields_ = value;
        onChanged();
      } else {
        fieldsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public Builder setFields(
        com.google.protobuf.FieldMask.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        fields_ = builderForValue.build();
        onChanged();
      } else {
        fieldsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public Builder mergeFields(com.google.protobuf.FieldMask value) {
      if (fieldsBuilder_ == null) {
        if (fields_ != null) {
          fields_ =
            com.google.protobuf.FieldMask.newBuilder(fields_).mergeFrom(value).buildPartial();
        } else {
          fields_ = value;
        }
        onChanged();
      } else {
        fieldsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = null;
        onChanged();
      } else {
        fields_ = null;
        fieldsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public com.google.protobuf.FieldMask.Builder getFieldsBuilder() {
      
      onChanged();
      return getFieldsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getFieldsOrBuilder() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilder();
      } else {
        return fields_ == null ?
            com.google.protobuf.FieldMask.getDefaultInstance() : fields_;
      }
    }
    /**
     * <pre>
     * Fields that matched the provided search query.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask fields = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.FieldMask, com.google.protobuf.FieldMask.Builder, com.google.protobuf.FieldMaskOrBuilder> 
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask, com.google.protobuf.FieldMask.Builder, com.google.protobuf.FieldMaskOrBuilder>(
                getFields(),
                getParentForChildren(),
                isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.ProductSearchResult, io.bloombox.schema.search.ProductSearchResult.Builder, io.bloombox.schema.search.ProductSearchResultOrBuilder> productBuilder_;
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public boolean hasProduct() {
      return resultCase_ == 10;
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public io.bloombox.schema.search.ProductSearchResult getProduct() {
      if (productBuilder_ == null) {
        if (resultCase_ == 10) {
          return (io.bloombox.schema.search.ProductSearchResult) result_;
        }
        return io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
      } else {
        if (resultCase_ == 10) {
          return productBuilder_.getMessage();
        }
        return io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public Builder setProduct(io.bloombox.schema.search.ProductSearchResult value) {
      if (productBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        productBuilder_.setMessage(value);
      }
      resultCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public Builder setProduct(
        io.bloombox.schema.search.ProductSearchResult.Builder builderForValue) {
      if (productBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        productBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public Builder mergeProduct(io.bloombox.schema.search.ProductSearchResult value) {
      if (productBuilder_ == null) {
        if (resultCase_ == 10 &&
            result_ != io.bloombox.schema.search.ProductSearchResult.getDefaultInstance()) {
          result_ = io.bloombox.schema.search.ProductSearchResult.newBuilder((io.bloombox.schema.search.ProductSearchResult) result_)
              .mergeFrom(value).buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 10) {
          productBuilder_.mergeFrom(value);
        }
        productBuilder_.setMessage(value);
      }
      resultCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public Builder clearProduct() {
      if (productBuilder_ == null) {
        if (resultCase_ == 10) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 10) {
          resultCase_ = 0;
          result_ = null;
        }
        productBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public io.bloombox.schema.search.ProductSearchResult.Builder getProductBuilder() {
      return getProductFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    public io.bloombox.schema.search.ProductSearchResultOrBuilder getProductOrBuilder() {
      if ((resultCase_ == 10) && (productBuilder_ != null)) {
        return productBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 10) {
          return (io.bloombox.schema.search.ProductSearchResult) result_;
        }
        return io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a catalog product.
     * </pre>
     *
     * <code>.bloombox.schema.search.ProductSearchResult product = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.ProductSearchResult, io.bloombox.schema.search.ProductSearchResult.Builder, io.bloombox.schema.search.ProductSearchResultOrBuilder> 
        getProductFieldBuilder() {
      if (productBuilder_ == null) {
        if (!(resultCase_ == 10)) {
          result_ = io.bloombox.schema.search.ProductSearchResult.getDefaultInstance();
        }
        productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.search.ProductSearchResult, io.bloombox.schema.search.ProductSearchResult.Builder, io.bloombox.schema.search.ProductSearchResultOrBuilder>(
                (io.bloombox.schema.search.ProductSearchResult) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 10;
      onChanged();;
      return productBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.UserSearchResult, io.bloombox.schema.search.UserSearchResult.Builder, io.bloombox.schema.search.UserSearchResultOrBuilder> profileBuilder_;
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public boolean hasProfile() {
      return resultCase_ == 11;
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public io.bloombox.schema.search.UserSearchResult getProfile() {
      if (profileBuilder_ == null) {
        if (resultCase_ == 11) {
          return (io.bloombox.schema.search.UserSearchResult) result_;
        }
        return io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
      } else {
        if (resultCase_ == 11) {
          return profileBuilder_.getMessage();
        }
        return io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public Builder setProfile(io.bloombox.schema.search.UserSearchResult value) {
      if (profileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        profileBuilder_.setMessage(value);
      }
      resultCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public Builder setProfile(
        io.bloombox.schema.search.UserSearchResult.Builder builderForValue) {
      if (profileBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        profileBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public Builder mergeProfile(io.bloombox.schema.search.UserSearchResult value) {
      if (profileBuilder_ == null) {
        if (resultCase_ == 11 &&
            result_ != io.bloombox.schema.search.UserSearchResult.getDefaultInstance()) {
          result_ = io.bloombox.schema.search.UserSearchResult.newBuilder((io.bloombox.schema.search.UserSearchResult) result_)
              .mergeFrom(value).buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 11) {
          profileBuilder_.mergeFrom(value);
        }
        profileBuilder_.setMessage(value);
      }
      resultCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public Builder clearProfile() {
      if (profileBuilder_ == null) {
        if (resultCase_ == 11) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 11) {
          resultCase_ = 0;
          result_ = null;
        }
        profileBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public io.bloombox.schema.search.UserSearchResult.Builder getProfileBuilder() {
      return getProfileFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    public io.bloombox.schema.search.UserSearchResultOrBuilder getProfileOrBuilder() {
      if ((resultCase_ == 11) && (profileBuilder_ != null)) {
        return profileBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 11) {
          return (io.bloombox.schema.search.UserSearchResult) result_;
        }
        return io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a user or user profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.UserSearchResult profile = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.UserSearchResult, io.bloombox.schema.search.UserSearchResult.Builder, io.bloombox.schema.search.UserSearchResultOrBuilder> 
        getProfileFieldBuilder() {
      if (profileBuilder_ == null) {
        if (!(resultCase_ == 11)) {
          result_ = io.bloombox.schema.search.UserSearchResult.getDefaultInstance();
        }
        profileBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.search.UserSearchResult, io.bloombox.schema.search.UserSearchResult.Builder, io.bloombox.schema.search.UserSearchResultOrBuilder>(
                (io.bloombox.schema.search.UserSearchResult) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 11;
      onChanged();;
      return profileBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.PartnerSearchResult, io.bloombox.schema.search.PartnerSearchResult.Builder, io.bloombox.schema.search.PartnerSearchResultOrBuilder> partnerBuilder_;
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public boolean hasPartner() {
      return resultCase_ == 12;
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public io.bloombox.schema.search.PartnerSearchResult getPartner() {
      if (partnerBuilder_ == null) {
        if (resultCase_ == 12) {
          return (io.bloombox.schema.search.PartnerSearchResult) result_;
        }
        return io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
      } else {
        if (resultCase_ == 12) {
          return partnerBuilder_.getMessage();
        }
        return io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public Builder setPartner(io.bloombox.schema.search.PartnerSearchResult value) {
      if (partnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        partnerBuilder_.setMessage(value);
      }
      resultCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public Builder setPartner(
        io.bloombox.schema.search.PartnerSearchResult.Builder builderForValue) {
      if (partnerBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        partnerBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public Builder mergePartner(io.bloombox.schema.search.PartnerSearchResult value) {
      if (partnerBuilder_ == null) {
        if (resultCase_ == 12 &&
            result_ != io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance()) {
          result_ = io.bloombox.schema.search.PartnerSearchResult.newBuilder((io.bloombox.schema.search.PartnerSearchResult) result_)
              .mergeFrom(value).buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 12) {
          partnerBuilder_.mergeFrom(value);
        }
        partnerBuilder_.setMessage(value);
      }
      resultCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public Builder clearPartner() {
      if (partnerBuilder_ == null) {
        if (resultCase_ == 12) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 12) {
          resultCase_ = 0;
          result_ = null;
        }
        partnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public io.bloombox.schema.search.PartnerSearchResult.Builder getPartnerBuilder() {
      return getPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    public io.bloombox.schema.search.PartnerSearchResultOrBuilder getPartnerOrBuilder() {
      if ((resultCase_ == 12) && (partnerBuilder_ != null)) {
        return partnerBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 12) {
          return (io.bloombox.schema.search.PartnerSearchResult) result_;
        }
        return io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Resulting data that is a partner or partner location profile.
     * </pre>
     *
     * <code>.bloombox.schema.search.PartnerSearchResult partner = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.search.PartnerSearchResult, io.bloombox.schema.search.PartnerSearchResult.Builder, io.bloombox.schema.search.PartnerSearchResultOrBuilder> 
        getPartnerFieldBuilder() {
      if (partnerBuilder_ == null) {
        if (!(resultCase_ == 12)) {
          result_ = io.bloombox.schema.search.PartnerSearchResult.getDefaultInstance();
        }
        partnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.search.PartnerSearchResult, io.bloombox.schema.search.PartnerSearchResult.Builder, io.bloombox.schema.search.PartnerSearchResultOrBuilder>(
                (io.bloombox.schema.search.PartnerSearchResult) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 12;
      onChanged();;
      return partnerBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.search.SearchResult)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.search.SearchResult)
  private static final io.bloombox.schema.search.SearchResult DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.search.SearchResult();
  }

  public static io.bloombox.schema.search.SearchResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchResult>
      PARSER = new com.google.protobuf.AbstractParser<SearchResult>() {
    public SearchResult parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SearchResult(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SearchResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchResult> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.search.SearchResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

