/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: search/SearchSpec.proto

package io.bloombox.schema.search;

/**
 * <pre>
 * Specifies options for results returned from a search operation.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.search.SearchResultOptions}
 */
public  final class SearchResultOptions extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.search.SearchResultOptions)
    SearchResultOptionsOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SearchResultOptions.newBuilder() to construct.
  private SearchResultOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SearchResultOptions() {
    keysOnly_ = false;
    highlight_ = 0;
    include_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SearchResultOptions(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            keysOnly_ = input.readBool();
            break;
          }
          case 16: {
            int rawValue = input.readEnum();

            highlight_ = rawValue;
            break;
          }
          case 24: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
              include_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000004;
            }
            include_.add(rawValue);
            break;
          }
          case 26: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                include_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000004;
              }
              include_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
        include_ = java.util.Collections.unmodifiableList(include_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.search.SearchSpecOuterClass.internal_static_bloombox_schema_search_SearchResultOptions_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.search.SearchSpecOuterClass.internal_static_bloombox_schema_search_SearchResultOptions_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.search.SearchResultOptions.class, io.bloombox.schema.search.SearchResultOptions.Builder.class);
  }

  private int bitField0_;
  public static final int KEYS_ONLY_FIELD_NUMBER = 1;
  private boolean keysOnly_;
  /**
   * <pre>
   * Only return matching keys - i.e. don't include other object data, like its name, description, or media asset links.
   * </pre>
   *
   * <code>bool keys_only = 1;</code>
   */
  public boolean getKeysOnly() {
    return keysOnly_;
  }

  public static final int HIGHLIGHT_FIELD_NUMBER = 2;
  private int highlight_;
  /**
   * <pre>
   * Enable result highlighting
   * </pre>
   *
   * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
   */
  public int getHighlightValue() {
    return highlight_;
  }
  /**
   * <pre>
   * Enable result highlighting
   * </pre>
   *
   * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
   */
  public io.bloombox.schema.search.ResultHighlightMode getHighlight() {
    io.bloombox.schema.search.ResultHighlightMode result = io.bloombox.schema.search.ResultHighlightMode.valueOf(highlight_);
    return result == null ? io.bloombox.schema.search.ResultHighlightMode.UNRECOGNIZED : result;
  }

  public static final int INCLUDE_FIELD_NUMBER = 3;
  private java.util.List<java.lang.Integer> include_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.bloombox.schema.search.SearchResultExtension> include_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.bloombox.schema.search.SearchResultExtension>() {
            public io.bloombox.schema.search.SearchResultExtension convert(java.lang.Integer from) {
              io.bloombox.schema.search.SearchResultExtension result = io.bloombox.schema.search.SearchResultExtension.valueOf(from);
              return result == null ? io.bloombox.schema.search.SearchResultExtension.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Specifies desired extensions to stock search result data.
   * </pre>
   *
   * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
   */
  public java.util.List<io.bloombox.schema.search.SearchResultExtension> getIncludeList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.bloombox.schema.search.SearchResultExtension>(include_, include_converter_);
  }
  /**
   * <pre>
   * Specifies desired extensions to stock search result data.
   * </pre>
   *
   * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
   */
  public int getIncludeCount() {
    return include_.size();
  }
  /**
   * <pre>
   * Specifies desired extensions to stock search result data.
   * </pre>
   *
   * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
   */
  public io.bloombox.schema.search.SearchResultExtension getInclude(int index) {
    return include_converter_.convert(include_.get(index));
  }
  /**
   * <pre>
   * Specifies desired extensions to stock search result data.
   * </pre>
   *
   * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
   */
  public java.util.List<java.lang.Integer>
  getIncludeValueList() {
    return include_;
  }
  /**
   * <pre>
   * Specifies desired extensions to stock search result data.
   * </pre>
   *
   * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
   */
  public int getIncludeValue(int index) {
    return include_.get(index);
  }
  private int includeMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (keysOnly_ != false) {
      output.writeBool(1, keysOnly_);
    }
    if (highlight_ != io.bloombox.schema.search.ResultHighlightMode.NO_HIGHLIGHTING.getNumber()) {
      output.writeEnum(2, highlight_);
    }
    if (getIncludeList().size() > 0) {
      output.writeUInt32NoTag(26);
      output.writeUInt32NoTag(includeMemoizedSerializedSize);
    }
    for (int i = 0; i < include_.size(); i++) {
      output.writeEnumNoTag(include_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (keysOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, keysOnly_);
    }
    if (highlight_ != io.bloombox.schema.search.ResultHighlightMode.NO_HIGHLIGHTING.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, highlight_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < include_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(include_.get(i));
      }
      size += dataSize;
      if (!getIncludeList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }includeMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.search.SearchResultOptions)) {
      return super.equals(obj);
    }
    io.bloombox.schema.search.SearchResultOptions other = (io.bloombox.schema.search.SearchResultOptions) obj;

    boolean result = true;
    result = result && (getKeysOnly()
        == other.getKeysOnly());
    result = result && highlight_ == other.highlight_;
    result = result && include_.equals(other.include_);
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + KEYS_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getKeysOnly());
    hash = (37 * hash) + HIGHLIGHT_FIELD_NUMBER;
    hash = (53 * hash) + highlight_;
    if (getIncludeCount() > 0) {
      hash = (37 * hash) + INCLUDE_FIELD_NUMBER;
      hash = (53 * hash) + include_.hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.search.SearchResultOptions parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.search.SearchResultOptions prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies options for results returned from a search operation.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.search.SearchResultOptions}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.search.SearchResultOptions)
      io.bloombox.schema.search.SearchResultOptionsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.search.SearchSpecOuterClass.internal_static_bloombox_schema_search_SearchResultOptions_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.search.SearchSpecOuterClass.internal_static_bloombox_schema_search_SearchResultOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.search.SearchResultOptions.class, io.bloombox.schema.search.SearchResultOptions.Builder.class);
    }

    // Construct using io.bloombox.schema.search.SearchResultOptions.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      keysOnly_ = false;

      highlight_ = 0;

      include_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.search.SearchSpecOuterClass.internal_static_bloombox_schema_search_SearchResultOptions_descriptor;
    }

    public io.bloombox.schema.search.SearchResultOptions getDefaultInstanceForType() {
      return io.bloombox.schema.search.SearchResultOptions.getDefaultInstance();
    }

    public io.bloombox.schema.search.SearchResultOptions build() {
      io.bloombox.schema.search.SearchResultOptions result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.search.SearchResultOptions buildPartial() {
      io.bloombox.schema.search.SearchResultOptions result = new io.bloombox.schema.search.SearchResultOptions(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.keysOnly_ = keysOnly_;
      result.highlight_ = highlight_;
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        include_ = java.util.Collections.unmodifiableList(include_);
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.include_ = include_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.search.SearchResultOptions) {
        return mergeFrom((io.bloombox.schema.search.SearchResultOptions)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.search.SearchResultOptions other) {
      if (other == io.bloombox.schema.search.SearchResultOptions.getDefaultInstance()) return this;
      if (other.getKeysOnly() != false) {
        setKeysOnly(other.getKeysOnly());
      }
      if (other.highlight_ != 0) {
        setHighlightValue(other.getHighlightValue());
      }
      if (!other.include_.isEmpty()) {
        if (include_.isEmpty()) {
          include_ = other.include_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureIncludeIsMutable();
          include_.addAll(other.include_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.search.SearchResultOptions parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.search.SearchResultOptions) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private boolean keysOnly_ ;
    /**
     * <pre>
     * Only return matching keys - i.e. don't include other object data, like its name, description, or media asset links.
     * </pre>
     *
     * <code>bool keys_only = 1;</code>
     */
    public boolean getKeysOnly() {
      return keysOnly_;
    }
    /**
     * <pre>
     * Only return matching keys - i.e. don't include other object data, like its name, description, or media asset links.
     * </pre>
     *
     * <code>bool keys_only = 1;</code>
     */
    public Builder setKeysOnly(boolean value) {
      
      keysOnly_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Only return matching keys - i.e. don't include other object data, like its name, description, or media asset links.
     * </pre>
     *
     * <code>bool keys_only = 1;</code>
     */
    public Builder clearKeysOnly() {
      
      keysOnly_ = false;
      onChanged();
      return this;
    }

    private int highlight_ = 0;
    /**
     * <pre>
     * Enable result highlighting
     * </pre>
     *
     * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
     */
    public int getHighlightValue() {
      return highlight_;
    }
    /**
     * <pre>
     * Enable result highlighting
     * </pre>
     *
     * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
     */
    public Builder setHighlightValue(int value) {
      highlight_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enable result highlighting
     * </pre>
     *
     * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
     */
    public io.bloombox.schema.search.ResultHighlightMode getHighlight() {
      io.bloombox.schema.search.ResultHighlightMode result = io.bloombox.schema.search.ResultHighlightMode.valueOf(highlight_);
      return result == null ? io.bloombox.schema.search.ResultHighlightMode.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Enable result highlighting
     * </pre>
     *
     * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
     */
    public Builder setHighlight(io.bloombox.schema.search.ResultHighlightMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      highlight_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Enable result highlighting
     * </pre>
     *
     * <code>.bloombox.schema.search.ResultHighlightMode highlight = 2;</code>
     */
    public Builder clearHighlight() {
      
      highlight_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> include_ =
      java.util.Collections.emptyList();
    private void ensureIncludeIsMutable() {
      if (!((bitField0_ & 0x00000004) == 0x00000004)) {
        include_ = new java.util.ArrayList<java.lang.Integer>(include_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public java.util.List<io.bloombox.schema.search.SearchResultExtension> getIncludeList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.bloombox.schema.search.SearchResultExtension>(include_, include_converter_);
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public int getIncludeCount() {
      return include_.size();
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public io.bloombox.schema.search.SearchResultExtension getInclude(int index) {
      return include_converter_.convert(include_.get(index));
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder setInclude(
        int index, io.bloombox.schema.search.SearchResultExtension value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeIsMutable();
      include_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder addInclude(io.bloombox.schema.search.SearchResultExtension value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeIsMutable();
      include_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder addAllInclude(
        java.lang.Iterable<? extends io.bloombox.schema.search.SearchResultExtension> values) {
      ensureIncludeIsMutable();
      for (io.bloombox.schema.search.SearchResultExtension value : values) {
        include_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder clearInclude() {
      include_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public java.util.List<java.lang.Integer>
    getIncludeValueList() {
      return java.util.Collections.unmodifiableList(include_);
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public int getIncludeValue(int index) {
      return include_.get(index);
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder setIncludeValue(
        int index, int value) {
      ensureIncludeIsMutable();
      include_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder addIncludeValue(int value) {
      ensureIncludeIsMutable();
      include_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies desired extensions to stock search result data.
     * </pre>
     *
     * <code>repeated .bloombox.schema.search.SearchResultExtension include = 3;</code>
     */
    public Builder addAllIncludeValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureIncludeIsMutable();
      for (int value : values) {
        include_.add(value);
      }
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.search.SearchResultOptions)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.search.SearchResultOptions)
  private static final io.bloombox.schema.search.SearchResultOptions DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.search.SearchResultOptions();
  }

  public static io.bloombox.schema.search.SearchResultOptions getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchResultOptions>
      PARSER = new com.google.protobuf.AbstractParser<SearchResultOptions>() {
    public SearchResultOptions parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SearchResultOptions(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SearchResultOptions> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchResultOptions> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.search.SearchResultOptions getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

